// ============================================================================
// Rocks'n'Diamonds - McDuffin Strikes Back!
// ----------------------------------------------------------------------------
// (c) 1995-2014 by Artsoft Entertainment
//     		    Holger Schemel
//		    info@artsoft.org
//		    http://www.artsoft.org/
// ----------------------------------------------------------------------------
// editor.c
// ============================================================================

#include <math.h>

#include "libgame/libgame.h"

#include "editor.h"
#include "screens.h"
#include "tools.h"
#include "files.h"
#include "game.h"
#include "init.h"
#include "tape.h"


#define INFOTEXT_UNKNOWN_ELEMENT	"unknown"


/*
  -----------------------------------------------------------------------------
  screen and artwork graphic pixel position definitions
  -----------------------------------------------------------------------------
*/

/* values for the control window */
#define ED_CTRL1_BUTTONS_HORIZ		4
#define ED_CTRL1_BUTTONS_VERT		4
#define ED_CTRL2_BUTTONS_HORIZ		3
#define ED_CTRL2_BUTTONS_VERT		2
#define ED_CTRL3_BUTTONS_HORIZ		3
#define ED_CTRL3_BUTTONS_VERT		1
#define ED_CTRL4_BUTTONS_HORIZ		2
#define ED_CTRL4_BUTTONS_VERT		1
#define ED_CTRL5_BUTTONS_HORIZ		1
#define ED_CTRL5_BUTTONS_VERT		1

#define ED_NUM_CTRL1_BUTTONS   (ED_CTRL1_BUTTONS_HORIZ * ED_CTRL1_BUTTONS_VERT)
#define ED_NUM_CTRL2_BUTTONS   (ED_CTRL2_BUTTONS_HORIZ * ED_CTRL2_BUTTONS_VERT)
#define ED_NUM_CTRL3_BUTTONS   (ED_CTRL3_BUTTONS_HORIZ * ED_CTRL3_BUTTONS_VERT)
#define ED_NUM_CTRL4_BUTTONS   (ED_CTRL4_BUTTONS_HORIZ * ED_CTRL4_BUTTONS_VERT)
#define ED_NUM_CTRL5_BUTTONS   (ED_CTRL5_BUTTONS_HORIZ * ED_CTRL5_BUTTONS_VERT)
#define ED_NUM_CTRL1_2_BUTTONS (ED_NUM_CTRL1_BUTTONS   + ED_NUM_CTRL2_BUTTONS)
#define ED_NUM_CTRL1_3_BUTTONS (ED_NUM_CTRL1_2_BUTTONS + ED_NUM_CTRL3_BUTTONS)
#define ED_NUM_CTRL1_4_BUTTONS (ED_NUM_CTRL1_3_BUTTONS + ED_NUM_CTRL4_BUTTONS)
#define ED_NUM_CTRL_BUTTONS    (ED_NUM_CTRL1_4_BUTTONS + ED_NUM_CTRL5_BUTTONS)

/* values for the element list */
#define ED_ELEMENTLIST_XPOS		(editor.palette.x)
#define ED_ELEMENTLIST_YPOS		(editor.palette.y)
#define ED_ELEMENTLIST_XSIZE		(graphic_info[IMG_EDITOR_PALETTE_BUTTON].width)
#define ED_ELEMENTLIST_YSIZE		(graphic_info[IMG_EDITOR_PALETTE_BUTTON].height)
#define ED_ELEMENTLIST_BUTTONS_HORIZ	(editor.palette.cols)
#define ED_ELEMENTLIST_BUTTONS_VERT	(editor.palette.rows)
#define ED_NUM_ELEMENTLIST_BUTTONS	(ED_ELEMENTLIST_BUTTONS_HORIZ *	\
					 ED_ELEMENTLIST_BUTTONS_VERT)

/* standard distances */
#define ED_GADGET_NORMAL_DISTANCE	(editor.gadget.normal_spacing)
#define ED_GADGET_SMALL_DISTANCE	(editor.gadget.small_spacing)
#define ED_GADGET_TINY_DISTANCE		(editor.gadget.tiny_spacing)
#define ED_GADGET_LINE_DISTANCE		(editor.gadget.line_spacing)
#define ED_GADGET_TEXT_DISTANCE		(editor.gadget.text_spacing)
#define ED_TAB_BAR_HEIGHT		(editor.gadget.separator_line.height)
#define ED_DRAWINGAREA_TEXT_DISTANCE	(ED_GADGET_TEXT_DISTANCE +	\
					 ED_DRAWINGAREA_BORDER_SIZE)
#define ED_GADGET_SPACE_DISTANCE	(getFontWidth(FONT_TEXT_1))

/* values for drawingarea gadgets */
#define IMG_BORDER_1			IMG_EDITOR_ELEMENT_BORDER
#define IMG_BORDER_2			IMG_EDITOR_ELEMENT_BORDER_INPUT
#define ED_ELEMENT_BORDER		(graphic_info[IMG_BORDER_1].border_size)
#define ED_DRAWINGAREA_BORDER_SIZE	(graphic_info[IMG_BORDER_2].border_size)
#define ED_DRAWINGAREA_TILE_SIZE	(editor.drawingarea.tile_size)

/* values for checkbutton gadgets */
#define ED_CHECKBUTTON_XSIZE	     (graphic_info[IMG_EDITOR_CHECKBOX].width)
#define ED_CHECKBUTTON_YSIZE	     (graphic_info[IMG_EDITOR_CHECKBOX].height)

#define ED_TABBUTTON_XSIZE	     (graphic_info[IMG_EDITOR_TABBUTTON].width)
#define ED_TABBUTTON_YSIZE	     (graphic_info[IMG_EDITOR_TABBUTTON].height)

#define ED_LEVEL_SETTINGS_TABS_X	(editor.settings.tabs.x)
#define ED_LEVEL_SETTINGS_TABS_Y	(editor.settings.tabs.y)
#define ED_ELEMENT_SETTINGS_TABS_X	(editor.settings.tabs.x)
#define ED_ELEMENT_SETTINGS_TABS_Y	(editor.settings.tabs.y +	\
					 editor.settings.tabs.yoffset2)

#define ED_SETTINGS_TABS_XOFFSET	(editor.settings.tabs.draw_xoffset)
#define ED_SETTINGS_TABS_YOFFSET	(editor.settings.tabs.draw_yoffset)

#define ED_LEVEL_SETTINGS_XSTART	(ED_LEVEL_SETTINGS_TABS_X +	\
					 ED_SETTINGS_TABS_XOFFSET)
#define ED_LEVEL_SETTINGS_YSTART	(ED_LEVEL_SETTINGS_TABS_Y +	\
					 ED_TABBUTTON_YSIZE +		\
					 ED_GADGET_TINY_DISTANCE +	\
					 ED_TAB_BAR_HEIGHT +		\
					 ED_SETTINGS_TABS_YOFFSET +	\
					 getFontHeight(FONT_TEXT_1) +	\
					 ED_GADGET_TEXT_DISTANCE)
#define ED_ELEMENT_SETTINGS_XSTART	(ED_ELEMENT_SETTINGS_TABS_X +	\
					 ED_SETTINGS_TABS_XOFFSET)
#define ED_ELEMENT_SETTINGS_YSTART	(ED_ELEMENT_SETTINGS_TABS_Y +	\
					 ED_TABBUTTON_YSIZE +		\
					 ED_GADGET_TINY_DISTANCE +	\
					 ED_TAB_BAR_HEIGHT +		\
					 ED_SETTINGS_TABS_YOFFSET)

#define ED_SETTINGS_XOFFSET		(ED_CHECKBUTTON_XSIZE +		\
					 ED_GADGET_TEXT_DISTANCE)
#define ED_SETTINGS_YOFFSET		(ED_CHECKBUTTON_YSIZE +		\
					 ED_GADGET_LINE_DISTANCE)

#define ED_POS_LEVEL_SETTINGS_RANGE	(10000)
#define ED_POS_LEVEL_SETTINGS_FIRST	(1 * ED_POS_LEVEL_SETTINGS_RANGE)
#define ED_POS_LEVEL_SETTINGS_LAST	(2 * ED_POS_LEVEL_SETTINGS_RANGE - 1)
#define ED_POS_ELEMENT_SETTINGS_FIRST	(2 * ED_POS_LEVEL_SETTINGS_RANGE)
#define ED_POS_ELEMENT_SETTINGS_LAST	(3 * ED_POS_LEVEL_SETTINGS_RANGE - 1)

#define ED_LEVEL_SETTINGS_XPOS(n)	(ED_POS_LEVEL_SETTINGS_FIRST + (n))
#define ED_LEVEL_SETTINGS_YPOS(n)	(ED_POS_LEVEL_SETTINGS_FIRST + (n))

#define ED_ELEMENT_SETTINGS_XPOS(n)	(ED_POS_ELEMENT_SETTINGS_FIRST + (n))
#define ED_ELEMENT_SETTINGS_YPOS(n)	(ED_POS_ELEMENT_SETTINGS_FIRST + (n))

#define IS_POS_LEVEL_SETTINGS(n)      ((n) >= ED_POS_LEVEL_SETTINGS_FIRST && \
				       (n) <= ED_POS_LEVEL_SETTINGS_LAST)
#define IS_POS_ELEMENT_SETTINGS(n)    ((n) >= ED_POS_ELEMENT_SETTINGS_FIRST && \
				       (n) <= ED_POS_ELEMENT_SETTINGS_LAST)

#define ED_LEVEL_SETTINGS_LINE(n)	((n) - ED_POS_LEVEL_SETTINGS_FIRST)
#define ED_ELEMENT_SETTINGS_LINE(n)	((n) - ED_POS_ELEMENT_SETTINGS_FIRST)

#define ED_LEVEL_SETTINGS_X(n)		(ED_LEVEL_SETTINGS_XSTART +	\
					 (n) * ED_SETTINGS_XOFFSET)
#define ED_LEVEL_SETTINGS_Y(n)		(ED_LEVEL_SETTINGS_YSTART +	\
					 (n) * ED_SETTINGS_YOFFSET)

#define ED_ELEMENT_SETTINGS_X(n)	(ED_ELEMENT_SETTINGS_XSTART +	\
					 (n) * ED_SETTINGS_XOFFSET)
#define ED_ELEMENT_SETTINGS_Y(n)	(ED_ELEMENT_SETTINGS_YSTART +	\
					 (n) * ED_SETTINGS_YOFFSET)

#define ED_POS_TO_LEVEL_SETTINGS_X(n)	\
  (ED_LEVEL_SETTINGS_X(ED_LEVEL_SETTINGS_LINE(n)))
#define ED_POS_TO_LEVEL_SETTINGS_Y(n)	\
  (ED_LEVEL_SETTINGS_Y(ED_LEVEL_SETTINGS_LINE(n)))

#define ED_POS_TO_ELEMENT_SETTINGS_X(n)	\
  (ED_ELEMENT_SETTINGS_X(ED_ELEMENT_SETTINGS_LINE(n)))
#define ED_POS_TO_ELEMENT_SETTINGS_Y(n)	\
  (ED_ELEMENT_SETTINGS_Y(ED_ELEMENT_SETTINGS_LINE(n)))

#define ED_SETTINGS_X(n)		(IS_POS_LEVEL_SETTINGS(n) ?	\
					 ED_POS_TO_LEVEL_SETTINGS_X(n) : \
					 IS_POS_ELEMENT_SETTINGS(n) ?	\
					 ED_POS_TO_ELEMENT_SETTINGS_X(n) : (n))
#define ED_SETTINGS_Y(n)		(IS_POS_LEVEL_SETTINGS(n) ?	\
					 ED_POS_TO_LEVEL_SETTINGS_Y(n) : \
					 IS_POS_ELEMENT_SETTINGS(n) ?	\
					 ED_POS_TO_ELEMENT_SETTINGS_Y(n) : (n))

#define ED_TAB_SETTINGS_X(n)		(IS_POS_LEVEL_SETTINGS(n) ?	\
					 ED_LEVEL_SETTINGS_TABS_X :	\
					 ED_ELEMENT_SETTINGS_TABS_X)
#define ED_TAB_SETTINGS_Y(n)		(IS_POS_LEVEL_SETTINGS(n) ?	\
					 ED_LEVEL_SETTINGS_TABS_Y :	\
					 ED_ELEMENT_SETTINGS_TABS_Y)

#define ED_SETTINGS_XOFF(n)		(5 * ((n) % 4) *		\
					 ED_DRAWINGAREA_TILE_SIZE)
#define ED_SETTINGS_YOFF(n)		(5 * ((n) / 4) *		\
					 ED_DRAWINGAREA_TILE_SIZE)

#define ED_AREA_XOFFSET_1(n)		((n) != 0 ?			\
					 ED_DRAWINGAREA_BORDER_SIZE : 0)
#define ED_AREA_YOFFSET_1(n)		((n) != 0 ?			\
					 (ED_CHECKBUTTON_YSIZE -	\
					  ED_DRAWINGAREA_TILE_SIZE) / 2 : 0)

#define ED_AREA_XOFFSET_2(n)	  (0)
#define ED_AREA_YOFFSET_2(n)	  ((n) == 3 ?			\
				   ((n) - 1) * ED_DRAWINGAREA_TILE_SIZE / 2 : 0)

#define ED_AREA_SETTINGS_X(i)	   (ED_SETTINGS_X((i).x) +		\
				    ED_SETTINGS_XOFF((i).xoffset) +	\
				    ED_AREA_XOFFSET_1((i).x) -		\
				    ED_AREA_XOFFSET_2((i).area_xsize))
#define ED_AREA_SETTINGS_Y(i)	   (ED_SETTINGS_Y((i).y) +		\
				    ED_SETTINGS_YOFF((i).yoffset) +	\
				    ED_AREA_YOFFSET_1((i).y) -		\
				    ED_AREA_YOFFSET_2((i).area_ysize))

/* values for element content drawing areas */
#define ED_AREA_1X1_LSETTINGS_XPOS(n)	ED_LEVEL_SETTINGS_XPOS(n)
#define ED_AREA_1X1_LSETTINGS_YPOS(n)	ED_LEVEL_SETTINGS_YPOS(n)
#define ED_AREA_1X1_LSETTINGS_XOFF	(0)
#define ED_AREA_1X1_LSETTINGS_YOFF	(0)

#define ED_AREA_1X1_SETTINGS_XPOS(n)	ED_ELEMENT_SETTINGS_XPOS(n)
#define ED_AREA_1X1_SETTINGS_YPOS(n)	ED_ELEMENT_SETTINGS_YPOS(n)
#define ED_AREA_1X1_SETTINGS_XOFF	(0)
#define ED_AREA_1X1_SETTINGS_YOFF	(0)

#define ED_AREA_3X3_SETTINGS_XPOS(n)	ED_ELEMENT_SETTINGS_XPOS(n)
#define ED_AREA_3X3_SETTINGS_YPOS(n)	ED_ELEMENT_SETTINGS_YPOS(n)
#define ED_AREA_3X3_SETTINGS_XOFF	(0)
#define ED_AREA_3X3_SETTINGS_YOFF	(0)

/* element content */
#define ED_AREA_ELEMENT_CONTENT_XOFF(n)	(n)
#define ED_AREA_ELEMENT_CONTENT_YOFF(n)	(n)

/* yamyam content */
#define ED_XPOS_YAM			0
#define ED_YPOS_YAM			5
#define ED_AREA_YAMYAM_CONTENT_XPOS	ED_ELEMENT_SETTINGS_XPOS(ED_XPOS_YAM)
#define ED_AREA_YAMYAM_CONTENT_YPOS	ED_ELEMENT_SETTINGS_YPOS(ED_YPOS_YAM)
#define ED_AREA_YAMYAM_CONTENT_XOFF(n)	ED_AREA_ELEMENT_CONTENT_XOFF(n)
#define ED_AREA_YAMYAM_CONTENT_YOFF(n)	ED_AREA_ELEMENT_CONTENT_YOFF(n)
#define ED_AREA_YAMYAM_CONTENT_X(n)	(ED_ELEMENT_SETTINGS_X(ED_XPOS_YAM) + \
					 ED_SETTINGS_XOFF(n))
#define ED_AREA_YAMYAM_CONTENT_Y(n)	(ED_ELEMENT_SETTINGS_Y(ED_YPOS_YAM) + \
					 ED_SETTINGS_YOFF(n) +		\
					 ED_AREA_YOFFSET_1(ED_YPOS_YAM) - \
					 ED_AREA_YOFFSET_2(3))

/* magic ball content */
#define ED_XPOS_BALL			0
#define ED_YPOS_BALL			6
#define ED_AREA_MAGIC_BALL_CONTENT_XPOS	ED_ELEMENT_SETTINGS_XPOS(ED_XPOS_BALL)
#define ED_AREA_MAGIC_BALL_CONTENT_YPOS	ED_ELEMENT_SETTINGS_YPOS(ED_YPOS_BALL)
#define ED_AREA_MAGIC_BALL_CONTENT_XOFF(n) ED_AREA_ELEMENT_CONTENT_XOFF(n)
#define ED_AREA_MAGIC_BALL_CONTENT_YOFF(n) ED_AREA_ELEMENT_CONTENT_YOFF(n)
#define ED_AREA_MAGIC_BALL_CONTENT_X(n)	(ED_ELEMENT_SETTINGS_X(ED_XPOS_BALL) + \
					 ED_SETTINGS_XOFF(n))
#define ED_AREA_MAGIC_BALL_CONTENT_Y(n)	(ED_ELEMENT_SETTINGS_Y(ED_YPOS_BALL) + \
					 ED_SETTINGS_YOFF(n) +		\
					 ED_AREA_YOFFSET_1(ED_YPOS_BALL) - \
					 ED_AREA_YOFFSET_2(3))

/* values for scrolling gadgets for drawing area */
#define ED_SCROLLBUTTON_XSIZE		16
#define ED_SCROLLBUTTON_YSIZE		16

#define ED_SCROLL_UP_XPOS		(SXSIZE - ED_SCROLLBUTTON_XSIZE)
#define ED_SCROLL_UP_YPOS		(0)
#define ED_SCROLL_DOWN_XPOS		ED_SCROLL_UP_XPOS
#define ED_SCROLL_DOWN_YPOS		(SYSIZE - 3 * ED_SCROLLBUTTON_YSIZE)
#define ED_SCROLL_LEFT_XPOS		(0)
#define ED_SCROLL_LEFT_YPOS		(SYSIZE - 2 * ED_SCROLLBUTTON_YSIZE)
#define ED_SCROLL_RIGHT_XPOS		(SXSIZE - 2 * ED_SCROLLBUTTON_XSIZE)
#define ED_SCROLL_RIGHT_YPOS		ED_SCROLL_LEFT_YPOS
#define ED_SCROLL_HORIZONTAL_XPOS	(ED_SCROLL_LEFT_XPOS +		\
					 ED_SCROLLBUTTON_XSIZE)
#define ED_SCROLL_HORIZONTAL_YPOS	ED_SCROLL_LEFT_YPOS
#define ED_SCROLL_HORIZONTAL_XSIZE	(SXSIZE - 3 * ED_SCROLLBUTTON_XSIZE)
#define ED_SCROLL_HORIZONTAL_YSIZE	ED_SCROLLBUTTON_YSIZE
#define ED_SCROLL_VERTICAL_XPOS		ED_SCROLL_UP_XPOS
#define ED_SCROLL_VERTICAL_YPOS		(ED_SCROLL_UP_YPOS +		\
					 ED_SCROLLBUTTON_YSIZE)
#define ED_SCROLL_VERTICAL_XSIZE	ED_SCROLLBUTTON_XSIZE
#define ED_SCROLL_VERTICAL_YSIZE	(SYSIZE - 4 * ED_SCROLLBUTTON_YSIZE)

/* values for scrolling gadgets for element list */
#define ED_SCROLLBUTTON2_XSIZE		(graphic_info[IMG_EDITOR_PALETTE_SCROLL_UP].width)
#define ED_SCROLLBUTTON2_YSIZE		(graphic_info[IMG_EDITOR_PALETTE_SCROLL_UP].height)

#define ED_SCROLL2_UP_XPOS		(ED_ELEMENTLIST_XPOS +		\
					 ED_ELEMENTLIST_BUTTONS_HORIZ *	\
					 ED_ELEMENTLIST_XSIZE)
#define ED_SCROLL2_UP_YPOS		ED_ELEMENTLIST_YPOS
#define ED_SCROLL2_DOWN_XPOS		ED_SCROLL2_UP_XPOS
#define ED_SCROLL2_DOWN_YPOS		(ED_SCROLL2_UP_YPOS +		\
					 ED_ELEMENTLIST_BUTTONS_VERT *	\
					 ED_ELEMENTLIST_YSIZE -		\
					 ED_SCROLLBUTTON2_YSIZE)
#define ED_SCROLL2_VERTICAL_XPOS	ED_SCROLL2_UP_XPOS
#define ED_SCROLL2_VERTICAL_YPOS	(ED_SCROLL2_UP_YPOS +		\
					 ED_SCROLLBUTTON2_YSIZE)
#define ED_SCROLL2_VERTICAL_XSIZE	ED_SCROLLBUTTON2_XSIZE
#define ED_SCROLL2_VERTICAL_YSIZE	(ED_ELEMENTLIST_BUTTONS_VERT *	\
					 ED_ELEMENTLIST_YSIZE -		\
					 2 * ED_SCROLLBUTTON2_YSIZE)

/* values for ClearEditorGadgetInfoText() and HandleEditorGadgetInfoText() */
#define INFOTEXT_FONT		FONT_TEXT_2
#define INFOTEXT_XSIZE		SXSIZE
#define INFOTEXT_YSIZE		getFontHeight(INFOTEXT_FONT)
#define INFOTEXT_YSIZE_FULL	(INFOTEXT_YSIZE + ED_GADGET_SMALL_DISTANCE)
#define INFOTEXT_XPOS		SX
#define INFOTEXT_YPOS		(SY + SYSIZE - INFOTEXT_YSIZE)


/*
  -----------------------------------------------------------------------------
  editor gadget definitions
  -----------------------------------------------------------------------------
*/

/* drawing toolbox buttons */
#define GADGET_ID_NONE			-1
#define GADGET_ID_TOOLBOX_FIRST		0

#define GADGET_ID_SINGLE_ITEMS		(GADGET_ID_TOOLBOX_FIRST + 0)
#define GADGET_ID_CONNECTED_ITEMS	(GADGET_ID_TOOLBOX_FIRST + 1)
#define GADGET_ID_LINE			(GADGET_ID_TOOLBOX_FIRST + 2)
#define GADGET_ID_ARC			(GADGET_ID_TOOLBOX_FIRST + 3)
#define GADGET_ID_RECTANGLE		(GADGET_ID_TOOLBOX_FIRST + 4)
#define GADGET_ID_FILLED_BOX		(GADGET_ID_TOOLBOX_FIRST + 5)
#define GADGET_ID_WRAP_UP		(GADGET_ID_TOOLBOX_FIRST + 6)
#define GADGET_ID_TEXT			(GADGET_ID_TOOLBOX_FIRST + 7)
#define GADGET_ID_FLOOD_FILL		(GADGET_ID_TOOLBOX_FIRST + 8)
#define GADGET_ID_WRAP_LEFT		(GADGET_ID_TOOLBOX_FIRST + 9)
#define GADGET_ID_ZOOM			(GADGET_ID_TOOLBOX_FIRST + 10)
#define GADGET_ID_WRAP_RIGHT		(GADGET_ID_TOOLBOX_FIRST + 11)
#define GADGET_ID_RANDOM_PLACEMENT	(GADGET_ID_TOOLBOX_FIRST + 12)
#define GADGET_ID_GRAB_BRUSH		(GADGET_ID_TOOLBOX_FIRST + 13)
#define GADGET_ID_WRAP_DOWN		(GADGET_ID_TOOLBOX_FIRST + 14)
#define GADGET_ID_PICK_ELEMENT		(GADGET_ID_TOOLBOX_FIRST + 15)

#define GADGET_ID_UNDO			(GADGET_ID_TOOLBOX_FIRST + 16)
#define GADGET_ID_INFO			(GADGET_ID_TOOLBOX_FIRST + 17)
#define GADGET_ID_SAVE			(GADGET_ID_TOOLBOX_FIRST + 18)
#define GADGET_ID_CLEAR			(GADGET_ID_TOOLBOX_FIRST + 19)
#define GADGET_ID_TEST			(GADGET_ID_TOOLBOX_FIRST + 20)
#define GADGET_ID_EXIT			(GADGET_ID_TOOLBOX_FIRST + 21)

#define GADGET_ID_CUSTOM_COPY_FROM	(GADGET_ID_TOOLBOX_FIRST + 22)
#define GADGET_ID_CUSTOM_COPY_TO	(GADGET_ID_TOOLBOX_FIRST + 23)
#define GADGET_ID_CUSTOM_EXCHANGE	(GADGET_ID_TOOLBOX_FIRST + 24)
#define GADGET_ID_CUSTOM_COPY		(GADGET_ID_TOOLBOX_FIRST + 25)
#define GADGET_ID_CUSTOM_PASTE		(GADGET_ID_TOOLBOX_FIRST + 26)

#define GADGET_ID_PROPERTIES		(GADGET_ID_TOOLBOX_FIRST + 27)

/* counter gadget identifiers */
#define GADGET_ID_COUNTER_FIRST		(GADGET_ID_TOOLBOX_FIRST + 28)

#define GADGET_ID_SELECT_LEVEL_DOWN	(GADGET_ID_COUNTER_FIRST + 0)
#define GADGET_ID_SELECT_LEVEL_TEXT	(GADGET_ID_COUNTER_FIRST + 1)
#define GADGET_ID_SELECT_LEVEL_UP	(GADGET_ID_COUNTER_FIRST + 2)
#define GADGET_ID_LEVEL_XSIZE_DOWN	(GADGET_ID_COUNTER_FIRST + 3)
#define GADGET_ID_LEVEL_XSIZE_TEXT	(GADGET_ID_COUNTER_FIRST + 4)
#define GADGET_ID_LEVEL_XSIZE_UP	(GADGET_ID_COUNTER_FIRST + 5)
#define GADGET_ID_LEVEL_YSIZE_DOWN	(GADGET_ID_COUNTER_FIRST + 6)
#define GADGET_ID_LEVEL_YSIZE_TEXT	(GADGET_ID_COUNTER_FIRST + 7)
#define GADGET_ID_LEVEL_YSIZE_UP	(GADGET_ID_COUNTER_FIRST + 8)
#define GADGET_ID_LEVEL_RANDOM_DOWN	(GADGET_ID_COUNTER_FIRST + 9)
#define GADGET_ID_LEVEL_RANDOM_TEXT	(GADGET_ID_COUNTER_FIRST + 10)
#define GADGET_ID_LEVEL_RANDOM_UP	(GADGET_ID_COUNTER_FIRST + 11)
#define GADGET_ID_LEVEL_GEMSLIMIT_DOWN	(GADGET_ID_COUNTER_FIRST + 12)
#define GADGET_ID_LEVEL_GEMSLIMIT_TEXT	(GADGET_ID_COUNTER_FIRST + 13)
#define GADGET_ID_LEVEL_GEMSLIMIT_UP	(GADGET_ID_COUNTER_FIRST + 14)
#define GADGET_ID_LEVEL_TIMELIMIT_DOWN	(GADGET_ID_COUNTER_FIRST + 15)
#define GADGET_ID_LEVEL_TIMELIMIT_TEXT	(GADGET_ID_COUNTER_FIRST + 16)
#define GADGET_ID_LEVEL_TIMELIMIT_UP	(GADGET_ID_COUNTER_FIRST + 17)
#define GADGET_ID_LEVEL_TIMESCORE_DOWN	(GADGET_ID_COUNTER_FIRST + 18)
#define GADGET_ID_LEVEL_TIMESCORE_TEXT	(GADGET_ID_COUNTER_FIRST + 19)
#define GADGET_ID_LEVEL_TIMESCORE_UP	(GADGET_ID_COUNTER_FIRST + 20)
#define GADGET_ID_LEVEL_RANDOM_SEED_DOWN (GADGET_ID_COUNTER_FIRST + 21)
#define GADGET_ID_LEVEL_RANDOM_SEED_TEXT (GADGET_ID_COUNTER_FIRST + 22)
#define GADGET_ID_LEVEL_RANDOM_SEED_UP	(GADGET_ID_COUNTER_FIRST + 23)
#define GADGET_ID_ELEMENT_VALUE1_DOWN	(GADGET_ID_COUNTER_FIRST + 24)
#define GADGET_ID_ELEMENT_VALUE1_TEXT	(GADGET_ID_COUNTER_FIRST + 25)
#define GADGET_ID_ELEMENT_VALUE1_UP	(GADGET_ID_COUNTER_FIRST + 26)
#define GADGET_ID_ELEMENT_VALUE2_DOWN	(GADGET_ID_COUNTER_FIRST + 27)
#define GADGET_ID_ELEMENT_VALUE2_TEXT	(GADGET_ID_COUNTER_FIRST + 28)
#define GADGET_ID_ELEMENT_VALUE2_UP	(GADGET_ID_COUNTER_FIRST + 29)
#define GADGET_ID_ELEMENT_VALUE3_DOWN	(GADGET_ID_COUNTER_FIRST + 30)
#define GADGET_ID_ELEMENT_VALUE3_TEXT	(GADGET_ID_COUNTER_FIRST + 31)
#define GADGET_ID_ELEMENT_VALUE3_UP	(GADGET_ID_COUNTER_FIRST + 32)
#define GADGET_ID_ELEMENT_VALUE4_DOWN	(GADGET_ID_COUNTER_FIRST + 33)
#define GADGET_ID_ELEMENT_VALUE4_TEXT	(GADGET_ID_COUNTER_FIRST + 34)
#define GADGET_ID_ELEMENT_VALUE4_UP	(GADGET_ID_COUNTER_FIRST + 35)
#define GADGET_ID_YAMYAM_CONTENT_DOWN	(GADGET_ID_COUNTER_FIRST + 36)
#define GADGET_ID_YAMYAM_CONTENT_TEXT	(GADGET_ID_COUNTER_FIRST + 37)
#define GADGET_ID_YAMYAM_CONTENT_UP	(GADGET_ID_COUNTER_FIRST + 38)
#define GADGET_ID_BALL_CONTENT_DOWN	(GADGET_ID_COUNTER_FIRST + 39)
#define GADGET_ID_BALL_CONTENT_TEXT	(GADGET_ID_COUNTER_FIRST + 40)
#define GADGET_ID_BALL_CONTENT_UP	(GADGET_ID_COUNTER_FIRST + 41)
#define GADGET_ID_ANDROID_CONTENT_DOWN	(GADGET_ID_COUNTER_FIRST + 42)
#define GADGET_ID_ANDROID_CONTENT_TEXT	(GADGET_ID_COUNTER_FIRST + 43)
#define GADGET_ID_ANDROID_CONTENT_UP	(GADGET_ID_COUNTER_FIRST + 44)
#define GADGET_ID_ENVELOPE_XSIZE_DOWN	(GADGET_ID_COUNTER_FIRST + 45)
#define GADGET_ID_ENVELOPE_XSIZE_TEXT	(GADGET_ID_COUNTER_FIRST + 46)
#define GADGET_ID_ENVELOPE_XSIZE_UP	(GADGET_ID_COUNTER_FIRST + 47)
#define GADGET_ID_ENVELOPE_YSIZE_DOWN	(GADGET_ID_COUNTER_FIRST + 48)
#define GADGET_ID_ENVELOPE_YSIZE_TEXT	(GADGET_ID_COUNTER_FIRST + 49)
#define GADGET_ID_ENVELOPE_YSIZE_UP	(GADGET_ID_COUNTER_FIRST + 50)
#define GADGET_ID_INVENTORY_SIZE_DOWN	(GADGET_ID_COUNTER_FIRST + 51)
#define GADGET_ID_INVENTORY_SIZE_TEXT	(GADGET_ID_COUNTER_FIRST + 52)
#define GADGET_ID_INVENTORY_SIZE_UP	(GADGET_ID_COUNTER_FIRST + 53)
#define GADGET_ID_CUSTOM_SCORE_DOWN	(GADGET_ID_COUNTER_FIRST + 54)
#define GADGET_ID_CUSTOM_SCORE_TEXT	(GADGET_ID_COUNTER_FIRST + 55)
#define GADGET_ID_CUSTOM_SCORE_UP	(GADGET_ID_COUNTER_FIRST + 56)
#define GADGET_ID_CUSTOM_GEMCOUNT_DOWN	(GADGET_ID_COUNTER_FIRST + 57)
#define GADGET_ID_CUSTOM_GEMCOUNT_TEXT	(GADGET_ID_COUNTER_FIRST + 58)
#define GADGET_ID_CUSTOM_GEMCOUNT_UP	(GADGET_ID_COUNTER_FIRST + 59)
#define GADGET_ID_CUSTOM_VALUE_FIX_DOWN	(GADGET_ID_COUNTER_FIRST + 60)
#define GADGET_ID_CUSTOM_VALUE_FIX_TEXT	(GADGET_ID_COUNTER_FIRST + 61)
#define GADGET_ID_CUSTOM_VALUE_FIX_UP	(GADGET_ID_COUNTER_FIRST + 62)
#define GADGET_ID_CUSTOM_VALUE_RND_DOWN	(GADGET_ID_COUNTER_FIRST + 63)
#define GADGET_ID_CUSTOM_VALUE_RND_TEXT	(GADGET_ID_COUNTER_FIRST + 64)
#define GADGET_ID_CUSTOM_VALUE_RND_UP	(GADGET_ID_COUNTER_FIRST + 65)
#define GADGET_ID_PUSH_DELAY_FIX_DOWN	(GADGET_ID_COUNTER_FIRST + 66)
#define GADGET_ID_PUSH_DELAY_FIX_TEXT	(GADGET_ID_COUNTER_FIRST + 67)
#define GADGET_ID_PUSH_DELAY_FIX_UP	(GADGET_ID_COUNTER_FIRST + 68)
#define GADGET_ID_PUSH_DELAY_RND_DOWN	(GADGET_ID_COUNTER_FIRST + 69)
#define GADGET_ID_PUSH_DELAY_RND_TEXT	(GADGET_ID_COUNTER_FIRST + 70)
#define GADGET_ID_PUSH_DELAY_RND_UP	(GADGET_ID_COUNTER_FIRST + 71)
#define GADGET_ID_DROP_DELAY_FIX_DOWN	(GADGET_ID_COUNTER_FIRST + 72)
#define GADGET_ID_DROP_DELAY_FIX_TEXT	(GADGET_ID_COUNTER_FIRST + 73)
#define GADGET_ID_DROP_DELAY_FIX_UP	(GADGET_ID_COUNTER_FIRST + 74)
#define GADGET_ID_DROP_DELAY_RND_DOWN	(GADGET_ID_COUNTER_FIRST + 75)
#define GADGET_ID_DROP_DELAY_RND_TEXT	(GADGET_ID_COUNTER_FIRST + 76)
#define GADGET_ID_DROP_DELAY_RND_UP	(GADGET_ID_COUNTER_FIRST + 77)
#define GADGET_ID_MOVE_DELAY_FIX_DOWN	(GADGET_ID_COUNTER_FIRST + 78)
#define GADGET_ID_MOVE_DELAY_FIX_TEXT	(GADGET_ID_COUNTER_FIRST + 79)
#define GADGET_ID_MOVE_DELAY_FIX_UP	(GADGET_ID_COUNTER_FIRST + 80)
#define GADGET_ID_MOVE_DELAY_RND_DOWN	(GADGET_ID_COUNTER_FIRST + 81)
#define GADGET_ID_MOVE_DELAY_RND_TEXT	(GADGET_ID_COUNTER_FIRST + 82)
#define GADGET_ID_MOVE_DELAY_RND_UP	(GADGET_ID_COUNTER_FIRST + 83)
#define GADGET_ID_EXPLOSION_DELAY_DOWN	(GADGET_ID_COUNTER_FIRST + 84)
#define GADGET_ID_EXPLOSION_DELAY_TEXT	(GADGET_ID_COUNTER_FIRST + 85)
#define GADGET_ID_EXPLOSION_DELAY_UP	(GADGET_ID_COUNTER_FIRST + 86)
#define GADGET_ID_IGNITION_DELAY_DOWN	(GADGET_ID_COUNTER_FIRST + 87)
#define GADGET_ID_IGNITION_DELAY_TEXT	(GADGET_ID_COUNTER_FIRST + 88)
#define GADGET_ID_IGNITION_DELAY_UP	(GADGET_ID_COUNTER_FIRST + 89)
#define GADGET_ID_CHANGE_DELAY_FIX_DOWN	(GADGET_ID_COUNTER_FIRST + 90)
#define GADGET_ID_CHANGE_DELAY_FIX_TEXT	(GADGET_ID_COUNTER_FIRST + 91)
#define GADGET_ID_CHANGE_DELAY_FIX_UP	(GADGET_ID_COUNTER_FIRST + 92)
#define GADGET_ID_CHANGE_DELAY_RND_DOWN	(GADGET_ID_COUNTER_FIRST + 93)
#define GADGET_ID_CHANGE_DELAY_RND_TEXT	(GADGET_ID_COUNTER_FIRST + 94)
#define GADGET_ID_CHANGE_DELAY_RND_UP	(GADGET_ID_COUNTER_FIRST + 95)
#define GADGET_ID_CHANGE_CONT_RND_DOWN	(GADGET_ID_COUNTER_FIRST + 96)
#define GADGET_ID_CHANGE_CONT_RND_TEXT	(GADGET_ID_COUNTER_FIRST + 97)
#define GADGET_ID_CHANGE_CONT_RND_UP	(GADGET_ID_COUNTER_FIRST + 98)
#define GADGET_ID_GROUP_CONTENT_DOWN	(GADGET_ID_COUNTER_FIRST + 99)
#define GADGET_ID_GROUP_CONTENT_TEXT	(GADGET_ID_COUNTER_FIRST + 100)
#define GADGET_ID_GROUP_CONTENT_UP	(GADGET_ID_COUNTER_FIRST + 101)

/* drawing area identifiers */
#define GADGET_ID_DRAWING_AREA_FIRST	(GADGET_ID_COUNTER_FIRST + 102)

#define GADGET_ID_DRAWING_LEVEL		(GADGET_ID_DRAWING_AREA_FIRST + 0)
#define GADGET_ID_YAMYAM_CONTENT_0	(GADGET_ID_DRAWING_AREA_FIRST + 1)
#define GADGET_ID_YAMYAM_CONTENT_1	(GADGET_ID_DRAWING_AREA_FIRST + 2)
#define GADGET_ID_YAMYAM_CONTENT_2	(GADGET_ID_DRAWING_AREA_FIRST + 3)
#define GADGET_ID_YAMYAM_CONTENT_3	(GADGET_ID_DRAWING_AREA_FIRST + 4)
#define GADGET_ID_YAMYAM_CONTENT_4	(GADGET_ID_DRAWING_AREA_FIRST + 5)
#define GADGET_ID_YAMYAM_CONTENT_5	(GADGET_ID_DRAWING_AREA_FIRST + 6)
#define GADGET_ID_YAMYAM_CONTENT_6	(GADGET_ID_DRAWING_AREA_FIRST + 7)
#define GADGET_ID_YAMYAM_CONTENT_7	(GADGET_ID_DRAWING_AREA_FIRST + 8)
#define GADGET_ID_MAGIC_BALL_CONTENT_0	(GADGET_ID_DRAWING_AREA_FIRST + 9)
#define GADGET_ID_MAGIC_BALL_CONTENT_1	(GADGET_ID_DRAWING_AREA_FIRST + 10)
#define GADGET_ID_MAGIC_BALL_CONTENT_2	(GADGET_ID_DRAWING_AREA_FIRST + 11)
#define GADGET_ID_MAGIC_BALL_CONTENT_3	(GADGET_ID_DRAWING_AREA_FIRST + 12)
#define GADGET_ID_MAGIC_BALL_CONTENT_4	(GADGET_ID_DRAWING_AREA_FIRST + 13)
#define GADGET_ID_MAGIC_BALL_CONTENT_5	(GADGET_ID_DRAWING_AREA_FIRST + 14)
#define GADGET_ID_MAGIC_BALL_CONTENT_6	(GADGET_ID_DRAWING_AREA_FIRST + 15)
#define GADGET_ID_MAGIC_BALL_CONTENT_7	(GADGET_ID_DRAWING_AREA_FIRST + 16)
#define GADGET_ID_ANDROID_CONTENT	(GADGET_ID_DRAWING_AREA_FIRST + 17)
#define GADGET_ID_AMOEBA_CONTENT	(GADGET_ID_DRAWING_AREA_FIRST + 18)
#define GADGET_ID_START_ELEMENT		(GADGET_ID_DRAWING_AREA_FIRST + 19)
#define GADGET_ID_ARTWORK_ELEMENT	(GADGET_ID_DRAWING_AREA_FIRST + 20)
#define GADGET_ID_EXPLOSION_ELEMENT	(GADGET_ID_DRAWING_AREA_FIRST + 21)
#define GADGET_ID_INVENTORY_CONTENT	(GADGET_ID_DRAWING_AREA_FIRST + 22)
#define GADGET_ID_CUSTOM_GRAPHIC	(GADGET_ID_DRAWING_AREA_FIRST + 23)
#define GADGET_ID_CUSTOM_CONTENT	(GADGET_ID_DRAWING_AREA_FIRST + 24)
#define GADGET_ID_CUSTOM_MOVE_ENTER	(GADGET_ID_DRAWING_AREA_FIRST + 25)
#define GADGET_ID_CUSTOM_MOVE_LEAVE	(GADGET_ID_DRAWING_AREA_FIRST + 26)
#define GADGET_ID_CUSTOM_CHANGE_TARGET	(GADGET_ID_DRAWING_AREA_FIRST + 27)
#define GADGET_ID_CUSTOM_CHANGE_CONTENT	(GADGET_ID_DRAWING_AREA_FIRST + 28)
#define GADGET_ID_CUSTOM_CHANGE_TRIGGER	(GADGET_ID_DRAWING_AREA_FIRST + 29)
#define GADGET_ID_CUSTOM_CHANGE_ACTION	(GADGET_ID_DRAWING_AREA_FIRST + 30)
#define GADGET_ID_GROUP_CONTENT		(GADGET_ID_DRAWING_AREA_FIRST + 31)
#define GADGET_ID_RANDOM_BACKGROUND	(GADGET_ID_DRAWING_AREA_FIRST + 32)

/* text input identifiers */
#define GADGET_ID_TEXT_INPUT_FIRST	(GADGET_ID_DRAWING_AREA_FIRST + 33)

#define GADGET_ID_LEVEL_NAME		(GADGET_ID_TEXT_INPUT_FIRST + 0)
#define GADGET_ID_LEVEL_AUTHOR		(GADGET_ID_TEXT_INPUT_FIRST + 1)
#define GADGET_ID_ELEMENT_NAME		(GADGET_ID_TEXT_INPUT_FIRST + 2)

/* text area identifiers */
#define GADGET_ID_TEXT_AREA_FIRST	(GADGET_ID_TEXT_INPUT_FIRST + 3)

#define GADGET_ID_ENVELOPE_INFO		(GADGET_ID_TEXT_AREA_FIRST + 0)

/* selectbox identifiers */
#define GADGET_ID_SELECTBOX_FIRST	(GADGET_ID_TEXT_AREA_FIRST + 1)

#define GADGET_ID_TIME_OR_STEPS		(GADGET_ID_SELECTBOX_FIRST + 0)
#define GADGET_ID_GAME_ENGINE_TYPE	(GADGET_ID_SELECTBOX_FIRST + 1)
#define GADGET_ID_WIND_DIRECTION	(GADGET_ID_SELECTBOX_FIRST + 2)
#define GADGET_ID_PLAYER_SPEED		(GADGET_ID_SELECTBOX_FIRST + 3)
#define GADGET_ID_CUSTOM_WALK_TO_ACTION	(GADGET_ID_SELECTBOX_FIRST + 4)
#define GADGET_ID_CUSTOM_EXPLOSION_TYPE	(GADGET_ID_SELECTBOX_FIRST + 5)
#define GADGET_ID_CUSTOM_DEADLINESS	(GADGET_ID_SELECTBOX_FIRST + 6)
#define GADGET_ID_CUSTOM_MOVE_PATTERN	(GADGET_ID_SELECTBOX_FIRST + 7)
#define GADGET_ID_CUSTOM_MOVE_DIRECTION	(GADGET_ID_SELECTBOX_FIRST + 8)
#define GADGET_ID_CUSTOM_MOVE_STEPSIZE	(GADGET_ID_SELECTBOX_FIRST + 9)
#define GADGET_ID_CUSTOM_MOVE_LEAVE_TYPE (GADGET_ID_SELECTBOX_FIRST + 10)
#define GADGET_ID_CUSTOM_SMASH_TARGETS	(GADGET_ID_SELECTBOX_FIRST + 11)
#define GADGET_ID_CUSTOM_SLIPPERY_TYPE	(GADGET_ID_SELECTBOX_FIRST + 12)
#define GADGET_ID_CUSTOM_ACCESS_TYPE	(GADGET_ID_SELECTBOX_FIRST + 13)
#define GADGET_ID_CUSTOM_ACCESS_LAYER	(GADGET_ID_SELECTBOX_FIRST + 14)
#define GADGET_ID_CUSTOM_ACCESS_PROTECTED (GADGET_ID_SELECTBOX_FIRST + 15)
#define GADGET_ID_CUSTOM_ACCESS_DIRECTION (GADGET_ID_SELECTBOX_FIRST + 16)
#define GADGET_ID_CHANGE_TIME_UNITS	(GADGET_ID_SELECTBOX_FIRST + 17)
#define GADGET_ID_CHANGE_DIRECT_ACTION	(GADGET_ID_SELECTBOX_FIRST + 18)
#define GADGET_ID_CHANGE_OTHER_ACTION	(GADGET_ID_SELECTBOX_FIRST + 19)
#define GADGET_ID_CHANGE_SIDE		(GADGET_ID_SELECTBOX_FIRST + 20)
#define GADGET_ID_CHANGE_PLAYER		(GADGET_ID_SELECTBOX_FIRST + 21)
#define GADGET_ID_CHANGE_PAGE		(GADGET_ID_SELECTBOX_FIRST + 22)
#define GADGET_ID_CHANGE_REPLACE_WHEN	(GADGET_ID_SELECTBOX_FIRST + 23)
#define GADGET_ID_ACTION_TYPE		(GADGET_ID_SELECTBOX_FIRST + 24)
#define GADGET_ID_ACTION_MODE		(GADGET_ID_SELECTBOX_FIRST + 25)
#define GADGET_ID_ACTION_ARG		(GADGET_ID_SELECTBOX_FIRST + 26)
#define GADGET_ID_SELECT_CHANGE_PAGE	(GADGET_ID_SELECTBOX_FIRST + 27)
#define GADGET_ID_GROUP_CHOICE_MODE	(GADGET_ID_SELECTBOX_FIRST + 28)

/* textbutton identifiers */
#define GADGET_ID_TEXTBUTTON_FIRST	(GADGET_ID_SELECTBOX_FIRST + 29)

#define GADGET_ID_LEVELINFO_LEVEL	(GADGET_ID_TEXTBUTTON_FIRST + 0)
#define GADGET_ID_LEVELINFO_EDITOR	(GADGET_ID_TEXTBUTTON_FIRST + 1)
#define GADGET_ID_PROPERTIES_INFO	(GADGET_ID_TEXTBUTTON_FIRST + 2)
#define GADGET_ID_PROPERTIES_CONFIG	(GADGET_ID_TEXTBUTTON_FIRST + 3)
#define GADGET_ID_PROPERTIES_CONFIG_1	(GADGET_ID_TEXTBUTTON_FIRST + 4)
#define GADGET_ID_PROPERTIES_CONFIG_2	(GADGET_ID_TEXTBUTTON_FIRST + 5)
#define GADGET_ID_PROPERTIES_CHANGE	(GADGET_ID_TEXTBUTTON_FIRST + 6)
#define GADGET_ID_SAVE_AS_TEMPLATE	(GADGET_ID_TEXTBUTTON_FIRST + 7)
#define GADGET_ID_ADD_CHANGE_PAGE	(GADGET_ID_TEXTBUTTON_FIRST + 8)
#define GADGET_ID_DEL_CHANGE_PAGE	(GADGET_ID_TEXTBUTTON_FIRST + 9)

/* graphicbutton identifiers */
#define GADGET_ID_GRAPHICBUTTON_FIRST	(GADGET_ID_TEXTBUTTON_FIRST + 10)

#define GADGET_ID_PREV_CHANGE_PAGE	(GADGET_ID_GRAPHICBUTTON_FIRST + 0)
#define GADGET_ID_NEXT_CHANGE_PAGE	(GADGET_ID_GRAPHICBUTTON_FIRST + 1)
#define GADGET_ID_COPY_CHANGE_PAGE	(GADGET_ID_GRAPHICBUTTON_FIRST + 2)
#define GADGET_ID_PASTE_CHANGE_PAGE	(GADGET_ID_GRAPHICBUTTON_FIRST + 3)

/* gadgets for scrolling of drawing area */
#define GADGET_ID_SCROLLING_FIRST	(GADGET_ID_GRAPHICBUTTON_FIRST + 4)

#define GADGET_ID_SCROLL_UP		(GADGET_ID_SCROLLING_FIRST + 0)
#define GADGET_ID_SCROLL_DOWN		(GADGET_ID_SCROLLING_FIRST + 1)
#define GADGET_ID_SCROLL_LEFT		(GADGET_ID_SCROLLING_FIRST + 2)
#define GADGET_ID_SCROLL_RIGHT		(GADGET_ID_SCROLLING_FIRST + 3)
#define GADGET_ID_SCROLL_HORIZONTAL	(GADGET_ID_SCROLLING_FIRST + 4)
#define GADGET_ID_SCROLL_VERTICAL	(GADGET_ID_SCROLLING_FIRST + 5)

/* gadgets for scrolling element list */
#define GADGET_ID_SCROLLING_LIST_FIRST	(GADGET_ID_SCROLLING_FIRST + 6)

#define GADGET_ID_SCROLL_LIST_UP	(GADGET_ID_SCROLLING_LIST_FIRST + 0)
#define GADGET_ID_SCROLL_LIST_DOWN	(GADGET_ID_SCROLLING_LIST_FIRST + 1)
#define GADGET_ID_SCROLL_LIST_VERTICAL	(GADGET_ID_SCROLLING_LIST_FIRST + 2)

/* checkbuttons/radiobuttons for level/element properties */
#define GADGET_ID_CHECKBUTTON_FIRST	(GADGET_ID_SCROLLING_LIST_FIRST + 3)

#define GADGET_ID_RANDOM_PERCENTAGE	(GADGET_ID_CHECKBUTTON_FIRST + 0)
#define GADGET_ID_RANDOM_QUANTITY	(GADGET_ID_CHECKBUTTON_FIRST + 1)
#define GADGET_ID_RANDOM_RESTRICTED	(GADGET_ID_CHECKBUTTON_FIRST + 2)
#define GADGET_ID_STICK_ELEMENT		(GADGET_ID_CHECKBUTTON_FIRST + 3)
#define GADGET_ID_EM_SLIPPERY_GEMS	(GADGET_ID_CHECKBUTTON_FIRST + 4)
#define GADGET_ID_EM_EXPLODES_BY_FIRE	(GADGET_ID_CHECKBUTTON_FIRST + 5)
#define GADGET_ID_USE_SPRING_BUG	(GADGET_ID_CHECKBUTTON_FIRST + 6)
#define GADGET_ID_USE_TIME_ORB_BUG	(GADGET_ID_CHECKBUTTON_FIRST + 7)
#define GADGET_ID_RANDOM_BALL_CONTENT	(GADGET_ID_CHECKBUTTON_FIRST + 8)
#define GADGET_ID_INITIAL_BALL_STATE	(GADGET_ID_CHECKBUTTON_FIRST + 9)
#define GADGET_ID_GROW_INTO_DIGGABLE	(GADGET_ID_CHECKBUTTON_FIRST + 10)
#define GADGET_ID_AUTO_EXIT_SOKOBAN	(GADGET_ID_CHECKBUTTON_FIRST + 11)
#define GADGET_ID_CONTINUOUS_SNAPPING	(GADGET_ID_CHECKBUTTON_FIRST + 12)
#define GADGET_ID_BLOCK_SNAP_FIELD	(GADGET_ID_CHECKBUTTON_FIRST + 13)
#define GADGET_ID_BLOCK_LAST_FIELD	(GADGET_ID_CHECKBUTTON_FIRST + 14)
#define GADGET_ID_SP_BLOCK_LAST_FIELD	(GADGET_ID_CHECKBUTTON_FIRST + 15)
#define GADGET_ID_INSTANT_RELOCATION	(GADGET_ID_CHECKBUTTON_FIRST + 16)
#define GADGET_ID_SHIFTED_RELOCATION	(GADGET_ID_CHECKBUTTON_FIRST + 17)
#define GADGET_ID_LAZY_RELOCATION	(GADGET_ID_CHECKBUTTON_FIRST + 18)
#define GADGET_ID_USE_START_ELEMENT	(GADGET_ID_CHECKBUTTON_FIRST + 19)
#define GADGET_ID_USE_ARTWORK_ELEMENT	(GADGET_ID_CHECKBUTTON_FIRST + 20)
#define GADGET_ID_USE_EXPLOSION_ELEMENT	(GADGET_ID_CHECKBUTTON_FIRST + 21)
#define GADGET_ID_INITIAL_GRAVITY	(GADGET_ID_CHECKBUTTON_FIRST + 22)
#define GADGET_ID_USE_INITIAL_INVENTORY	(GADGET_ID_CHECKBUTTON_FIRST + 23)
#define GADGET_ID_CAN_PASS_TO_WALKABLE	(GADGET_ID_CHECKBUTTON_FIRST + 24)
#define GADGET_ID_CAN_FALL_INTO_ACID	(GADGET_ID_CHECKBUTTON_FIRST + 25)
#define GADGET_ID_CAN_MOVE_INTO_ACID	(GADGET_ID_CHECKBUTTON_FIRST + 26)
#define GADGET_ID_DONT_COLLIDE_WITH	(GADGET_ID_CHECKBUTTON_FIRST + 27)
#define GADGET_ID_ENVELOPE_AUTOWRAP	(GADGET_ID_CHECKBUTTON_FIRST + 28)
#define GADGET_ID_ENVELOPE_CENTERED	(GADGET_ID_CHECKBUTTON_FIRST + 29)
#define GADGET_ID_CUSTOM_INDESTRUCTIBLE	(GADGET_ID_CHECKBUTTON_FIRST + 30)
#define GADGET_ID_CUSTOM_CAN_EXPLODE	(GADGET_ID_CHECKBUTTON_FIRST + 31)
#define GADGET_ID_CUSTOM_EXPLODE_FIRE	(GADGET_ID_CHECKBUTTON_FIRST + 32)
#define GADGET_ID_CUSTOM_EXPLODE_SMASH	(GADGET_ID_CHECKBUTTON_FIRST + 33)
#define GADGET_ID_CUSTOM_EXPLODE_IMPACT	(GADGET_ID_CHECKBUTTON_FIRST + 34)
#define GADGET_ID_CUSTOM_WALK_TO_OBJECT	(GADGET_ID_CHECKBUTTON_FIRST + 35)
#define GADGET_ID_CUSTOM_DEADLY		(GADGET_ID_CHECKBUTTON_FIRST + 36)
#define GADGET_ID_CUSTOM_CAN_MOVE	(GADGET_ID_CHECKBUTTON_FIRST + 37)
#define GADGET_ID_CUSTOM_CAN_FALL	(GADGET_ID_CHECKBUTTON_FIRST + 38)
#define GADGET_ID_CUSTOM_CAN_SMASH	(GADGET_ID_CHECKBUTTON_FIRST + 39)
#define GADGET_ID_CUSTOM_SLIPPERY	(GADGET_ID_CHECKBUTTON_FIRST + 40)
#define GADGET_ID_CUSTOM_ACCESSIBLE	(GADGET_ID_CHECKBUTTON_FIRST + 41)
#define GADGET_ID_CUSTOM_GRAV_REACHABLE	(GADGET_ID_CHECKBUTTON_FIRST + 42)
#define GADGET_ID_CUSTOM_USE_LAST_VALUE	(GADGET_ID_CHECKBUTTON_FIRST + 43)
#define GADGET_ID_CUSTOM_USE_GRAPHIC	(GADGET_ID_CHECKBUTTON_FIRST + 44)
#define GADGET_ID_CUSTOM_USE_TEMPLATE	(GADGET_ID_CHECKBUTTON_FIRST + 45)
#define GADGET_ID_CUSTOM_CAN_CHANGE	(GADGET_ID_CHECKBUTTON_FIRST + 46)
#define GADGET_ID_CHANGE_USE_CONTENT	(GADGET_ID_CHECKBUTTON_FIRST + 47)
#define GADGET_ID_CHANGE_USE_EXPLOSION	(GADGET_ID_CHECKBUTTON_FIRST + 48)
#define GADGET_ID_CHANGE_ONLY_COMPLETE	(GADGET_ID_CHECKBUTTON_FIRST + 49)
#define GADGET_ID_CHANGE_USE_RANDOM	(GADGET_ID_CHECKBUTTON_FIRST + 50)
#define GADGET_ID_CHANGE_HAS_ACTION	(GADGET_ID_CHECKBUTTON_FIRST + 51)
#define GADGET_ID_CHANGE_DELAY		(GADGET_ID_CHECKBUTTON_FIRST + 52)
#define GADGET_ID_CHANGE_BY_DIRECT_ACT	(GADGET_ID_CHECKBUTTON_FIRST + 53)
#define GADGET_ID_CHANGE_BY_OTHER_ACT	(GADGET_ID_CHECKBUTTON_FIRST + 54)

/* gadgets for buttons in element list */
#define GADGET_ID_ELEMENTLIST_FIRST	(GADGET_ID_CHECKBUTTON_FIRST + 55)
#define GADGET_ID_ELEMENTLIST_LAST	(GADGET_ID_ELEMENTLIST_FIRST +	\
	 				ED_NUM_ELEMENTLIST_BUTTONS - 1)

#define NUM_EDITOR_GADGETS		(GADGET_ID_ELEMENTLIST_LAST + 1)

/* radio button numbers */
#define RADIO_NR_NONE			0
#define RADIO_NR_DRAWING_TOOLBOX	1
#define RADIO_NR_RANDOM_ELEMENTS	2

/* values for counter gadgets */
#define ED_COUNTER_ID_SELECT_LEVEL	0
#define ED_COUNTER_ID_LEVEL_XSIZE	1
#define ED_COUNTER_ID_LEVEL_YSIZE	2
#define ED_COUNTER_ID_LEVEL_GEMSLIMIT	3
#define ED_COUNTER_ID_LEVEL_TIMELIMIT	4
#define ED_COUNTER_ID_LEVEL_TIMESCORE	5
#define ED_COUNTER_ID_LEVEL_RANDOM_SEED	6
#define ED_COUNTER_ID_LEVEL_RANDOM	7
#define ED_COUNTER_ID_ELEMENT_VALUE1	8
#define ED_COUNTER_ID_ELEMENT_VALUE2	9
#define ED_COUNTER_ID_ELEMENT_VALUE3	10
#define ED_COUNTER_ID_ELEMENT_VALUE4	11
#define ED_COUNTER_ID_YAMYAM_CONTENT	12
#define ED_COUNTER_ID_BALL_CONTENT	13
#define ED_COUNTER_ID_ANDROID_CONTENT	14
#define ED_COUNTER_ID_ENVELOPE_XSIZE	15
#define ED_COUNTER_ID_ENVELOPE_YSIZE	16
#define ED_COUNTER_ID_INVENTORY_SIZE	17
#define ED_COUNTER_ID_CUSTOM_SCORE	18
#define ED_COUNTER_ID_CUSTOM_GEMCOUNT	19
#define ED_COUNTER_ID_CUSTOM_VALUE_FIX	20
#define ED_COUNTER_ID_CUSTOM_VALUE_RND	21
#define ED_COUNTER_ID_PUSH_DELAY_FIX	22
#define ED_COUNTER_ID_PUSH_DELAY_RND	23
#define ED_COUNTER_ID_DROP_DELAY_FIX	24
#define ED_COUNTER_ID_DROP_DELAY_RND	25
#define ED_COUNTER_ID_MOVE_DELAY_FIX	26
#define ED_COUNTER_ID_MOVE_DELAY_RND	27
#define ED_COUNTER_ID_EXPLOSION_DELAY	28
#define ED_COUNTER_ID_IGNITION_DELAY	29
#define ED_COUNTER_ID_GROUP_CONTENT	30
#define ED_COUNTER_ID_CHANGE_DELAY_FIX	31
#define ED_COUNTER_ID_CHANGE_DELAY_RND	32
#define ED_COUNTER_ID_CHANGE_CONT_RND	33

#define ED_NUM_COUNTERBUTTONS		34

#define ED_COUNTER_ID_LEVEL_FIRST	ED_COUNTER_ID_LEVEL_XSIZE
#define ED_COUNTER_ID_LEVEL_LAST	ED_COUNTER_ID_LEVEL_RANDOM_SEED
#define ED_COUNTER_ID_EDITOR_FIRST	ED_COUNTER_ID_LEVEL_RANDOM
#define ED_COUNTER_ID_EDITOR_LAST	ED_COUNTER_ID_LEVEL_RANDOM

#define ED_COUNTER_ID_CUSTOM1_FIRST	ED_COUNTER_ID_CUSTOM_SCORE
#define ED_COUNTER_ID_CUSTOM1_LAST	ED_COUNTER_ID_DROP_DELAY_RND
#define ED_COUNTER_ID_CUSTOM2_FIRST	ED_COUNTER_ID_MOVE_DELAY_FIX
#define ED_COUNTER_ID_CUSTOM2_LAST	ED_COUNTER_ID_IGNITION_DELAY
#define ED_COUNTER_ID_CUSTOM_FIRST	ED_COUNTER_ID_CUSTOM1_FIRST
#define ED_COUNTER_ID_CUSTOM_LAST	ED_COUNTER_ID_CUSTOM2_LAST

#define ED_COUNTER_ID_CHANGE_FIRST	ED_COUNTER_ID_CHANGE_DELAY_FIX
#define ED_COUNTER_ID_CHANGE_LAST	ED_COUNTER_ID_CHANGE_CONT_RND

/* values for scrollbutton gadgets */
#define ED_SCROLLBUTTON_ID_AREA_UP	0
#define ED_SCROLLBUTTON_ID_AREA_DOWN	1
#define ED_SCROLLBUTTON_ID_AREA_LEFT	2
#define ED_SCROLLBUTTON_ID_AREA_RIGHT	3
#define ED_SCROLLBUTTON_ID_LIST_UP	4
#define ED_SCROLLBUTTON_ID_LIST_DOWN	5

#define ED_NUM_SCROLLBUTTONS		6

#define ED_SCROLLBUTTON_ID_AREA_FIRST	ED_SCROLLBUTTON_ID_AREA_UP
#define ED_SCROLLBUTTON_ID_AREA_LAST	ED_SCROLLBUTTON_ID_AREA_RIGHT

/* values for scrollbar gadgets */
#define ED_SCROLLBAR_ID_AREA_HORIZONTAL	0
#define ED_SCROLLBAR_ID_AREA_VERTICAL	1
#define ED_SCROLLBAR_ID_LIST_VERTICAL	2

#define ED_NUM_SCROLLBARS		3

#define ED_SCROLLBAR_ID_AREA_FIRST	ED_SCROLLBAR_ID_AREA_HORIZONTAL
#define ED_SCROLLBAR_ID_AREA_LAST	ED_SCROLLBAR_ID_AREA_VERTICAL

/* values for text input gadgets */
#define ED_TEXTINPUT_ID_LEVEL_NAME	0
#define ED_TEXTINPUT_ID_LEVEL_AUTHOR	1
#define ED_TEXTINPUT_ID_ELEMENT_NAME	2

#define ED_NUM_TEXTINPUT		3

#define ED_TEXTINPUT_ID_LEVEL_FIRST	ED_TEXTINPUT_ID_LEVEL_NAME
#define ED_TEXTINPUT_ID_LEVEL_LAST	ED_TEXTINPUT_ID_LEVEL_AUTHOR

/* values for text area gadgets */
#define ED_TEXTAREA_ID_ENVELOPE_INFO	0

#define ED_NUM_TEXTAREAS			1

#define ED_TEXTAREA_ID_LEVEL_FIRST	ED_TEXTAREA_ID_ENVELOPE
#define ED_TEXTAREA_ID_LEVEL_LAST	ED_TEXTAREA_ID_ENVELOPE

/* values for selectbox gadgets */
#define ED_SELECTBOX_ID_TIME_OR_STEPS		0
#define ED_SELECTBOX_ID_GAME_ENGINE_TYPE	1
#define ED_SELECTBOX_ID_WIND_DIRECTION		2
#define ED_SELECTBOX_ID_PLAYER_SPEED		3
#define ED_SELECTBOX_ID_CUSTOM_ACCESS_TYPE	4
#define ED_SELECTBOX_ID_CUSTOM_ACCESS_LAYER	5
#define ED_SELECTBOX_ID_CUSTOM_ACCESS_PROTECTED	6
#define ED_SELECTBOX_ID_CUSTOM_ACCESS_DIRECTION	7
#define ED_SELECTBOX_ID_CUSTOM_WALK_TO_ACTION	8
#define ED_SELECTBOX_ID_CUSTOM_MOVE_PATTERN	9
#define ED_SELECTBOX_ID_CUSTOM_MOVE_DIRECTION	10	
#define ED_SELECTBOX_ID_CUSTOM_MOVE_STEPSIZE	11
#define ED_SELECTBOX_ID_CUSTOM_MOVE_LEAVE_TYPE	12
#define ED_SELECTBOX_ID_CUSTOM_SMASH_TARGETS	13
#define ED_SELECTBOX_ID_CUSTOM_SLIPPERY_TYPE	14
#define ED_SELECTBOX_ID_CUSTOM_DEADLINESS	15
#define ED_SELECTBOX_ID_CUSTOM_EXPLOSION_TYPE	16
#define ED_SELECTBOX_ID_CHANGE_TIME_UNITS	17
#define ED_SELECTBOX_ID_CHANGE_DIRECT_ACTION	18
#define ED_SELECTBOX_ID_CHANGE_OTHER_ACTION	19
#define ED_SELECTBOX_ID_CHANGE_SIDE		20
#define ED_SELECTBOX_ID_CHANGE_PLAYER		21
#define ED_SELECTBOX_ID_CHANGE_PAGE		22
#define ED_SELECTBOX_ID_CHANGE_REPLACE_WHEN	23
#define ED_SELECTBOX_ID_ACTION_TYPE		24
#define ED_SELECTBOX_ID_ACTION_MODE		25
#define ED_SELECTBOX_ID_ACTION_ARG		26
#define ED_SELECTBOX_ID_SELECT_CHANGE_PAGE	27
#define ED_SELECTBOX_ID_GROUP_CHOICE_MODE	28

#define ED_NUM_SELECTBOX			29

#define ED_SELECTBOX_ID_LEVEL_FIRST	ED_SELECTBOX_ID_TIME_OR_STEPS
#define ED_SELECTBOX_ID_LEVEL_LAST	ED_SELECTBOX_ID_WIND_DIRECTION

#define ED_SELECTBOX_ID_CUSTOM1_FIRST	ED_SELECTBOX_ID_CUSTOM_ACCESS_TYPE
#define ED_SELECTBOX_ID_CUSTOM1_LAST	ED_SELECTBOX_ID_CUSTOM_WALK_TO_ACTION
#define ED_SELECTBOX_ID_CUSTOM2_FIRST	ED_SELECTBOX_ID_CUSTOM_MOVE_PATTERN
#define ED_SELECTBOX_ID_CUSTOM2_LAST	ED_SELECTBOX_ID_CUSTOM_EXPLOSION_TYPE
#define ED_SELECTBOX_ID_CUSTOM_FIRST	ED_SELECTBOX_ID_CUSTOM1_FIRST
#define ED_SELECTBOX_ID_CUSTOM_LAST	ED_SELECTBOX_ID_CUSTOM2_LAST

#define ED_SELECTBOX_ID_CHANGE_FIRST	ED_SELECTBOX_ID_CHANGE_TIME_UNITS
#define ED_SELECTBOX_ID_CHANGE_LAST	ED_SELECTBOX_ID_SELECT_CHANGE_PAGE

/* values for textbutton gadgets */
#define ED_TEXTBUTTON_ID_LEVELINFO_LEVEL	0
#define ED_TEXTBUTTON_ID_LEVELINFO_EDITOR	1
#define ED_TEXTBUTTON_ID_PROPERTIES_INFO	2
#define ED_TEXTBUTTON_ID_PROPERTIES_CONFIG	3
#define ED_TEXTBUTTON_ID_PROPERTIES_CONFIG_1	4
#define ED_TEXTBUTTON_ID_PROPERTIES_CONFIG_2	5
#define ED_TEXTBUTTON_ID_PROPERTIES_CHANGE	6
#define ED_TEXTBUTTON_ID_SAVE_AS_TEMPLATE	7
#define ED_TEXTBUTTON_ID_ADD_CHANGE_PAGE	8
#define ED_TEXTBUTTON_ID_DEL_CHANGE_PAGE	9

#define ED_NUM_TEXTBUTTONS			10

#define ED_TEXTBUTTON_ID_LEVELINFO_FIRST ED_TEXTBUTTON_ID_LEVELINFO_LEVEL
#define ED_TEXTBUTTON_ID_LEVELINFO_LAST  ED_TEXTBUTTON_ID_LEVELINFO_EDITOR

#define ED_TEXTBUTTON_ID_PROPERTIES_FIRST ED_TEXTBUTTON_ID_PROPERTIES_INFO
#define ED_TEXTBUTTON_ID_PROPERTIES_LAST  ED_TEXTBUTTON_ID_PROPERTIES_CHANGE

#define ED_TEXTBUTTON_ID_CHANGE_FIRST	ED_TEXTBUTTON_ID_ADD_CHANGE_PAGE
#define ED_TEXTBUTTON_ID_CHANGE_LAST	ED_TEXTBUTTON_ID_DEL_CHANGE_PAGE

/* values for graphicbutton gadgets */
#define ED_GRAPHICBUTTON_ID_PREV_CHANGE_PAGE	0
#define ED_GRAPHICBUTTON_ID_NEXT_CHANGE_PAGE	1
#define ED_GRAPHICBUTTON_ID_COPY_CHANGE_PAGE	2
#define ED_GRAPHICBUTTON_ID_PASTE_CHANGE_PAGE	3

#define ED_NUM_GRAPHICBUTTONS			4

#define ED_GRAPHICBUTTON_ID_CHANGE_FIRST  ED_GRAPHICBUTTON_ID_PREV_CHANGE_PAGE
#define ED_GRAPHICBUTTON_ID_CHANGE_LAST   ED_GRAPHICBUTTON_ID_PASTE_CHANGE_PAGE

/* values for checkbutton gadgets */
#define ED_CHECKBUTTON_ID_RANDOM_RESTRICTED	0
#define ED_CHECKBUTTON_ID_STICK_ELEMENT		1
#define ED_CHECKBUTTON_ID_EM_SLIPPERY_GEMS	2
#define ED_CHECKBUTTON_ID_EM_EXPLODES_BY_FIRE	3
#define ED_CHECKBUTTON_ID_USE_SPRING_BUG	4
#define ED_CHECKBUTTON_ID_USE_TIME_ORB_BUG	5
#define ED_CHECKBUTTON_ID_RANDOM_BALL_CONTENT	6
#define ED_CHECKBUTTON_ID_INITIAL_BALL_STATE	7
#define ED_CHECKBUTTON_ID_GROW_INTO_DIGGABLE	8
#define ED_CHECKBUTTON_ID_AUTO_EXIT_SOKOBAN	9
#define ED_CHECKBUTTON_ID_CONTINUOUS_SNAPPING	10
#define ED_CHECKBUTTON_ID_BLOCK_SNAP_FIELD	11
#define ED_CHECKBUTTON_ID_BLOCK_LAST_FIELD	12
#define ED_CHECKBUTTON_ID_SP_BLOCK_LAST_FIELD	13
#define ED_CHECKBUTTON_ID_INSTANT_RELOCATION	14
#define ED_CHECKBUTTON_ID_SHIFTED_RELOCATION	15
#define ED_CHECKBUTTON_ID_LAZY_RELOCATION	16
#define ED_CHECKBUTTON_ID_USE_START_ELEMENT	17
#define ED_CHECKBUTTON_ID_USE_ARTWORK_ELEMENT	18
#define ED_CHECKBUTTON_ID_USE_EXPLOSION_ELEMENT	19
#define ED_CHECKBUTTON_ID_INITIAL_GRAVITY	20
#define ED_CHECKBUTTON_ID_USE_INITIAL_INVENTORY	21
#define ED_CHECKBUTTON_ID_CAN_PASS_TO_WALKABLE	22
#define ED_CHECKBUTTON_ID_CAN_FALL_INTO_ACID	23
#define ED_CHECKBUTTON_ID_CAN_MOVE_INTO_ACID	24
#define ED_CHECKBUTTON_ID_DONT_COLLIDE_WITH	25
#define ED_CHECKBUTTON_ID_ENVELOPE_AUTOWRAP	26
#define ED_CHECKBUTTON_ID_ENVELOPE_CENTERED	27
#define ED_CHECKBUTTON_ID_CUSTOM_USE_GRAPHIC	28
#define ED_CHECKBUTTON_ID_CUSTOM_USE_TEMPLATE	29
#define ED_CHECKBUTTON_ID_CUSTOM_ACCESSIBLE	30
#define ED_CHECKBUTTON_ID_CUSTOM_GRAV_REACHABLE	31
#define ED_CHECKBUTTON_ID_CUSTOM_USE_LAST_VALUE	32
#define ED_CHECKBUTTON_ID_CUSTOM_WALK_TO_OBJECT	33
#define ED_CHECKBUTTON_ID_CUSTOM_INDESTRUCTIBLE	34
#define ED_CHECKBUTTON_ID_CUSTOM_CAN_MOVE	35
#define ED_CHECKBUTTON_ID_CUSTOM_CAN_FALL	36
#define ED_CHECKBUTTON_ID_CUSTOM_CAN_SMASH	37
#define ED_CHECKBUTTON_ID_CUSTOM_SLIPPERY	38
#define ED_CHECKBUTTON_ID_CUSTOM_DEADLY		39
#define ED_CHECKBUTTON_ID_CUSTOM_CAN_EXPLODE	40
#define ED_CHECKBUTTON_ID_CUSTOM_EXPLODE_FIRE	41
#define ED_CHECKBUTTON_ID_CUSTOM_EXPLODE_SMASH	42
#define ED_CHECKBUTTON_ID_CUSTOM_EXPLODE_IMPACT	43
#define ED_CHECKBUTTON_ID_CUSTOM_CAN_CHANGE	44
#define ED_CHECKBUTTON_ID_CHANGE_DELAY		45
#define ED_CHECKBUTTON_ID_CHANGE_BY_DIRECT_ACT	46
#define ED_CHECKBUTTON_ID_CHANGE_BY_OTHER_ACT	47
#define ED_CHECKBUTTON_ID_CHANGE_USE_EXPLOSION	48
#define ED_CHECKBUTTON_ID_CHANGE_USE_CONTENT	49
#define ED_CHECKBUTTON_ID_CHANGE_ONLY_COMPLETE	50
#define ED_CHECKBUTTON_ID_CHANGE_USE_RANDOM	51
#define ED_CHECKBUTTON_ID_CHANGE_HAS_ACTION	52

#define ED_NUM_CHECKBUTTONS			53

#define ED_CHECKBUTTON_ID_EDITOR_FIRST	ED_CHECKBUTTON_ID_RANDOM_RESTRICTED
#define ED_CHECKBUTTON_ID_EDITOR_LAST	ED_CHECKBUTTON_ID_RANDOM_RESTRICTED

#define ED_CHECKBUTTON_ID_CUSTOM1_FIRST	ED_CHECKBUTTON_ID_CUSTOM_USE_GRAPHIC
#define ED_CHECKBUTTON_ID_CUSTOM1_LAST	ED_CHECKBUTTON_ID_CUSTOM_INDESTRUCTIBLE
#define ED_CHECKBUTTON_ID_CUSTOM2_FIRST	ED_CHECKBUTTON_ID_CUSTOM_CAN_MOVE
#define ED_CHECKBUTTON_ID_CUSTOM2_LAST	ED_CHECKBUTTON_ID_CUSTOM_EXPLODE_IMPACT
#define ED_CHECKBUTTON_ID_CUSTOM_FIRST	ED_CHECKBUTTON_ID_CUSTOM1_FIRST
#define ED_CHECKBUTTON_ID_CUSTOM_LAST	ED_CHECKBUTTON_ID_CUSTOM2_LAST

#define ED_CHECKBUTTON_ID_CHANGE_FIRST	ED_CHECKBUTTON_ID_CUSTOM_CAN_CHANGE
#define ED_CHECKBUTTON_ID_CHANGE_LAST	ED_CHECKBUTTON_ID_CHANGE_HAS_ACTION

/* values for radiobutton gadgets */
#define ED_RADIOBUTTON_ID_PERCENTAGE	0
#define ED_RADIOBUTTON_ID_QUANTITY	1

#define ED_NUM_RADIOBUTTONS		2

#define ED_RADIOBUTTON_ID_EDITOR_FIRST	ED_RADIOBUTTON_ID_PERCENTAGE
#define ED_RADIOBUTTON_ID_EDITOR_LAST	ED_RADIOBUTTON_ID_QUANTITY

/* values for drawing area gadgets */
#define ED_DRAWING_ID_DRAWING_LEVEL		0
#define ED_DRAWING_ID_YAMYAM_CONTENT_0		1
#define ED_DRAWING_ID_YAMYAM_CONTENT_1		2
#define ED_DRAWING_ID_YAMYAM_CONTENT_2		3
#define ED_DRAWING_ID_YAMYAM_CONTENT_3		4
#define ED_DRAWING_ID_YAMYAM_CONTENT_4		5
#define ED_DRAWING_ID_YAMYAM_CONTENT_5		6
#define ED_DRAWING_ID_YAMYAM_CONTENT_6		7
#define ED_DRAWING_ID_YAMYAM_CONTENT_7		8
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_0	9
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_1	10
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_2	11
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_3	12
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_4	13
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_5	14
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_6	15
#define ED_DRAWING_ID_MAGIC_BALL_CONTENT_7	16
#define ED_DRAWING_ID_ANDROID_CONTENT		17
#define ED_DRAWING_ID_AMOEBA_CONTENT		18
#define ED_DRAWING_ID_START_ELEMENT		19
#define ED_DRAWING_ID_ARTWORK_ELEMENT		20
#define ED_DRAWING_ID_EXPLOSION_ELEMENT		21
#define ED_DRAWING_ID_INVENTORY_CONTENT		22
#define ED_DRAWING_ID_CUSTOM_GRAPHIC		23
#define ED_DRAWING_ID_CUSTOM_CONTENT		24
#define ED_DRAWING_ID_CUSTOM_MOVE_ENTER		25
#define ED_DRAWING_ID_CUSTOM_MOVE_LEAVE		26
#define ED_DRAWING_ID_CUSTOM_CHANGE_TARGET	27
#define ED_DRAWING_ID_CUSTOM_CHANGE_CONTENT	28
#define ED_DRAWING_ID_CUSTOM_CHANGE_TRIGGER	29
#define ED_DRAWING_ID_CUSTOM_CHANGE_ACTION	30
#define ED_DRAWING_ID_GROUP_CONTENT		31
#define ED_DRAWING_ID_RANDOM_BACKGROUND		32

#define ED_NUM_DRAWING_AREAS			33


/*
  -----------------------------------------------------------------------------
  some internally used definitions
  -----------------------------------------------------------------------------
*/

/* values for CopyLevelToUndoBuffer() */
#define UNDO_IMMEDIATE			0
#define UNDO_ACCUMULATE			1

/* values for scrollbars */
#define ED_SCROLL_NO			0
#define ED_SCROLL_LEFT			1
#define ED_SCROLL_RIGHT			2
#define ED_SCROLL_UP			4
#define ED_SCROLL_DOWN			8

/* screens in the level editor */
#define ED_MODE_DRAWING			0
#define ED_MODE_INFO			1
#define ED_MODE_PROPERTIES		2

/* sub-screens in the global settings section */
#define ED_MODE_LEVELINFO_LEVEL		ED_TEXTBUTTON_ID_LEVELINFO_LEVEL
#define ED_MODE_LEVELINFO_EDITOR	ED_TEXTBUTTON_ID_LEVELINFO_EDITOR

/* sub-screens in the element properties section */
#define ED_MODE_PROPERTIES_INFO		ED_TEXTBUTTON_ID_PROPERTIES_INFO
#define ED_MODE_PROPERTIES_CONFIG	ED_TEXTBUTTON_ID_PROPERTIES_CONFIG
#define ED_MODE_PROPERTIES_CONFIG_1	ED_TEXTBUTTON_ID_PROPERTIES_CONFIG_1
#define ED_MODE_PROPERTIES_CONFIG_2	ED_TEXTBUTTON_ID_PROPERTIES_CONFIG_2
#define ED_MODE_PROPERTIES_CHANGE	ED_TEXTBUTTON_ID_PROPERTIES_CHANGE

/* how many steps can be cancelled */
#define NUM_UNDO_STEPS			(64 + 1)

/* values for elements with score for certain actions */
#define MIN_SCORE			0
#define MAX_SCORE			999

/* values for elements with count for collecting */
#define MIN_COLLECT_COUNT		0
#define MAX_COLLECT_COUNT		999

/* values for random placement */
#define RANDOM_USE_PERCENTAGE		0
#define RANDOM_USE_QUANTITY		1

/* default value for element tile size in drawing area */
#define DEFAULT_EDITOR_TILESIZE		MINI_TILESIZE


/*
  -----------------------------------------------------------------------------
  some internally used data structure definitions
  -----------------------------------------------------------------------------
*/

static struct
{
  int graphic;
  int gadget_id;
  struct XY *pos;
  int gadget_type;
  char *infotext;
  char shortcut;
} controlbutton_info[ED_NUM_CTRL_BUTTONS] =
{
  /* note: some additional characters are already reserved for "cheat mode"
     shortcuts (":XYZ" style) -- for details, see "events.c" */

  /* ---------- toolbox control buttons ------------------------------------ */

  {
    IMG_GFX_EDITOR_BUTTON_DRAW_SINGLE,		GADGET_ID_SINGLE_ITEMS,
    &editor.button.draw_single,			GD_TYPE_RADIO_BUTTON,
    "draw single items",			's'
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_CONNECTED,	GADGET_ID_CONNECTED_ITEMS,
    &editor.button.draw_connected,		GD_TYPE_RADIO_BUTTON,
    "draw connected items",			'd'
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_LINE,		GADGET_ID_LINE,
    &editor.button.draw_line,			GD_TYPE_RADIO_BUTTON,
    "draw lines",				'l'
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_ARC,		GADGET_ID_ARC,
    &editor.button.draw_arc,			GD_TYPE_RADIO_BUTTON,
    "draw arcs",				'a'
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_RECTANGLE,	GADGET_ID_RECTANGLE,
    &editor.button.draw_rectangle,		GD_TYPE_RADIO_BUTTON,
    "draw outline rectangles",			'r'
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_FILLED_BOX,	GADGET_ID_FILLED_BOX,
    &editor.button.draw_filled_box,		GD_TYPE_RADIO_BUTTON,
    "draw filled rectangles",			'R'
  },
  {
    IMG_GFX_EDITOR_BUTTON_ROTATE_UP,		GADGET_ID_WRAP_UP,
    &editor.button.rotate_up,			GD_TYPE_NORMAL_BUTTON,
    "wrap (rotate) level up",			0
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_TEXT,		GADGET_ID_TEXT,
    &editor.button.draw_text,			GD_TYPE_RADIO_BUTTON,
    "enter text elements",			't'
  },
  {
    IMG_GFX_EDITOR_BUTTON_FLOOD_FILL,		GADGET_ID_FLOOD_FILL,
    &editor.button.flood_fill,			GD_TYPE_RADIO_BUTTON,
    "flood fill",				'f'
  },
  {
    IMG_GFX_EDITOR_BUTTON_ROTATE_LEFT,		GADGET_ID_WRAP_LEFT,
    &editor.button.rotate_left,			GD_TYPE_NORMAL_BUTTON,
    "wrap (rotate) level left",			0
  },
  {
    IMG_GFX_EDITOR_BUTTON_ZOOM_LEVEL,		GADGET_ID_ZOOM,
    &editor.button.zoom_level,			GD_TYPE_NORMAL_BUTTON,
    "zoom level tile size",			'+'
  },
  {
    IMG_GFX_EDITOR_BUTTON_ROTATE_RIGHT,		GADGET_ID_WRAP_RIGHT,
    &editor.button.rotate_right,		GD_TYPE_NORMAL_BUTTON,
    "wrap (rotate) level right",		0
  },
  {
    IMG_GFX_EDITOR_BUTTON_DRAW_RANDOM,		GADGET_ID_RANDOM_PLACEMENT,
    &editor.button.draw_random,			GD_TYPE_NORMAL_BUTTON,
    "random element placement",			0
  },
  {
    IMG_GFX_EDITOR_BUTTON_GRAB_BRUSH,		GADGET_ID_GRAB_BRUSH,
    &editor.button.grab_brush,			GD_TYPE_RADIO_BUTTON,
    "grab brush",				'b'
  },
  {
    IMG_GFX_EDITOR_BUTTON_ROTATE_DOWN,		GADGET_ID_WRAP_DOWN,
    &editor.button.rotate_down,			GD_TYPE_NORMAL_BUTTON,
    "wrap (rotate) level down",			0
  },
  {
    IMG_GFX_EDITOR_BUTTON_PICK_ELEMENT,		GADGET_ID_PICK_ELEMENT,
    &editor.button.pick_element,		GD_TYPE_RADIO_BUTTON,
    "pick drawing element",			','
  },

  /* ---------- level control buttons -------------------------------------- */

  {
    IMG_GFX_EDITOR_BUTTON_UNDO,			GADGET_ID_UNDO,
    &editor.button.undo,			GD_TYPE_NORMAL_BUTTON,
    "undo/redo last operation",			'u'
  },
  {
    IMG_GFX_EDITOR_BUTTON_CONF,			GADGET_ID_INFO,
    &editor.button.conf,			GD_TYPE_NORMAL_BUTTON,
    "properties of level",			'I'
  },
  {
    IMG_GFX_EDITOR_BUTTON_SAVE,			GADGET_ID_SAVE,
    &editor.button.save,			GD_TYPE_NORMAL_BUTTON,
    "save level",				'S'
  },
  {
    IMG_GFX_EDITOR_BUTTON_CLEAR,		GADGET_ID_CLEAR,
    &editor.button.clear,			GD_TYPE_NORMAL_BUTTON,
    "clear level",				'C'
  },
  {
    IMG_GFX_EDITOR_BUTTON_TEST,			GADGET_ID_TEST,
    &editor.button.test,			GD_TYPE_NORMAL_BUTTON,
    "test level",				'T'
  },
  {
    IMG_GFX_EDITOR_BUTTON_EXIT,			GADGET_ID_EXIT,
    &editor.button.exit,			GD_TYPE_NORMAL_BUTTON,
    "exit level editor",			'E'
  },

  /* ---------- CE and GE control buttons ---------------------------------- */

  {
    IMG_GFX_EDITOR_BUTTON_CE_COPY_FROM,		GADGET_ID_CUSTOM_COPY_FROM,
    &editor.button.ce_copy_from,		GD_TYPE_RADIO_BUTTON,
    "copy settings from other element",		0
  },
  {
    IMG_GFX_EDITOR_BUTTON_CE_COPY_TO,		GADGET_ID_CUSTOM_COPY_TO,
    &editor.button.ce_copy_to,			GD_TYPE_RADIO_BUTTON,
    "copy settings to other element",		0
  },
  {
    IMG_GFX_EDITOR_BUTTON_CE_SWAP,		GADGET_ID_CUSTOM_EXCHANGE,
    &editor.button.ce_swap,			GD_TYPE_RADIO_BUTTON,
    "exchange element with other element",	0
  },
  {
    IMG_GFX_EDITOR_BUTTON_CE_COPY,		GADGET_ID_CUSTOM_COPY,
    &editor.button.ce_copy,			GD_TYPE_NORMAL_BUTTON,
    "copy settings from this element",		0
  },
  {
    IMG_GFX_EDITOR_BUTTON_CE_PASTE,		GADGET_ID_CUSTOM_PASTE,
    &editor.button.ce_paste,			GD_TYPE_NORMAL_BUTTON,
    "paste settings to this element",		0
  },

  /* ---------- palette control buttons ------------------------------------ */

  {
    IMG_GFX_EDITOR_BUTTON_PROPERTIES,		GADGET_ID_PROPERTIES,
    &editor.button.properties,			GD_TYPE_NORMAL_BUTTON,
    "properties of drawing element",		'p'
  }
};

static int random_placement_value = 10;
static int random_placement_method = RANDOM_USE_QUANTITY;
static int random_placement_background_element = EL_SAND;
static boolean random_placement_background_restricted = FALSE;
static boolean stick_element_properties_window = FALSE;
static boolean custom_element_properties[NUM_ELEMENT_PROPERTIES];
static boolean custom_element_change_events[NUM_CHANGE_EVENTS];
static struct ElementChangeInfo custom_element_change;
static struct ElementGroupInfo group_element_info;
static struct ElementInfo custom_element;

static struct
{
  int x, y;
  int min_value, max_value;
  int gadget_id_down, gadget_id_up;
  int gadget_id_text;
  int gadget_id_align;
  int *value;
  char *text_above, *text_left, *text_right;
} counterbutton_info[ED_NUM_COUNTERBUTTONS] =
{
  /* ---------- current level number --------------------------------------- */

  {
    -1, -1,	/* these values are not constant, but can change at runtime */
    1,					100,
    GADGET_ID_SELECT_LEVEL_DOWN,	GADGET_ID_SELECT_LEVEL_UP,
    GADGET_ID_SELECT_LEVEL_TEXT,	GADGET_ID_NONE,
    &level_nr,
    NULL,				NULL, NULL
  },

  /* ---------- level and editor settings ---------------------------------- */

  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(4),
    MIN_LEV_FIELDX,			MAX_LEV_FIELDX,
    GADGET_ID_LEVEL_XSIZE_DOWN,		GADGET_ID_LEVEL_XSIZE_UP,
    GADGET_ID_LEVEL_XSIZE_TEXT,		GADGET_ID_NONE,
    &level.fieldx,
    "playfield size:",			NULL, "width",
  },
  {
    -1,					ED_LEVEL_SETTINGS_YPOS(4),
    MIN_LEV_FIELDY,			MAX_LEV_FIELDY,
    GADGET_ID_LEVEL_YSIZE_DOWN,		GADGET_ID_LEVEL_YSIZE_UP,
    GADGET_ID_LEVEL_YSIZE_TEXT,		GADGET_ID_LEVEL_XSIZE_UP,
    &level.fieldy,
    NULL,				" ", "height",
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(5),
    0,					999,
    GADGET_ID_LEVEL_GEMSLIMIT_DOWN,	GADGET_ID_LEVEL_GEMSLIMIT_UP,
    GADGET_ID_LEVEL_GEMSLIMIT_TEXT,	GADGET_ID_NONE,
    &level.gems_needed,
    NULL,				"number of gems to collect:", NULL
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(7),
    0,					9999,
    GADGET_ID_LEVEL_TIMELIMIT_DOWN,	GADGET_ID_LEVEL_TIMELIMIT_UP,
    GADGET_ID_LEVEL_TIMELIMIT_TEXT,	GADGET_ID_NONE,
    &level.time,
    "time or step limit to solve level:", NULL, NULL
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(9),
    0,					999,
    GADGET_ID_LEVEL_TIMESCORE_DOWN,	GADGET_ID_LEVEL_TIMESCORE_UP,
    GADGET_ID_LEVEL_TIMESCORE_TEXT,	GADGET_ID_NONE,
    &level.score[SC_TIME_BONUS],
    "score for each second/step left:",	NULL, NULL
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(12),
    0,					9999,
    GADGET_ID_LEVEL_RANDOM_SEED_DOWN,	GADGET_ID_LEVEL_RANDOM_SEED_UP,
    GADGET_ID_LEVEL_RANDOM_SEED_TEXT,	GADGET_ID_NONE,
    &level.random_seed,
    NULL,				"random seed:", "(0 => random)"
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(0),
    1,					100,
    GADGET_ID_LEVEL_RANDOM_DOWN,	GADGET_ID_LEVEL_RANDOM_UP,
    GADGET_ID_LEVEL_RANDOM_TEXT,	GADGET_ID_NONE,
    &random_placement_value,
    "random element placement:",	NULL, "in"
  },

  /* ---------- element settings: configure (various elements) ------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    MIN_SCORE,				MAX_SCORE,
    GADGET_ID_ELEMENT_VALUE1_DOWN,	GADGET_ID_ELEMENT_VALUE1_UP,
    GADGET_ID_ELEMENT_VALUE1_TEXT,	GADGET_ID_NONE,
    NULL,				/* will be set when used */
    NULL,				NULL, NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    MIN_SCORE,				MAX_SCORE,
    GADGET_ID_ELEMENT_VALUE2_DOWN,	GADGET_ID_ELEMENT_VALUE2_UP,
    GADGET_ID_ELEMENT_VALUE2_TEXT,	GADGET_ID_NONE,
    NULL,				/* will be set when used */
    NULL,				NULL, NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    MIN_SCORE,				MAX_SCORE,
    GADGET_ID_ELEMENT_VALUE3_DOWN,	GADGET_ID_ELEMENT_VALUE3_UP,
    GADGET_ID_ELEMENT_VALUE3_TEXT,	GADGET_ID_NONE,
    NULL,				/* will be set when used */
    NULL,				NULL, NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(3),
    MIN_SCORE,				MAX_SCORE,
    GADGET_ID_ELEMENT_VALUE4_DOWN,	GADGET_ID_ELEMENT_VALUE4_UP,
    GADGET_ID_ELEMENT_VALUE4_TEXT,	GADGET_ID_NONE,
    NULL,				/* will be set when used */
    NULL,				NULL, NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(3),
    MIN_ELEMENT_CONTENTS,		MAX_ELEMENT_CONTENTS,
    GADGET_ID_YAMYAM_CONTENT_DOWN,	GADGET_ID_YAMYAM_CONTENT_UP,
    GADGET_ID_YAMYAM_CONTENT_TEXT,	GADGET_ID_NONE,
    &level.num_yamyam_contents,
    NULL,				NULL, "number of content areas"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(4),
    MIN_ELEMENT_CONTENTS,		MAX_ELEMENT_CONTENTS,
    GADGET_ID_BALL_CONTENT_DOWN,	GADGET_ID_BALL_CONTENT_UP,
    GADGET_ID_BALL_CONTENT_TEXT,	GADGET_ID_NONE,
    &level.num_ball_contents,
    NULL,				NULL, "number of content areas"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(4),
    MIN_ANDROID_ELEMENTS,		MAX_ANDROID_ELEMENTS,
    GADGET_ID_ANDROID_CONTENT_DOWN,	GADGET_ID_ANDROID_CONTENT_UP,
    GADGET_ID_ANDROID_CONTENT_TEXT,	GADGET_ID_NONE,
    &level.num_android_clone_elements,
    NULL,				NULL, "number of clonable elements"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    MIN_ENVELOPE_XSIZE,			MAX_ENVELOPE_XSIZE,
    GADGET_ID_ENVELOPE_XSIZE_DOWN,	GADGET_ID_ENVELOPE_XSIZE_UP,
    GADGET_ID_ENVELOPE_XSIZE_TEXT,	GADGET_ID_NONE,
    NULL,				/* will be set when used */
    NULL,				NULL, "width",
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(0),
    MIN_ENVELOPE_YSIZE,			MAX_ENVELOPE_YSIZE,
    GADGET_ID_ENVELOPE_YSIZE_DOWN,	GADGET_ID_ENVELOPE_YSIZE_UP,
    GADGET_ID_ENVELOPE_YSIZE_TEXT,	GADGET_ID_ENVELOPE_XSIZE_UP,
    NULL,				/* will be set when used */
    NULL,				" ", "height",
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    MIN_INITIAL_INVENTORY_SIZE,		MAX_INITIAL_INVENTORY_SIZE,
    GADGET_ID_INVENTORY_SIZE_DOWN,	GADGET_ID_INVENTORY_SIZE_UP,
    GADGET_ID_INVENTORY_SIZE_TEXT,	GADGET_ID_NONE,
    &level.initial_inventory_size[0],
    NULL,				NULL, "number of inventory elements"
  },

  /* ---------- element settings: configure 1 (custom elements) ------------ */

  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(5),
    MIN_SCORE,				MAX_SCORE,
    GADGET_ID_CUSTOM_SCORE_DOWN,	GADGET_ID_CUSTOM_SCORE_UP,
    GADGET_ID_CUSTOM_SCORE_TEXT,	GADGET_ID_NONE,
    &custom_element.collect_score_initial,
    NULL,				"CE score", " "
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(5),
    MIN_COLLECT_COUNT,			MAX_COLLECT_COUNT,
    GADGET_ID_CUSTOM_GEMCOUNT_DOWN,	GADGET_ID_CUSTOM_GEMCOUNT_UP,
    GADGET_ID_CUSTOM_GEMCOUNT_TEXT,	GADGET_ID_CUSTOM_SCORE_UP,
    &custom_element.collect_count_initial,
    NULL,				"CE count", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(10),
    0,					9999,
    GADGET_ID_CUSTOM_VALUE_FIX_DOWN,	GADGET_ID_CUSTOM_VALUE_FIX_UP,
    GADGET_ID_CUSTOM_VALUE_FIX_TEXT,	GADGET_ID_NONE,
    &custom_element.ce_value_fixed_initial,
    NULL,				"CE value", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(10),
    0,					9999,
    GADGET_ID_CUSTOM_VALUE_RND_DOWN,	GADGET_ID_CUSTOM_VALUE_RND_UP,
    GADGET_ID_CUSTOM_VALUE_RND_TEXT,	GADGET_ID_CUSTOM_VALUE_FIX_UP,
    &custom_element.ce_value_random_initial,
    NULL,				"+random", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(6),
    0,					999,
    GADGET_ID_PUSH_DELAY_FIX_DOWN,	GADGET_ID_PUSH_DELAY_FIX_UP,
    GADGET_ID_PUSH_DELAY_FIX_TEXT,	GADGET_ID_NONE,
    &custom_element.push_delay_fixed,
    NULL,				"push delay", NULL
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(6),
    0,					999,
    GADGET_ID_PUSH_DELAY_RND_DOWN,	GADGET_ID_PUSH_DELAY_RND_UP,
    GADGET_ID_PUSH_DELAY_RND_TEXT,	GADGET_ID_PUSH_DELAY_FIX_UP,
    &custom_element.push_delay_random,
    NULL,				"+random", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(7),
    0,					999,
    GADGET_ID_DROP_DELAY_FIX_DOWN,	GADGET_ID_DROP_DELAY_FIX_UP,
    GADGET_ID_DROP_DELAY_FIX_TEXT,	GADGET_ID_NONE,
    &custom_element.drop_delay_fixed,
    NULL,				"drop delay", NULL
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(7),
    0,					999,
    GADGET_ID_DROP_DELAY_RND_DOWN,	GADGET_ID_DROP_DELAY_RND_UP,
    GADGET_ID_DROP_DELAY_RND_TEXT,	GADGET_ID_DROP_DELAY_FIX_UP,
    &custom_element.drop_delay_random,
    NULL,				"+random", NULL
  },

  /* ---------- element settings: configure 2 (custom elements) ------------ */

  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(5),
    0,					999,
    GADGET_ID_MOVE_DELAY_FIX_DOWN,	GADGET_ID_MOVE_DELAY_FIX_UP,
    GADGET_ID_MOVE_DELAY_FIX_TEXT,	GADGET_ID_NONE,
    &custom_element.move_delay_fixed,
    NULL,				"move delay", NULL
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(5),
    0,					999,
    GADGET_ID_MOVE_DELAY_RND_DOWN,	GADGET_ID_MOVE_DELAY_RND_UP,
    GADGET_ID_MOVE_DELAY_RND_TEXT,	GADGET_ID_MOVE_DELAY_FIX_UP,
    &custom_element.move_delay_random,
    NULL,				"+random", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(12),
    0,					999,
    GADGET_ID_EXPLOSION_DELAY_DOWN,	GADGET_ID_EXPLOSION_DELAY_UP,
    GADGET_ID_EXPLOSION_DELAY_TEXT,	GADGET_ID_NONE,
    &custom_element.explosion_delay,
    NULL,				"explosion delay", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(13),
    0,					999,
    GADGET_ID_IGNITION_DELAY_DOWN,	GADGET_ID_IGNITION_DELAY_UP,
    GADGET_ID_IGNITION_DELAY_TEXT,	GADGET_ID_NONE,
    &custom_element.ignition_delay,
    NULL,				"ignition delay", "(by fire)"
  },

  /* ---------- element settings: configure (group elements) --------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(3),
    MIN_ELEMENTS_IN_GROUP,		MAX_ELEMENTS_IN_GROUP,
    GADGET_ID_GROUP_CONTENT_DOWN,	GADGET_ID_GROUP_CONTENT_UP,
    GADGET_ID_GROUP_CONTENT_TEXT,	GADGET_ID_NONE,
    &group_element_info.num_elements,
    NULL,				NULL, "number of elements in group"
  },

  /* ---------- element settings: advanced (custom elements) --------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(2),
    0,					999,
    GADGET_ID_CHANGE_DELAY_FIX_DOWN,	GADGET_ID_CHANGE_DELAY_FIX_UP,
    GADGET_ID_CHANGE_DELAY_FIX_TEXT,	GADGET_ID_NONE,
    &custom_element_change.delay_fixed,
    NULL,				"CE delay", NULL,
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(2),
    0,					999,
    GADGET_ID_CHANGE_DELAY_RND_DOWN,	GADGET_ID_CHANGE_DELAY_RND_UP,
    GADGET_ID_CHANGE_DELAY_RND_TEXT,	GADGET_ID_CHANGE_DELAY_FIX_UP,
    &custom_element_change.delay_random,
    NULL,				"+random", NULL
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(3),	ED_ELEMENT_SETTINGS_YPOS(12),
    0,					100,
    GADGET_ID_CHANGE_CONT_RND_DOWN,	GADGET_ID_CHANGE_CONT_RND_UP,
    GADGET_ID_CHANGE_CONT_RND_TEXT,	GADGET_ID_NONE,
    &custom_element_change.random_percentage,
    NULL,				"use random replace:", "%"
  },
};

static struct
{
  int x, y;
  int gadget_id;
  int size;
  char *value;
  char *text_above, *infotext;
} textinput_info[ED_NUM_TEXTINPUT] =
{
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(0),
    GADGET_ID_LEVEL_NAME,
    MAX_LEVEL_NAME_LEN,
    level.name,
    "Title:", "Title"
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(2),
    GADGET_ID_LEVEL_AUTHOR,
    MAX_LEVEL_AUTHOR_LEN,
    level.author,
    "Author:", "Author"
  },
  {
    -1, -1,	/* these values are not constant, but can change at runtime */
    GADGET_ID_ELEMENT_NAME,
    MAX_ELEMENT_NAME_LEN - 2,		/* currently 2 chars less editable */
    custom_element.description,
    NULL, "Element name"
  }
};

static struct
{
  int x, y;
  int gadget_id;
  int xsize, ysize;
  char *value;
  char *text_above, *infotext;
} textarea_info[ED_NUM_TEXTAREAS] =
{
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(3),
    GADGET_ID_ENVELOPE_INFO,
    MAX_ENVELOPE_XSIZE, MAX_ENVELOPE_YSIZE,
    NULL,
    "Envelope Content:", "Envelope Content"
  }
};

static struct ValueTextInfo options_time_or_steps[] =
{
  { 0,				"seconds"			},
  { 1,				"steps"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_game_engine_type[] =
{
  { GAME_ENGINE_TYPE_RND,	"Rocks'n'Diamonds"		},
  { GAME_ENGINE_TYPE_EM,	"Emerald Mine"			},
  { GAME_ENGINE_TYPE_SP,	"Supaplex"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_wind_direction[] =
{
  { MV_START_NONE,		"none"				},
  { MV_START_LEFT,		"left"				},
  { MV_START_RIGHT,		"right"				},
  { MV_START_UP,		"up"				},
  { MV_START_DOWN,		"down"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_player_speed[] =
{
  { 0,				"frozen"			},
  { 1,				"very slow"			},
  { 2,				"slow"				},
  { 4,				"normal"			},
  { 8,				"fast"				},
  { 16,				"very fast"			},
  { 32,				"ultrafast"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_access_type[] =
{
  { EP_WALKABLE,		"walkable"			},
  { EP_PASSABLE,		"passable"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_access_layer[] =
{
  { EP_ACCESSIBLE_OVER,		"over"				},
  { EP_ACCESSIBLE_INSIDE,	"inside"			},
  { EP_ACCESSIBLE_UNDER,	"under"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_access_protected[] =
{
  { 0,				"unprotected"			},
  { 1,				"protected"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_access_direction[] =
{
  { MV_NO_DIRECTION,		"no direction"			},
  { MV_LEFT,			"left"				},
  { MV_RIGHT,			"right"				},
  { MV_UP,			"up"				},
  { MV_DOWN,			"down"				},
  { MV_LEFT  | MV_UP,		"left + up"			},
  { MV_LEFT  | MV_DOWN,		"left + down"			},
  { MV_RIGHT | MV_UP,		"right + up"			},
  { MV_RIGHT | MV_DOWN,		"right + down"			},
  { MV_HORIZONTAL,		"horizontal"			},
  { MV_VERTICAL,		"vertical"			},
  { MV_HORIZONTAL | MV_UP,	"horizontal + up"		},
  { MV_HORIZONTAL | MV_DOWN,	"horizontal + down"		},
  { MV_VERTICAL   | MV_LEFT,	"vertical + left"		},
  { MV_VERTICAL   | MV_RIGHT,	"vertical + right"		},
  { MV_ALL_DIRECTIONS,		"all directions"		},

  { -1,				NULL				}
};

static struct ValueTextInfo options_walk_to_action[] =
{
  { EP_DIGGABLE,		"diggable"			},
  { EP_COLLECTIBLE_ONLY,	"collectible"			},
  { EP_DROPPABLE,		"collectible & droppable"	},
  { EP_THROWABLE,		"collectible & throwable"	},
  { EP_PUSHABLE,		"pushable"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_move_pattern[] =
{
  { MV_LEFT,			"left"				},
  { MV_RIGHT,			"right"				},
  { MV_UP,			"up"				},
  { MV_DOWN,			"down"				},
  { MV_HORIZONTAL,		"horizontal"			},
  { MV_VERTICAL,		"vertical"			},
  { MV_ALL_DIRECTIONS,		"all directions"		},
  { MV_WIND_DIRECTION,		"wind direction"		},
  { MV_TOWARDS_PLAYER,		"towards player"		},
  { MV_AWAY_FROM_PLAYER,	"away from player"		},
  { MV_ALONG_LEFT_SIDE,		"along left side"		},
  { MV_ALONG_RIGHT_SIDE,	"along right side"		},
  { MV_TURNING_LEFT,		"turning left"			},
  { MV_TURNING_RIGHT,		"turning right"			},
  { MV_TURNING_LEFT_RIGHT,	"turning left, right"		},
  { MV_TURNING_RIGHT_LEFT,	"turning right, left"		},
  { MV_TURNING_RANDOM,		"turning random"		},
  { MV_MAZE_RUNNER,		"maze runner style"		},
  { MV_MAZE_HUNTER,		"maze hunter style"		},
  { MV_WHEN_PUSHED,		"when pushed"			},
  { MV_WHEN_DROPPED,		"when dropped/thrown"		},

  { -1,				NULL				}
};

static struct ValueTextInfo options_move_direction[] =
{
  { MV_START_AUTOMATIC,		"automatic"			},
  { MV_START_LEFT,		"left"				},
  { MV_START_RIGHT,		"right"				},
  { MV_START_UP,		"up"				},
  { MV_START_DOWN,		"down"				},
  { MV_START_RANDOM,		"random"			},
  { MV_START_PREVIOUS,		"previous"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_move_stepsize[] =
{
  { 0,				"not moving"			},
  { 1,				"very slow"			},
  { 2,				"slow"				},
  { 4,				"normal"			},
  { 8,				"fast"				},
  { 16,				"very fast"			},
  { 32,				"even faster"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_move_leave_type[] =
{
  { LEAVE_TYPE_UNLIMITED,	"leave behind"			},
  { LEAVE_TYPE_LIMITED,		"change it to"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_smash_targets[] =
{
  { EP_CAN_SMASH_PLAYER,	"player"			},
#if 0
  { EP_CAN_SMASH_ENEMIES,	"enemies"			},
#endif
  { EP_CAN_SMASH_EVERYTHING,	"everything"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_slippery_type[] =
{
  { SLIPPERY_ANY_RANDOM,	"random"			},
  { SLIPPERY_ANY_LEFT_RIGHT,	"left, right"			},
  { SLIPPERY_ANY_RIGHT_LEFT,	"right, left"			},
  { SLIPPERY_ONLY_LEFT,		"only left"			},
  { SLIPPERY_ONLY_RIGHT,	"only right"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_deadliness[] =
{
  { EP_DONT_RUN_INTO,		"running into"			},
  { EP_DONT_COLLIDE_WITH,	"colliding with"		},
  { EP_DONT_GET_HIT_BY,		"getting hit by"		},
  { EP_DONT_TOUCH,		"touching"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_explosion_type[] =
{
  { EXPLODES_3X3,		"3x3"				},
  { EXPLODES_CROSS,		"3+3"				},
  { EXPLODES_1X1,		"1x1"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_time_units[] =
{
  { 1,				"frames"			},
  { FRAMES_PER_SECOND,		"seconds"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_change_direct_action[] =
{
  { CE_TOUCHED_BY_PLAYER,	"touched by player"		},
  { CE_PRESSED_BY_PLAYER,	"pressed by player"		},
  { CE_SWITCHED_BY_PLAYER,	"switched by player"		},
  { CE_SNAPPED_BY_PLAYER,	"snapped by player"		},
  { CE_PUSHED_BY_PLAYER,	"pushed by player"		},
  { CE_ENTERED_BY_PLAYER,	"entered by player"		},
  { CE_LEFT_BY_PLAYER,		"left by player"		},
  { CE_DROPPED_BY_PLAYER,	"dropped/thrown by player"	},
  { CE_SWITCHED,		"switched"			},
  { CE_HITTING_SOMETHING,	"hitting something"		},
  { CE_HIT_BY_SOMETHING,	"hit by something"		},
#if 0
  { CE_BLOCKED,			"blocked"			},
#endif
  { CE_IMPACT,			"impact (on something)"		},
  { CE_SMASHED,			"smashed (from above)"		},
#if 0
  { CE_VALUE_CHANGES,		"CE value changes"		},
  { CE_SCORE_CHANGES,		"CE score changes"		},
#endif
  { CE_VALUE_GETS_ZERO,		"CE value gets 0"		},
  { CE_SCORE_GETS_ZERO,		"CE score gets 0"		},

  { -1,				NULL				}
};

static struct ValueTextInfo options_change_other_action[] =
{
  { CE_PLAYER_TOUCHES_X,	"player touches"		},
  { CE_PLAYER_PRESSES_X,	"player presses"		},
  { CE_PLAYER_SWITCHES_X,	"player switches"		},
  { CE_PLAYER_SNAPS_X,		"player snaps"			},
  { CE_PLAYER_PUSHES_X,		"player pushes"			},
  { CE_PLAYER_ENTERS_X,		"player enters"			},
  { CE_PLAYER_LEAVES_X,		"player leaves"			},
  { CE_PLAYER_DIGS_X,		"player digs"			},
  { CE_PLAYER_COLLECTS_X,	"player collects"		},
  { CE_PLAYER_DROPS_X,		"player drops/throws"		},
  { CE_TOUCHING_X,		"touching"			},
  { CE_HITTING_X,		"hitting"			},
  { CE_DIGGING_X,		"digging"			},
  { CE_HIT_BY_X,		"hit by"			},
  { CE_SWITCH_OF_X,		"switch of"			},
  { CE_CHANGE_OF_X,		"change by page of"		},
  { CE_EXPLOSION_OF_X,		"explosion of"			},
  { CE_MOVE_OF_X,		"move of"			},
  { CE_CREATION_OF_X,		"creation of"			},
  { CE_VALUE_CHANGES_OF_X,	"CE value changes of"		},
  { CE_SCORE_CHANGES_OF_X,	"CE score changes of"		},
  { CE_VALUE_GETS_ZERO_OF_X,	"CE value gets 0 of"		},
  { CE_SCORE_GETS_ZERO_OF_X,	"CE score gets 0 of"		},

  { -1,				NULL				}
};

static struct ValueTextInfo options_change_trigger_side[] =
{
  { CH_SIDE_LEFT,		"left"				},
  { CH_SIDE_RIGHT,		"right"				},
  { CH_SIDE_TOP,		"top"				},
  { CH_SIDE_BOTTOM,		"bottom"			},
  { CH_SIDE_LEFT_RIGHT,		"left/right"			},
  { CH_SIDE_TOP_BOTTOM,		"top/bottom"			},
  { CH_SIDE_ANY,		"any"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_change_trigger_player[] =
{
  { CH_PLAYER_1,		"1"				},
  { CH_PLAYER_2,		"2"				},
  { CH_PLAYER_3,		"3"				},
  { CH_PLAYER_4,		"4"				},
  { CH_PLAYER_ANY,		"any"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_change_trigger_page[] =
{
  { (1 << 0),			"1"				},
  { (1 << 1),			"2"				},
  { (1 << 2),			"3"				},
  { (1 << 3),			"4"				},
  { (1 << 4),			"5"				},
  { (1 << 5),			"6"				},
  { (1 << 6),			"7"				},
  { (1 << 7),			"8"				},
  { (1 << 8),			"9"				},
  { (1 << 9),			"10"				},
  { (1 << 10),			"11"				},
  { (1 << 11),			"12"				},
  { (1 << 12),			"13"				},
  { (1 << 13),			"14"				},
  { (1 << 14),			"15"				},
  { (1 << 15),			"16"				},
  { (1 << 16),			"17"				},
  { (1 << 17),			"18"				},
  { (1 << 18),			"19"				},
  { (1 << 19),			"20"				},
  { (1 << 20),			"21"				},
  { (1 << 21),			"22"				},
  { (1 << 22),			"23"				},
  { (1 << 23),			"24"				},
  { (1 << 24),			"25"				},
  { (1 << 25),			"26"				},
  { (1 << 26),			"27"				},
  { (1 << 27),			"28"				},
  { (1 << 28),			"29"				},
  { (1 << 29),			"30"				},
  { (1 << 30),			"31"				},
  { (1 << 31),			"32"				},
  { CH_PAGE_ANY,		"any"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_change_replace_when[] =
{
  { CP_WHEN_EMPTY,		"empty"				},
  { CP_WHEN_WALKABLE,		"walkable"			},
  { CP_WHEN_DIGGABLE,		"diggable"			},
  { CP_WHEN_COLLECTIBLE,	"collectible"			},
  { CP_WHEN_REMOVABLE,		"removable"			},
  { CP_WHEN_DESTRUCTIBLE,	"destructible"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_type[] =
{
  { CA_NO_ACTION,		"no action"			},
  { CA_UNDEFINED,		" "				},
  { CA_HEADLINE_LEVEL_ACTIONS,	"[level]"			},
  { CA_RESTART_LEVEL,		"restart level"			},
  { CA_SHOW_ENVELOPE,		"show envelope"			},
  { CA_SET_LEVEL_TIME,		"set time"			},
  { CA_SET_LEVEL_SCORE,		"set score"			},
  { CA_SET_LEVEL_GEMS,		"set gems"			},
  { CA_SET_LEVEL_WIND,		"set wind dir."			},
  { CA_SET_LEVEL_RANDOM_SEED,	"set rand. seed"		},
  { CA_UNDEFINED,		" "				},
  { CA_HEADLINE_PLAYER_ACTIONS,	"[player]"			},
  { CA_MOVE_PLAYER,		"move player"			},
  { CA_EXIT_PLAYER,		"exit player"			},
  { CA_KILL_PLAYER,		"kill player"			},
  { CA_SET_PLAYER_KEYS,		"set keys"			},
  { CA_SET_PLAYER_SPEED,	"set speed"			},
  { CA_SET_PLAYER_SHIELD,	"set shield"			},
  { CA_SET_PLAYER_GRAVITY,	"set gravity"			},
  { CA_SET_PLAYER_ARTWORK,	"set artwork"			},
  { CA_SET_PLAYER_INVENTORY,	"set inventory"			},
  { CA_UNDEFINED,		" "				},
  { CA_HEADLINE_CE_ACTIONS,	"[CE]"				},
  { CA_SET_CE_VALUE,		"set CE value"			},
  { CA_SET_CE_SCORE,		"set CE score"			},
  { CA_SET_CE_ARTWORK,		"set CE artwork"		},
  { CA_UNDEFINED,		" "				},
  { CA_HEADLINE_ENGINE_ACTIONS,	"[engine]"			},
  { CA_SET_ENGINE_SCAN_MODE,	"set scan mode"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_mode_none[] =
{
  { CA_MODE_UNDEFINED,		" "				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_mode_assign[] =
{
  { CA_MODE_SET,		"="				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_mode_add_remove[] =
{
  { CA_MODE_ADD,		"+"				},
  { CA_MODE_SUBTRACT,		"-"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_mode_calculate[] =
{
  { CA_MODE_SET,		"="				},
  { CA_MODE_ADD,		"+"				},
  { CA_MODE_SUBTRACT,		"-"				},
  { CA_MODE_MULTIPLY,		"*"				},
  { CA_MODE_DIVIDE,		"/"				},
  { CA_MODE_MODULO,		"%"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_none[] =
{
  { CA_ARG_UNDEFINED,		"         "			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_player[] =
{
  { CA_ARG_PLAYER_HEADLINE,	"[player]"			},
  { CA_ARG_PLAYER_1,		"1"				},
  { CA_ARG_PLAYER_2,		"2"				},
  { CA_ARG_PLAYER_3,		"3"				},
  { CA_ARG_PLAYER_4,		"4"				},
  { CA_ARG_PLAYER_ANY,		"any"				},
  { CA_ARG_PLAYER_TRIGGER,	"trigger"			},
  { CA_ARG_PLAYER_ACTION,	"action ->"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_number[] =
{
  { CA_ARG_NUMBER_HEADLINE,	"[number]"			},
  { CA_ARG_0,			"0"				},
  { CA_ARG_1,			"1"				},
  { CA_ARG_2,			"2"				},
  { CA_ARG_3,			"3"				},
  { CA_ARG_4,			"4"				},
  { CA_ARG_5,			"5"				},
  { CA_ARG_10,			"10"				},
  { CA_ARG_100,			"100"				},
  { CA_ARG_1000,		"1000"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_MIN,		"min"				},
  { CA_ARG_NUMBER_MAX,		"max"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_RESET,	"reset"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_CE_VALUE,	"CE value"			},
  { CA_ARG_NUMBER_CE_SCORE,	"CE score"			},
  { CA_ARG_NUMBER_CE_DELAY,	"CE delay"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_LEVEL_TIME,	"time"				},
  { CA_ARG_NUMBER_LEVEL_GEMS,	"gems"				},
  { CA_ARG_NUMBER_LEVEL_SCORE,	"score"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_CV_HEADLINE,	"[CE value]"			},
  { CA_ARG_ELEMENT_CV_TARGET,	"target"			},
  { CA_ARG_ELEMENT_CV_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_CV_ACTION,	"action ->"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_CS_HEADLINE,	"[CE score]"			},
  { CA_ARG_ELEMENT_CS_TARGET,	"target"			},
  { CA_ARG_ELEMENT_CS_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_CS_ACTION,	"action ->"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_value[] =
{
  { CA_ARG_NUMBER_HEADLINE,	"[number]"			},
  { CA_ARG_0,			"0"				},
  { CA_ARG_1,			"1"				},
  { CA_ARG_2,			"2"				},
  { CA_ARG_3,			"3"				},
  { CA_ARG_4,			"4"				},
  { CA_ARG_5,			"5"				},
  { CA_ARG_10,			"10"				},
  { CA_ARG_100,			"100"				},
  { CA_ARG_1000,		"1000"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_MIN,		"min"				},
  { CA_ARG_NUMBER_MAX,		"max"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_RESET,	"reset"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_CE_VALUE,	"CE value"			},
  { CA_ARG_NUMBER_CE_SCORE,	"CE score"			},
  { CA_ARG_NUMBER_CE_DELAY,	"CE delay"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_NUMBER_LEVEL_TIME,	"time"				},
  { CA_ARG_NUMBER_LEVEL_GEMS,	"gems"				},
  { CA_ARG_NUMBER_LEVEL_SCORE,	"score"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_CV_HEADLINE,	"[CE value]"			},
  { CA_ARG_ELEMENT_CV_TARGET,	"target"			},
  { CA_ARG_ELEMENT_CV_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_CV_ACTION,	"action ->"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_CS_HEADLINE,	"[CE score]"			},
  { CA_ARG_ELEMENT_CS_TARGET,	"target"			},
  { CA_ARG_ELEMENT_CS_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_CS_ACTION,	"action ->"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_NR_HEADLINE,	"[element]"			},
  { CA_ARG_ELEMENT_NR_TARGET,	"target"			},
  { CA_ARG_ELEMENT_NR_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_NR_ACTION,	"action ->"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_envelope[] =
{
  { CA_ARG_NUMBER_HEADLINE,	"[number]"			},
  { CA_ARG_1,			"1"				},
  { CA_ARG_2,			"2"				},
  { CA_ARG_3,			"3"				},
  { CA_ARG_4,			"4"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_HEADLINE,	"[element]"			},
  { CA_ARG_ELEMENT_TARGET,	"target"			},
  { CA_ARG_ELEMENT_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_ACTION,	"action ->"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_key[] =
{
  { CA_ARG_NUMBER_HEADLINE,	"[number]"			},
  { CA_ARG_1,			"1"				},
  { CA_ARG_2,			"2"				},
  { CA_ARG_3,			"3"				},
  { CA_ARG_4,			"4"				},
  { CA_ARG_5,			"5"				},
  { CA_ARG_6,			"6"				},
  { CA_ARG_7,			"7"				},
  { CA_ARG_8,			"8"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_HEADLINE,	"[element]"			},
  { CA_ARG_ELEMENT_TARGET,	"target"			},
  { CA_ARG_ELEMENT_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_ACTION,	"action ->"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_speed[] =
{
  { CA_ARG_SPEED_HEADLINE,	"[speed]"			},
  { CA_ARG_SPEED_NOT_MOVING,	"frozen"			},
  { CA_ARG_SPEED_VERY_SLOW,	"very slow"			},
  { CA_ARG_SPEED_SLOW,		"slow"				},
  { CA_ARG_SPEED_NORMAL,	"normal"			},
  { CA_ARG_SPEED_FAST,		"fast"				},
  { CA_ARG_SPEED_VERY_FAST,	"very fast"			},
  { CA_ARG_SPEED_EVEN_FASTER,	"ultrafast"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_SPEED_SLOWER,	"slower"			},
  { CA_ARG_SPEED_FASTER,	"faster"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_SPEED_RESET,		"reset"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_shield[] =
{
  { CA_ARG_SHIELD_HEADLINE,	"[shield]"			},
  { CA_ARG_SHIELD_OFF,		"off"				},
  { CA_ARG_SHIELD_NORMAL,	"normal"			},
  { CA_ARG_SHIELD_DEADLY,	"deadly"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_artwork[] =
{
  { CA_ARG_ELEMENT_HEADLINE,	"[element]"			},
  { CA_ARG_ELEMENT_TARGET,	"target"			},
  { CA_ARG_ELEMENT_TRIGGER,	"trigger"			},
  { CA_ARG_ELEMENT_ACTION,	"action ->"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_ELEMENT_RESET,	"reset"				},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_gravity[] =
{
  { CA_ARG_GRAVITY_HEADLINE,	"[gravity]"			},
  { CA_ARG_GRAVITY_ON,		"on"				},
  { CA_ARG_GRAVITY_OFF,		"off"				},
  { CA_ARG_GRAVITY_TOGGLE,	"toggle"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_direction[] =
{
  { CA_ARG_DIRECTION_HEADLINE,	"[dir.]"			},
  { CA_ARG_DIRECTION_NONE,	"none"				},
  { CA_ARG_DIRECTION_LEFT,	"left"				},
  { CA_ARG_DIRECTION_RIGHT,	"right"				},
  { CA_ARG_DIRECTION_UP,	"up"				},
  { CA_ARG_DIRECTION_DOWN,	"down"				},
  { CA_ARG_DIRECTION_TRIGGER,	"trigger"			},
  { CA_ARG_DIRECTION_TRIGGER_BACK, "-trigger"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_scan_mode[] =
{
  { CA_ARG_SCAN_MODE_HEADLINE,	"[mode]"			},
  { CA_ARG_SCAN_MODE_NORMAL,	"normal"			},
  { CA_ARG_SCAN_MODE_REVERSE,	"reverse"			},

  { -1,				NULL				}
};

static struct ValueTextInfo options_action_arg_inventory[] =
{
  { CA_ARG_INVENTORY_HEADLINE,	"[add]"				},
  { CA_ARG_ELEMENT_TARGET,	"+ target"			},
  { CA_ARG_ELEMENT_TRIGGER,	"+ trigger"			},
  { CA_ARG_ELEMENT_ACTION,	"+ action"			},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_INVENTORY_RM_HEADLINE,"[remove]"			},
  { CA_ARG_INVENTORY_RM_TARGET,	"- target"			},
  { CA_ARG_INVENTORY_RM_TRIGGER,"- trigger"			},
  { CA_ARG_INVENTORY_RM_ACTION,	"- action"			},
  { CA_ARG_INVENTORY_RM_FIRST,	"- first"			},
  { CA_ARG_INVENTORY_RM_LAST,	"- last"			},
  { CA_ARG_INVENTORY_RM_ALL,	"- all"				},
  { CA_ARG_UNDEFINED,		" "				},
  { CA_ARG_INVENTORY_RESET,	"reset"				},

  { -1,				NULL				}
};

static char options_change_page_strings[MAX_CHANGE_PAGES][10];
static struct ValueTextInfo options_change_page[MAX_CHANGE_PAGES + 1] =
{
  { -1,				NULL				}
};

static struct ValueTextInfo options_group_choice_mode[] =
{
  { ANIM_RANDOM,		"random"			},
  { ANIM_LOOP,			"loop"				},
  { ANIM_LINEAR,		"linear"			},
  { ANIM_PINGPONG,		"pingpong"			},
  { ANIM_PINGPONG2,		"pingpong 2"			},

  { -1,				NULL				}
};

static struct ValueTextInfo *action_arg_modes[] =
{
  options_action_mode_none,
  options_action_mode_assign,
  options_action_mode_add_remove,
  options_action_mode_calculate,
};

static struct
{
  int value;
  int mode;
  struct ValueTextInfo *options;
}
action_arg_options[] =
{
  { CA_NO_ACTION,		0,	options_action_arg_none,	},
  { CA_EXIT_PLAYER,		0,	options_action_arg_player,	},
  { CA_KILL_PLAYER,		0,	options_action_arg_player,	},
  { CA_MOVE_PLAYER,		0,	options_action_arg_direction,	},
  { CA_RESTART_LEVEL,		0,	options_action_arg_none,	},
  { CA_SHOW_ENVELOPE,		0,	options_action_arg_envelope,	},
  { CA_SET_LEVEL_TIME,		3,	options_action_arg_number,	},
  { CA_SET_LEVEL_GEMS,		3,	options_action_arg_number,	},
  { CA_SET_LEVEL_SCORE,		3,	options_action_arg_number,	},
  { CA_SET_LEVEL_WIND,		1,	options_action_arg_direction,	},
  { CA_SET_LEVEL_RANDOM_SEED,	1,	options_action_arg_number,	},
  { CA_SET_PLAYER_KEYS,		2,	options_action_arg_key,		},
  { CA_SET_PLAYER_SPEED,	1,	options_action_arg_speed,	},
  { CA_SET_PLAYER_SHIELD,	1,	options_action_arg_shield,	},
  { CA_SET_PLAYER_GRAVITY,	1,	options_action_arg_gravity,	},
  { CA_SET_PLAYER_ARTWORK,	1,	options_action_arg_artwork,	},
  { CA_SET_PLAYER_INVENTORY,	0,	options_action_arg_inventory,	},
  { CA_SET_CE_VALUE,		3,	options_action_arg_value,	},
  { CA_SET_CE_SCORE,		3,	options_action_arg_value,	},
  { CA_SET_CE_ARTWORK,		1,	options_action_arg_artwork,	},
  { CA_SET_ENGINE_SCAN_MODE,	1,	options_action_arg_scan_mode,	},

  { -1,				FALSE,	NULL				}
};

static struct
{
  int x, y;
  int gadget_id;
  int gadget_id_align;
  int size;	/* char size of selectbox or '-1' (dynamically determined) */
  struct ValueTextInfo *options;
  int *value;
  char *text_left, *text_right, *infotext;
} selectbox_info[ED_NUM_SELECTBOX] =
{
  /* ---------- level and editor settings ---------------------------------- */

  {
    -1,					ED_LEVEL_SETTINGS_YPOS(7),
    GADGET_ID_TIME_OR_STEPS,		GADGET_ID_LEVEL_TIMELIMIT_UP,
    -1,
    options_time_or_steps,
    &level.use_step_counter,
    NULL, "(0 => no limit)",		"time or step limit"
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(11),
    GADGET_ID_GAME_ENGINE_TYPE,		GADGET_ID_NONE,
    -1,
    options_game_engine_type,
    &level.game_engine_type,
    "game engine:", NULL,		"game engine"
  },
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(10),
    GADGET_ID_WIND_DIRECTION,		GADGET_ID_NONE,
    -1,
    options_wind_direction,
    &level.wind_direction_initial,
    "initial wind direction:", NULL,	"initial wind direction"
  },

  /* ---------- element settings: configure (several elements) ------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(7),
    GADGET_ID_PLAYER_SPEED,		GADGET_ID_NONE,
    -1,
    options_player_speed,
    &level.initial_player_stepsize[0],
    "initial player speed:", NULL,	"initial player speed"
  },

  /* ---------- element settings: configure 1 (custom elements) ------------ */

  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_CUSTOM_ACCESS_TYPE,	GADGET_ID_NONE,
    -1,
    options_access_type,
    &custom_element.access_type,
    NULL, NULL,				"type of access to this field"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_CUSTOM_ACCESS_LAYER,	GADGET_ID_CUSTOM_ACCESS_TYPE,
    -1,
    options_access_layer,
    &custom_element.access_layer,
    NULL, NULL,				"layer of access for this field"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_CUSTOM_ACCESS_PROTECTED,	GADGET_ID_CUSTOM_ACCESS_LAYER,
    -1,
    options_access_protected,
    &custom_element.access_protected,
    NULL, NULL,				"protected access for this field"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(3),
    GADGET_ID_CUSTOM_ACCESS_DIRECTION,	GADGET_ID_NONE,
    -1,
    options_access_direction,
    &custom_element.access_direction,
    "from", NULL,			"access direction for this field"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_CUSTOM_WALK_TO_ACTION,	GADGET_ID_NONE,
    -1,
    options_walk_to_action,
    &custom_element.walk_to_action,
    NULL, NULL,				"diggable/collectible/pushable"
  },

  /* ---------- element settings: configure 2 (custom elements) ------------ */

  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_CUSTOM_MOVE_PATTERN,	GADGET_ID_NONE,
    -1,
    options_move_pattern,
    &custom_element.move_pattern,
    "can move", NULL,			"element move pattern"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_CUSTOM_MOVE_DIRECTION,	GADGET_ID_NONE,
    -1,
    options_move_direction,
    &custom_element.move_direction_initial,
    "starts moving", NULL,		"initial element move direction"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_CUSTOM_MOVE_STEPSIZE,	GADGET_ID_NONE,
    -1,
    options_move_stepsize,
    &custom_element.move_stepsize,
    "move/fall speed", NULL,		"speed of element movement"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(3),
    GADGET_ID_CUSTOM_MOVE_LEAVE_TYPE,	GADGET_ID_NONE,
    -1,
    options_move_leave_type,
    &custom_element.move_leave_type,
    // left text with leading spaces to place gadget next to "can dig" gadget
    // (needed because drawing area gadgets created after selectbox gadgets)
    // "can dig:    can", ":",		"leave behind or change element"
    "            can", ":",		"leave behind or change element"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(7),
    GADGET_ID_CUSTOM_SMASH_TARGETS,	GADGET_ID_CUSTOM_CAN_SMASH,
    -1,
    options_smash_targets,
    &custom_element.smash_targets,
    "can smash", NULL,			"elements that can be smashed"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(8),
    GADGET_ID_CUSTOM_SLIPPERY_TYPE,	GADGET_ID_NONE,
    -1,
    options_slippery_type,
    &custom_element.slippery_type,
    "slippery", NULL,			"where other elements fall down"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(9),
    GADGET_ID_CUSTOM_DEADLINESS,	GADGET_ID_NONE,
    -1,
    options_deadliness,
    &custom_element.deadliness,
    "deadly when", NULL,		"deadliness of element"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(10),
    GADGET_ID_CUSTOM_EXPLOSION_TYPE,	GADGET_ID_NONE,
    -1,
    options_explosion_type,
    &custom_element.explosion_type,
    "can explode", NULL,		"explosion type"
  },

  /* ---------- element settings: advanced (custom elements) --------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(3),
    GADGET_ID_CHANGE_TIME_UNITS,	GADGET_ID_NONE,
    -1,
    options_time_units,
    &custom_element_change.delay_frames,
    "delay time given in", NULL,	"delay time units for change"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_CHANGE_DIRECT_ACTION,	GADGET_ID_NONE,
    -1,
    options_change_direct_action,
    &custom_element_change.direct_action,
    NULL, NULL,				"type of direct action"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(5),
    GADGET_ID_CHANGE_OTHER_ACTION,	GADGET_ID_NONE,
    -1,
    options_change_other_action,
    &custom_element_change.other_action,
    NULL, "element:",			"type of other element action"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(6),
    GADGET_ID_CHANGE_SIDE,		GADGET_ID_NONE,
    -1,
    options_change_trigger_side,
    &custom_element_change.trigger_side,
    "at", "side",			"element side triggering change"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(7),
    GADGET_ID_CHANGE_PLAYER,		GADGET_ID_NONE,
    -1,
    options_change_trigger_player,
    &custom_element_change.trigger_player,
    "player:", " ",			"player that causes change"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(7),
    GADGET_ID_CHANGE_PAGE,		GADGET_ID_CHANGE_PLAYER,
    -1,
    options_change_trigger_page,
    &custom_element_change.trigger_page,
    "page:", NULL,			"change page that causes change"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(10),
    GADGET_ID_CHANGE_REPLACE_WHEN,	GADGET_ID_NONE,
    -1,
    options_change_replace_when,
    &custom_element_change.replace_when,
    "replace when", NULL,		"which elements can be replaced"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(13),
    GADGET_ID_ACTION_TYPE,		GADGET_ID_NONE,
    -1,
    options_action_type,
    &custom_element_change.action_type,
    NULL, NULL,				"action on specified condition"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(13),
    GADGET_ID_ACTION_MODE,		GADGET_ID_ACTION_TYPE,
    -1,
    options_action_mode_none,
    &custom_element_change.action_mode,
    NULL, NULL,				"action operator"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(13),
    GADGET_ID_ACTION_ARG,		GADGET_ID_ACTION_MODE,
    -1,
    options_action_arg_none,
    &custom_element_change.action_arg,
    NULL, NULL,				"action parameter"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(14),
    GADGET_ID_SELECT_CHANGE_PAGE,	GADGET_ID_NONE,
    3,
    options_change_page,
    &custom_element.current_change_page,
    NULL, NULL,				"element change page"
  },

  /* ---------- element settings: configure (group elements) --------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_GROUP_CHOICE_MODE,	GADGET_ID_NONE,
    -1,
    options_group_choice_mode,
    &group_element_info.choice_mode,
    "choice type:", NULL,		"type of group element choice"
  },
};

static struct
{
  int x, y;
  int gadget_id;
  int gadget_id_align;
  int size;
  char *text;
  char *text_left, *text_right, *infotext;
} textbutton_info[ED_NUM_TEXTBUTTONS] =
{
  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(0),
    GADGET_ID_LEVELINFO_LEVEL,		GADGET_ID_NONE,
    8,					"Level",			
    NULL, NULL,				"Configure level properties"
  },
  {
    -1,					-1,
    GADGET_ID_LEVELINFO_EDITOR,		GADGET_ID_LEVELINFO_LEVEL,
    8,					"Editor",			
    NULL, NULL,				"Configure editor properties"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    GADGET_ID_PROPERTIES_INFO,		GADGET_ID_NONE,
    8,					"Info",			
    NULL, NULL,				"Show information about element"
  },
  {
    -1,					-1,
    GADGET_ID_PROPERTIES_CONFIG,	GADGET_ID_PROPERTIES_INFO,
    8,					"Config",
    NULL, NULL,				"Configure element properties"
  },
  {
    -1,					-1,
    GADGET_ID_PROPERTIES_CONFIG_1,	GADGET_ID_PROPERTIES_INFO,
    8,					"Config 1",
    NULL, NULL,				"Configure element properties, part 1"
  },
  {
    -1,					-1,
    GADGET_ID_PROPERTIES_CONFIG_2,	GADGET_ID_PROPERTIES_CONFIG_1,
    8,					"Config 2",
    NULL, NULL,				"Configure element properties, part 2"
  },
  {
    -1,					-1,
    GADGET_ID_PROPERTIES_CHANGE,	GADGET_ID_PROPERTIES_CONFIG_2,
    8,					"Change",
    NULL, NULL,				"Configure custom element change pages"
  },
  {
    -1,					-1,
    GADGET_ID_SAVE_AS_TEMPLATE,		GADGET_ID_CUSTOM_USE_TEMPLATE,
    -1,					"Save",
    " ", "As Template",			"Save current settings as new template"
  },
  {
    -1,					-1,
    GADGET_ID_ADD_CHANGE_PAGE,		GADGET_ID_PASTE_CHANGE_PAGE,
    -1,					"New",
    NULL, NULL,				"Add new change page"
  },
  {
    -1,					-1,
    GADGET_ID_DEL_CHANGE_PAGE,		GADGET_ID_ADD_CHANGE_PAGE,
    -1,					"Delete",
    NULL, NULL,				"Delete current change page"
  },
};

static struct
{
  int graphic;
  int x, y;
  int gadget_id;
  int gadget_id_align;
  char *text_left, *text_right, *infotext;
} graphicbutton_info[ED_NUM_GRAPHICBUTTONS] =
{
  {
    IMG_EDITOR_COUNTER_DOWN,
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(14),
    GADGET_ID_PREV_CHANGE_PAGE,		GADGET_ID_NONE,
    NULL, NULL,				"select previous change page"
  },
  {
    IMG_EDITOR_COUNTER_UP,
    -1,					ED_ELEMENT_SETTINGS_YPOS(14),
    GADGET_ID_NEXT_CHANGE_PAGE,		GADGET_ID_SELECT_CHANGE_PAGE,
    NULL, "change page",		"select next change page"
  },
  {
    IMG_GFX_EDITOR_BUTTON_CP_COPY,
    -1,					ED_ELEMENT_SETTINGS_YPOS(14),
    GADGET_ID_COPY_CHANGE_PAGE,		GADGET_ID_NEXT_CHANGE_PAGE,
    " ", NULL,				"copy settings from this change page"
  },
  {
    IMG_GFX_EDITOR_BUTTON_CP_PASTE,
    -1,					ED_ELEMENT_SETTINGS_YPOS(14),
    GADGET_ID_PASTE_CHANGE_PAGE,	GADGET_ID_COPY_CHANGE_PAGE,
    NULL, NULL,				"paste settings to this change page"
  },
};

static struct
{
  int x, y;
} scrollbutton_pos[ED_NUM_SCROLLBUTTONS];

static struct
{
  int graphic;
  int gadget_id;
  char *infotext;
} scrollbutton_info[ED_NUM_SCROLLBUTTONS] =
{
  {
    IMG_EDITOR_PLAYFIELD_SCROLL_UP,
    GADGET_ID_SCROLL_UP,
    "scroll level editing area up"
  },
  {
    IMG_EDITOR_PLAYFIELD_SCROLL_DOWN,
    GADGET_ID_SCROLL_DOWN,
    "scroll level editing area down"
  },
  {
    IMG_EDITOR_PLAYFIELD_SCROLL_LEFT,
    GADGET_ID_SCROLL_LEFT,
    "scroll level editing area left"
  },
  {
    IMG_EDITOR_PLAYFIELD_SCROLL_RIGHT,
    GADGET_ID_SCROLL_RIGHT,
    "scroll level editing area right"
  },
  {
    IMG_EDITOR_PALETTE_SCROLL_UP,
    GADGET_ID_SCROLL_LIST_UP,
    "scroll element list up ('Page Up')"
  },
  {
    IMG_EDITOR_PALETTE_SCROLL_DOWN,
    GADGET_ID_SCROLL_LIST_DOWN,
    "scroll element list down ('Page Down')"
  },
};

static struct
{
  int x, y;
  int width, height;
  int wheel_x, wheel_y;
  int wheel_width, wheel_height;
} scrollbar_pos[ED_NUM_SCROLLBARS];

static struct
{
  int graphic;
  int type;
  int gadget_id;
  char *infotext;
} scrollbar_info[ED_NUM_SCROLLBARS] =
{
  {
    IMG_EDITOR_PLAYFIELD_SCROLLBAR,
    GD_TYPE_SCROLLBAR_HORIZONTAL,
    GADGET_ID_SCROLL_HORIZONTAL,
    "scroll level editing area horizontally"
  },
  {
    IMG_EDITOR_PLAYFIELD_SCROLLBAR,
    GD_TYPE_SCROLLBAR_VERTICAL,
    GADGET_ID_SCROLL_VERTICAL,
    "scroll level editing area vertically"
  },
  {
    IMG_EDITOR_PALETTE_SCROLLBAR,
    GD_TYPE_SCROLLBAR_VERTICAL,
    GADGET_ID_SCROLL_LIST_VERTICAL,
    "scroll element list vertically"
  }
};


static struct
{
  int x, y;
  int gadget_id;
  int gadget_id_align;
  int radio_button_nr;
  int *value;
  int checked_value;
  char *text_left, *text_right, *infotext;
} radiobutton_info[ED_NUM_RADIOBUTTONS] =
{
  {
    -1,					ED_LEVEL_SETTINGS_YPOS(0),
    GADGET_ID_RANDOM_PERCENTAGE,	GADGET_ID_LEVEL_RANDOM_UP,
    RADIO_NR_RANDOM_ELEMENTS,
    &random_placement_method,		RANDOM_USE_PERCENTAGE,
    " ", "percentage",			"use percentage for random elements"
  },
  {
    -1,					ED_LEVEL_SETTINGS_YPOS(0),
    GADGET_ID_RANDOM_QUANTITY,		GADGET_ID_RANDOM_PERCENTAGE,
    RADIO_NR_RANDOM_ELEMENTS,
    &random_placement_method,		RANDOM_USE_QUANTITY,
    " ", "quantity",			"use quantity for random elements"
  }
};

static struct
{
  int x, y;
  int gadget_id;
  int gadget_id_align;
  boolean *value;
  char *text_left, *text_right, *infotext;
} checkbutton_info[ED_NUM_CHECKBUTTONS] =
{
  /* ---------- level and editor settings ---------------------------------- */

  {
    ED_LEVEL_SETTINGS_XPOS(0),		ED_LEVEL_SETTINGS_YPOS(1),
    GADGET_ID_RANDOM_RESTRICTED,	GADGET_ID_NONE,
    &random_placement_background_restricted,
    NULL,
    "restrict random placement to:",	"set random placement restriction"
  },

  /* ---------- element settings: configure (various elements) ------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    GADGET_ID_STICK_ELEMENT,		GADGET_ID_NONE,
    &stick_element_properties_window,
    NULL,
    "stick this screen to edit content","stick this screen to edit content"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_EM_SLIPPERY_GEMS,		GADGET_ID_NONE,
    &level.em_slippery_gems,
    NULL,
    "slip down from certain flat walls","use EM/DC style slipping behaviour"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_EM_EXPLODES_BY_FIRE,	GADGET_ID_NONE,
    &level.em_explodes_by_fire,
    NULL,
    "explodes with chain reaction",	"use R'n'D style explosion behaviour"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_USE_SPRING_BUG,		GADGET_ID_NONE,
    &level.use_spring_bug,
    NULL,
    "use spring pushing bug",		"use odd spring pushing behaviour"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_USE_TIME_ORB_BUG,		GADGET_ID_NONE,
    &level.use_time_orb_bug,
    NULL,
    "use time orb bug",			"use odd time orb behaviour"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_RANDOM_BALL_CONTENT,	GADGET_ID_NONE,
    &level.ball_random,
    NULL,
    "create single random element",	"only create one element from content"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_INITIAL_BALL_STATE,	GADGET_ID_NONE,
    &level.ball_state_initial,
    NULL,
    "magic ball initially activated",	"activate magic ball after level start"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    GADGET_ID_GROW_INTO_DIGGABLE,	GADGET_ID_NONE,
    &level.grow_into_diggable,
    NULL,
    "can grow into anything diggable",	"grow into more than just sand"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    GADGET_ID_AUTO_EXIT_SOKOBAN,	GADGET_ID_NONE,
    &level.auto_exit_sokoban,
    NULL,
    "exit level if all fields solved",	"automatically finish Sokoban levels"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(9),
    GADGET_ID_CONTINUOUS_SNAPPING,	GADGET_ID_NONE,
    &level.continuous_snapping,
    NULL,
    "continuous snapping",		"use snapping without releasing key"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(8),
    GADGET_ID_BLOCK_SNAP_FIELD,		GADGET_ID_NONE,
    &level.block_snap_field,
    NULL,
    "block snapped field when snapping", "use snapping delay to show animation"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_BLOCK_LAST_FIELD,		GADGET_ID_NONE,
    &level.block_last_field,
    NULL,
    "block last field when moving",	"player blocks last field when moving"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_SP_BLOCK_LAST_FIELD,	GADGET_ID_NONE,
    &level.sp_block_last_field,
    NULL,
    "block last field when moving",	"player blocks last field when moving"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(3),
    GADGET_ID_INSTANT_RELOCATION,	GADGET_ID_NONE,
    &level.instant_relocation,
    NULL,
    "no scrolling when relocating",	"player gets relocated without delay"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_SHIFTED_RELOCATION,	GADGET_ID_NONE,
    &level.shifted_relocation,
    NULL,
    "no centering when relocating",	"level not centered after relocation"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(5),
    GADGET_ID_LAZY_RELOCATION,		GADGET_ID_NONE,
    &level.lazy_relocation,
    NULL,
    "only redraw off-screen relocation","no redraw if relocation target visible"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(10),
    GADGET_ID_USE_START_ELEMENT,	GADGET_ID_NONE,
    &level.use_start_element[0],
    NULL,
    "use level start element:",	       "start level at this element's position"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(11),
    GADGET_ID_USE_ARTWORK_ELEMENT,	GADGET_ID_NONE,
    &level.use_artwork_element[0],
    NULL,
    "use artwork from element:",	"use player artwork from other element"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(12),
    GADGET_ID_USE_EXPLOSION_ELEMENT,	GADGET_ID_NONE,
    &level.use_explosion_element[0],
    NULL,
    "use explosion from element:",	"use explosion properties from element"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(13),
    GADGET_ID_INITIAL_GRAVITY,		GADGET_ID_NONE,
    &level.initial_player_gravity[0],
    NULL,
    "use initial gravity",		"set initial player gravity"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_USE_INITIAL_INVENTORY,	GADGET_ID_NONE,
    &level.use_initial_inventory[0],
    NULL,
    "use initial inventory:",		"use collected elements on level start"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(6),
    GADGET_ID_CAN_PASS_TO_WALKABLE,	GADGET_ID_NONE,
    &level.can_pass_to_walkable,
    NULL,
    "can pass to walkable element",	"player can pass to empty or walkable"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_CAN_FALL_INTO_ACID,	GADGET_ID_NONE,
    &custom_element_properties[EP_CAN_MOVE_INTO_ACID],
    NULL,
    "can fall into acid (with gravity)","player can fall into acid pool"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(0),
    GADGET_ID_CAN_MOVE_INTO_ACID,	GADGET_ID_NONE,
    &custom_element_properties[EP_CAN_MOVE_INTO_ACID],
    NULL,
    "can move into acid",		"element can move into acid pool"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_DONT_COLLIDE_WITH,	GADGET_ID_NONE,
    &custom_element_properties[EP_DONT_COLLIDE_WITH],
    NULL,
    "deadly when colliding with",	"element is deadly when hitting player"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_ENVELOPE_AUTOWRAP,	GADGET_ID_NONE,
    &level.envelope[0].autowrap,
    NULL,
    "auto-wrap",			"automatically wrap envelope text"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_ENVELOPE_CENTERED,	GADGET_ID_ENVELOPE_AUTOWRAP,
    &level.envelope[0].centered,
    " ",
    "centered",				"automatically center envelope text"
  },

  /* ---------- element settings: configure 1 (custom elements) ----------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_CUSTOM_USE_GRAPHIC,	GADGET_ID_NONE,
    &custom_element.use_gfx_element,
    NULL,
    "use graphic of element:",		"use existing element graphic"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(14),
    GADGET_ID_CUSTOM_USE_TEMPLATE,	GADGET_ID_NONE,
    &level.use_custom_template,
    NULL,
    "use template",			"use template for custom properties"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_CUSTOM_ACCESSIBLE,	GADGET_ID_NONE,
    &custom_element_properties[EP_ACCESSIBLE],
    NULL,
    NULL,				"player can walk to or pass this field"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(9),
    GADGET_ID_CUSTOM_GRAV_REACHABLE,	GADGET_ID_NONE,
    &custom_element_properties[EP_GRAVITY_REACHABLE],
    NULL,
    "reachable despite gravity",	"player can walk/dig despite gravity"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(11),
    GADGET_ID_CUSTOM_USE_LAST_VALUE,	GADGET_ID_NONE,
    &custom_element.use_last_ce_value,
    NULL,
    "use last CE value after change",	"use last CE value after change"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_CUSTOM_WALK_TO_OBJECT,	GADGET_ID_NONE,
    &custom_element_properties[EP_WALK_TO_OBJECT],
    NULL,
    NULL,				"player can dig/collect/push element"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(8),
    GADGET_ID_CUSTOM_INDESTRUCTIBLE,	GADGET_ID_NONE,
    &custom_element_properties[EP_INDESTRUCTIBLE],
    NULL,
    "indestructible",			"element is indestructible"
  },

  /* ---------- element settings: configure 2 (custom elements) ----------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_CUSTOM_CAN_MOVE,		GADGET_ID_NONE,
    &custom_element_properties[EP_CAN_MOVE],
    NULL,
    NULL,				"element can move with some pattern"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(7),
    GADGET_ID_CUSTOM_CAN_FALL,		GADGET_ID_NONE,
    &custom_element_properties[EP_CAN_FALL],
    NULL,
    "can fall",				"element can fall down"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(7),
    GADGET_ID_CUSTOM_CAN_SMASH,		GADGET_ID_CUSTOM_CAN_FALL,
    &custom_element_properties[EP_CAN_SMASH],
    " ",
    NULL,				"element can smash other elements"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(8),
    GADGET_ID_CUSTOM_SLIPPERY,		GADGET_ID_NONE,
    &custom_element_properties[EP_SLIPPERY],
    NULL,
    NULL,				"other elements can fall down from it"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(9),
    GADGET_ID_CUSTOM_DEADLY,		GADGET_ID_NONE,
    &custom_element_properties[EP_DEADLY],
    NULL,
    NULL,				"element can kill the player"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(10),
    GADGET_ID_CUSTOM_CAN_EXPLODE,	GADGET_ID_NONE,
    &custom_element_properties[EP_CAN_EXPLODE],
    NULL,
    NULL,				"element can explode"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(11),
    GADGET_ID_CUSTOM_EXPLODE_FIRE,	GADGET_ID_NONE,
    &custom_element_properties[EP_EXPLODES_BY_FIRE],
    NULL,
    "by fire",				"element can explode by fire/explosion"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(11),
    GADGET_ID_CUSTOM_EXPLODE_SMASH,	GADGET_ID_CUSTOM_EXPLODE_FIRE,
    &custom_element_properties[EP_EXPLODES_SMASHED],
    " ",
    "smashed",				"element can explode when smashed"
  },
  {
    -1,					ED_ELEMENT_SETTINGS_YPOS(11),
    GADGET_ID_CUSTOM_EXPLODE_IMPACT,	GADGET_ID_CUSTOM_EXPLODE_SMASH,
    &custom_element_properties[EP_EXPLODES_IMPACT],
    " ",
    "impact",				"element can explode on impact"
  },

  /* ---------- element settings: advanced (custom elements) --------------- */

  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(1),
    GADGET_ID_CUSTOM_CAN_CHANGE,	GADGET_ID_NONE,
    &custom_element_change.can_change,
    NULL,
    "element changes to:",		"change element on specified condition"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(2),
    GADGET_ID_CHANGE_DELAY,		GADGET_ID_NONE,
    &custom_element_change_events[CE_DELAY],
    NULL,
    NULL,				"element changes after delay"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(4),
    GADGET_ID_CHANGE_BY_DIRECT_ACT,	GADGET_ID_NONE,
    &custom_element_change_events[CE_BY_DIRECT_ACTION],
    NULL,
    NULL,				"element changes by direct action"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(5),
    GADGET_ID_CHANGE_BY_OTHER_ACT,	GADGET_ID_NONE,
    &custom_element_change_events[CE_BY_OTHER_ACTION],
    NULL,
    NULL,				"element changes by other element"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(8),
    GADGET_ID_CHANGE_USE_EXPLOSION,	GADGET_ID_NONE,
    &custom_element_change.explode,
    NULL,
    "explode instead of change",	"element explodes instead of change"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(1),	ED_ELEMENT_SETTINGS_YPOS(9),
    GADGET_ID_CHANGE_USE_CONTENT,	GADGET_ID_NONE,
    &custom_element_change.use_target_content,
    NULL,
    "use extended change target:",	"element changes to more elements"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(11),
    GADGET_ID_CHANGE_ONLY_COMPLETE,	GADGET_ID_NONE,
    &custom_element_change.only_if_complete,
    NULL,
    "replace all or nothing",		"only replace when all can be changed"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(2),	ED_ELEMENT_SETTINGS_YPOS(12),
    GADGET_ID_CHANGE_USE_RANDOM,	GADGET_ID_NONE,
    &custom_element_change.use_random_replace,
    NULL,
    NULL,				"use percentage for random replace"
  },
  {
    ED_ELEMENT_SETTINGS_XPOS(0),	ED_ELEMENT_SETTINGS_YPOS(13),
    GADGET_ID_CHANGE_HAS_ACTION,	GADGET_ID_NONE,
    &custom_element_change.has_action,
    NULL,
    NULL,				"execute action on specified condition"
  },
};

static struct
{
  int x, y;
  int xoffset, yoffset;
  int gadget_id;
  int gadget_id_align;
  int *value;
  int area_xsize, area_ysize;
  char *text_left, *text_right, *text_below, *infotext;
} drawingarea_info[ED_NUM_DRAWING_AREAS] =
{
  /* ---------- level playfield content ------------------------------------ */

  {
    0,					0,
    0,					0,
    GADGET_ID_DRAWING_LEVEL,		GADGET_ID_NONE,
    NULL,
    -1, -1,	/* these values are not constant, but can change at runtime */
    NULL, NULL, NULL,			NULL
  },

  /* ---------- yam yam content -------------------------------------------- */

  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(0),	ED_AREA_YAMYAM_CONTENT_YOFF(0),
    GADGET_ID_YAMYAM_CONTENT_0,		GADGET_ID_NONE,
    &level.yamyam_content[0].e[0][0],	3, 3,
    NULL, NULL, "1",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(1),	ED_AREA_YAMYAM_CONTENT_YOFF(1),
    GADGET_ID_YAMYAM_CONTENT_1,		GADGET_ID_NONE,
    &level.yamyam_content[1].e[0][0],	3, 3,
    NULL, NULL, "2",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(2),	ED_AREA_YAMYAM_CONTENT_YOFF(2),
    GADGET_ID_YAMYAM_CONTENT_2,		GADGET_ID_NONE,
    &level.yamyam_content[2].e[0][0],	3, 3,
    NULL, NULL, "3",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(3),	ED_AREA_YAMYAM_CONTENT_YOFF(3),
    GADGET_ID_YAMYAM_CONTENT_3,		GADGET_ID_NONE,
    &level.yamyam_content[3].e[0][0],	3, 3,
    NULL, NULL, "4",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(4),	ED_AREA_YAMYAM_CONTENT_YOFF(4),
    GADGET_ID_YAMYAM_CONTENT_4,		GADGET_ID_NONE,
    &level.yamyam_content[4].e[0][0],	3, 3,
    NULL, NULL, "5",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(5),	ED_AREA_YAMYAM_CONTENT_YOFF(5),
    GADGET_ID_YAMYAM_CONTENT_5,		GADGET_ID_NONE,
    &level.yamyam_content[5].e[0][0],	3, 3,
    NULL, NULL, "6",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(6),	ED_AREA_YAMYAM_CONTENT_YOFF(6),
    GADGET_ID_YAMYAM_CONTENT_6,		GADGET_ID_NONE,
    &level.yamyam_content[6].e[0][0],	3, 3,
    NULL, NULL, "7",			NULL
  },
  {
    ED_AREA_YAMYAM_CONTENT_XPOS,	ED_AREA_YAMYAM_CONTENT_YPOS,
    ED_AREA_YAMYAM_CONTENT_XOFF(7),	ED_AREA_YAMYAM_CONTENT_YOFF(7),
    GADGET_ID_YAMYAM_CONTENT_7,		GADGET_ID_NONE,
    &level.yamyam_content[7].e[0][0],	3, 3,
    NULL, NULL, "8",			NULL
  },

  /* ---------- magic ball content ----------------------------------------- */

  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(0),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(0),
    GADGET_ID_MAGIC_BALL_CONTENT_0,	GADGET_ID_NONE,
    &level.ball_content[0].e[0][0],	3, 3,
    NULL, NULL, "1",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(1),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(1),
    GADGET_ID_MAGIC_BALL_CONTENT_1,	GADGET_ID_NONE,
    &level.ball_content[1].e[0][0],	3, 3,
    NULL, NULL, "2",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(2),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(2),
    GADGET_ID_MAGIC_BALL_CONTENT_2,	GADGET_ID_NONE,
    &level.ball_content[2].e[0][0],	3, 3,
    NULL, NULL, "3",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(3),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(3),
    GADGET_ID_MAGIC_BALL_CONTENT_3,	GADGET_ID_NONE,
    &level.ball_content[3].e[0][0],	3, 3,
    NULL, NULL, "4",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(4),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(4),
    GADGET_ID_MAGIC_BALL_CONTENT_4,	GADGET_ID_NONE,
    &level.ball_content[4].e[0][0],	3, 3,
    NULL, NULL, "5",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(5),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(5),
    GADGET_ID_MAGIC_BALL_CONTENT_5,	GADGET_ID_NONE,
    &level.ball_content[5].e[0][0],	3, 3,
    NULL, NULL, "6",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(6),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(6),
    GADGET_ID_MAGIC_BALL_CONTENT_6,	GADGET_ID_NONE,
    &level.ball_content[6].e[0][0],	3, 3,
    NULL, NULL, "7",			NULL
  },
  {
    ED_AREA_MAGIC_BALL_CONTENT_XPOS,	ED_AREA_MAGIC_BALL_CONTENT_YPOS,
    ED_AREA_MAGIC_BALL_CONTENT_XOFF(7),	ED_AREA_MAGIC_BALL_CONTENT_YOFF(7),
    GADGET_ID_MAGIC_BALL_CONTENT_7,	GADGET_ID_NONE,
    &level.ball_content[7].e[0][0],	3, 3,
    NULL, NULL, "8",			NULL
  },

  /* ---------- android content -------------------------------------------- */

  {
    ED_AREA_1X1_SETTINGS_XPOS(0),	ED_AREA_1X1_SETTINGS_YPOS(5),
    ED_AREA_1X1_SETTINGS_XOFF,		ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_ANDROID_CONTENT,		GADGET_ID_NONE,
    &level.android_clone_element[0],	MAX_ANDROID_ELEMENTS, 1,
    "elements:", NULL, NULL,		"elements android can clone"
  },

  /* ---------- amoeba content --------------------------------------------- */

  {
    ED_AREA_1X1_SETTINGS_XPOS(0),	ED_AREA_1X1_SETTINGS_YPOS(3),
    ED_AREA_1X1_SETTINGS_XOFF,		ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_AMOEBA_CONTENT,		GADGET_ID_NONE,
    &level.amoeba_content,		1, 1,
    "content:", NULL, NULL,		"amoeba content"
  },

  /* ---------- level start element ---------------------------------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(10),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_START_ELEMENT,		GADGET_ID_USE_START_ELEMENT,
    &level.start_element[0],		1, 1,
    NULL, NULL, NULL,			"level start element"
  },

  /* ---------- player artwork element ------------------------------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(11),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_ARTWORK_ELEMENT,		GADGET_ID_USE_ARTWORK_ELEMENT,
    &level.artwork_element[0],		1, 1,
    NULL, NULL, NULL,			"element for player artwork"
  },

  /* ---------- player explosion element ----------------------------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(12),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_EXPLOSION_ELEMENT,	GADGET_ID_USE_EXPLOSION_ELEMENT,
    &level.explosion_element[0],	1, 1,
    NULL, NULL, NULL,			"element for player explosion"
  },

  /* ---------- player initial inventory ----------------------------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(1),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_INVENTORY_CONTENT,	GADGET_ID_USE_INITIAL_INVENTORY,
    &level.initial_inventory_content[0][0], MAX_INITIAL_INVENTORY_SIZE, 1,
    NULL, NULL, NULL,			"content for initial inventory"
  },

  /* ---------- element settings: configure 1 (custom elements) ----------- */

  /* ---------- custom graphic --------------------------------------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(1),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_GRAPHIC,		GADGET_ID_CUSTOM_USE_GRAPHIC,
    &custom_element.gfx_element_initial,1, 1,
    NULL, NULL, NULL,			"custom graphic element"
  },

  /* ---------- element settings: configure 2 (custom elements) ----------- */

  /* ---------- custom content (when exploding) ---------------------------- */

  {
    -1,					ED_AREA_3X3_SETTINGS_YPOS(10),
    0,					ED_AREA_3X3_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_CONTENT,		GADGET_ID_NONE,	/* align three rows */
    &custom_element.content.e[0][0],	3, 3,
    "content:", NULL, NULL,		NULL
  },

  /* ---------- custom enter and leave element (when moving) --------------- */

  {
    ED_AREA_1X1_SETTINGS_XPOS(1),	ED_AREA_1X1_SETTINGS_YPOS(3),
    ED_AREA_1X1_SETTINGS_XOFF,		ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_MOVE_ENTER,	GADGET_ID_NONE,
    &custom_element.move_enter_element,	1, 1,
    "can dig:", " ", NULL,		"element that can be digged/collected"
  },
  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(3),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_MOVE_LEAVE,	GADGET_ID_CUSTOM_MOVE_LEAVE_TYPE,
    &custom_element.move_leave_element,	1, 1,
    NULL, NULL, NULL,			"element that will be left behind"
  },

  /* ---------- element settings: advanced (custom elements) --------------- */

  /* ---------- custom change target --------------------------------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(1),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_CHANGE_TARGET,	GADGET_ID_CUSTOM_CAN_CHANGE,
    &custom_element_change.target_element, 1, 1,
    NULL, "after/when:", NULL,		"new target element after change"
  },

  /* ---------- custom change content (extended change target) ------------- */

  {
    -1,					ED_AREA_3X3_SETTINGS_YPOS(9),
    0,					ED_AREA_3X3_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_CHANGE_CONTENT,	GADGET_ID_NONE,	/* align three rows */
    &custom_element_change.target_content.e[0][0], 3, 3,
    NULL, NULL, NULL,			"new extended elements after change"
  },

  /* ---------- custom change trigger (element causing change) ------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(5),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_CHANGE_TRIGGER,	GADGET_ID_CHANGE_OTHER_ACTION,
    &custom_element_change.initial_trigger_element, 1, 1,
    NULL, NULL, NULL,			"other element triggering change"
  },

  /* ---------- custom change action (element used for action) ------------- */

  {
    -1,					ED_AREA_1X1_SETTINGS_YPOS(13),
    0,					ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_CUSTOM_CHANGE_ACTION,	GADGET_ID_ACTION_ARG,
    &custom_element_change.action_element, 1, 1,
    NULL, NULL, NULL,			"element used as action parameter"
  },

  /* ---------- group element content -------------------------------------- */

  {
    ED_AREA_1X1_SETTINGS_XPOS(0),	ED_AREA_1X1_SETTINGS_YPOS(2),
    ED_AREA_1X1_SETTINGS_XOFF,		ED_AREA_1X1_SETTINGS_YOFF,
    GADGET_ID_GROUP_CONTENT,		GADGET_ID_NONE,
    &group_element_info.element[0],	MAX_ELEMENTS_IN_GROUP, 1,
    "content:", NULL, NULL,		NULL
  },

  /* ---------- random background (for random painting) -------------------- */

  {
    -1,					ED_AREA_1X1_LSETTINGS_YPOS(1),
    0,					ED_AREA_1X1_LSETTINGS_YOFF,
    GADGET_ID_RANDOM_BACKGROUND,	GADGET_ID_RANDOM_RESTRICTED,
    &random_placement_background_element, 1, 1,
    NULL, NULL, NULL,			"random placement background"
  },
};


/*
  -----------------------------------------------------------------------------
  some internally used variables
  -----------------------------------------------------------------------------
*/

/* maximal size of level editor drawing area */
static int MAX_ED_FIELDX, MAX_ED_FIELDY;

/* actual size of level editor drawing area */
static int ed_fieldx, ed_fieldy;

/* actual position of level editor drawing area in level playfield */
static int level_xpos = -1, level_ypos = -1;

/* actual tile size used to display playfield drawing area */
static int ed_tilesize = DEFAULT_EDITOR_TILESIZE;

#define IN_ED_FIELD(x,y)	IN_FIELD(x, y, ed_fieldx, ed_fieldy)

/* drawing elements on the three mouse buttons */
static int new_element1 = EL_WALL;
static int new_element2 = EL_EMPTY;
static int new_element3 = EL_SAND;

#define IS_VALID_BUTTON(button) (button >= 1 && button <= 3)
#define BUTTON_ELEMENT(button) ((button) == 1 ? new_element1 : \
				(button) == 2 ? new_element2 : \
				(button) == 3 ? new_element3 : EL_EMPTY)

/* forward declaration for internal use */
static void ModifyEditorCounterValue(int, int);
static void ModifyEditorCounterLimits(int, int, int);
static void ModifyEditorSelectboxValue(int, int);
static void ModifyEditorSelectboxOptions(int, struct ValueTextInfo *);
static void ModifyEditorDrawingArea(int, int, int);
static void ModifyEditorElementList();
static void AdjustElementListScrollbar();
static void RedrawDrawingElements();
static void DrawDrawingWindow();
static void DrawLevelInfoWindow();
static void DrawPropertiesWindow();
static void UpdateCustomElementGraphicGadgets();
static boolean checkPropertiesConfig(int);
static void CopyLevelToUndoBuffer(int);
static void HandleDrawingAreas(struct GadgetInfo *);
static void HandleCounterButtons(struct GadgetInfo *);
static void HandleTextInputGadgets(struct GadgetInfo *);
static void HandleTextAreaGadgets(struct GadgetInfo *);
static void HandleSelectboxGadgets(struct GadgetInfo *);
static void HandleTextbuttonGadgets(struct GadgetInfo *);
static void HandleGraphicbuttonGadgets(struct GadgetInfo *);
static void HandleRadiobuttons(struct GadgetInfo *);
static void HandleCheckbuttons(struct GadgetInfo *);
static void HandleControlButtons(struct GadgetInfo *);
static void HandleDrawingAreaInfo(struct GadgetInfo *);
static void PrintEditorGadgetInfoText(struct GadgetInfo *);

static int num_editor_gadgets = 0;	/* dynamically determined */

static struct GadgetInfo **level_editor_gadget = NULL;
static int *right_gadget_border = NULL;

static int drawing_function = GADGET_ID_SINGLE_ITEMS;
static int last_drawing_function = GADGET_ID_SINGLE_ITEMS;
static boolean draw_with_brush = FALSE;
static int properties_element = 0;

static short FieldBackup[MAX_LEV_FIELDX][MAX_LEV_FIELDY];
static short UndoBuffer[NUM_UNDO_STEPS][MAX_LEV_FIELDX][MAX_LEV_FIELDY];
static short IntelliDrawBuffer[MAX_LEV_FIELDX][MAX_LEV_FIELDY];
static int undo_buffer_position = 0;
static int undo_buffer_steps = 0;
static int redo_buffer_steps = 0;

static int edit_mode;
static int edit_mode_levelinfo;
static int edit_mode_properties;

static int element_shift = 0;

static int editor_el_players[] =
{
  EL_PLAYER_1,
  EL_PLAYER_2,
  EL_PLAYER_3,
  EL_PLAYER_4
};
static int *editor_el_players_ptr = editor_el_players;
static int num_editor_el_players = SIZEOF_ARRAY_INT(editor_el_players);

static int editor_hl_boulderdash[] =
{
  EL_INTERNAL_CASCADE_BD_ACTIVE,
  EL_CHAR('B'),
  EL_CHAR('D'),
  EL_EMPTY,
};

static int editor_el_boulderdash[] =
{
  EL_EMPTY,
  EL_SAND,
  EL_BD_ROCK,
  EL_BD_DIAMOND,

  EL_STEELWALL,
  EL_BD_WALL,
  EL_BD_EXPANDABLE_WALL,
  EL_BD_MAGIC_WALL,

  EL_BD_AMOEBA,
  EL_BD_BUTTERFLY_UP,
  EL_BD_FIREFLY_UP,
  EL_EXIT_CLOSED,

  EL_BD_BUTTERFLY_LEFT,
  EL_BD_FIREFLY_LEFT,
  EL_BD_BUTTERFLY_RIGHT,
  EL_BD_FIREFLY_RIGHT,

  EL_EMPTY,
  EL_BD_BUTTERFLY_DOWN,
  EL_BD_FIREFLY_DOWN,
  EL_EXIT_OPEN,
};
static int *editor_hl_boulderdash_ptr = editor_hl_boulderdash;
static int *editor_el_boulderdash_ptr = editor_el_boulderdash;
static int num_editor_hl_boulderdash = SIZEOF_ARRAY_INT(editor_hl_boulderdash);
static int num_editor_el_boulderdash = SIZEOF_ARRAY_INT(editor_el_boulderdash);

static int editor_hl_emerald_mine[] =
{
  EL_INTERNAL_CASCADE_EM_ACTIVE,
  EL_CHAR('E'),
  EL_CHAR('M'),
  EL_EMPTY,
};

static int editor_el_emerald_mine[] =
{
  EL_SAND,
  EL_ROCK,
  EL_QUICKSAND_EMPTY,
  EL_QUICKSAND_FULL,

  EL_STEELWALL,
  EL_WALL,
  EL_WALL_SLIPPERY,
  EL_MAGIC_WALL,

  EL_EMERALD,
  EL_DIAMOND,
  EL_NUT,
  EL_BOMB,

  EL_WALL_EMERALD,
  EL_WALL_DIAMOND,
  EL_DYNAMITE,
  EL_DYNAMITE_ACTIVE,

  EL_YAMYAM,
  EL_BUG_UP,
  EL_SPACESHIP_UP,
  EL_ROBOT,

  EL_BUG_LEFT,
  EL_SPACESHIP_LEFT,
  EL_BUG_RIGHT,
  EL_SPACESHIP_RIGHT,

  EL_ROBOT_WHEEL,
  EL_BUG_DOWN,
  EL_SPACESHIP_DOWN,
  EL_INVISIBLE_WALL,

  EL_ACID_POOL_TOPLEFT,
  EL_ACID,
  EL_ACID_POOL_TOPRIGHT,
  EL_AMOEBA_DROP,

  EL_ACID_POOL_BOTTOMLEFT,
  EL_ACID_POOL_BOTTOM,
  EL_ACID_POOL_BOTTOMRIGHT,
  EL_AMOEBA_WET,

  EL_EM_KEY_1,
  EL_EM_KEY_2,
  EL_EM_KEY_3,
  EL_EM_KEY_4,

  EL_EM_GATE_1,
  EL_EM_GATE_2,
  EL_EM_GATE_3,
  EL_EM_GATE_4,

  EL_EM_GATE_1_GRAY,
  EL_EM_GATE_2_GRAY,
  EL_EM_GATE_3_GRAY,
  EL_EM_GATE_4_GRAY,

  EL_EM_EXIT_CLOSED,
  EL_EM_EXIT_OPEN,
  EL_EM_STEEL_EXIT_CLOSED,
  EL_EM_STEEL_EXIT_OPEN,
};
static int *editor_hl_emerald_mine_ptr = editor_hl_emerald_mine;
static int *editor_el_emerald_mine_ptr = editor_el_emerald_mine;
static int num_editor_hl_emerald_mine=SIZEOF_ARRAY_INT(editor_hl_emerald_mine);
static int num_editor_el_emerald_mine=SIZEOF_ARRAY_INT(editor_el_emerald_mine);

static int editor_hl_emerald_mine_club[] =
{
  EL_INTERNAL_CASCADE_EMC_ACTIVE,
  EL_CHAR('E'),
  EL_CHAR('M'),
  EL_CHAR('C'),
};

static int editor_el_emerald_mine_club[] =
{
  EL_EMC_KEY_5,
  EL_EMC_KEY_6,
  EL_EMC_KEY_7,
  EL_EMC_KEY_8,

  EL_EMC_GATE_5,
  EL_EMC_GATE_6,
  EL_EMC_GATE_7,
  EL_EMC_GATE_8,

  EL_EMC_GATE_5_GRAY,
  EL_EMC_GATE_6_GRAY,
  EL_EMC_GATE_7_GRAY,
  EL_EMC_GATE_8_GRAY,

  EL_EMC_STEELWALL_1,
  EL_EMC_STEELWALL_2,
  EL_EMC_STEELWALL_3,
  EL_EMC_STEELWALL_4,

  EL_EMC_WALL_13,
  EL_EMC_WALL_14,
  EL_EMC_WALL_15,
  EL_EMC_WALL_16,

  EL_EMC_WALL_SLIPPERY_1,
  EL_EMC_WALL_SLIPPERY_2,
  EL_EMC_WALL_SLIPPERY_3,
  EL_EMC_WALL_SLIPPERY_4,

  EL_EMC_WALL_1,
  EL_EMC_WALL_2,
  EL_EMC_WALL_3,
  EL_EMC_WALL_4,

  EL_EMC_WALL_5,
  EL_EMC_WALL_6,
  EL_EMC_WALL_7,
  EL_EMC_WALL_8,

  EL_EMC_WALL_9,
  EL_EMC_WALL_10,
  EL_EMC_WALL_11,
  EL_EMC_WALL_12,

  EL_EMC_GRASS,
  EL_EMC_FAKE_GRASS,
  EL_EMC_PLANT,
  EL_EMC_DRIPPER,

  EL_EMC_MAGIC_BALL,
  EL_EMC_MAGIC_BALL_SWITCH,
  EL_SPRING,
  EL_EMC_SPRING_BUMPER,

  EL_EMC_LENSES,
  EL_EMC_MAGNIFIER,
  EL_EM_DYNAMITE,
  EL_EM_DYNAMITE_ACTIVE,

  EL_BALLOON,
  EL_YAMYAM_UP,
  EL_BALLOON_SWITCH_UP,
  EL_BALLOON_SWITCH_ANY,

  EL_YAMYAM_LEFT,
  EL_BALLOON_SWITCH_LEFT,
  EL_YAMYAM_RIGHT,
  EL_BALLOON_SWITCH_RIGHT,

  EL_EMC_ANDROID,
  EL_YAMYAM_DOWN,
  EL_BALLOON_SWITCH_DOWN,
  EL_BALLOON_SWITCH_NONE,
};
static int *editor_hl_emerald_mine_club_ptr = editor_hl_emerald_mine_club;
static int *editor_el_emerald_mine_club_ptr = editor_el_emerald_mine_club;
static int num_editor_hl_emerald_mine_club=SIZEOF_ARRAY_INT(editor_hl_emerald_mine_club);
static int num_editor_el_emerald_mine_club=SIZEOF_ARRAY_INT(editor_el_emerald_mine_club);

static int editor_hl_rnd[] =
{
  EL_INTERNAL_CASCADE_RND_ACTIVE,
  EL_CHAR('R'),
  EL_CHAR('N'),
  EL_CHAR('D'),
};

static int editor_el_rnd[] =
{
  EL_KEY_1,
  EL_KEY_2,
  EL_KEY_3,
  EL_KEY_4,

  EL_GATE_1,
  EL_GATE_2,
  EL_GATE_3,
  EL_GATE_4,

  EL_GATE_1_GRAY,
  EL_GATE_2_GRAY,
  EL_GATE_3_GRAY,
  EL_GATE_4_GRAY,

  EL_ARROW_LEFT,
  EL_ARROW_RIGHT,
  EL_ARROW_UP,
  EL_ARROW_DOWN,

  EL_AMOEBA_DEAD,
  EL_AMOEBA_DRY,
  EL_AMOEBA_FULL,
  EL_GAME_OF_LIFE,

  EL_EMERALD_YELLOW,
  EL_EMERALD_RED,
  EL_EMERALD_PURPLE,
  EL_BIOMAZE,

  EL_WALL_EMERALD_YELLOW,
  EL_WALL_EMERALD_RED,
  EL_WALL_EMERALD_PURPLE,
  EL_WALL_BD_DIAMOND,

  EL_SPEED_PILL,
  EL_PACMAN_UP,
  EL_TIME_ORB_FULL,
  EL_TIME_ORB_EMPTY,

  EL_PACMAN_LEFT,
  EL_DARK_YAMYAM,
  EL_PACMAN_RIGHT,
  EL_EMPTY,

  EL_BLACK_ORB,
  EL_PACMAN_DOWN,
  EL_LAMP,
  EL_LAMP_ACTIVE,

  EL_DYNABOMB_INCREASE_NUMBER,
  EL_DYNABOMB_INCREASE_SIZE,
  EL_DYNABOMB_INCREASE_POWER,
  EL_STONEBLOCK,

  EL_MOLE,
  EL_PENGUIN,
  EL_PIG,
  EL_DRAGON,

  EL_BUG,
  EL_MOLE_UP,
  EL_BD_BUTTERFLY,
  EL_BD_FIREFLY,

  EL_MOLE_LEFT,
  EL_SATELLITE,
  EL_MOLE_RIGHT,
  EL_PACMAN,

  EL_SPACESHIP,
  EL_MOLE_DOWN,
  EL_INVISIBLE_STEELWALL,
  EL_INVISIBLE_WALL,

  EL_EXPANDABLE_WALL,
  EL_EXPANDABLE_WALL_HORIZONTAL,
  EL_EXPANDABLE_WALL_VERTICAL,
  EL_EXPANDABLE_WALL_ANY,
};
static int *editor_hl_rnd_ptr = editor_hl_rnd;
static int *editor_el_rnd_ptr = editor_el_rnd;
static int num_editor_hl_rnd = SIZEOF_ARRAY_INT(editor_hl_rnd);
static int num_editor_el_rnd = SIZEOF_ARRAY_INT(editor_el_rnd);

static int editor_hl_sokoban[] =
{
  EL_INTERNAL_CASCADE_SB_ACTIVE,
  EL_CHAR('S'),
  EL_CHAR('B'),
  EL_EMPTY,
};

static int editor_el_sokoban[] =
{
  EL_SOKOBAN_OBJECT,
  EL_SOKOBAN_FIELD_EMPTY,
  EL_SOKOBAN_FIELD_FULL,
  EL_SOKOBAN_FIELD_PLAYER,
};
static int *editor_hl_sokoban_ptr = editor_hl_sokoban;
static int *editor_el_sokoban_ptr = editor_el_sokoban;
static int num_editor_hl_sokoban = SIZEOF_ARRAY_INT(editor_hl_sokoban);
static int num_editor_el_sokoban = SIZEOF_ARRAY_INT(editor_el_sokoban);

static int editor_hl_supaplex[] =
{
  EL_INTERNAL_CASCADE_SP_ACTIVE,
  EL_CHAR('S'),
  EL_CHAR('P'),
  EL_EMPTY,
};

static int editor_el_supaplex[] =
{
  EL_SP_MURPHY,
  EL_EMPTY,
  EL_SP_BASE,
  EL_SP_BUGGY_BASE,

  EL_SP_INFOTRON,
  EL_SP_ZONK,
  EL_SP_SNIKSNAK,
  EL_SP_ELECTRON,

  EL_SP_DISK_RED,
  EL_SP_DISK_ORANGE,
  EL_SP_DISK_YELLOW,
  EL_SP_TERMINAL,

  EL_SP_EXIT_CLOSED,
  EL_SP_PORT_HORIZONTAL,
  EL_SP_PORT_VERTICAL,
  EL_SP_PORT_ANY,

  EL_SP_PORT_LEFT,
  EL_SP_PORT_RIGHT,
  EL_SP_PORT_UP,
  EL_SP_PORT_DOWN,

  EL_SP_GRAVITY_PORT_LEFT,
  EL_SP_GRAVITY_PORT_RIGHT,
  EL_SP_GRAVITY_PORT_UP,
  EL_SP_GRAVITY_PORT_DOWN,

  EL_SP_GRAVITY_ON_PORT_LEFT,
  EL_SP_GRAVITY_ON_PORT_RIGHT,
  EL_SP_GRAVITY_ON_PORT_UP,
  EL_SP_GRAVITY_ON_PORT_DOWN,

  EL_SP_GRAVITY_OFF_PORT_LEFT,
  EL_SP_GRAVITY_OFF_PORT_RIGHT,
  EL_SP_GRAVITY_OFF_PORT_UP,
  EL_SP_GRAVITY_OFF_PORT_DOWN,

  EL_SP_HARDWARE_GRAY,
  EL_SP_HARDWARE_GREEN,
  EL_SP_HARDWARE_BLUE,
  EL_SP_HARDWARE_RED,

  EL_SP_HARDWARE_BASE_1,
  EL_SP_HARDWARE_BASE_2,
  EL_SP_HARDWARE_BASE_3,
  EL_SP_HARDWARE_BASE_4,

  EL_SP_HARDWARE_BASE_5,
  EL_SP_HARDWARE_BASE_6,
  EL_SP_HARDWARE_YELLOW,
  EL_SP_CHIP_TOP,

  EL_SP_CHIP_SINGLE,
  EL_SP_CHIP_LEFT,
  EL_SP_CHIP_RIGHT,
  EL_SP_CHIP_BOTTOM,
};
static int *editor_hl_supaplex_ptr = editor_hl_supaplex;
static int *editor_el_supaplex_ptr = editor_el_supaplex;
static int num_editor_hl_supaplex = SIZEOF_ARRAY_INT(editor_hl_supaplex);
static int num_editor_el_supaplex = SIZEOF_ARRAY_INT(editor_el_supaplex);

static int editor_hl_diamond_caves[] =
{
  EL_INTERNAL_CASCADE_DC_ACTIVE,
  EL_CHAR('D'),
  EL_CHAR('C'),
  EL_CHAR('2'),
};

static int editor_el_diamond_caves[] =
{
  EL_PEARL,
  EL_CRYSTAL,
  EL_WALL_PEARL,
  EL_WALL_CRYSTAL,

  EL_CONVEYOR_BELT_1_LEFT,
  EL_CONVEYOR_BELT_1_MIDDLE,
  EL_CONVEYOR_BELT_1_RIGHT,
  EL_CONVEYOR_BELT_1_SWITCH_MIDDLE,

  EL_CONVEYOR_BELT_2_LEFT,
  EL_CONVEYOR_BELT_2_MIDDLE,
  EL_CONVEYOR_BELT_2_RIGHT,
  EL_CONVEYOR_BELT_2_SWITCH_MIDDLE,

  EL_CONVEYOR_BELT_3_LEFT,
  EL_CONVEYOR_BELT_3_MIDDLE,
  EL_CONVEYOR_BELT_3_RIGHT,
  EL_CONVEYOR_BELT_3_SWITCH_MIDDLE,

  EL_CONVEYOR_BELT_4_LEFT,
  EL_CONVEYOR_BELT_4_MIDDLE,
  EL_CONVEYOR_BELT_4_RIGHT,
  EL_CONVEYOR_BELT_4_SWITCH_MIDDLE,

  EL_CONVEYOR_BELT_1_SWITCH_LEFT,
  EL_CONVEYOR_BELT_2_SWITCH_LEFT,
  EL_CONVEYOR_BELT_3_SWITCH_LEFT,
  EL_CONVEYOR_BELT_4_SWITCH_LEFT,

  EL_CONVEYOR_BELT_1_SWITCH_RIGHT,
  EL_CONVEYOR_BELT_2_SWITCH_RIGHT,
  EL_CONVEYOR_BELT_3_SWITCH_RIGHT,
  EL_CONVEYOR_BELT_4_SWITCH_RIGHT,

  EL_TIMEGATE_CLOSED,
  EL_TIMEGATE_OPEN,
  EL_TIMEGATE_SWITCH,
  EL_DC_TIMEGATE_SWITCH,

  EL_SWITCHGATE_CLOSED,
  EL_SWITCHGATE_OPEN,
  EL_SWITCHGATE_SWITCH_UP,
  EL_SWITCHGATE_SWITCH_DOWN,

  EL_LIGHT_SWITCH,
  EL_LIGHT_SWITCH_ACTIVE,
  EL_DC_SWITCHGATE_SWITCH_UP,
  EL_DC_SWITCHGATE_SWITCH_DOWN,

  EL_STEEL_EXIT_CLOSED,
  EL_STEEL_EXIT_OPEN,
  EL_STEELWALL_SLIPPERY,
  EL_INVISIBLE_SAND,

  EL_QUICKSAND_FAST_EMPTY,
  EL_QUICKSAND_FAST_FULL,
  EL_LANDMINE,
  EL_DC_LANDMINE,

  EL_SHIELD_NORMAL,
  EL_SHIELD_DEADLY,
  EL_EXTRA_TIME,
  EL_DC_MAGIC_WALL,

  EL_ENVELOPE_1,
  EL_ENVELOPE_2,
  EL_ENVELOPE_3,
  EL_ENVELOPE_4,

  EL_SIGN_RADIOACTIVITY,
  EL_SIGN_WHEELCHAIR,
  EL_SIGN_PARKING,
  EL_SIGN_NO_ENTRY,

  EL_SIGN_GIVE_WAY,
  EL_SIGN_ENTRY_FORBIDDEN,
  EL_SIGN_EMERGENCY_EXIT,
  EL_SIGN_YIN_YANG,

#if 0
  EL_SIGN_SPERMS,
  EL_SIGN_BULLET,
  EL_SIGN_HEART,
  EL_SIGN_CROSS,

  EL_SIGN_FRANKIE,
  EL_EMPTY,
  EL_EMPTY,
  EL_EMPTY,

  EL_SPERMS,
  EL_BULLET,
  EL_HEART,
  EL_CROSS,

  EL_FRANKIE,
  EL_EMPTY,
  EL_EMPTY,
  EL_EMPTY,
#endif

  EL_DC_STEELWALL_2_SINGLE,
  EL_DC_STEELWALL_2_TOP,
  EL_SIGN_EXCLAMATION,
  EL_SIGN_STOP,

  EL_DC_STEELWALL_2_LEFT,
  EL_DC_STEELWALL_2_MIDDLE,
  EL_DC_STEELWALL_2_HORIZONTAL,
  EL_DC_STEELWALL_2_RIGHT,

  EL_DC_STEELWALL_1_TOPLEFT,
  EL_DC_STEELWALL_2_VERTICAL,
  EL_DC_STEELWALL_1_TOPRIGHT,
  EL_DC_GATE_WHITE,

  EL_DC_STEELWALL_1_VERTICAL,
  EL_DC_STEELWALL_2_BOTTOM,
  EL_DC_KEY_WHITE,
  EL_DC_GATE_WHITE_GRAY,

  EL_DC_STEELWALL_1_BOTTOMLEFT,
  EL_DC_STEELWALL_1_HORIZONTAL,
  EL_DC_STEELWALL_1_BOTTOMRIGHT,
  EL_DC_GATE_FAKE_GRAY,

  EL_DC_STEELWALL_1_BOTTOMRIGHT_2,
  EL_DC_STEELWALL_1_BOTTOM,
  EL_DC_STEELWALL_1_BOTTOMLEFT_2,
  EL_EXPANDABLE_STEELWALL_HORIZONTAL,

  EL_DC_STEELWALL_1_RIGHT,
  EL_EMPTY,
  EL_DC_STEELWALL_1_LEFT,
  EL_EXPANDABLE_STEELWALL_VERTICAL,

  EL_DC_STEELWALL_1_TOPRIGHT_2,
  EL_DC_STEELWALL_1_TOP,
  EL_DC_STEELWALL_1_TOPLEFT_2,
  EL_EXPANDABLE_STEELWALL_ANY,
};
static int *editor_hl_diamond_caves_ptr = editor_hl_diamond_caves;
static int *editor_el_diamond_caves_ptr = editor_el_diamond_caves;
static int num_editor_hl_diamond_caves = SIZEOF_ARRAY_INT(editor_hl_diamond_caves);
static int num_editor_el_diamond_caves = SIZEOF_ARRAY_INT(editor_el_diamond_caves);

static int editor_hl_dx_boulderdash[] =
{
  EL_INTERNAL_CASCADE_DX_ACTIVE,
  EL_CHAR('D'),
  EL_CHAR('X'),
  EL_EMPTY,
};

static int editor_el_dx_boulderdash[] =
{
  EL_EMPTY,
  EL_TUBE_RIGHT_DOWN,
  EL_TUBE_HORIZONTAL_DOWN,
  EL_TUBE_LEFT_DOWN,

  EL_TUBE_HORIZONTAL,
  EL_TUBE_VERTICAL_RIGHT,
  EL_TUBE_ANY,
  EL_TUBE_VERTICAL_LEFT,

  EL_TUBE_VERTICAL,
  EL_TUBE_RIGHT_UP,
  EL_TUBE_HORIZONTAL_UP,
  EL_TUBE_LEFT_UP,

  EL_TRAP,
  EL_DX_SUPABOMB,
  EL_EMPTY,
  EL_EMPTY
};
static int *editor_hl_dx_boulderdash_ptr = editor_hl_dx_boulderdash;
static int *editor_el_dx_boulderdash_ptr = editor_el_dx_boulderdash;
static int num_editor_hl_dx_boulderdash = SIZEOF_ARRAY_INT(editor_hl_dx_boulderdash);
static int num_editor_el_dx_boulderdash = SIZEOF_ARRAY_INT(editor_el_dx_boulderdash);

static int editor_hl_chars[] =
{
  EL_INTERNAL_CASCADE_CHARS_ACTIVE,
  EL_CHAR('T'),
  EL_CHAR('X'),
  EL_CHAR('T'),
};

static int editor_el_chars[] =
{
  EL_CHAR(' '),
  EL_CHAR('!'),
  EL_CHAR('"'),
  EL_CHAR('#'),

  EL_CHAR('$'),
  EL_CHAR('%'),
  EL_CHAR('&'),
  EL_CHAR('\''),

  EL_CHAR('('),
  EL_CHAR(')'),
  EL_CHAR('*'),
  EL_CHAR('+'),

  EL_CHAR(','),
  EL_CHAR('-'),
  EL_CHAR('.'),
  EL_CHAR('/'),

  EL_CHAR('0'),
  EL_CHAR('1'),
  EL_CHAR('2'),
  EL_CHAR('3'),

  EL_CHAR('4'),
  EL_CHAR('5'),
  EL_CHAR('6'),
  EL_CHAR('7'),

  EL_CHAR('8'),
  EL_CHAR('9'),
  EL_CHAR(':'),
  EL_CHAR(';'),

  EL_CHAR('<'),
  EL_CHAR('='),
  EL_CHAR('>'),
  EL_CHAR('?'),

  EL_CHAR('@'),
  EL_CHAR('A'),
  EL_CHAR('B'),
  EL_CHAR('C'),

  EL_CHAR('D'),
  EL_CHAR('E'),
  EL_CHAR('F'),
  EL_CHAR('G'),

  EL_CHAR('H'),
  EL_CHAR('I'),
  EL_CHAR('J'),
  EL_CHAR('K'),

  EL_CHAR('L'),
  EL_CHAR('M'),
  EL_CHAR('N'),
  EL_CHAR('O'),

  EL_CHAR('P'),
  EL_CHAR('Q'),
  EL_CHAR('R'),
  EL_CHAR('S'),

  EL_CHAR('T'),
  EL_CHAR('U'),
  EL_CHAR('V'),
  EL_CHAR('W'),

  EL_CHAR('X'),
  EL_CHAR('Y'),
  EL_CHAR('Z'),
  EL_CHAR('['),

  EL_CHAR('\\'),
  EL_CHAR(']'),
  EL_CHAR('^'),
  EL_CHAR('_'),

  EL_CHAR(CHAR_BYTE_COPYRIGHT),
  EL_CHAR(CHAR_BYTE_UMLAUT_A),
  EL_CHAR(CHAR_BYTE_UMLAUT_O),
  EL_CHAR(CHAR_BYTE_UMLAUT_U),

  EL_CHAR(CHAR_BYTE_DEGREE),
  EL_CHAR(CHAR_BYTE_REGISTERED),
  EL_CHAR(FONT_ASCII_CURSOR),
  EL_CHAR(FONT_ASCII_BUTTON),

  EL_CHAR(FONT_ASCII_UP),
  EL_CHAR(FONT_ASCII_DOWN),
  EL_CHAR(' '),
  EL_CHAR(' ')
};
static int *editor_hl_chars_ptr = editor_hl_chars;
static int *editor_el_chars_ptr = editor_el_chars;
static int num_editor_hl_chars = SIZEOF_ARRAY_INT(editor_hl_chars);
static int num_editor_el_chars = SIZEOF_ARRAY_INT(editor_el_chars);

static int editor_hl_steel_chars[] =
{
  EL_INTERNAL_CASCADE_STEEL_CHARS_ACTIVE,
  EL_STEEL_CHAR('T'),
  EL_STEEL_CHAR('X'),
  EL_STEEL_CHAR('T'),
};

static int editor_el_steel_chars[] =
{
  EL_STEEL_CHAR(' '),
  EL_STEEL_CHAR('!'),
  EL_STEEL_CHAR('"'),
  EL_STEEL_CHAR('#'),

  EL_STEEL_CHAR('$'),
  EL_STEEL_CHAR('%'),
  EL_STEEL_CHAR('&'),
  EL_STEEL_CHAR('\''),

  EL_STEEL_CHAR('('),
  EL_STEEL_CHAR(')'),
  EL_STEEL_CHAR('*'),
  EL_STEEL_CHAR('+'),

  EL_STEEL_CHAR(','),
  EL_STEEL_CHAR('-'),
  EL_STEEL_CHAR('.'),
  EL_STEEL_CHAR('/'),

  EL_STEEL_CHAR('0'),
  EL_STEEL_CHAR('1'),
  EL_STEEL_CHAR('2'),
  EL_STEEL_CHAR('3'),

  EL_STEEL_CHAR('4'),
  EL_STEEL_CHAR('5'),
  EL_STEEL_CHAR('6'),
  EL_STEEL_CHAR('7'),

  EL_STEEL_CHAR('8'),
  EL_STEEL_CHAR('9'),
  EL_STEEL_CHAR(':'),
  EL_STEEL_CHAR(';'),

  EL_STEEL_CHAR('<'),
  EL_STEEL_CHAR('='),
  EL_STEEL_CHAR('>'),
  EL_STEEL_CHAR('?'),

  EL_STEEL_CHAR('@'),
  EL_STEEL_CHAR('A'),
  EL_STEEL_CHAR('B'),
  EL_STEEL_CHAR('C'),

  EL_STEEL_CHAR('D'),
  EL_STEEL_CHAR('E'),
  EL_STEEL_CHAR('F'),
  EL_STEEL_CHAR('G'),

  EL_STEEL_CHAR('H'),
  EL_STEEL_CHAR('I'),
  EL_STEEL_CHAR('J'),
  EL_STEEL_CHAR('K'),

  EL_STEEL_CHAR('L'),
  EL_STEEL_CHAR('M'),
  EL_STEEL_CHAR('N'),
  EL_STEEL_CHAR('O'),

  EL_STEEL_CHAR('P'),
  EL_STEEL_CHAR('Q'),
  EL_STEEL_CHAR('R'),
  EL_STEEL_CHAR('S'),

  EL_STEEL_CHAR('T'),
  EL_STEEL_CHAR('U'),
  EL_STEEL_CHAR('V'),
  EL_STEEL_CHAR('W'),

  EL_STEEL_CHAR('X'),
  EL_STEEL_CHAR('Y'),
  EL_STEEL_CHAR('Z'),
  EL_STEEL_CHAR('['),

  EL_STEEL_CHAR('\\'),
  EL_STEEL_CHAR(']'),
  EL_STEEL_CHAR('^'),
  EL_STEEL_CHAR('_'),

  EL_STEEL_CHAR(CHAR_BYTE_COPYRIGHT),
  EL_STEEL_CHAR(CHAR_BYTE_UMLAUT_A),
  EL_STEEL_CHAR(CHAR_BYTE_UMLAUT_O),
  EL_STEEL_CHAR(CHAR_BYTE_UMLAUT_U),

  EL_STEEL_CHAR(CHAR_BYTE_DEGREE),
  EL_STEEL_CHAR(CHAR_BYTE_REGISTERED),
  EL_STEEL_CHAR(FONT_ASCII_CURSOR),
  EL_STEEL_CHAR(FONT_ASCII_BUTTON),

  EL_STEEL_CHAR(FONT_ASCII_UP),
  EL_STEEL_CHAR(FONT_ASCII_DOWN),
  EL_STEEL_CHAR(' '),
  EL_STEEL_CHAR(' ')
};
static int *editor_hl_steel_chars_ptr = editor_hl_steel_chars;
static int *editor_el_steel_chars_ptr = editor_el_steel_chars;
static int num_editor_hl_steel_chars = SIZEOF_ARRAY_INT(editor_hl_steel_chars);
static int num_editor_el_steel_chars = SIZEOF_ARRAY_INT(editor_el_steel_chars);

static int editor_hl_custom[] =
{
  EL_INTERNAL_CASCADE_CE_ACTIVE,
  EL_CHAR('C'),
  EL_CHAR('E'),
  EL_EMPTY,
};

static int editor_el_custom[] =
{
  EL_CUSTOM_START + 0,
  EL_CUSTOM_START + 1,
  EL_CUSTOM_START + 2,
  EL_CUSTOM_START + 3,

  EL_CUSTOM_START + 4,
  EL_CUSTOM_START + 5,
  EL_CUSTOM_START + 6,
  EL_CUSTOM_START + 7,

  EL_CUSTOM_START + 8,
  EL_CUSTOM_START + 9,
  EL_CUSTOM_START + 10,
  EL_CUSTOM_START + 11,

  EL_CUSTOM_START + 12,
  EL_CUSTOM_START + 13,
  EL_CUSTOM_START + 14,
  EL_CUSTOM_START + 15,

  EL_CUSTOM_START + 16,
  EL_CUSTOM_START + 17,
  EL_CUSTOM_START + 18,
  EL_CUSTOM_START + 19,

  EL_CUSTOM_START + 20,
  EL_CUSTOM_START + 21,
  EL_CUSTOM_START + 22,
  EL_CUSTOM_START + 23,

  EL_CUSTOM_START + 24,
  EL_CUSTOM_START + 25,
  EL_CUSTOM_START + 26,
  EL_CUSTOM_START + 27,

  EL_CUSTOM_START + 28,
  EL_CUSTOM_START + 29,
  EL_CUSTOM_START + 30,
  EL_CUSTOM_START + 31,

  EL_CUSTOM_START + 32,
  EL_CUSTOM_START + 33,
  EL_CUSTOM_START + 34,
  EL_CUSTOM_START + 35,

  EL_CUSTOM_START + 36,
  EL_CUSTOM_START + 37,
  EL_CUSTOM_START + 38,
  EL_CUSTOM_START + 39,

  EL_CUSTOM_START + 40,
  EL_CUSTOM_START + 41,
  EL_CUSTOM_START + 42,
  EL_CUSTOM_START + 43,

  EL_CUSTOM_START + 44,
  EL_CUSTOM_START + 45,
  EL_CUSTOM_START + 46,
  EL_CUSTOM_START + 47,

  EL_CUSTOM_START + 48,
  EL_CUSTOM_START + 49,
  EL_CUSTOM_START + 50,
  EL_CUSTOM_START + 51,

  EL_CUSTOM_START + 52,
  EL_CUSTOM_START + 53,
  EL_CUSTOM_START + 54,
  EL_CUSTOM_START + 55,

  EL_CUSTOM_START + 56,
  EL_CUSTOM_START + 57,
  EL_CUSTOM_START + 58,
  EL_CUSTOM_START + 59,

  EL_CUSTOM_START + 60,
  EL_CUSTOM_START + 61,
  EL_CUSTOM_START + 62,
  EL_CUSTOM_START + 63,

  EL_CUSTOM_START + 64,
  EL_CUSTOM_START + 65,
  EL_CUSTOM_START + 66,
  EL_CUSTOM_START + 67,

  EL_CUSTOM_START + 68,
  EL_CUSTOM_START + 69,
  EL_CUSTOM_START + 70,
  EL_CUSTOM_START + 71,

  EL_CUSTOM_START + 72,
  EL_CUSTOM_START + 73,
  EL_CUSTOM_START + 74,
  EL_CUSTOM_START + 75,

  EL_CUSTOM_START + 76,
  EL_CUSTOM_START + 77,
  EL_CUSTOM_START + 78,
  EL_CUSTOM_START + 79,

  EL_CUSTOM_START + 80,
  EL_CUSTOM_START + 81,
  EL_CUSTOM_START + 82,
  EL_CUSTOM_START + 83,

  EL_CUSTOM_START + 84,
  EL_CUSTOM_START + 85,
  EL_CUSTOM_START + 86,
  EL_CUSTOM_START + 87,

  EL_CUSTOM_START + 88,
  EL_CUSTOM_START + 89,
  EL_CUSTOM_START + 90,
  EL_CUSTOM_START + 91,

  EL_CUSTOM_START + 92,
  EL_CUSTOM_START + 93,
  EL_CUSTOM_START + 94,
  EL_CUSTOM_START + 95,

  EL_CUSTOM_START + 96,
  EL_CUSTOM_START + 97,
  EL_CUSTOM_START + 98,
  EL_CUSTOM_START + 99,

  EL_CUSTOM_START + 100,
  EL_CUSTOM_START + 101,
  EL_CUSTOM_START + 102,
  EL_CUSTOM_START + 103,

  EL_CUSTOM_START + 104,
  EL_CUSTOM_START + 105,
  EL_CUSTOM_START + 106,
  EL_CUSTOM_START + 107,

  EL_CUSTOM_START + 108,
  EL_CUSTOM_START + 109,
  EL_CUSTOM_START + 110,
  EL_CUSTOM_START + 111,

  EL_CUSTOM_START + 112,
  EL_CUSTOM_START + 113,
  EL_CUSTOM_START + 114,
  EL_CUSTOM_START + 115,

  EL_CUSTOM_START + 116,
  EL_CUSTOM_START + 117,
  EL_CUSTOM_START + 118,
  EL_CUSTOM_START + 119,

  EL_CUSTOM_START + 120,
  EL_CUSTOM_START + 121,
  EL_CUSTOM_START + 122,
  EL_CUSTOM_START + 123,

  EL_CUSTOM_START + 124,
  EL_CUSTOM_START + 125,
  EL_CUSTOM_START + 126,
  EL_CUSTOM_START + 127,

  EL_CUSTOM_START + 128,
  EL_CUSTOM_START + 129,
  EL_CUSTOM_START + 130,
  EL_CUSTOM_START + 131,

  EL_CUSTOM_START + 132,
  EL_CUSTOM_START + 133,
  EL_CUSTOM_START + 134,
  EL_CUSTOM_START + 135,

  EL_CUSTOM_START + 136,
  EL_CUSTOM_START + 137,
  EL_CUSTOM_START + 138,
  EL_CUSTOM_START + 139,

  EL_CUSTOM_START + 140,
  EL_CUSTOM_START + 141,
  EL_CUSTOM_START + 142,
  EL_CUSTOM_START + 143,

  EL_CUSTOM_START + 144,
  EL_CUSTOM_START + 145,
  EL_CUSTOM_START + 146,
  EL_CUSTOM_START + 147,

  EL_CUSTOM_START + 148,
  EL_CUSTOM_START + 149,
  EL_CUSTOM_START + 150,
  EL_CUSTOM_START + 151,

  EL_CUSTOM_START + 152,
  EL_CUSTOM_START + 153,
  EL_CUSTOM_START + 154,
  EL_CUSTOM_START + 155,

  EL_CUSTOM_START + 156,
  EL_CUSTOM_START + 157,
  EL_CUSTOM_START + 158,
  EL_CUSTOM_START + 159,

  EL_CUSTOM_START + 160,
  EL_CUSTOM_START + 161,
  EL_CUSTOM_START + 162,
  EL_CUSTOM_START + 163,

  EL_CUSTOM_START + 164,
  EL_CUSTOM_START + 165,
  EL_CUSTOM_START + 166,
  EL_CUSTOM_START + 167,

  EL_CUSTOM_START + 168,
  EL_CUSTOM_START + 169,
  EL_CUSTOM_START + 170,
  EL_CUSTOM_START + 171,

  EL_CUSTOM_START + 172,
  EL_CUSTOM_START + 173,
  EL_CUSTOM_START + 174,
  EL_CUSTOM_START + 175,

  EL_CUSTOM_START + 176,
  EL_CUSTOM_START + 177,
  EL_CUSTOM_START + 178,
  EL_CUSTOM_START + 179,

  EL_CUSTOM_START + 180,
  EL_CUSTOM_START + 181,
  EL_CUSTOM_START + 182,
  EL_CUSTOM_START + 183,

  EL_CUSTOM_START + 184,
  EL_CUSTOM_START + 185,
  EL_CUSTOM_START + 186,
  EL_CUSTOM_START + 187,

  EL_CUSTOM_START + 188,
  EL_CUSTOM_START + 189,
  EL_CUSTOM_START + 190,
  EL_CUSTOM_START + 191,

  EL_CUSTOM_START + 192,
  EL_CUSTOM_START + 193,
  EL_CUSTOM_START + 194,
  EL_CUSTOM_START + 195,

  EL_CUSTOM_START + 196,
  EL_CUSTOM_START + 197,
  EL_CUSTOM_START + 198,
  EL_CUSTOM_START + 199,

  EL_CUSTOM_START + 200,
  EL_CUSTOM_START + 201,
  EL_CUSTOM_START + 202,
  EL_CUSTOM_START + 203,

  EL_CUSTOM_START + 204,
  EL_CUSTOM_START + 205,
  EL_CUSTOM_START + 206,
  EL_CUSTOM_START + 207,

  EL_CUSTOM_START + 208,
  EL_CUSTOM_START + 209,
  EL_CUSTOM_START + 210,
  EL_CUSTOM_START + 211,

  EL_CUSTOM_START + 212,
  EL_CUSTOM_START + 213,
  EL_CUSTOM_START + 214,
  EL_CUSTOM_START + 215,

  EL_CUSTOM_START + 216,
  EL_CUSTOM_START + 217,
  EL_CUSTOM_START + 218,
  EL_CUSTOM_START + 219,

  EL_CUSTOM_START + 220,
  EL_CUSTOM_START + 221,
  EL_CUSTOM_START + 222,
  EL_CUSTOM_START + 223,

  EL_CUSTOM_START + 224,
  EL_CUSTOM_START + 225,
  EL_CUSTOM_START + 226,
  EL_CUSTOM_START + 227,

  EL_CUSTOM_START + 228,
  EL_CUSTOM_START + 229,
  EL_CUSTOM_START + 230,
  EL_CUSTOM_START + 231,

  EL_CUSTOM_START + 232,
  EL_CUSTOM_START + 233,
  EL_CUSTOM_START + 234,
  EL_CUSTOM_START + 235,

  EL_CUSTOM_START + 236,
  EL_CUSTOM_START + 237,
  EL_CUSTOM_START + 238,
  EL_CUSTOM_START + 239,

  EL_CUSTOM_START + 240,
  EL_CUSTOM_START + 241,
  EL_CUSTOM_START + 242,
  EL_CUSTOM_START + 243,

  EL_CUSTOM_START + 244,
  EL_CUSTOM_START + 245,
  EL_CUSTOM_START + 246,
  EL_CUSTOM_START + 247,

  EL_CUSTOM_START + 248,
  EL_CUSTOM_START + 249,
  EL_CUSTOM_START + 250,
  EL_CUSTOM_START + 251,

  EL_CUSTOM_START + 252,
  EL_CUSTOM_START + 253,
  EL_CUSTOM_START + 254,
  EL_CUSTOM_START + 255
};
static int *editor_hl_custom_ptr = editor_hl_custom;
static int *editor_el_custom_ptr = editor_el_custom;
static int num_editor_hl_custom = SIZEOF_ARRAY_INT(editor_hl_custom);
static int num_editor_el_custom = SIZEOF_ARRAY_INT(editor_el_custom);

static int editor_hl_group[] =
{
  EL_INTERNAL_CASCADE_GE_ACTIVE,
  EL_CHAR('G'),
  EL_CHAR('E'),
  EL_EMPTY,
};

static int editor_el_group[] =
{
  EL_GROUP_START + 0,
  EL_GROUP_START + 1,
  EL_GROUP_START + 2,
  EL_GROUP_START + 3,

  EL_GROUP_START + 4,
  EL_GROUP_START + 5,
  EL_GROUP_START + 6,
  EL_GROUP_START + 7,

  EL_GROUP_START + 8,
  EL_GROUP_START + 9,
  EL_GROUP_START + 10,
  EL_GROUP_START + 11,

  EL_GROUP_START + 12,
  EL_GROUP_START + 13,
  EL_GROUP_START + 14,
  EL_GROUP_START + 15,

  EL_GROUP_START + 16,
  EL_GROUP_START + 17,
  EL_GROUP_START + 18,
  EL_GROUP_START + 19,

  EL_GROUP_START + 20,
  EL_GROUP_START + 21,
  EL_GROUP_START + 22,
  EL_GROUP_START + 23,

  EL_GROUP_START + 24,
  EL_GROUP_START + 25,
  EL_GROUP_START + 26,
  EL_GROUP_START + 27,

  EL_GROUP_START + 28,
  EL_GROUP_START + 29,
  EL_GROUP_START + 30,
  EL_GROUP_START + 31
};
static int *editor_hl_group_ptr = editor_hl_group;
static int *editor_el_group_ptr = editor_el_group;
static int num_editor_hl_group = SIZEOF_ARRAY_INT(editor_hl_group);
static int num_editor_el_group = SIZEOF_ARRAY_INT(editor_el_group);

static int editor_hl_reference[] =
{
  EL_INTERNAL_CASCADE_REF_ACTIVE,
  EL_CHAR('R'),
  EL_CHAR('E'),
  EL_CHAR('F')
};

static int editor_el_reference[] =
{
  EL_TRIGGER_PLAYER,
  EL_TRIGGER_ELEMENT,
  EL_TRIGGER_CE_VALUE,
  EL_TRIGGER_CE_SCORE,

  EL_SELF,
  EL_ANY_ELEMENT,
  EL_CURRENT_CE_VALUE,
  EL_CURRENT_CE_SCORE,

  EL_PREV_CE_8,
  EL_PREV_CE_7,
  EL_PREV_CE_6,
  EL_PREV_CE_5,

  EL_PREV_CE_4,
  EL_PREV_CE_3,
  EL_PREV_CE_2,
  EL_PREV_CE_1,

  EL_NEXT_CE_1,
  EL_NEXT_CE_2,
  EL_NEXT_CE_3,
  EL_NEXT_CE_4,

  EL_NEXT_CE_5,
  EL_NEXT_CE_6,
  EL_NEXT_CE_7,
  EL_NEXT_CE_8,
};
static int *editor_hl_reference_ptr = editor_hl_reference;
static int *editor_el_reference_ptr = editor_el_reference;
static int num_editor_hl_reference = SIZEOF_ARRAY_INT(editor_hl_reference);
static int num_editor_el_reference = SIZEOF_ARRAY_INT(editor_el_reference);

static int editor_hl_user_defined[] =
{
  EL_INTERNAL_CASCADE_USER_ACTIVE,
  EL_CHAR('M'),
  EL_CHAR('Y'),
  EL_EMPTY,
};

static int *editor_hl_user_defined_ptr = editor_hl_user_defined;
static int *editor_el_user_defined_ptr = NULL;
static int num_editor_hl_user_defined=SIZEOF_ARRAY_INT(editor_hl_user_defined);
static int num_editor_el_user_defined = 0;

static int editor_hl_dynamic[] =
{
  EL_INTERNAL_CASCADE_DYNAMIC_ACTIVE,
  EL_CHAR('U'),
  EL_CHAR('S'),
  EL_CHAR('E'),
};

static int *editor_hl_dynamic_ptr = editor_hl_dynamic;
static int *editor_el_dynamic_ptr = NULL;
static int num_editor_hl_dynamic = SIZEOF_ARRAY_INT(editor_hl_dynamic);
static int num_editor_el_dynamic = 0;

static int editor_hl_empty[] = { EL_EMPTY };
static int *editor_el_empty = NULL;	/* dynamically allocated */

static int *editor_hl_empty_ptr = editor_hl_empty;
static int *editor_el_empty_ptr = NULL;
static int num_editor_hl_empty = 0;
static int num_editor_el_empty = 0;	/* dynamically determined, if needed */

static boolean use_el_empty = FALSE;

static int *editor_elements = NULL;	/* dynamically allocated */
static int num_editor_elements = 0;	/* dynamically determined */

static boolean setup_editor_show_always = TRUE;
static boolean setup_editor_cascade_never = FALSE;

static int editor_hl_unused[] = { EL_EMPTY };
static int *editor_hl_unused_ptr = editor_hl_unused;
static int num_editor_hl_unused = 0;

static struct
{
  boolean *setup_value;
  boolean *setup_cascade_value;

  int **headline_list;
  int *headline_list_size;

  int **element_list;
  int *element_list_size;

  boolean last_setup_value;
}
editor_elements_info[] =
{
  {
    &setup_editor_show_always,
    &setup_editor_cascade_never,
    &editor_hl_unused_ptr,		&num_editor_hl_unused,
    &editor_el_players_ptr,		&num_editor_el_players
  },
  {
    &setup.editor.el_boulderdash,
    &setup.editor_cascade.el_bd,
    &editor_hl_boulderdash_ptr,		&num_editor_hl_boulderdash,
    &editor_el_boulderdash_ptr,		&num_editor_el_boulderdash
  },
  {
    &setup.editor.el_emerald_mine,
    &setup.editor_cascade.el_em,
    &editor_hl_emerald_mine_ptr,	&num_editor_hl_emerald_mine,
    &editor_el_emerald_mine_ptr,	&num_editor_el_emerald_mine
  },
  {
    &setup.editor.el_emerald_mine_club,
    &setup.editor_cascade.el_emc,
    &editor_hl_emerald_mine_club_ptr,	&num_editor_hl_emerald_mine_club,
    &editor_el_emerald_mine_club_ptr,	&num_editor_el_emerald_mine_club
  },
  {
    &setup.editor.el_more,
    &setup.editor_cascade.el_rnd,
    &editor_hl_rnd_ptr,			&num_editor_hl_rnd,
    &editor_el_rnd_ptr,			&num_editor_el_rnd
  },
  {
    &setup.editor.el_sokoban,
    &setup.editor_cascade.el_sb,
    &editor_hl_sokoban_ptr,		&num_editor_hl_sokoban,
    &editor_el_sokoban_ptr,		&num_editor_el_sokoban
  },
  {
    &setup.editor.el_supaplex,
    &setup.editor_cascade.el_sp,
    &editor_hl_supaplex_ptr,		&num_editor_hl_supaplex,
    &editor_el_supaplex_ptr,		&num_editor_el_supaplex
  },
  {
    &setup.editor.el_diamond_caves,
    &setup.editor_cascade.el_dc,
    &editor_hl_diamond_caves_ptr,	&num_editor_hl_diamond_caves,
    &editor_el_diamond_caves_ptr,	&num_editor_el_diamond_caves
  },
  {
    &setup.editor.el_dx_boulderdash,
    &setup.editor_cascade.el_dx,
    &editor_hl_dx_boulderdash_ptr,	&num_editor_hl_dx_boulderdash,
    &editor_el_dx_boulderdash_ptr,	&num_editor_el_dx_boulderdash
  },
  {
    &setup.editor.el_chars,
    &setup.editor_cascade.el_chars,
    &editor_hl_chars_ptr,		&num_editor_hl_chars,
    &editor_el_chars_ptr,		&num_editor_el_chars
  },
  {
    &setup.editor.el_steel_chars,
    &setup.editor_cascade.el_steel_chars,
    &editor_hl_steel_chars_ptr,		&num_editor_hl_steel_chars,
    &editor_el_steel_chars_ptr,		&num_editor_el_steel_chars
  },
  {
    &setup.editor.el_custom,
    &setup.editor_cascade.el_ce,
    &editor_hl_custom_ptr,		&num_editor_hl_custom,
    &editor_el_custom_ptr,		&num_editor_el_custom
  },
  {
    &setup.editor.el_custom,
    &setup.editor_cascade.el_ge,
    &editor_hl_group_ptr,		&num_editor_hl_group,
    &editor_el_group_ptr,		&num_editor_el_group
  },
  {
    &setup.editor.el_custom,
    &setup.editor_cascade.el_ref,
    &editor_hl_reference_ptr,		&num_editor_hl_reference,
    &editor_el_reference_ptr,		&num_editor_el_reference
  },
  {
    &setup.editor.el_user_defined,
    &setup.editor_cascade.el_user,
    &editor_hl_user_defined_ptr,	&num_editor_hl_user_defined,
    &editor_el_user_defined_ptr,	&num_editor_el_user_defined
  },
  {
    &setup.editor.el_dynamic,
    &setup.editor_cascade.el_dynamic,
    &editor_hl_dynamic_ptr,		&num_editor_hl_dynamic,
    &editor_el_dynamic_ptr,		&num_editor_el_dynamic,
  },
  {
    &use_el_empty,
    &use_el_empty,
    &editor_hl_empty_ptr,		&num_editor_hl_empty,
    &editor_el_empty_ptr,		&num_editor_el_empty,
  },
  {
    NULL,
    NULL,
    NULL,				NULL,
    NULL,				NULL
  }
};


/*
  -----------------------------------------------------------------------------
  functions
  -----------------------------------------------------------------------------
*/

static int getMaxInfoTextLength()
{
  return (SXSIZE / getFontWidth(INFOTEXT_FONT));
}

static int getTextWidthForGadget(char *text)
{
  if (text == NULL)
    return 0;

  return (getTextWidth(text, FONT_TEXT_1) + ED_GADGET_TEXT_DISTANCE);
}

static int getTextWidthForDrawingArea(char *text)
{
  if (text == NULL)
    return 0;

  return (getTextWidth(text, FONT_TEXT_1) + ED_DRAWINGAREA_TEXT_DISTANCE);
}

static int getRightGadgetBorder(struct GadgetInfo *gi, char *text)
{
  return (gi->x + gi->width + getTextWidthForGadget(text));
}

static char *getElementInfoText(int element)
{
  char *info_text = NULL;

  if (element < MAX_NUM_ELEMENTS)
  {
    if (strlen(element_info[element].description) > 0)
      info_text = element_info[element].description;
    else if (element_info[element].custom_description != NULL)
      info_text = element_info[element].custom_description;
    else if (element_info[element].editor_description != NULL)
      info_text = element_info[element].editor_description;
  }

  if (info_text == NULL)
    info_text = INFOTEXT_UNKNOWN_ELEMENT;

  return info_text;
}

static char *getElementDescriptionFilenameExt(char *basename)
{
  char *elements_subdir = "elements";
  static char *elements_subdir2 = NULL;
  static char *filename = NULL;

  if (elements_subdir2 == NULL)
    elements_subdir2 = getPath2(DOCS_DIRECTORY, elements_subdir);

  checked_free(filename);

  /* 1st try: look for element description in current level set directory */
  filename = getPath3(getCurrentLevelDir(), elements_subdir2, basename);
  if (fileExists(filename))
    return filename;

  free(filename);

  /* 2nd try: look for element description in the game's base directory */
  filename = getPath3(options.docs_directory, elements_subdir, basename);
  if (fileExists(filename))
    return filename;

  return NULL;
}

char *getElementDescriptionFilename(int element)
{
  char basename[MAX_FILENAME_LEN];
  char *filename;

  /* 1st try: look for element description file for exactly this element */
  sprintf(basename, "%s.txt", element_info[element].token_name);
  filename = getElementDescriptionFilenameExt(basename);
  if (filename != NULL)
    return filename;

  /* 2nd try: look for element description file for this element's class */
  sprintf(basename, "%s.txt", element_info[element].class_name);
  filename = getElementDescriptionFilenameExt(basename);
  if (filename != NULL)
    return filename;

  return NULL;
}

static void InitDynamicEditorElementList(int **elements, int *num_elements)
{
  boolean element_found[NUM_FILE_ELEMENTS];
  int i, x, y;

  /* initialize list of used elements to "not used" */
  for (i = 0; i < NUM_FILE_ELEMENTS; i++)
    element_found[i] = FALSE;

  /* find all elements used in current level */
  for (y = 0; y < lev_fieldy; y++)
    for (x = 0; x < lev_fieldx; x++)
      if (Feld[x][y] < NUM_FILE_ELEMENTS)	/* should always be true */
	element_found[Feld[x][y]] = TRUE;

  *num_elements = 0;

  /* count number of elements used in current level */
  for (i = 0; i < NUM_FILE_ELEMENTS; i++)
    if (element_found[i])
      (*num_elements)++;

  /* add space for up to 3 more elements for padding that may be needed */
  *num_elements += 3;

  /* free memory for old list of elements, if needed */
  checked_free(*elements);

  /* allocate memory for new list of elements */
  *elements = checked_malloc(*num_elements * sizeof(int));

  *num_elements = 0;

  /* add all elements used in current level (non-custom/group elements) */
  for (i = 0; i < NUM_FILE_ELEMENTS; i++)
    if (element_found[i] && !(IS_CUSTOM_ELEMENT(i) || IS_GROUP_ELEMENT(i)))
      (*elements)[(*num_elements)++] = i;

  /* add all elements used in current level (custom/group elements) */
  for (i = 0; i < NUM_FILE_ELEMENTS; i++)
    if (element_found[i] && (IS_CUSTOM_ELEMENT(i) || IS_GROUP_ELEMENT(i)))
      (*elements)[(*num_elements)++] = i;

  while (*num_elements % 4)	/* pad with empty elements, if needed */
    (*elements)[(*num_elements)++] = EL_EMPTY;
}

static void ReinitializeElementList()
{
  static boolean initialization_needed = TRUE;
  int pos = 0;
  int i, j;

  if (initialization_needed)
  {
    LoadSetup_EditorCascade();		/* load last editor cascade state */

    /* initialize editor cascade element from saved cascade state */
    for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
    {
      int *cascade_element = &(*editor_elements_info[i].headline_list)[0];
      boolean cascade_value = *editor_elements_info[i].setup_cascade_value;

      if (IS_EDITOR_CASCADE(*cascade_element))
	*cascade_element =
	  (cascade_value ? EL_CASCADE_ACTIVE(*cascade_element) :
	   EL_CASCADE_INACTIVE(*cascade_element));
    }

    initialization_needed = FALSE;
  }

  checked_free(editor_elements);

  /* reload optional user defined element list for each invocation of editor */
  LoadUserDefinedEditorElementList(&editor_el_user_defined_ptr,
				   &num_editor_el_user_defined);

  /* initialize dynamic level element list for each invocation of editor */
  InitDynamicEditorElementList(&editor_el_dynamic_ptr,
			       &num_editor_el_dynamic);

  /* initialize list of empty elements (used for padding, if needed) */
  for (i = 0; i < ED_NUM_ELEMENTLIST_BUTTONS; i++)
    editor_el_empty[i] = EL_EMPTY;

  /* do some sanity checks for each element from element list */
  for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
  {
    for (j = 0; j < *editor_elements_info[i].element_list_size; j++)
    {
      int element = (*editor_elements_info[i].element_list)[j];

      if (element >= NUM_FILE_ELEMENTS)
	Error(ERR_WARN, "editor element %d is runtime element", element);

      if (strEqual(getElementInfoText(element), INFOTEXT_UNKNOWN_ELEMENT))
	Error(ERR_WARN, "no element description for element %d", element);
    }
  }

  num_editor_elements = 0;
  use_el_empty = FALSE;

  /* determine size of element list */
  for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
  {
    boolean found_inactive_cascade = FALSE;

    if (*editor_elements_info[i].setup_value)
    {
      if (setup.editor.el_headlines)
      {
	// required for correct padding of palette headline buttons
	if (*editor_elements_info[i].headline_list_size > 0)
	  num_editor_elements += editor.palette.cols;

	for (j = 0; j < *editor_elements_info[i].headline_list_size; j++)
	{
	  int element = (*editor_elements_info[i].headline_list)[j];

	  if (IS_EDITOR_CASCADE_INACTIVE(element))
	    found_inactive_cascade = TRUE;
	}
      }

      if (found_inactive_cascade)
	continue;

      // required for correct padding of palette element buttons
      int element_list_size = *editor_elements_info[i].element_list_size;
      int element_rows =
	(element_list_size + editor.palette.cols - 1) / editor.palette.cols;
      int element_buttons = editor.palette.cols * element_rows;

      num_editor_elements += element_buttons;
    }
  }

  if (num_editor_elements < ED_NUM_ELEMENTLIST_BUTTONS)
  {
    /* offer at least as many elements as element buttons exist */
    use_el_empty = TRUE;
    num_editor_el_empty = ED_NUM_ELEMENTLIST_BUTTONS - num_editor_elements;

    num_editor_elements += num_editor_el_empty;
  }

  editor_elements = checked_malloc(num_editor_elements * sizeof(int));

  /* fill element list */
  for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
  {
    boolean found_inactive_cascade = FALSE;

    if (*editor_elements_info[i].setup_value)
    {
      if (setup.editor.el_headlines)
      {
	// required for correct padding of palette headline buttons
	int headline_size = (*editor_elements_info[i].headline_list_size > 0 ?
			     editor.palette.cols : 0);

	for (j = 0; j < headline_size; j++)
	{
	  // use empty elements for padding of palette headline buttons
	  int element = (j < *editor_elements_info[i].headline_list_size ?
			 (*editor_elements_info[i].headline_list)[j] :
			 editor_el_empty[0]);

	  editor_elements[pos++] = element;

	  if (IS_EDITOR_CASCADE_INACTIVE(element))
	    found_inactive_cascade = TRUE;
	}
      }

      if (found_inactive_cascade)
	continue;

      // required for correct padding of palette element buttons
      int element_list_size = *editor_elements_info[i].element_list_size;
      int element_rows =
	(element_list_size + editor.palette.cols - 1) / editor.palette.cols;
      int element_buttons = editor.palette.cols * element_rows;

      // copy all elements from element list
      for (j = 0; j < element_list_size; j++)
	editor_elements[pos++] = (*editor_elements_info[i].element_list)[j];

      // use empty elements for padding of palette element buttons
      for (j = 0; j < element_buttons - element_list_size; j++)
	editor_elements[pos++] = editor_el_empty[0];
    }
  }

  /* (this function is also called before editor gadgets are initialized!) */
  AdjustElementListScrollbar();
}

void PrintEditorElementList()
{
  boolean *stop = &setup.editor.el_user_defined;
  int i, j;

  for (i = 0; editor_elements_info[i].setup_value != stop; i++)
  {
    int cascade_element = (*editor_elements_info[i].headline_list)[0];

    if (IS_EDITOR_CASCADE(cascade_element))
    {
      int cascade_element_show = EL_CASCADE_INACTIVE(cascade_element);
      char *headline = element_info[cascade_element_show].editor_description;

      PrintLineWithPrefix("# ", "-", 77);
      Print("# %s\n", headline);
      PrintLineWithPrefix("# ", "-", 77);
    }

    for (j = 0; j < *editor_elements_info[i].headline_list_size; j++)
    {
      int element = (*editor_elements_info[i].headline_list)[j];

      if (IS_EDITOR_CASCADE(element))
	element = EL_CHAR_MINUS;

      Print("# %s\n", element_info[element].token_name);
    }

    if (j > 0)
      Print("#\n");

    for (j = 0; j < *editor_elements_info[i].element_list_size; j++)
    {
      int element = (*editor_elements_info[i].element_list)[j];

      Print("# %s\n", element_info[element].token_name);
    }

    if (j > 0)
      Print("#\n");
  }
}

static void ReinitializeElementListButtons()
{
  static boolean last_setup_value_headlines = FALSE;
  static boolean initialization_needed = TRUE;
  int i;

  if (!initialization_needed)	/* check if editor element setup has changed */
  {
    if (last_setup_value_headlines != setup.editor.el_headlines)
      initialization_needed = TRUE;

    for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
      if (editor_elements_info[i].last_setup_value !=
	  *editor_elements_info[i].setup_value)
	initialization_needed = TRUE;
  }

  if (!initialization_needed)
    return;

  FreeLevelEditorGadgets();
  CreateLevelEditorGadgets();

  /* store current setup values for next invocation of this function */
  last_setup_value_headlines = setup.editor.el_headlines;
  for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
    editor_elements_info[i].last_setup_value =
      *editor_elements_info[i].setup_value;

  initialization_needed = FALSE;
}

static void DrawElementBorder(int dest_x, int dest_y, int width, int height,
			      boolean input)
{
  int border_graphic =
    (input ? IMG_EDITOR_ELEMENT_BORDER_INPUT : IMG_EDITOR_ELEMENT_BORDER);
  struct GraphicInfo *g = &graphic_info[border_graphic];
  Bitmap *src_bitmap = g->bitmap;
  int src_x = g->src_x;
  int src_y = g->src_y;
  int border_size = g->border_size;
  int border_xpos = g->width  - border_size;
  int border_ypos = g->height - border_size;
  int tilesize = ED_DRAWINGAREA_TILE_SIZE;
  int i;

  BlitBitmap(src_bitmap, drawto, src_x, src_y,
	     border_size, border_size,
	     dest_x - border_size, dest_y - border_size);
  BlitBitmap(src_bitmap, drawto, src_x + border_xpos, src_y,
	     border_size, border_size,
	     dest_x + width, dest_y - border_size);
  BlitBitmap(src_bitmap, drawto, src_x, src_y + border_ypos,
	     border_size, border_size,
	     dest_x - border_size, dest_y + height);
  BlitBitmap(src_bitmap, drawto, src_x + border_xpos, src_y + border_ypos,
	     border_size, border_size,
	     dest_x + width, dest_y + height);

  for (i = 0; i < width / tilesize; i++)
  {
    BlitBitmap(src_bitmap, drawto, src_x + border_size, src_y,
	       tilesize, border_size,
	       dest_x + i * tilesize, dest_y - border_size);
    BlitBitmap(src_bitmap, drawto, src_x + border_size, src_y + border_ypos,
	       tilesize, border_size,
	       dest_x + i * tilesize, dest_y + height);
  }

  for (i = 0; i < height / tilesize; i++)
  {
    BlitBitmap(src_bitmap, drawto, src_x, src_y + border_size,
	       border_size, tilesize,
	       dest_x - border_size, dest_y + i * tilesize);
    BlitBitmap(src_bitmap, drawto, src_x + border_xpos, src_y + border_size,
	       border_size, tilesize,
	       dest_x + width, dest_y + i * tilesize);
  }

  ClearRectangle(drawto, dest_x - 1, dest_y - 1, width + 2, height + 2);
}

static void DrawEditorElement(int x, int y, int element)
{
  DrawSizedElement(x, y, element, ed_tilesize);
}

static void DrawEditorElementOrWall(int x, int y, int scroll_x, int scroll_y)
{
  DrawSizedElementOrWall(x, y, scroll_x, scroll_y, ed_tilesize);
}

static void DrawEditorLevel(int size_x, int size_y, int scroll_x, int scroll_y)
{
  DrawSizedLevel(size_x, size_y, scroll_x, scroll_y, ed_tilesize);
}

static void DrawDrawingArea(int id)
{
  struct GadgetInfo *gi = level_editor_gadget[drawingarea_info[id].gadget_id];
  int x, y;

  int *value = drawingarea_info[id].value;
  int area_xsize = drawingarea_info[id].area_xsize;
  int area_ysize = drawingarea_info[id].area_ysize;
  int tilesize = ED_DRAWINGAREA_TILE_SIZE;

  for (x = 0; x < area_xsize; x++)
    for (y = 0; y < area_ysize; y++)
      DrawSizedGraphicExt(drawto,
			  gi->x + x * tilesize,
			  gi->y + y * tilesize,
			  el2edimg(value[x * area_ysize + y]), 0, tilesize);
}

static void ScrollEditorLevel(int from_x, int from_y, int scroll)
{
  int x, y;
  int dx = (scroll == ED_SCROLL_LEFT ? -1 : scroll == ED_SCROLL_RIGHT ? 1 : 0);
  int dy = (scroll == ED_SCROLL_UP   ? -1 : scroll == ED_SCROLL_DOWN  ? 1 : 0);

  BlitBitmap(drawto, drawto,
	     SX + (dx == -1 ? ed_tilesize : 0),
	     SY + (dy == -1 ? ed_tilesize : 0),
	     (ed_fieldx * ed_tilesize) - (dx != 0 ? ed_tilesize : 0),
	     (ed_fieldy * ed_tilesize) - (dy != 0 ? ed_tilesize : 0),
	     SX + (dx == +1 ? ed_tilesize : 0),
	     SY + (dy == +1 ? ed_tilesize : 0));

  if (dx)
  {
    x = (dx == 1 ? 0 : ed_fieldx - 1);
    for (y = 0; y < ed_fieldy; y++)
      DrawEditorElementOrWall(x, y, from_x, from_y);
  }
  else if (dy)
  {
    y = (dy == 1 ? 0 : ed_fieldy - 1);
    for (x = 0; x < ed_fieldx; x++)
      DrawEditorElementOrWall(x, y, from_x, from_y);
  }

  redraw_mask |= REDRAW_FIELD;
  BackToFront();
}

void getElementListGraphicSource(int element, Bitmap **bitmap, int *x, int *y)
{
  int graphic = el2edimg(element);
  int tile_size = (editor.palette.tile_size >= TILESIZE ? TILESIZE :
		   MINI_TILESIZE);

  getSizedGraphicSource(graphic, 0, tile_size, bitmap, x, y);
}

static void CreateControlButtons()
{
  struct GadgetInfo *gi;
  int i;

  /* create toolbox buttons */
  for (i = 0; i < ED_NUM_CTRL_BUTTONS; i++)
  {
    int id = controlbutton_info[i].gadget_id;
    int type = controlbutton_info[i].gadget_type;
    int graphic = controlbutton_info[i].graphic;
    struct XY *pos = controlbutton_info[i].pos;
    struct GraphicInfo *gd = &graphic_info[graphic];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;
    int gd_x1a = gd->src_x + gd->active_xoffset;
    int gd_y1a = gd->src_y + gd->active_yoffset;
    int gd_x2a = gd->src_x + gd->active_xoffset + gd->pressed_xoffset;
    int gd_y2a = gd->src_y + gd->active_yoffset + gd->pressed_yoffset;
    int x = pos->x;
    int y = pos->y;
    unsigned int event_mask;
    int radio_button_nr = RADIO_NR_NONE;
    boolean checked = FALSE;

    if (type == GD_TYPE_RADIO_BUTTON)
    {
      event_mask = GD_EVENT_PRESSED;
      radio_button_nr = RADIO_NR_DRAWING_TOOLBOX;

      if (id == drawing_function)
	checked = TRUE;
    }
    else
    {
      if (id == GADGET_ID_WRAP_LEFT ||
	  id == GADGET_ID_WRAP_RIGHT ||
	  id == GADGET_ID_WRAP_UP ||
	  id == GADGET_ID_WRAP_DOWN)
	event_mask = GD_EVENT_PRESSED | GD_EVENT_REPEATED;
      else
	event_mask = GD_EVENT_RELEASED;
    }

    if (id == GADGET_ID_PROPERTIES)
    {
      x += DX;
      y += DY;
    }
    else
    {
      x += EX;
      y += EY;
    }

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, controlbutton_info[i].infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_WIDTH, gd->width,
		      GDI_HEIGHT, gd->height,
		      GDI_TYPE, type,
		      GDI_STATE, GD_BUTTON_UNPRESSED,
		      GDI_RADIO_NR, radio_button_nr,
		      GDI_CHECKED, checked,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_ALT_DESIGN_UNPRESSED, gd->bitmap, gd_x1a, gd_y1a,
		      GDI_ALT_DESIGN_PRESSED, gd->bitmap, gd_x2a, gd_y2a,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleControlButtons,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
  }

  /* these values are not constant, but can change at runtime */
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_UP].x    = ED_SCROLL_UP_XPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_UP].y    = ED_SCROLL_UP_YPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_DOWN].x  = ED_SCROLL_DOWN_XPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_DOWN].y  = ED_SCROLL_DOWN_YPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_LEFT].x  = ED_SCROLL_LEFT_XPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_LEFT].y  = ED_SCROLL_LEFT_YPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_RIGHT].x = ED_SCROLL_RIGHT_XPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_AREA_RIGHT].y = ED_SCROLL_RIGHT_YPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_LIST_UP].x    = ED_SCROLL2_UP_XPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_LIST_UP].y    = ED_SCROLL2_UP_YPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_LIST_DOWN].x  = ED_SCROLL2_DOWN_XPOS;
  scrollbutton_pos[ED_SCROLLBUTTON_ID_LIST_DOWN].y  = ED_SCROLL2_DOWN_YPOS;

  /* create buttons for scrolling of drawing area and element list */
  for (i = 0; i < ED_NUM_SCROLLBUTTONS; i++)
  {
    int id = scrollbutton_info[i].gadget_id;
    int graphic = scrollbutton_info[i].graphic;
    struct GraphicInfo *gd = &graphic_info[graphic];
    Bitmap *gd_bitmap = gd->bitmap;
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;
    int width  = gd->width;
    int height = gd->height;
    int x = scrollbutton_pos[i].x;
    int y = scrollbutton_pos[i].y;
    unsigned int event_mask = GD_EVENT_PRESSED | GD_EVENT_REPEATED;

    if (id == GADGET_ID_SCROLL_LIST_UP ||
	id == GADGET_ID_SCROLL_LIST_DOWN)
    {
      x += DX;
      y += DY;
    }
    else
    {
      x += SX;
      y += SY;
    }

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, scrollbutton_info[i].infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_WIDTH, width,
		      GDI_HEIGHT, height,
		      GDI_TYPE, GD_TYPE_NORMAL_BUTTON,
		      GDI_STATE, GD_BUTTON_UNPRESSED,
		      GDI_DESIGN_UNPRESSED, gd_bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd_bitmap, gd_x2, gd_y2,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleControlButtons,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
  }

  /* create buttons for element list */
  for (i = 0; i < ED_NUM_ELEMENTLIST_BUTTONS; i++)
  {
    int id = GADGET_ID_ELEMENTLIST_FIRST + i;
    int graphic = IMG_EDITOR_PALETTE_BUTTON;
    struct GraphicInfo *gd = &graphic_info[graphic];
    Bitmap *gd_bitmap = gd->bitmap;
    Bitmap *deco_bitmap;
    int deco_x, deco_y, deco_xpos, deco_ypos;
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;
    int xx = i % ED_ELEMENTLIST_BUTTONS_HORIZ;
    int yy = i / ED_ELEMENTLIST_BUTTONS_HORIZ;
    int x = DX + ED_ELEMENTLIST_XPOS + xx * gd->width;
    int y = DY + ED_ELEMENTLIST_YPOS + yy * gd->height;
    int element = editor_elements[i];
    int tile_size = (editor.palette.tile_size >= TILESIZE ? TILESIZE :
		     MINI_TILESIZE);
    unsigned int event_mask = GD_EVENT_RELEASED;

    getElementListGraphicSource(element, &deco_bitmap, &deco_x, &deco_y);
    deco_xpos = (gd->width  - tile_size) / 2;
    deco_ypos = (gd->height - tile_size) / 2;

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, getElementInfoText(element),
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_WIDTH, gd->width,
		      GDI_HEIGHT, gd->height,
		      GDI_TYPE, GD_TYPE_NORMAL_BUTTON,
		      GDI_STATE, GD_BUTTON_UNPRESSED,
		      GDI_DESIGN_UNPRESSED, gd_bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd_bitmap, gd_x2, gd_y2,
		      GDI_DECORATION_DESIGN, deco_bitmap, deco_x, deco_y,
		      GDI_DECORATION_POSITION, deco_xpos, deco_ypos,
		      GDI_DECORATION_SIZE, tile_size, tile_size,
		      GDI_DECORATION_SHIFTING, 1, 1,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleControlButtons,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
  }
}

static void CreateCounterButtons()
{
  int max_infotext_len = getMaxInfoTextLength();
  int i;

  for (i = 0; i < ED_NUM_COUNTERBUTTONS; i++)
  {
    int j;
    int x = SX + ED_SETTINGS_X(counterbutton_info[i].x); /* down count button */
    int y = SY + ED_SETTINGS_Y(counterbutton_info[i].y);

    /* determine horizontal position to the right of specified gadget */
    if (counterbutton_info[i].gadget_id_align != GADGET_ID_NONE)
      x = (right_gadget_border[counterbutton_info[i].gadget_id_align] +
	   ED_GADGET_TEXT_DISTANCE);

    /* determine horizontal offset for leading text */
    if (counterbutton_info[i].text_left != NULL)
      x += getTextWidthForGadget(counterbutton_info[i].text_left);

    for (j = 0; j < 2; j++)
    {
      struct GadgetInfo *gi;
      int id = (j == 0 ?
		counterbutton_info[i].gadget_id_down :
		counterbutton_info[i].gadget_id_up);
      int graphic;
      struct GraphicInfo *gd;
      int gd_x1, gd_x2, gd_y1, gd_y2;
      unsigned int event_mask;
      char infotext[max_infotext_len + 1];

      event_mask = GD_EVENT_PRESSED | GD_EVENT_REPEATED;

      if (i == ED_COUNTER_ID_SELECT_LEVEL)
      {
	graphic = (j == 0 ?
		   IMG_GFX_EDITOR_BUTTON_PREV_LEVEL :
		   IMG_GFX_EDITOR_BUTTON_NEXT_LEVEL);

	event_mask |= GD_EVENT_RELEASED;

	if (j == 0)
	{
	  x = DX + editor.button.prev_level.x;
	  y = DY + editor.button.prev_level.y;
	}
	else
	{
	  x = DX + editor.button.next_level.x;
	  y = DY + editor.button.next_level.y;
	}
      }
      else
      {
	graphic = (j == 0 ?
		   IMG_EDITOR_COUNTER_DOWN :
		   IMG_EDITOR_COUNTER_UP);
      }

      gd = &graphic_info[graphic];

      gd_x1 = gd->src_x;
      gd_y1 = gd->src_y;
      gd_x2 = gd->src_x + gd->pressed_xoffset;
      gd_y2 = gd->src_y + gd->pressed_yoffset;

      sprintf(infotext, "%s counter value by 1, 5 or 10",
	      (j == 0 ? "decrease" : "increase"));

      gi = CreateGadget(GDI_CUSTOM_ID, id,
			GDI_CUSTOM_TYPE_ID, i,
			GDI_INFO_TEXT, infotext,
			GDI_X, x,
			GDI_Y, y,
			GDI_WIDTH, gd->width,
			GDI_HEIGHT, gd->height,
			GDI_TYPE, GD_TYPE_NORMAL_BUTTON,
			GDI_STATE, GD_BUTTON_UNPRESSED,
			GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
			GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
			GDI_EVENT_MASK, event_mask,
			GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
			GDI_CALLBACK_ACTION, HandleCounterButtons,
			GDI_END);

      if (gi == NULL)
	Error(ERR_EXIT, "cannot create gadget");

      level_editor_gadget[id] = gi;
      right_gadget_border[id] =
	getRightGadgetBorder(gi, counterbutton_info[i].text_right);

      x += gi->width + ED_GADGET_SMALL_DISTANCE;	/* text count button */

      if (j == 0)
      {
	int font_type = FONT_INPUT_1;
	int font_type_active = FONT_INPUT_1_ACTIVE;

	id = counterbutton_info[i].gadget_id_text;

	event_mask = GD_EVENT_TEXT_RETURN | GD_EVENT_TEXT_LEAVING;

	if (i == ED_COUNTER_ID_SELECT_LEVEL)
	{
	  graphic = IMG_GFX_EDITOR_INPUT_LEVEL_NUMBER;

	  font_type = FONT_LEVEL_NUMBER;
	  font_type_active = FONT_LEVEL_NUMBER_ACTIVE;

	  x = DX + editor.input.level_number.x;
	  y = DY + editor.input.level_number.y;
	}
	else
	{
	  graphic = IMG_EDITOR_COUNTER_INPUT;
	}

	gd = &graphic_info[graphic];

	gd_x1 = gd->src_x;
	gd_y1 = gd->src_y;
	gd_x2 = gd->src_x + gd->active_xoffset;
	gd_y2 = gd->src_y + gd->active_yoffset;

	gi = CreateGadget(GDI_CUSTOM_ID, id,
			  GDI_CUSTOM_TYPE_ID, i,
			  GDI_INFO_TEXT, "enter counter value",
			  GDI_X, x,
			  GDI_Y, y,
			  GDI_TYPE, GD_TYPE_TEXT_INPUT_NUMERIC,
			  GDI_NUMBER_VALUE, 0,
			  GDI_NUMBER_MIN, counterbutton_info[i].min_value,
			  GDI_NUMBER_MAX, counterbutton_info[i].max_value,
			  GDI_TEXT_SIZE, 3,	/* minimal counter text size */
			  GDI_TEXT_FONT, font_type,
			  GDI_TEXT_FONT_ACTIVE, font_type_active,
			  GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
			  GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
			  GDI_BORDER_SIZE, gd->border_size, gd->border_size,
			  GDI_DESIGN_WIDTH, gd->width,
			  GDI_EVENT_MASK, event_mask,
			  GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
			  GDI_CALLBACK_ACTION, HandleCounterButtons,
			  GDI_END);

	if (gi == NULL)
	  Error(ERR_EXIT, "cannot create gadget");

	level_editor_gadget[id] = gi;
	right_gadget_border[id] =
	  getRightGadgetBorder(gi, counterbutton_info[i].text_right);

	x += gi->width + ED_GADGET_SMALL_DISTANCE;	/* up count button */
      }
    }
  }
}

static void CreateDrawingAreas()
{
  int i;

  /* these values are not constant, but can change at runtime */
  drawingarea_info[ED_DRAWING_ID_DRAWING_LEVEL].area_xsize = MAX_ED_FIELDX;
  drawingarea_info[ED_DRAWING_ID_DRAWING_LEVEL].area_ysize = MAX_ED_FIELDY;

  for (i = 0; i < ED_NUM_DRAWING_AREAS; i++)
  {
    struct GadgetInfo *gi;
    unsigned int event_mask;
    int id = drawingarea_info[i].gadget_id;
    int x = SX + ED_AREA_SETTINGS_X(drawingarea_info[i]);
    int y = SY + ED_AREA_SETTINGS_Y(drawingarea_info[i]);
    int area_xsize = drawingarea_info[i].area_xsize;
    int area_ysize = drawingarea_info[i].area_ysize;
    int item_size = (id == GADGET_ID_DRAWING_LEVEL ?
		     ed_tilesize : ED_DRAWINGAREA_TILE_SIZE);

    event_mask =
      GD_EVENT_PRESSED | GD_EVENT_RELEASED | GD_EVENT_MOVING |
      GD_EVENT_OFF_BORDERS;

    /* determine horizontal position to the right of specified gadget */
    if (drawingarea_info[i].gadget_id_align != GADGET_ID_NONE)
      x = (right_gadget_border[drawingarea_info[i].gadget_id_align] +
	   ED_DRAWINGAREA_TEXT_DISTANCE);

    /* determine horizontal offset for leading text */
    if (drawingarea_info[i].text_left != NULL)
      x += getTextWidthForDrawingArea(drawingarea_info[i].text_left);

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_TYPE, GD_TYPE_DRAWING_AREA,
		      GDI_AREA_SIZE, area_xsize, area_ysize,
		      GDI_ITEM_SIZE, item_size, item_size,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleDrawingAreaInfo,
		      GDI_CALLBACK_ACTION, HandleDrawingAreas,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
    right_gadget_border[id] =
      getRightGadgetBorder(gi, drawingarea_info[i].text_right);
  }
}

static void CreateTextInputGadgets()
{
  struct GraphicInfo *gd = &graphic_info[IMG_EDITOR_INPUT_TEXT];
  int max_infotext_len = getMaxInfoTextLength();
  int i;

  for (i = 0; i < ED_NUM_TEXTINPUT; i++)
  {
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->active_xoffset;
    int gd_y2 = gd->src_y + gd->active_yoffset;
    struct GadgetInfo *gi;
    unsigned int event_mask;
    char infotext[MAX_OUTPUT_LINESIZE + 1];
    int id = textinput_info[i].gadget_id;
    int x, y;

    if (i == ED_TEXTINPUT_ID_ELEMENT_NAME)
    {
      int element_border = graphic_info[IMG_EDITOR_ELEMENT_BORDER].border_size;
      int border_size = gd->border_size;
      int font_nr = FONT_INPUT_1;
      int font_height = getFontHeight(font_nr);
      int xoffset = element_border + TILEX + element_border + 3 * border_size;
      int yoffset = element_border + (TILEY - font_height) / 2;

      x = (editor.settings.element_name.x != -1 ?
	   editor.settings.element_name.x :
	   editor.settings.element_graphic.x + xoffset) - border_size;
      y = (editor.settings.element_name.y != -1 ?
	   editor.settings.element_name.y :
	   editor.settings.element_graphic.y + yoffset) - border_size;
    }
    else
    {
      x = ED_SETTINGS_X(textinput_info[i].x);
      y = ED_SETTINGS_Y(textinput_info[i].y);
    }

    event_mask = GD_EVENT_TEXT_RETURN | GD_EVENT_TEXT_LEAVING;

    sprintf(infotext, "Enter %s", textinput_info[i].infotext);
    infotext[max_infotext_len] = '\0';

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, infotext,
		      GDI_X, SX + x,
		      GDI_Y, SY + y,
		      GDI_TYPE, GD_TYPE_TEXT_INPUT_ALPHANUMERIC,
		      GDI_TEXT_VALUE, textinput_info[i].value,
		      GDI_TEXT_SIZE, textinput_info[i].size,
		      GDI_TEXT_FONT, FONT_INPUT_1,
		      GDI_TEXT_FONT_ACTIVE, FONT_INPUT_1_ACTIVE,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_BORDER_SIZE, gd->border_size, gd->border_size,
		      GDI_DESIGN_WIDTH, gd->width,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleTextInputGadgets,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
  }
}

static void CreateTextAreaGadgets()
{
  int max_infotext_len = getMaxInfoTextLength();
  int i;

  for (i = 0; i < ED_NUM_TEXTAREAS; i++)
  {
    struct GraphicInfo *gd = &graphic_info[IMG_EDITOR_INPUT_TEXTAREA];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->active_xoffset;
    int gd_y2 = gd->src_y + gd->active_yoffset;
    struct GadgetInfo *gi;
    unsigned int event_mask;
    char infotext[MAX_OUTPUT_LINESIZE + 1];
    int id = textarea_info[i].gadget_id;
    int area_xsize = textarea_info[i].xsize;
    int area_ysize = textarea_info[i].ysize;

    event_mask = GD_EVENT_TEXT_LEAVING;

    sprintf(infotext, "Enter %s", textarea_info[i].infotext);
    infotext[max_infotext_len] = '\0';

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, infotext,
		      GDI_X, SX + ED_SETTINGS_X(textarea_info[i].x),
		      GDI_Y, SY + ED_SETTINGS_Y(textarea_info[i].y),
		      GDI_TYPE, GD_TYPE_TEXT_AREA,
		      GDI_AREA_SIZE, area_xsize, area_ysize,
		      GDI_TEXT_FONT, FONT_INPUT_1,
		      GDI_TEXT_FONT_ACTIVE, FONT_INPUT_1_ACTIVE,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_BORDER_SIZE, gd->border_size, gd->border_size,
		      GDI_DESIGN_WIDTH, gd->width,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleTextAreaGadgets,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
  }
}

static void CreateSelectboxGadgets()
{
  int max_infotext_len = getMaxInfoTextLength();
  int i, j;

  for (i = 0; i < ED_NUM_SELECTBOX; i++)
  {
    struct GraphicInfo *gd = &graphic_info[IMG_EDITOR_SELECTBOX_INPUT];
    struct GraphicInfo *gd2 = &graphic_info[IMG_EDITOR_SELECTBOX_BUTTON];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->active_xoffset;
    int gd_y2 = gd->src_y + gd->active_yoffset;
    int selectbox_button_xsize = gd2->width;
    struct GadgetInfo *gi;
    unsigned int event_mask;
    char infotext[MAX_OUTPUT_LINESIZE + 1];
    int id = selectbox_info[i].gadget_id;
    int x = SX + ED_SETTINGS_X(selectbox_info[i].x);
    int y = SY + ED_SETTINGS_Y(selectbox_info[i].y);

    if (selectbox_info[i].size == -1)	/* dynamically determine size */
    {
      /* (we cannot use -1 for uninitialized values if we directly compare
	 with results from strlen(), because the '<' and '>' operation will
	 implicitely cast -1 to an unsigned integer value!) */
      selectbox_info[i].size = 0;

      for (j = 0; selectbox_info[i].options[j].text != NULL; j++)
	if (strlen(selectbox_info[i].options[j].text) > selectbox_info[i].size)
	  selectbox_info[i].size = strlen(selectbox_info[i].options[j].text);

      selectbox_info[i].size++;		/* add one character empty space */
    }

    event_mask = GD_EVENT_RELEASED |
      GD_EVENT_TEXT_RETURN | GD_EVENT_TEXT_LEAVING;

    /* determine horizontal position to the right of specified gadget */
    if (selectbox_info[i].gadget_id_align != GADGET_ID_NONE)
      x = (right_gadget_border[selectbox_info[i].gadget_id_align] +
	   ED_GADGET_TEXT_DISTANCE);

    /* determine horizontal offset for leading text */
    if (selectbox_info[i].text_left != NULL)
      x += getTextWidthForGadget(selectbox_info[i].text_left);

    sprintf(infotext, "Select %s", selectbox_info[i].infotext);
    infotext[max_infotext_len] = '\0';

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_TYPE, GD_TYPE_SELECTBOX,
		      GDI_SELECTBOX_OPTIONS, selectbox_info[i].options,
		      GDI_SELECTBOX_CHAR_UNSELECTABLE, '[',
		      GDI_TEXT_SIZE, selectbox_info[i].size,
		      GDI_TEXT_FONT, FONT_INPUT_1,
		      GDI_TEXT_FONT_ACTIVE, FONT_INPUT_1_ACTIVE,
		      GDI_TEXT_FONT_UNSELECTABLE, FONT_TEXT_1,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_BORDER_SIZE, gd->border_size, gd->border_size,
		      GDI_BORDER_SIZE_SELECTBUTTON, selectbox_button_xsize,
		      GDI_DESIGN_WIDTH, gd->width,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleSelectboxGadgets,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
    right_gadget_border[id] =
      getRightGadgetBorder(gi, selectbox_info[i].text_right);
  }
}

static void CreateTextbuttonGadgets()
{
  int max_infotext_len = getMaxInfoTextLength();
  int i;

  for (i = 0; i < ED_NUM_TEXTBUTTONS; i++)
  {
    int id = textbutton_info[i].gadget_id;
    int is_tab_button =
      ((id >= GADGET_ID_LEVELINFO_LEVEL && id <= GADGET_ID_LEVELINFO_EDITOR) ||
       (id >= GADGET_ID_PROPERTIES_INFO && id <= GADGET_ID_PROPERTIES_CHANGE));
    int graphic =
      (is_tab_button ? IMG_EDITOR_TABBUTTON : IMG_EDITOR_TEXTBUTTON);
    int gadget_distance =
      (is_tab_button ? ED_GADGET_SMALL_DISTANCE : ED_GADGET_TEXT_DISTANCE);
    struct GraphicInfo *gd = &graphic_info[graphic];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;
    int gd_x1a = gd->src_x + gd->active_xoffset;
    int gd_y1a = gd->src_y + gd->active_yoffset;
    int border_xsize = gd->border_size + gd->draw_xoffset;
    int border_ysize = gd->border_size;
    struct GadgetInfo *gi;
    unsigned int event_mask;
    char infotext[MAX_OUTPUT_LINESIZE + 1];
    int x = SX + ED_TAB_SETTINGS_X(textbutton_info[i].x);
    int y = SY + ED_TAB_SETTINGS_Y(textbutton_info[i].y);

    if (textbutton_info[i].size == -1)	/* dynamically determine size */
      textbutton_info[i].size = strlen(textbutton_info[i].text);

    event_mask = GD_EVENT_RELEASED;

    sprintf(infotext, "%s", textbutton_info[i].infotext);
    infotext[max_infotext_len] = '\0';

    /* determine horizontal position to the right of specified gadget */
    if (textbutton_info[i].gadget_id_align != GADGET_ID_NONE)
    {
      int gadget_id_align = textbutton_info[i].gadget_id_align;

      x = right_gadget_border[gadget_id_align] + gadget_distance;

      if (textbutton_info[i].y == -1)
	y = level_editor_gadget[gadget_id_align]->y;
    }

    /* determine horizontal offset for leading text */
    if (textbutton_info[i].text_left != NULL)
      x += getTextWidthForGadget(textbutton_info[i].text_left);

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_TYPE, GD_TYPE_TEXT_BUTTON,
		      GDI_TEXT_VALUE, textbutton_info[i].text,
		      GDI_TEXT_SIZE, textbutton_info[i].size,
		      GDI_TEXT_FONT, FONT_INPUT_2,
		      GDI_TEXT_FONT_ACTIVE, FONT_INPUT_2_ACTIVE,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_ALT_DESIGN_UNPRESSED, gd->bitmap, gd_x1a, gd_y1a,
		      GDI_BORDER_SIZE, border_xsize, border_ysize,
		      GDI_DESIGN_WIDTH, gd->width,
		      GDI_DECORATION_SHIFTING, 1, 1,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleTextbuttonGadgets,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
    right_gadget_border[id] =
      getRightGadgetBorder(gi, textbutton_info[i].text_right);
  }
}

static void CreateGraphicbuttonGadgets()
{
  struct GadgetInfo *gi;
  unsigned int event_mask;
  int i;

  /* create buttons for scrolling of drawing area and element list */
  for (i = 0; i < ED_NUM_GRAPHICBUTTONS; i++)
  {
    int id = graphicbutton_info[i].gadget_id;
    int x = SX + ED_SETTINGS_X(graphicbutton_info[i].x);
    int y = SY + ED_SETTINGS_Y(graphicbutton_info[i].y);
    struct GraphicInfo *gd = &graphic_info[graphicbutton_info[i].graphic];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;

    event_mask = GD_EVENT_PRESSED | GD_EVENT_REPEATED;

    /* determine horizontal position to the right of specified gadget */
    if (graphicbutton_info[i].gadget_id_align != GADGET_ID_NONE)
      x = (right_gadget_border[graphicbutton_info[i].gadget_id_align] +
	   ED_GADGET_TEXT_DISTANCE);

    /* determine horizontal offset for leading text */
    if (graphicbutton_info[i].text_left != NULL)
      x += getTextWidthForGadget(graphicbutton_info[i].text_left);

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, graphicbutton_info[i].infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_WIDTH, gd->width,
		      GDI_HEIGHT, gd->height,
		      GDI_TYPE, GD_TYPE_NORMAL_BUTTON,
		      GDI_STATE, GD_BUTTON_UNPRESSED,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleGraphicbuttonGadgets,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
    right_gadget_border[id] =
      getRightGadgetBorder(gi, graphicbutton_info[i].text_right);
  }
}

static void CreateScrollbarGadgets()
{
  int i;

  /* these values are not constant, but can change at runtime */
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].x =
    SX + ED_SCROLL_HORIZONTAL_XPOS;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].y =
    SY + ED_SCROLL_HORIZONTAL_YPOS;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].width =
    ED_SCROLL_HORIZONTAL_XSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].height =
    ED_SCROLL_HORIZONTAL_YSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].wheel_x      = SX;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].wheel_y      = SY;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].wheel_width  = SXSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_HORIZONTAL].wheel_height = SYSIZE;

  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].x =
    SX + ED_SCROLL_VERTICAL_XPOS;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].y =
    SY + ED_SCROLL_VERTICAL_YPOS;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].width =
    ED_SCROLL_VERTICAL_XSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].height =
    ED_SCROLL_VERTICAL_YSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].wheel_x      = SX;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].wheel_y      = SY;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].wheel_width  = SXSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_AREA_VERTICAL].wheel_height = SYSIZE;

  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].x =
    DX + ED_SCROLL2_VERTICAL_XPOS;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].y =
    DY + ED_SCROLL2_VERTICAL_YPOS;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].width =
    ED_SCROLL2_VERTICAL_XSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].height =
    ED_SCROLL2_VERTICAL_YSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].wheel_x = DX;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].wheel_y = DY;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].wheel_width  = DXSIZE;
  scrollbar_pos[ED_SCROLLBAR_ID_LIST_VERTICAL].wheel_height = DYSIZE;

  for (i = 0; i < ED_NUM_SCROLLBARS; i++)
  {
    int id = scrollbar_info[i].gadget_id;
    int graphic = scrollbar_info[i].graphic;
    struct GraphicInfo *gd = &graphic_info[graphic];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;
    struct GadgetInfo *gi;
    int items_max, items_visible, item_position;
    unsigned int event_mask;

    if (i == ED_SCROLLBAR_ID_LIST_VERTICAL)
    {
      items_max = num_editor_elements / ED_ELEMENTLIST_BUTTONS_HORIZ;
      items_visible = ED_ELEMENTLIST_BUTTONS_VERT;
      item_position = element_shift / ED_ELEMENTLIST_BUTTONS_HORIZ;
    }
    else	/* drawing area scrollbars */
    {
      if (scrollbar_info[i].type == GD_TYPE_SCROLLBAR_HORIZONTAL)
      {
	items_max = MAX(lev_fieldx + 2, ed_fieldx);
	items_visible = ed_fieldx;
	item_position = 0;
      }
      else
      {
	items_max = MAX(lev_fieldy + 2, ed_fieldy);
	items_visible = ed_fieldy;
	item_position = 0;
      }
    }

    event_mask = GD_EVENT_MOVING | GD_EVENT_OFF_BORDERS;

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, scrollbar_info[i].infotext,
		      GDI_X, scrollbar_pos[i].x,
		      GDI_Y, scrollbar_pos[i].y,
		      GDI_WIDTH, scrollbar_pos[i].width,
		      GDI_HEIGHT, scrollbar_pos[i].height,
		      GDI_TYPE, scrollbar_info[i].type,
		      GDI_SCROLLBAR_ITEMS_MAX, items_max,
		      GDI_SCROLLBAR_ITEMS_VISIBLE, items_visible,
		      GDI_SCROLLBAR_ITEM_POSITION, item_position,
		      GDI_WHEEL_AREA_X, scrollbar_pos[i].wheel_x,
		      GDI_WHEEL_AREA_Y, scrollbar_pos[i].wheel_y,
		      GDI_WHEEL_AREA_WIDTH, scrollbar_pos[i].wheel_width,
		      GDI_WHEEL_AREA_HEIGHT, scrollbar_pos[i].wheel_height,
		      GDI_STATE, GD_BUTTON_UNPRESSED,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_BORDER_SIZE, gd->border_size, gd->border_size,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleControlButtons,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
  }
}

static void CreateCheckbuttonGadgets()
{
  struct GadgetInfo *gi;
  unsigned int event_mask;
  int i;

  event_mask = GD_EVENT_PRESSED;

  for (i = 0; i < ED_NUM_CHECKBUTTONS; i++)
  {
    int id = checkbutton_info[i].gadget_id;
    int graphic = (id == GADGET_ID_STICK_ELEMENT ? IMG_EDITOR_STICKYBUTTON :
		   IMG_EDITOR_CHECKBOX);
    struct GraphicInfo *gd = &graphic_info[graphic];
    int gd_x1 = gd->src_x;
    int gd_y1 = gd->src_y;
    int gd_x2 = gd->src_x + gd->pressed_xoffset;
    int gd_y2 = gd->src_y + gd->pressed_yoffset;
    int gd_x1a = gd->src_x + gd->active_xoffset;
    int gd_y1a = gd->src_y + gd->active_yoffset;
    int gd_x2a = gd->src_x + gd->active_xoffset + gd->pressed_xoffset;
    int gd_y2a = gd->src_y + gd->active_yoffset + gd->pressed_yoffset;
    int x = SX + ED_SETTINGS_X(checkbutton_info[i].x);
    int y = SY + ED_SETTINGS_Y(checkbutton_info[i].y);

    /* determine horizontal position to the right of specified gadget */
    if (checkbutton_info[i].gadget_id_align != GADGET_ID_NONE)
      x = (right_gadget_border[checkbutton_info[i].gadget_id_align] +
	   ED_GADGET_TEXT_DISTANCE);

    /* determine horizontal offset for leading text */
    if (checkbutton_info[i].text_left != NULL)
      x += getTextWidthForGadget(checkbutton_info[i].text_left);

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, checkbutton_info[i].infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_WIDTH, gd->width,
		      GDI_HEIGHT, gd->height,
		      GDI_TYPE, GD_TYPE_CHECK_BUTTON,
		      GDI_CHECKED, *checkbutton_info[i].value,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_ALT_DESIGN_UNPRESSED, gd->bitmap, gd_x1a, gd_y1a,
		      GDI_ALT_DESIGN_PRESSED, gd->bitmap, gd_x2a, gd_y2a,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleCheckbuttons,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
    right_gadget_border[id] =
      getRightGadgetBorder(gi, checkbutton_info[i].text_right);
  }
}

static void CreateRadiobuttonGadgets()
{
  struct GraphicInfo *gd = &graphic_info[IMG_EDITOR_RADIOBUTTON];
  int gd_x1 = gd->src_x;
  int gd_y1 = gd->src_y;
  int gd_x2 = gd->src_x + gd->pressed_xoffset;
  int gd_y2 = gd->src_y + gd->pressed_yoffset;
  int gd_x1a = gd->src_x + gd->active_xoffset;
  int gd_y1a = gd->src_y + gd->active_yoffset;
  int gd_x2a = gd->src_x + gd->active_xoffset + gd->pressed_xoffset;
  int gd_y2a = gd->src_y + gd->active_yoffset + gd->pressed_yoffset;
  struct GadgetInfo *gi;
  unsigned int event_mask;
  int i;

  event_mask = GD_EVENT_PRESSED;

  for (i = 0; i < ED_NUM_RADIOBUTTONS; i++)
  {
    int id = radiobutton_info[i].gadget_id;
    int x = SX + ED_SETTINGS_X(radiobutton_info[i].x);
    int y = SY + ED_SETTINGS_Y(radiobutton_info[i].y);

    int checked =
      (*radiobutton_info[i].value == radiobutton_info[i].checked_value);

    /* determine horizontal position to the right of specified gadget */
    if (radiobutton_info[i].gadget_id_align != GADGET_ID_NONE)
      x = (right_gadget_border[radiobutton_info[i].gadget_id_align] +
	   ED_GADGET_TEXT_DISTANCE);

    /* determine horizontal offset for leading text */
    if (radiobutton_info[i].text_left != NULL)
      x += getTextWidthForGadget(radiobutton_info[i].text_left);

    gi = CreateGadget(GDI_CUSTOM_ID, id,
		      GDI_CUSTOM_TYPE_ID, i,
		      GDI_INFO_TEXT, radiobutton_info[i].infotext,
		      GDI_X, x,
		      GDI_Y, y,
		      GDI_WIDTH, gd->width,
		      GDI_HEIGHT, gd->height,
		      GDI_TYPE, GD_TYPE_RADIO_BUTTON,
		      GDI_RADIO_NR, radiobutton_info[i].radio_button_nr,
		      GDI_CHECKED, checked,
		      GDI_DESIGN_UNPRESSED, gd->bitmap, gd_x1, gd_y1,
		      GDI_DESIGN_PRESSED, gd->bitmap, gd_x2, gd_y2,
		      GDI_ALT_DESIGN_UNPRESSED, gd->bitmap, gd_x1a, gd_y1a,
		      GDI_ALT_DESIGN_PRESSED, gd->bitmap, gd_x2a, gd_y2a,
		      GDI_EVENT_MASK, event_mask,
		      GDI_CALLBACK_INFO, HandleEditorGadgetInfoText,
		      GDI_CALLBACK_ACTION, HandleRadiobuttons,
		      GDI_END);

    if (gi == NULL)
      Error(ERR_EXIT, "cannot create gadget");

    level_editor_gadget[id] = gi;
    right_gadget_border[id] =
      getRightGadgetBorder(gi, radiobutton_info[i].text_right);
  }
}

void CreateLevelEditorGadgets()
{
  /* force EDITOR font inside level editor */
  SetFontStatus(GAME_MODE_EDITOR);

  /* these values are not constant, but can change at runtime */
  ed_fieldx = MAX_ED_FIELDX - 1;
  ed_fieldy = MAX_ED_FIELDY - 1;

  num_editor_gadgets = NUM_EDITOR_GADGETS;

  // printf("::: allocating %d gadgets ...\n", num_editor_gadgets);

  level_editor_gadget =
    checked_calloc(num_editor_gadgets * sizeof(struct GadgetInfo *));
  right_gadget_border =
    checked_calloc(num_editor_gadgets * sizeof(int));

  editor_el_empty = checked_calloc(ED_NUM_ELEMENTLIST_BUTTONS * sizeof(int));
  editor_el_empty_ptr = editor_el_empty;

  ReinitializeElementList();

  CreateControlButtons();
  CreateScrollbarGadgets();

  /* order of function calls is important because of cross-references */
  CreateCheckbuttonGadgets();
  CreateCounterButtons();
  CreateRadiobuttonGadgets();
  CreateTextInputGadgets();
  CreateTextAreaGadgets();
  CreateSelectboxGadgets();
  CreateGraphicbuttonGadgets();
  CreateTextbuttonGadgets();
  CreateDrawingAreas();

  ResetFontStatus();
}

void FreeLevelEditorGadgets()
{
  int i;

  // printf("::: freeing %d gadgets ...\n", num_editor_gadgets);

  for (i = 0; i < num_editor_gadgets; i++)
  {
    FreeGadget(level_editor_gadget[i]);

    level_editor_gadget[i] = NULL;
  }

  checked_free(level_editor_gadget);
  checked_free(right_gadget_border);

  checked_free(editor_el_empty);
}

static void MapCounterButtons(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  int gadget_id_down = counterbutton_info[id].gadget_id_down;
  int gadget_id_text = counterbutton_info[id].gadget_id_text;
  int gadget_id_up   = counterbutton_info[id].gadget_id_up;
  struct GadgetInfo *gi_down = level_editor_gadget[gadget_id_down];
  struct GadgetInfo *gi_text = level_editor_gadget[gadget_id_text];
  struct GadgetInfo *gi_up   = level_editor_gadget[gadget_id_up];
  int xoffset_left = getTextWidthForGadget(counterbutton_info[id].text_left);
  int xoffset_right = ED_GADGET_TEXT_DISTANCE;
  int yoffset_above = font_height + ED_GADGET_LINE_DISTANCE;
  int yoffset = (gi_down->height - font_height) / 2;
  int x_left = gi_down->x - xoffset_left;
  int x_right;	/* set after gadget position was modified */
  int y_above = gi_down->y - yoffset_above;
  int x = gi_down->x;
  int y;	/* set after gadget position was modified */

  /* counter limits must be changed first to prevent value truncation */
  ModifyEditorCounterLimits(id, counterbutton_info[id].min_value,
			    counterbutton_info[id].max_value);

  /* right text position might have changed after setting position above */
  x_right = gi_up->x + gi_up->width + xoffset_right;

  ModifyEditorCounterValue(id, *counterbutton_info[id].value);

  /* set position for "value[1,2,3,4]" counter gadgets (score in most cases) */
  if (id >= ED_COUNTER_ID_ELEMENT_VALUE1 &&
      id <= ED_COUNTER_ID_ELEMENT_VALUE4)
  {
    ModifyGadget(gi_down, GDI_Y,
		 SY + ED_SETTINGS_Y(counterbutton_info[id].y), GDI_END);
    ModifyGadget(gi_text, GDI_Y,
		 SY + ED_SETTINGS_Y(counterbutton_info[id].y), GDI_END);
    ModifyGadget(gi_up,   GDI_Y,
		 SY + ED_SETTINGS_Y(counterbutton_info[id].y), GDI_END);
  }

  /* vertical position might have changed after setting position above */
  y = gi_up->y + yoffset;

  if (counterbutton_info[id].text_above)
    DrawText(x, y_above, counterbutton_info[id].text_above, font_nr);

  if (counterbutton_info[id].text_left)
    DrawText(x_left, y, counterbutton_info[id].text_left, font_nr);

  if (counterbutton_info[id].text_right)
    DrawText(x_right, y, counterbutton_info[id].text_right, font_nr);

  MapGadget(gi_down);
  MapGadget(gi_text);
  MapGadget(gi_up);
}

static void MapControlButtons()
{
  int counter_id;
  int i;

  /* map toolbox buttons (excluding special CE toolbox buttons) */
  for (i = 0; i < ED_NUM_CTRL1_2_BUTTONS; i++)
    MapGadget(level_editor_gadget[i]);

  /* map toolbox buttons (element properties button) */
  MapGadget(level_editor_gadget[ED_NUM_CTRL1_4_BUTTONS]);

  /* map buttons to select elements */
  for (i = 0; i < ED_NUM_ELEMENTLIST_BUTTONS; i++)
    MapGadget(level_editor_gadget[GADGET_ID_ELEMENTLIST_FIRST + i]);
  MapGadget(level_editor_gadget[GADGET_ID_SCROLL_LIST_VERTICAL]);
  MapGadget(level_editor_gadget[GADGET_ID_SCROLL_LIST_UP]);
  MapGadget(level_editor_gadget[GADGET_ID_SCROLL_LIST_DOWN]);

  /* map buttons to select level */
  counter_id = ED_COUNTER_ID_SELECT_LEVEL;
  counterbutton_info[counter_id].min_value = leveldir_current->first_level;
  counterbutton_info[counter_id].max_value = leveldir_current->last_level;
  MapCounterButtons(counter_id);
}

static void MapDrawingArea(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[drawingarea_info[id].gadget_id];
  int area_xsize = gi->drawing.area_xsize;
  int area_ysize = gi->drawing.area_ysize;
  int xoffset_left = getTextWidthForDrawingArea(drawingarea_info[id].text_left);
  int xoffset_below = getTextWidth(drawingarea_info[id].text_below, font_nr);
  int x_left  = gi->x - xoffset_left;
  int x_right = gi->x + gi->width + ED_DRAWINGAREA_TEXT_DISTANCE;
  int x_below = gi->x + (gi->width - xoffset_below) / 2;
  int y_side  = gi->y + (gi->height - font_height) / 2;
  int y_below = gi->y + gi->height + ED_DRAWINGAREA_TEXT_DISTANCE;

  if (drawingarea_info[id].text_left)
    DrawText(x_left, y_side, drawingarea_info[id].text_left, font_nr);

  if (drawingarea_info[id].text_right)
    DrawText(x_right, y_side, drawingarea_info[id].text_right, font_nr);

  if (drawingarea_info[id].text_below)
    DrawText(x_below, y_below, drawingarea_info[id].text_below, font_nr);

  if (id != ED_DRAWING_ID_DRAWING_LEVEL)
  {
    DrawElementBorder(gi->x, gi->y,
		      area_xsize * ED_DRAWINGAREA_TILE_SIZE,
		      area_ysize * ED_DRAWINGAREA_TILE_SIZE, TRUE);

    DrawDrawingArea(id);
  }

  MapGadget(gi);
}

static void MapTextInputGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[textinput_info[id].gadget_id];
  int yoffset_above = font_height + ED_GADGET_LINE_DISTANCE;
  int x_above = ED_SETTINGS_X(textinput_info[id].x);
  int y_above = ED_SETTINGS_Y(textinput_info[id].y) - yoffset_above;

  if (textinput_info[id].text_above)
    DrawTextS(x_above, y_above, font_nr, textinput_info[id].text_above);

  ModifyGadget(gi, GDI_TEXT_VALUE, textinput_info[id].value, GDI_END);

  MapGadget(gi);
}

static void MapTextAreaGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[textarea_info[id].gadget_id];
  int yoffset_above = font_height + ED_GADGET_LINE_DISTANCE;
  int x_above = ED_SETTINGS_X(textarea_info[id].x);
  int y_above = ED_SETTINGS_Y(textarea_info[id].y) - yoffset_above;

  if (textarea_info[id].text_above)
    DrawTextS(x_above, y_above, font_nr, textarea_info[id].text_above);

  ModifyGadget(gi, GDI_TEXT_VALUE, textarea_info[id].value, GDI_END);

  MapGadget(gi);
}

static void MapSelectboxGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[selectbox_info[id].gadget_id];
  int xoffset_left = getTextWidthForGadget(selectbox_info[id].text_left);
  int xoffset_right = ED_GADGET_TEXT_DISTANCE;
  int yoffset = (gi->height - font_height) / 2;
  int x_left = gi->x - xoffset_left;
  int x_right = gi->x + gi->width + xoffset_right;
  int y = gi->y + yoffset;

  if (selectbox_info[id].text_left)
    DrawText(x_left, y, selectbox_info[id].text_left, font_nr);

  if (selectbox_info[id].text_right)
    DrawText(x_right, y, selectbox_info[id].text_right, font_nr);

  ModifyEditorSelectboxValue(id, *selectbox_info[id].value);

  MapGadget(gi);
}

static void MapTextbuttonGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[textbutton_info[id].gadget_id];
  int xoffset_left = getTextWidthForGadget(textbutton_info[id].text_left);
  int xoffset_right = ED_GADGET_TEXT_DISTANCE;
  int yoffset = (gi->height - font_height) / 2;
  int x_left = gi->x - xoffset_left;
  int x_right = gi->x + gi->width + xoffset_right;
  int y = gi->y + yoffset;

  /* only show button to delete change pages when more than minimum pages */
  if (id == ED_TEXTBUTTON_ID_DEL_CHANGE_PAGE &&
      custom_element.num_change_pages == MIN_CHANGE_PAGES)
    return;

  if (textbutton_info[id].text_left)
    DrawText(x_left, y, textbutton_info[id].text_left, font_nr);

  if (textbutton_info[id].text_right)
    DrawText(x_right, y, textbutton_info[id].text_right, font_nr);

  MapGadget(gi);
}

static void MapGraphicbuttonGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi= level_editor_gadget[graphicbutton_info[id].gadget_id];
  int xoffset_left = getTextWidthForGadget(graphicbutton_info[id].text_left);
  int xoffset_right = ED_GADGET_TEXT_DISTANCE;
  int yoffset = (gi->height - font_height) / 2;
  int x_left = gi->x - xoffset_left;
  int x_right = gi->x + gi->width + xoffset_right;
  int y = gi->y + yoffset;

  if (graphicbutton_info[id].text_left)
    DrawText(x_left, y, graphicbutton_info[id].text_left, font_nr);

  if (graphicbutton_info[id].text_right)
    DrawText(x_right, y, graphicbutton_info[id].text_right, font_nr);

  MapGadget(gi);
}

static void MapRadiobuttonGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[radiobutton_info[id].gadget_id];
  int xoffset_left = getTextWidthForGadget(checkbutton_info[id].text_left);
  int xoffset_right = ED_GADGET_TEXT_DISTANCE;
  int yoffset = (gi->height - font_height) / 2;
  int x_left = gi->x - xoffset_left;
  int x_right = gi->x + gi->width + xoffset_right;
  int y = gi->y + yoffset;
  boolean checked =
    (*radiobutton_info[id].value == radiobutton_info[id].checked_value);

  if (radiobutton_info[id].text_left)
    DrawText(x_left, y, radiobutton_info[id].text_left, font_nr);

  if (radiobutton_info[id].text_right)
    DrawText(x_right, y, radiobutton_info[id].text_right, font_nr);

  ModifyGadget(gi, GDI_CHECKED, checked, GDI_END);

  MapGadget(gi);
}

static void MapCheckbuttonGadget(int id)
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  struct GadgetInfo *gi = level_editor_gadget[checkbutton_info[id].gadget_id];
  int xoffset_left = getTextWidthForGadget(checkbutton_info[id].text_left);
  int xoffset_right = ED_GADGET_TEXT_DISTANCE;
  int yoffset = (gi->height - font_height) / 2;
  int x_left, x_right, y;	/* set after gadget position was modified */

  /* set position for gadgets with dynamically determined position */
  if (checkbutton_info[id].x != -1)	/* do not change dynamic positions */
    ModifyGadget(gi, GDI_X, SX + ED_SETTINGS_X(checkbutton_info[id].x),GDI_END);
  ModifyGadget(gi, GDI_Y, SY + ED_SETTINGS_Y(checkbutton_info[id].y), GDI_END);

  x_left = gi->x - xoffset_left;
  x_right = gi->x + gi->width + xoffset_right;
  y = gi->y + yoffset;

  if (checkbutton_info[id].text_left)
    DrawText(x_left, y, checkbutton_info[id].text_left, font_nr);

  if (checkbutton_info[id].text_right)
    DrawText(x_right, y, checkbutton_info[id].text_right, font_nr);

  ModifyGadget(gi, GDI_CHECKED, *checkbutton_info[id].value, GDI_END);

  MapGadget(gi);
}

static void MapMainDrawingArea()
{
  boolean no_horizontal_scrollbar = (lev_fieldx + 2 <= ed_fieldx);
  boolean no_vertical_scrollbar = (lev_fieldy + 2 <= ed_fieldy);
  int i;

  for (i=ED_SCROLLBUTTON_ID_AREA_FIRST; i <= ED_SCROLLBUTTON_ID_AREA_LAST; i++)
  {
    if (((i == ED_SCROLLBUTTON_ID_AREA_LEFT ||
	  i == ED_SCROLLBUTTON_ID_AREA_RIGHT) &&
	 no_horizontal_scrollbar) ||
	((i == ED_SCROLLBUTTON_ID_AREA_UP ||
	  i == ED_SCROLLBUTTON_ID_AREA_DOWN) &&
	 no_vertical_scrollbar))
      continue;

    MapGadget(level_editor_gadget[scrollbutton_info[i].gadget_id]);
  }

  for (i = ED_SCROLLBAR_ID_AREA_FIRST; i <= ED_SCROLLBAR_ID_AREA_LAST; i++)
  {
    if ((i == ED_SCROLLBAR_ID_AREA_HORIZONTAL && no_horizontal_scrollbar) ||
	(i == ED_SCROLLBAR_ID_AREA_VERTICAL && no_vertical_scrollbar))
      continue;

    MapGadget(level_editor_gadget[scrollbar_info[i].gadget_id]);
  }

  MapDrawingArea(ED_DRAWING_ID_DRAWING_LEVEL);
}

static void MapOrUnmapLevelEditorToolboxCustomGadgets(boolean map)
{
  int i;

  for (i = 0; i < ED_NUM_CTRL_BUTTONS; i++)
  {
    if (i == GADGET_ID_CUSTOM_COPY_FROM ||
        i == GADGET_ID_CUSTOM_COPY_TO ||
        i == GADGET_ID_CUSTOM_EXCHANGE ||
        i == GADGET_ID_CUSTOM_COPY ||
        i == GADGET_ID_CUSTOM_PASTE)
    {
      if (map)
	MapGadget(level_editor_gadget[i]);
      else
	UnmapGadget(level_editor_gadget[i]);
    }
  }
}

static void MapLevelEditorToolboxCustomGadgets()
{
  MapOrUnmapLevelEditorToolboxCustomGadgets(TRUE);
}

static void UnmapLevelEditorToolboxCustomGadgets()
{
  MapOrUnmapLevelEditorToolboxCustomGadgets(FALSE);
}

static void MapOrUnmapLevelEditorToolboxDrawingGadgets(boolean map)
{
  int i;

  for (i = 0; i < ED_NUM_CTRL1_BUTTONS; i++)
  {
    if (i != GADGET_ID_SINGLE_ITEMS &&
	i != GADGET_ID_PICK_ELEMENT)
    {
      struct GadgetInfo *gi = level_editor_gadget[i];

      if (map)
      {
	MapGadget(gi);
      }
      else
      {
	int graphic = IMG_EDITOR_NO_TOOLBOX_BUTTON;
	struct GraphicInfo *gd = &graphic_info[graphic];

	UnmapGadget(gi);

	BlitBitmap(gd->bitmap, drawto, gd->src_x, gd->src_y,
		   gi->width, gi->height, gi->x, gi->y);

	redraw_mask |= REDRAW_DOOR_3;
      }
    }
  }
}

static void MapLevelEditorToolboxDrawingGadgets()
{
  MapOrUnmapLevelEditorToolboxDrawingGadgets(TRUE);
}

static void UnmapLevelEditorToolboxDrawingGadgets()
{
  MapOrUnmapLevelEditorToolboxDrawingGadgets(FALSE);
}

static void UnmapDrawingArea(int id)
{
  UnmapGadget(level_editor_gadget[drawingarea_info[id].gadget_id]);
}

static void UnmapLevelEditorFieldGadgets()
{
  int i;

  for (i = 0; i < num_editor_gadgets; i++)
    if (IN_GFX_FIELD_FULL(level_editor_gadget[i]->x,
			  level_editor_gadget[i]->y))
      UnmapGadget(level_editor_gadget[i]);
}

void UnmapLevelEditorGadgets()
{
  int i;

  for (i = 0; i < num_editor_gadgets; i++)
    UnmapGadget(level_editor_gadget[i]);
}

static void ResetUndoBuffer()
{
  undo_buffer_position = -1;
  undo_buffer_steps = -1;
  redo_buffer_steps = 0;

  CopyLevelToUndoBuffer(UNDO_IMMEDIATE);

  level.changed = FALSE;
}

static void DrawEditModeWindow()
{
  ModifyEditorElementList();
  RedrawDrawingElements();

  if (edit_mode == ED_MODE_INFO)
    DrawLevelInfoWindow();
  else if (edit_mode == ED_MODE_PROPERTIES)
    DrawPropertiesWindow();
  else	/* edit_mode == ED_MODE_DRAWING */
    DrawDrawingWindow();
}

static boolean LevelChanged()
{
  boolean field_changed = FALSE;
  int x, y;

  for (y = 0; y < lev_fieldy; y++) 
    for (x = 0; x < lev_fieldx; x++)
      if (Feld[x][y] != level.field[x][y])
	field_changed = TRUE;

  return (level.changed || field_changed);
}

static boolean PrepareSavingIntoPersonalLevelSet()
{
  static LevelDirTree *last_copied_leveldir = NULL;
  static LevelDirTree *last_written_leveldir = NULL;
  static int last_copied_level_nr = -1;
  static int last_written_level_nr = -1;
  LevelDirTree *leveldir_former = leveldir_current;
  int level_nr_former = level_nr;
  int new_level_nr;

  // remember last mod/save so that for current session, we write
  // back to the same personal copy, asking only about overwrite.
  if (leveldir_current == last_copied_leveldir &&
      level_nr == last_copied_level_nr)
  {
    // "cd" to personal level set dir (as used when writing last copy)
    leveldir_current = last_written_leveldir;
    level_nr = last_written_level_nr;

    return TRUE;
  }

  if (!Request("This level is read only! "
	       "Save into personal level set?", REQ_ASK))
    return FALSE;

  // "cd" to personal level set dir (for writing copy the first time)
  leveldir_current =
    getTreeInfoFromIdentifier(leveldir_first, getLoginName());

  // find unused level number
  for (new_level_nr = leveldir_current->first_level; ; new_level_nr++)
  {
    static char *level_filename = NULL;

    setString(&level_filename, getDefaultLevelFilename(new_level_nr));

    if (!fileExists(level_filename))
      break;
  }

  last_copied_leveldir = leveldir_former;
  last_copied_level_nr = level_nr_former;

  last_written_leveldir = leveldir_current;
  last_written_level_nr = level_nr = new_level_nr;

  return TRUE;
}

static void ModifyLevelInfoForSavingIntoPersonalLevelSet(char *former_name)
{
  static char *filename_levelinfo = NULL, *mod_name = NULL;
  FILE *file;

  // annotate this copy-and-mod in personal levelinfo.conf
  setString(&filename_levelinfo,
	    getPath2(getCurrentLevelDir(), LEVELINFO_FILENAME));

  if ((file = fopen(filename_levelinfo, MODE_APPEND)))
  {
    fprintf(file, "\n");
    fprintf(file, "# level %d was modified from:\n", level_nr);
    fprintf(file, "# - previous level set name:    %s\n",
	    former_name);
    fprintf(file, "# - level within previous set:  %d \"%s\"\n",
	    level.file_info.nr, level.name);
    fprintf(file, "# - previous author:            %s\n",
	    level.author);
    fprintf(file, "# - previous save date:         ");

    if (level.creation_date.src == DATE_SRC_LEVELFILE)
    {
      fprintf(file, "%04d-%02d-%02d\n",
	      level.creation_date.year,
	      level.creation_date.month,
	      level.creation_date.day);
    }
    else
    {
      fprintf(file, "not recorded\n");
    }

    fclose(file);
  }

  if (level_nr > leveldir_current->last_level)
  {
    static char *temp_levelinfo = NULL;
    FILE *temp_file = NULL;
    char line[MAX_LINE_LEN];

    setString(&temp_levelinfo,
	      getPath2(getCurrentLevelDir(),
		       getStringCat2(LEVELINFO_FILENAME, ".new")));

    if ((file = fopen(filename_levelinfo, MODE_READ)) &&
	(temp_file = fopen(temp_levelinfo, MODE_WRITE)))
    {
      while (fgets(line, MAX_LINE_LEN, file))
      {
	if (!strPrefix(line, "levels:"))
	  fputs(line, temp_file);
	else
	  fprintf(temp_file, "%-32s%d\n", "levels:", level_nr + 9);
      }
    }

    if (temp_file)
      fclose(temp_file);

    if (file)
      fclose(file);

    // needs error handling; also, ok on dos/win?
    unlink(filename_levelinfo);
    rename(temp_levelinfo, filename_levelinfo);
  }

  // else: allow the save even if annotation failed

  // now... spray graffiti on the old level vital statistics
  // user can change these; just trying to set a good baseline

  // don't truncate names for fear of making offensive or silly:
  // long-named original author only recorded in levelinfo.conf.
  // try to fit "Joe after Bob", "Joe (ed.)", then just "Joe"
  if (!strEqual(level.author, leveldir_current->author))
  {
    setString(&mod_name, getStringCat3(leveldir_current->author,
				       " after ", level.author));

    if (strlen(mod_name) > MAX_LEVEL_AUTHOR_LEN)
      setString(&mod_name,
		getStringCat2(leveldir_current->author, " (ed.)"));

    if (strlen(mod_name) > MAX_LEVEL_AUTHOR_LEN)
      setString(&mod_name, leveldir_current->author);

    strncpy(level.author, mod_name, MAX_LEVEL_AUTHOR_LEN);

    // less worried about truncation here
    setString(&mod_name, getStringCat2("Mod: ", level.name));
    strncpy(level.name, mod_name, MAX_LEVEL_NAME_LEN);
  }
}

static void CopyPlayfield(short src[MAX_LEV_FIELDX][MAX_LEV_FIELDY],
			  short dst[MAX_LEV_FIELDX][MAX_LEV_FIELDY])
{
  int x, y;

  for (x = 0; x < lev_fieldx; x++)
    for (y = 0; y < lev_fieldy; y++) 
      dst[x][y] = src[x][y];
}

static int setSelectboxValue(int selectbox_id, int new_value)
{
  int new_index_value = 0;
  int i;

  for (i = 0; selectbox_info[selectbox_id].options[i].text != NULL; i++)
    if (selectbox_info[selectbox_id].options[i].value == new_value)
      new_index_value = i;

  *selectbox_info[selectbox_id].value =
    selectbox_info[selectbox_id].options[new_index_value].value;

  return new_index_value;
}

static void setSelectboxSpecialActionVariablesIfNeeded()
{
  int i;

  /* change action mode and arg variables according to action type variable */
  for (i = 0; action_arg_options[i].value != -1; i++)
  {
    if (action_arg_options[i].value == custom_element_change.action_type)
    {
      int mode = action_arg_options[i].mode;

      /* only change if corresponding selectbox has changed */
      if (selectbox_info[ED_SELECTBOX_ID_ACTION_MODE].options !=
	  action_arg_modes[mode])
	custom_element_change.action_mode = -1;

      /* only change if corresponding selectbox has changed */
      if (selectbox_info[ED_SELECTBOX_ID_ACTION_ARG].options !=
	  action_arg_options[i].options)
	custom_element_change.action_arg = -1;

      break;
    }
  }
}

static void setSelectboxSpecialActionOptions()
{
  int i;

  /* change action mode and arg selectbox according to action type selectbox */
  for (i = 0; action_arg_options[i].value != -1; i++)
  {
    if (action_arg_options[i].value == custom_element_change.action_type)
    {
      int mode = action_arg_options[i].mode;

      ModifyEditorSelectboxOptions(ED_SELECTBOX_ID_ACTION_MODE,
				   action_arg_modes[mode]);
      ModifyEditorSelectboxValue(ED_SELECTBOX_ID_ACTION_MODE,
				 custom_element_change.action_mode);

      ModifyEditorSelectboxOptions(ED_SELECTBOX_ID_ACTION_ARG,
				   action_arg_options[i].options);
      ModifyEditorSelectboxValue(ED_SELECTBOX_ID_ACTION_ARG,
				 custom_element_change.action_arg);
      break;
    }
  }
}

static void copy_custom_element_settings(int element_from, int element_to)
{
  struct ElementInfo *ei_from = &element_info[element_from];
  struct ElementInfo *ei_to = &element_info[element_to];

  copyElementInfo(ei_from, ei_to);
}

static void replace_custom_element_in_settings(int element_from,
					       int element_to)
{
  int i, j, x, y;

  for (i = 0; i < NUM_FILE_ELEMENTS; i++)
  {
    struct ElementInfo *ei = &element_info[i];

    for (y = 0; y < 3; y++)
      for (x = 0; x < 3; x++)
	if (ei->content.e[x][y] == element_from)
	  ei->content.e[x][y] = element_to;

    for (j = 0; j < ei->num_change_pages; j++)
    {
      struct ElementChangeInfo *change = &ei->change_page[j];

      if (change->target_element == element_from)
	change->target_element = element_to;

      if (change->initial_trigger_element == element_from)
	change->initial_trigger_element = element_to;

      if (change->action_element == element_from)
	change->action_element = element_to;

      for (y = 0; y < 3; y++)
	for (x = 0; x < 3; x++)
	  if (change->target_content.e[x][y] == element_from)
	    change->target_content.e[x][y] = element_to;
    }

    if (ei->group != NULL)				/* group or internal */
      for (j = 0; j < MAX_ELEMENTS_IN_GROUP; j++)
	if (ei->group->element[j] == element_from)
	  ei->group->element[j] = element_to;
  }
}

static void replace_custom_element_in_playfield(int element_from,
						int element_to)
{
  int x, y;

  for (x = 0; x < lev_fieldx; x++)
    for (y = 0; y < lev_fieldy; y++)
      if (Feld[x][y] == element_from)
	Feld[x][y] = element_to;
}

static boolean CopyCustomElement(int element_old, int element_new,
				 int copy_mode)
{
  if (copy_mode == GADGET_ID_CUSTOM_COPY)
  {
    element_new = (IS_CUSTOM_ELEMENT(element_old) ?
		   EL_INTERNAL_CLIPBOARD_CUSTOM : EL_INTERNAL_CLIPBOARD_GROUP);
    copy_mode = GADGET_ID_CUSTOM_COPY_TO;
  }
  else if (copy_mode == GADGET_ID_CUSTOM_PASTE)
  {
    element_old = (IS_CUSTOM_ELEMENT(element_new) ?
		   EL_INTERNAL_CLIPBOARD_CUSTOM : EL_INTERNAL_CLIPBOARD_GROUP);
    copy_mode = GADGET_ID_CUSTOM_COPY_TO;

    level.changed = TRUE;
  }
  else if (IS_CUSTOM_ELEMENT(element_old) && !IS_CUSTOM_ELEMENT(element_new))
  {
    Request("Please choose custom element!", REQ_CONFIRM);

    return FALSE;
  }
  else if (IS_GROUP_ELEMENT(element_old) && !IS_GROUP_ELEMENT(element_new))
  {
    Request("Please choose group element!", REQ_CONFIRM);

    return FALSE;
  }
  else
  {
    level.changed = TRUE;
  }

  if (copy_mode == GADGET_ID_CUSTOM_COPY_FROM)
  {
    copy_custom_element_settings(element_new, element_old);
  }
  else if (copy_mode == GADGET_ID_CUSTOM_COPY_TO)
  {
    copy_custom_element_settings(element_old, element_new);
  }
  else if (copy_mode == GADGET_ID_CUSTOM_EXCHANGE)
  {
    copy_custom_element_settings(element_old, EL_INTERNAL_DUMMY);
    copy_custom_element_settings(element_new, element_old);
    copy_custom_element_settings(EL_INTERNAL_DUMMY, element_new);

    replace_custom_element_in_settings(element_old, EL_INTERNAL_DUMMY);
    replace_custom_element_in_settings(element_new, element_old);
    replace_custom_element_in_settings(EL_INTERNAL_DUMMY, element_new);

    replace_custom_element_in_playfield(element_old, EL_INTERNAL_DUMMY);
    replace_custom_element_in_playfield(element_new, element_old);
    replace_custom_element_in_playfield(EL_INTERNAL_DUMMY, element_new);
  }

  UpdateCustomElementGraphicGadgets();
  DrawPropertiesWindow();

  return TRUE;
}

static void CopyCustomElementPropertiesToEditor(int element)
{
  int i;
  int current_change_page = element_info[element].current_change_page;

  /* dynamically (re)build selectbox for selecting change page */
  for (i = 0; i < element_info[element].num_change_pages; i++)
  {
    sprintf(options_change_page_strings[i], "%d", i + 1);

    options_change_page[i].value = i;
    options_change_page[i].text = options_change_page_strings[i];
  }

  options_change_page[i].value = -1;
  options_change_page[i].text = NULL;

  /* needed here to initialize combined element properties */
  InitElementPropertiesEngine(level.game_version);

  element_info[element].change =
    &element_info[element].change_page[current_change_page];

  custom_element = element_info[element];
  custom_element_change = *element_info[element].change;

  /* needed to initially set selectbox options for special action options */
  setSelectboxSpecialActionOptions();

  /* needed to initially set selectbox value variables to reliable defaults */
  for (i = 0; i < ED_NUM_SELECTBOX; i++)
    setSelectboxValue(i, *selectbox_info[i].value);

  for (i = 0; i < NUM_ELEMENT_PROPERTIES; i++)
    custom_element_properties[i] = HAS_PROPERTY(element, i);

  for (i = 0; i < NUM_CHANGE_EVENTS; i++)
    custom_element_change_events[i] = HAS_CHANGE_EVENT(element, i);

  /* ---------- element settings: configure (custom elements) ------------- */

  /* set accessible layer selectbox help value */
  custom_element.access_type =
    (IS_WALKABLE(element) ? EP_WALKABLE :
     IS_PASSABLE(element) ? EP_PASSABLE :
     custom_element.access_type);
  custom_element.access_layer =
    (IS_ACCESSIBLE_OVER(element) ? EP_ACCESSIBLE_OVER :
     IS_ACCESSIBLE_INSIDE(element) ? EP_ACCESSIBLE_INSIDE :
     IS_ACCESSIBLE_UNDER(element) ? EP_ACCESSIBLE_UNDER :
     custom_element.access_layer);
  custom_element.access_protected =
    (IS_PROTECTED(element) ? 1 : 0);
  custom_element_properties[EP_ACCESSIBLE] =
    (IS_ACCESSIBLE_OVER(element) ||
     IS_ACCESSIBLE_INSIDE(element) ||
     IS_ACCESSIBLE_UNDER(element));

  /* set walk-to-object action selectbox help value */
  custom_element.walk_to_action =
    (IS_DIGGABLE(element) ? EP_DIGGABLE :
     IS_COLLECTIBLE_ONLY(element) ? EP_COLLECTIBLE_ONLY :
     IS_DROPPABLE(element) ? EP_DROPPABLE :
     IS_THROWABLE(element) ? EP_THROWABLE :
     IS_PUSHABLE(element) ? EP_PUSHABLE :
     custom_element.walk_to_action);
  custom_element_properties[EP_WALK_TO_OBJECT] =
    (IS_DIGGABLE(element) ||
     IS_COLLECTIBLE_ONLY(element) ||
     IS_DROPPABLE(element) ||
     IS_THROWABLE(element) ||
     IS_PUSHABLE(element));

  /* set smash targets selectbox help value */
  custom_element.smash_targets =
    (CAN_SMASH_EVERYTHING(element) ? EP_CAN_SMASH_EVERYTHING :
     CAN_SMASH_ENEMIES(element) ? EP_CAN_SMASH_ENEMIES :
     CAN_SMASH_PLAYER(element) ? EP_CAN_SMASH_PLAYER :
     custom_element.smash_targets);
  custom_element_properties[EP_CAN_SMASH] =
    (CAN_SMASH_EVERYTHING(element) ||
     CAN_SMASH_ENEMIES(element) ||
     CAN_SMASH_PLAYER(element));

  /* set deadliness selectbox help value */
  custom_element.deadliness =
    (DONT_TOUCH(element) ? EP_DONT_TOUCH :
     DONT_GET_HIT_BY(element) ? EP_DONT_GET_HIT_BY :
     DONT_COLLIDE_WITH(element) ? EP_DONT_COLLIDE_WITH :
     DONT_RUN_INTO(element) ? EP_DONT_RUN_INTO :
     custom_element.deadliness);
  custom_element_properties[EP_DEADLY] =
    (DONT_TOUCH(element) ||
     DONT_GET_HIT_BY(element) ||
     DONT_COLLIDE_WITH(element) ||
     DONT_RUN_INTO(element));

  /* ---------- element settings: advanced (custom elements) --------------- */

  /* set "change by direct action" selectbox help value */
  custom_element_change.direct_action =
    (HAS_CHANGE_EVENT(element, CE_TOUCHED_BY_PLAYER) ? CE_TOUCHED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_PRESSED_BY_PLAYER) ? CE_PRESSED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_SWITCHED_BY_PLAYER) ? CE_SWITCHED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_SNAPPED_BY_PLAYER) ? CE_SNAPPED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_PUSHED_BY_PLAYER) ? CE_PUSHED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_ENTERED_BY_PLAYER) ? CE_ENTERED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_LEFT_BY_PLAYER) ? CE_LEFT_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_DROPPED_BY_PLAYER) ? CE_DROPPED_BY_PLAYER :
     HAS_CHANGE_EVENT(element, CE_SWITCHED) ? CE_SWITCHED :
     HAS_CHANGE_EVENT(element, CE_HITTING_SOMETHING) ? CE_HITTING_SOMETHING :
     HAS_CHANGE_EVENT(element, CE_HIT_BY_SOMETHING) ? CE_HIT_BY_SOMETHING :
     HAS_CHANGE_EVENT(element, CE_BLOCKED) ? CE_BLOCKED :
     HAS_CHANGE_EVENT(element, CE_IMPACT) ? CE_IMPACT :
     HAS_CHANGE_EVENT(element, CE_SMASHED) ? CE_SMASHED :
     HAS_CHANGE_EVENT(element, CE_VALUE_CHANGES) ? CE_VALUE_CHANGES :
     HAS_CHANGE_EVENT(element, CE_SCORE_CHANGES) ? CE_SCORE_CHANGES :
     HAS_CHANGE_EVENT(element, CE_VALUE_GETS_ZERO) ? CE_VALUE_GETS_ZERO :
     HAS_CHANGE_EVENT(element, CE_SCORE_GETS_ZERO) ? CE_SCORE_GETS_ZERO :
     custom_element_change.direct_action);

  /* set "change by other element action" selectbox help value */
  custom_element_change.other_action =
    (HAS_CHANGE_EVENT(element, CE_PLAYER_TOUCHES_X) ? CE_PLAYER_TOUCHES_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_PRESSES_X) ? CE_PLAYER_PRESSES_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_SWITCHES_X) ? CE_PLAYER_SWITCHES_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_SNAPS_X) ? CE_PLAYER_SNAPS_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_PUSHES_X) ? CE_PLAYER_PUSHES_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_ENTERS_X) ? CE_PLAYER_ENTERS_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_LEAVES_X) ? CE_PLAYER_LEAVES_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_DIGS_X) ? CE_PLAYER_DIGS_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_COLLECTS_X) ? CE_PLAYER_COLLECTS_X :
     HAS_CHANGE_EVENT(element, CE_PLAYER_DROPS_X) ? CE_PLAYER_DROPS_X :
     HAS_CHANGE_EVENT(element, CE_TOUCHING_X) ? CE_TOUCHING_X :
     HAS_CHANGE_EVENT(element, CE_HITTING_X) ? CE_HITTING_X :
     HAS_CHANGE_EVENT(element, CE_DIGGING_X) ? CE_DIGGING_X :
     HAS_CHANGE_EVENT(element, CE_HIT_BY_X) ? CE_HIT_BY_X :
     HAS_CHANGE_EVENT(element, CE_SWITCH_OF_X) ? CE_SWITCH_OF_X :
     HAS_CHANGE_EVENT(element, CE_CHANGE_OF_X) ? CE_CHANGE_OF_X :
     HAS_CHANGE_EVENT(element, CE_EXPLOSION_OF_X) ? CE_EXPLOSION_OF_X :
     HAS_CHANGE_EVENT(element, CE_MOVE_OF_X) ? CE_MOVE_OF_X :
     HAS_CHANGE_EVENT(element, CE_CREATION_OF_X) ? CE_CREATION_OF_X :
     HAS_CHANGE_EVENT(element, CE_VALUE_CHANGES_OF_X) ? CE_VALUE_CHANGES_OF_X :
     HAS_CHANGE_EVENT(element, CE_SCORE_CHANGES_OF_X) ? CE_SCORE_CHANGES_OF_X :
     HAS_CHANGE_EVENT(element, CE_VALUE_GETS_ZERO_OF_X) ? CE_VALUE_GETS_ZERO_OF_X :
     HAS_CHANGE_EVENT(element, CE_SCORE_GETS_ZERO_OF_X) ? CE_SCORE_GETS_ZERO_OF_X :
     custom_element_change.other_action);
}

static void CopyGroupElementPropertiesToEditor(int element)
{
  group_element_info = *element_info[element].group;
  custom_element = element_info[element];	/* needed for description */
}

static void CopyClassicElementPropertiesToEditor(int element)
{
  if (ELEM_IS_PLAYER(element) || COULD_MOVE_INTO_ACID(element))
    custom_element_properties[EP_CAN_MOVE_INTO_ACID] =
      getMoveIntoAcidProperty(&level, element);

  if (MAYBE_DONT_COLLIDE_WITH(element))
    custom_element_properties[EP_DONT_COLLIDE_WITH] =
      getDontCollideWithProperty(&level, element);
}

static void CopyElementPropertiesToEditor(int element)
{
  if (IS_CUSTOM_ELEMENT(element))
    CopyCustomElementPropertiesToEditor(element);
  else if (IS_GROUP_ELEMENT(element))
    CopyGroupElementPropertiesToEditor(element);
  else
    CopyClassicElementPropertiesToEditor(element);
}

static void CopyCustomElementPropertiesToGame(int element)
{
  int i;
  int access_type_and_layer;

  /* mark that this custom element has been modified */
  custom_element.modified_settings = TRUE;
  level.changed = TRUE;

  if (level.use_custom_template)
  {
    if (Request("Copy and modify level template?", REQ_ASK))
    {
      level.use_custom_template = FALSE;
      ModifyGadget(level_editor_gadget[GADGET_ID_CUSTOM_USE_TEMPLATE],
		   GDI_CHECKED, FALSE, GDI_END);
    }
    else
    {
      LoadLevelTemplate(-1);	/* this resets all element modifications ... */

      DrawEditModeWindow();	/* ... and copies them to 'custom_element' */
    }
  }

  element_info[element] = custom_element;
  *element_info[element].change = custom_element_change;

  /* ---------- element settings: configure (custom elements) ------------- */

  /* set accessible property from checkbox and selectbox */
  custom_element_properties[EP_WALKABLE_OVER] = FALSE;
  custom_element_properties[EP_WALKABLE_INSIDE] = FALSE;
  custom_element_properties[EP_WALKABLE_UNDER] = FALSE;
  custom_element_properties[EP_PASSABLE_OVER] = FALSE;
  custom_element_properties[EP_PASSABLE_INSIDE] = FALSE;
  custom_element_properties[EP_PASSABLE_UNDER] = FALSE;
  access_type_and_layer = ((custom_element.access_type == EP_WALKABLE ?
			    EP_WALKABLE_OVER : EP_PASSABLE_OVER) +
			   (custom_element.access_layer - EP_ACCESSIBLE_OVER));
  custom_element_properties[access_type_and_layer] =
    custom_element_properties[EP_ACCESSIBLE];
  custom_element_properties[EP_PROTECTED] =
    (custom_element.access_protected != 0 &&
     custom_element_properties[EP_ACCESSIBLE]);

  /* set walk-to-object property from checkbox and selectbox */
  custom_element_properties[EP_DIGGABLE] = FALSE;
  custom_element_properties[EP_COLLECTIBLE_ONLY] = FALSE;
  custom_element_properties[EP_DROPPABLE] = FALSE;
  custom_element_properties[EP_THROWABLE] = FALSE;
  custom_element_properties[EP_PUSHABLE] = FALSE;
  custom_element_properties[custom_element.walk_to_action] =
    custom_element_properties[EP_WALK_TO_OBJECT];

  /* set smash property from checkbox and selectbox */
  custom_element_properties[EP_CAN_SMASH_PLAYER] = FALSE;
  custom_element_properties[EP_CAN_SMASH_ENEMIES] = FALSE;
  custom_element_properties[EP_CAN_SMASH_EVERYTHING] = FALSE;
  custom_element_properties[custom_element.smash_targets] =
    custom_element_properties[EP_CAN_SMASH];

  /* set deadliness property from checkbox and selectbox */
  custom_element_properties[EP_DONT_RUN_INTO] = FALSE;
  custom_element_properties[EP_DONT_COLLIDE_WITH] = FALSE;
  custom_element_properties[EP_DONT_GET_HIT_BY] = FALSE;
  custom_element_properties[EP_DONT_TOUCH] = FALSE;
  custom_element_properties[custom_element.deadliness] =
    custom_element_properties[EP_DEADLY];

  /* ---------- element settings: advanced (custom elements) --------------- */

  /* set player change event from checkbox and selectbox */
  custom_element_change_events[CE_TOUCHED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_PRESSED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_SWITCHED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_SNAPPED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_PUSHED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_ENTERED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_LEFT_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_DROPPED_BY_PLAYER] = FALSE;
  custom_element_change_events[CE_SWITCHED] = FALSE;
  custom_element_change_events[CE_HITTING_SOMETHING] = FALSE;
  custom_element_change_events[CE_HIT_BY_SOMETHING] = FALSE;
  custom_element_change_events[CE_BLOCKED] = FALSE;
  custom_element_change_events[CE_IMPACT] = FALSE;
  custom_element_change_events[CE_SMASHED] = FALSE;
  custom_element_change_events[CE_VALUE_CHANGES] = FALSE;
  custom_element_change_events[CE_SCORE_CHANGES] = FALSE;
  custom_element_change_events[CE_VALUE_GETS_ZERO] = FALSE;
  custom_element_change_events[CE_SCORE_GETS_ZERO] = FALSE;
  custom_element_change_events[custom_element_change.direct_action] =
    custom_element_change_events[CE_BY_DIRECT_ACTION];

  /* set other element action change event from checkbox and selectbox */
  custom_element_change_events[CE_PLAYER_TOUCHES_X] = FALSE;
  custom_element_change_events[CE_PLAYER_PRESSES_X] = FALSE;
  custom_element_change_events[CE_PLAYER_SWITCHES_X] = FALSE;
  custom_element_change_events[CE_PLAYER_SNAPS_X] = FALSE;
  custom_element_change_events[CE_PLAYER_PUSHES_X] = FALSE;
  custom_element_change_events[CE_PLAYER_ENTERS_X] = FALSE;
  custom_element_change_events[CE_PLAYER_LEAVES_X] = FALSE;
  custom_element_change_events[CE_PLAYER_DIGS_X] = FALSE;
  custom_element_change_events[CE_PLAYER_COLLECTS_X] = FALSE;
  custom_element_change_events[CE_PLAYER_DROPS_X] = FALSE;
  custom_element_change_events[CE_TOUCHING_X] = FALSE;
  custom_element_change_events[CE_HITTING_X] = FALSE;
  custom_element_change_events[CE_DIGGING_X] = FALSE;
  custom_element_change_events[CE_HIT_BY_X] = FALSE;
  custom_element_change_events[CE_SWITCH_OF_X] = FALSE;
  custom_element_change_events[CE_CHANGE_OF_X] = FALSE;
  custom_element_change_events[CE_EXPLOSION_OF_X] = FALSE;
  custom_element_change_events[CE_MOVE_OF_X] = FALSE;
  custom_element_change_events[CE_CREATION_OF_X] = FALSE;
  custom_element_change_events[CE_VALUE_CHANGES_OF_X] = FALSE;
  custom_element_change_events[CE_SCORE_CHANGES_OF_X] = FALSE;
  custom_element_change_events[CE_VALUE_GETS_ZERO_OF_X] = FALSE;
  custom_element_change_events[CE_SCORE_GETS_ZERO_OF_X] = FALSE;
  custom_element_change_events[custom_element_change.other_action] =
    custom_element_change_events[CE_BY_OTHER_ACTION];

  for (i = 0; i < NUM_ELEMENT_PROPERTIES; i++)
    SET_PROPERTY(element, i, custom_element_properties[i]);

  for (i = 0; i < NUM_CHANGE_EVENTS; i++)
    SET_CHANGE_EVENT(element, i, custom_element_change_events[i]);

  /* copy change events also to special level editor variable */
  custom_element = element_info[element];
  custom_element_change = *element_info[element].change;
}

static void CopyGroupElementPropertiesToGame(int element)
{
  element_info[element] = custom_element;
  *element_info[element].group = group_element_info;

  /* mark that this group element has been modified */
  element_info[element].modified_settings = TRUE;
  level.changed = TRUE;
}

static void CopyClassicElementPropertiesToGame(int element)
{
  if (ELEM_IS_PLAYER(element) || COULD_MOVE_INTO_ACID(element))
    setMoveIntoAcidProperty(&level, element,
			    custom_element_properties[EP_CAN_MOVE_INTO_ACID]);

  if (MAYBE_DONT_COLLIDE_WITH(element))
    setDontCollideWithProperty(&level, element,
			      custom_element_properties[EP_DONT_COLLIDE_WITH]);
}

static void CopyElementPropertiesToGame(int element)
{
  if (IS_CUSTOM_ELEMENT(element))
    CopyCustomElementPropertiesToGame(element);
  else if (IS_GROUP_ELEMENT(element))
    CopyGroupElementPropertiesToGame(element);
  else
    CopyClassicElementPropertiesToGame(element);
}

void CheckElementDescriptions()
{
  int i;

  for (i = 0; i < NUM_FILE_ELEMENTS; i++)
    if (getElementDescriptionFilename(i) == NULL && !IS_OBSOLETE(i))
      Error(ERR_WARN, "no element description for element '%s'", EL_NAME(i));
}

static int getMaxEdFieldX(boolean has_scrollbar)
{
  int scrollbar_width = (has_scrollbar ? ED_SCROLLBUTTON_XSIZE : 0);
  int sxsize = SXSIZE - scrollbar_width;
  int max_ed_fieldx = sxsize / ed_tilesize;

  return max_ed_fieldx;
}

static int getMaxEdFieldY(boolean has_scrollbar)
{
  int infotext_height = INFOTEXT_YSIZE_FULL;
  int scrollbar_height = (has_scrollbar ? ED_SCROLLBUTTON_YSIZE : 0);
  int sysize = SYSIZE - scrollbar_height - infotext_height;
  int max_ed_fieldy = sysize / ed_tilesize;

  return max_ed_fieldy;
}

void InitZoomLevelSettings()
{
  MAX_ED_FIELDX = getMaxEdFieldX(FALSE);
  MAX_ED_FIELDY = getMaxEdFieldY(FALSE);
}

void DrawLevelEd()
{
  int fade_mask = REDRAW_FIELD;

  FadeSoundsAndMusic();

  if (CheckIfGlobalBorderHasChanged())
    fade_mask = REDRAW_ALL;

  FadeOut(fade_mask);

  /* needed if different viewport properties defined for editor */
  ChangeViewportPropertiesIfNeeded();

  ClearField();

  InitZoomLevelSettings();

  OpenDoor(DOOR_OPEN_1 | DOOR_OPEN_2 | DOOR_NO_DELAY);

#if DEBUG
  CheckElementDescriptions();
#endif

  if (level_editor_test_game)
  {
    CopyPlayfield(level.field, Feld);
    CopyPlayfield(FieldBackup, level.field);

    level_editor_test_game = FALSE;
  }
  else
  {
    edit_mode = ED_MODE_DRAWING;
    edit_mode_levelinfo = ED_MODE_LEVELINFO_LEVEL;
    edit_mode_properties = ED_MODE_PROPERTIES_INFO;

    ResetUndoBuffer();

    level_xpos = -1;
    level_ypos = -1;
  }

  /* needed for gadgets drawn on background (like palette scrollbar) */
  SetDoorBackgroundImage(IMG_UNDEFINED);

  /* copy default editor door content to main double buffer */
  BlitBitmap(graphic_info[IMG_BACKGROUND_PALETTE].bitmap, drawto,
	     graphic_info[IMG_BACKGROUND_PALETTE].src_x,
	     graphic_info[IMG_BACKGROUND_PALETTE].src_y,
	     DXSIZE, DYSIZE, DX, DY);

  /* draw bigger door */
  DrawSpecialEditorDoor();

  /* draw new control window */
  BlitBitmap(graphic_info[IMG_BACKGROUND_TOOLBOX].bitmap, drawto,
	     graphic_info[IMG_BACKGROUND_TOOLBOX].src_x,
	     graphic_info[IMG_BACKGROUND_TOOLBOX].src_y,
	     EXSIZE, EYSIZE, EX, EY);

  // redraw_mask |= REDRAW_ALL;

  FreeLevelEditorGadgets();
  CreateLevelEditorGadgets();

  ReinitializeElementList();		/* update dynamic level element list */
  ReinitializeElementListButtons();	/* custom element may look different */

  InitElementPropertiesGfxElement();

  UnmapAllGadgets();
  MapControlButtons();

  DrawEditModeWindow();

  DrawMaskedBorder(fade_mask);

  FadeIn(fade_mask);

  /* copy actual editor door content to door double buffer for OpenDoor() */
  BlitBitmap(drawto, bitmap_db_door_1, DX, DY, DXSIZE, DYSIZE, 0, 0);
}

static void AdjustDrawingAreaGadgets()
{
  int ed_xsize = lev_fieldx + 2;
  int ed_ysize = lev_fieldy + 2;
  int max_ed_fieldx = MAX_ED_FIELDX;
  int max_ed_fieldy = MAX_ED_FIELDY;
  boolean horizontal_scrollbar_needed;
  boolean vertical_scrollbar_needed;
  int x, y, width, height;

  /* check if we need any scrollbars */
  horizontal_scrollbar_needed = (ed_xsize > max_ed_fieldx);
  vertical_scrollbar_needed   = (ed_ysize > max_ed_fieldy);

  /* check if we have a smaller editor field because of scrollbars */
  max_ed_fieldx = getMaxEdFieldX(vertical_scrollbar_needed);
  max_ed_fieldy = getMaxEdFieldY(horizontal_scrollbar_needed);

  /* check again if we now need more scrollbars because of less space */
  horizontal_scrollbar_needed = (ed_xsize > max_ed_fieldx);
  vertical_scrollbar_needed   = (ed_ysize > max_ed_fieldy);

  /* check if editor field gets even smaller after adding new scrollbars */
  max_ed_fieldx = getMaxEdFieldX(vertical_scrollbar_needed);
  max_ed_fieldy = getMaxEdFieldY(horizontal_scrollbar_needed);

  ed_fieldx = (ed_xsize > max_ed_fieldx ? max_ed_fieldx : ed_xsize);
  ed_fieldy = (ed_ysize > max_ed_fieldy ? max_ed_fieldy : ed_ysize);

  x = SX + ed_fieldx * ed_tilesize;
  y = SY + ed_fieldy * ed_tilesize;

  width  = ed_fieldx * ed_tilesize - 2 * ED_SCROLLBUTTON_XSIZE;
  height = ed_fieldy * ed_tilesize - 2 * ED_SCROLLBUTTON_YSIZE;

  /* adjust drawing area gadget */
  ModifyGadget(level_editor_gadget[GADGET_ID_DRAWING_LEVEL],
	       GDI_AREA_SIZE, ed_fieldx, ed_fieldy,
	       GDI_ITEM_SIZE, ed_tilesize, ed_tilesize,
	       GDI_END);

  /* adjust horizontal scrollbar gadgets */
  ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_LEFT],
	       GDI_Y, y,
	       GDI_END);
  ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_RIGHT],
	       GDI_X, x - ED_SCROLLBUTTON_XSIZE,
	       GDI_Y, y,
	       GDI_END);
  ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_HORIZONTAL],
	       GDI_Y, y,
	       GDI_WIDTH, width,
	       GDI_SCROLLBAR_ITEMS_VISIBLE, ed_fieldx,
	       GDI_END);

  /* adjust vertical scrollbar gadgets */
  ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_UP],
	       GDI_X, x,
	       GDI_END);
  ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_DOWN],
	       GDI_X, x,
	       GDI_Y, y - ED_SCROLLBUTTON_YSIZE,
	       GDI_END);
  ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_VERTICAL],
	       GDI_X, x,
	       GDI_HEIGHT, height,
	       GDI_SCROLLBAR_ITEMS_VISIBLE, ed_fieldy,
	       GDI_END);
}

static void AdjustLevelScrollPosition()
{
  if (level_xpos < -1)
    level_xpos = -1;
  if (level_xpos > lev_fieldx - ed_fieldx + 1)
    level_xpos = lev_fieldx - ed_fieldx + 1;
  if (lev_fieldx < ed_fieldx - 2)
    level_xpos = -1;

  if (level_ypos < -1)
    level_ypos = -1;
  if (level_ypos > lev_fieldy - ed_fieldy + 1)
    level_ypos = lev_fieldy - ed_fieldy + 1;
  if (lev_fieldy < ed_fieldy - 2)
    level_ypos = -1;
}

static void AdjustEditorScrollbar(int id)
{
  struct GadgetInfo *gi = level_editor_gadget[id];
  int items_max, items_visible, item_position;

  if (id == GADGET_ID_SCROLL_HORIZONTAL)
  {
    items_max = MAX(lev_fieldx + 2, ed_fieldx);
    items_visible = ed_fieldx;
    item_position = level_xpos + 1;
  }
  else
  {
    items_max = MAX(lev_fieldy + 2, ed_fieldy);
    items_visible = ed_fieldy;
    item_position = level_ypos + 1;
  }

  if (item_position > items_max - items_visible)
    item_position = items_max - items_visible;

  ModifyGadget(gi, GDI_SCROLLBAR_ITEMS_MAX, items_max,
	       GDI_SCROLLBAR_ITEM_POSITION, item_position, GDI_END);
}

static void AdjustElementListScrollbar()
{
  struct GadgetInfo *gi = level_editor_gadget[GADGET_ID_SCROLL_LIST_VERTICAL];
  int items_max, items_visible, item_position;

  /* correct position of element list scrollbar */
  if (element_shift < 0)
    element_shift = 0;
  if (element_shift > num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS)
    element_shift = num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS;

  items_max = num_editor_elements / ED_ELEMENTLIST_BUTTONS_HORIZ;
  items_visible = ED_ELEMENTLIST_BUTTONS_VERT;
  item_position = element_shift / ED_ELEMENTLIST_BUTTONS_HORIZ;

  ModifyGadget(gi, GDI_SCROLLBAR_ITEMS_MAX, items_max,
	       GDI_SCROLLBAR_ITEMS_VISIBLE, items_visible,
	       GDI_SCROLLBAR_ITEM_POSITION, item_position, GDI_END);
}

static void ModifyEditorCounterValue(int counter_id, int new_value)
{
  int *counter_value = counterbutton_info[counter_id].value;
  int gadget_id = counterbutton_info[counter_id].gadget_id_text;
  struct GadgetInfo *gi = level_editor_gadget[gadget_id];

  ModifyGadget(gi, GDI_NUMBER_VALUE, new_value, GDI_END);

  if (counter_value != NULL)
    *counter_value = gi->textinput.number_value;
}

static void ModifyEditorCounterLimits(int counter_id, int min, int max)
{
  int gadget_id = counterbutton_info[counter_id].gadget_id_text;
  struct GadgetInfo *gi = level_editor_gadget[gadget_id];

  ModifyGadget(gi, GDI_NUMBER_MIN, min, GDI_NUMBER_MAX, max, GDI_END);

  if (counter_id >= ED_COUNTER_ID_ELEMENT_VALUE1 &&
      counter_id <= ED_COUNTER_ID_ELEMENT_VALUE4)
  {
    int gadget_id_up = counterbutton_info[counter_id].gadget_id_up;
    struct GadgetInfo *gi_up = level_editor_gadget[gadget_id_up];

    ModifyGadget(gi, GDI_TEXT_SIZE, (max < 10 ? 1 : 3), GDI_END);
    ModifyGadget(gi_up, GDI_X, gi->x + gi->width + ED_GADGET_SMALL_DISTANCE,
		 GDI_END);
  }
}

static void ModifyEditorSelectboxValue(int selectbox_id, int new_value)
{
  int gadget_id = selectbox_info[selectbox_id].gadget_id;
  struct GadgetInfo *gi = level_editor_gadget[gadget_id];
  int new_index_value = setSelectboxValue(selectbox_id, new_value);

  ModifyGadget(gi, GDI_SELECTBOX_INDEX, new_index_value, GDI_END);
}

static void ModifyEditorSelectboxOptions(int selectbox_id,
					 struct ValueTextInfo *options)
{
  int gadget_id = selectbox_info[selectbox_id].gadget_id;
  struct GadgetInfo *gi = level_editor_gadget[gadget_id];

  selectbox_info[selectbox_id].options = options;

  /* set index to zero -- list may be shorter now (correct later, if needed) */
  ModifyGadget(gi, GDI_SELECTBOX_INDEX, 0,
	       GDI_SELECTBOX_OPTIONS, options, GDI_END);
}

static void ModifyEditorDrawingArea(int drawingarea_id, int xsize, int ysize)
{
  int gadget_id = drawingarea_info[drawingarea_id].gadget_id;
  struct GadgetInfo *gi = level_editor_gadget[gadget_id];

  drawingarea_info[drawingarea_id].area_xsize = xsize;
  drawingarea_info[drawingarea_id].area_ysize = ysize;

  ModifyGadget(gi, GDI_AREA_SIZE, xsize, ysize, GDI_END);
}

static void ModifyEditorElementList()
{
  int i;

  for (i = 0; i < ED_NUM_ELEMENTLIST_BUTTONS; i++)
  {
    int gadget_id = GADGET_ID_ELEMENTLIST_FIRST + i;
    struct GadgetInfo *gi = level_editor_gadget[gadget_id];
    struct GadgetDesign *gd = &gi->deco.design;
    int element = editor_elements[element_shift + i];

    UnmapGadget(gi);

    getElementListGraphicSource(element, &gd->bitmap, &gd->x, &gd->y);

    ModifyGadget(gi, GDI_INFO_TEXT, getElementInfoText(element), GDI_END);

    MapGadget(gi);
  }
}

static void DrawDrawingElement(int element, struct EditorPaletteElementInfo *e)
{
  int graphic = el2edimg(element);
  int tile_size = (e->tile_size >= TILESIZE ? TILESIZE : MINI_TILESIZE);

  DrawSizedGraphicExt(drawto, DX + e->x, DY + e->y, graphic, 0, tile_size);
}

static void PickDrawingElement(int button, int element)
{
  struct
  {
    int *new_element;
    struct EditorPaletteElementInfo *e;
  } de, drawing_elements[] =
  {
    { &new_element1,	&editor.palette.element_left	},
    { &new_element2,	&editor.palette.element_middle	},
    { &new_element3,	&editor.palette.element_right	},
  };

  if (button < 1 || button > 3)
    return;

  de = drawing_elements[button - 1];

  DrawDrawingElement((*de.new_element = element), de.e);

  redraw_mask |= REDRAW_DOOR_1;
}

static void RedrawDrawingElements()
{
  PickDrawingElement(1, new_element1);
  PickDrawingElement(2, new_element2);
  PickDrawingElement(3, new_element3);
}

static void DrawDrawingWindow()
{
  stick_element_properties_window = FALSE;

  SetMainBackgroundImage(IMG_UNDEFINED);
  ClearField();

  UnmapLevelEditorFieldGadgets();
  UnmapLevelEditorToolboxCustomGadgets();

  AdjustDrawingAreaGadgets();
  AdjustLevelScrollPosition();
  AdjustEditorScrollbar(GADGET_ID_SCROLL_HORIZONTAL);
  AdjustEditorScrollbar(GADGET_ID_SCROLL_VERTICAL);

  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);

  MapMainDrawingArea();
  MapLevelEditorToolboxDrawingGadgets();
}

static int getTabulatorBarWidth()
{
  struct GadgetInfo *gd_gi1 = level_editor_gadget[GADGET_ID_PROPERTIES_INFO];
  struct GadgetInfo *gd_gi4 = level_editor_gadget[GADGET_ID_PROPERTIES_CHANGE];

  return gd_gi4->x - gd_gi1->x + gd_gi4->width;
}

static int getTabulatorBarHeight()
{
  return ED_TAB_BAR_HEIGHT;
}

static void DrawLevelInfoTabulatorGadgets()
{
  struct GadgetInfo *gd_gi1 = level_editor_gadget[GADGET_ID_LEVELINFO_LEVEL];
  struct GadgetDesign *gd = &gd_gi1->alt_design[GD_BUTTON_UNPRESSED];
  int gd_x = gd->x + gd_gi1->border.width / 2;
  int gd_y = gd->y + gd_gi1->height - 1;
  Pixel tab_color = GetPixel(gd->bitmap, gd_x, gd_y);
  int id_first = ED_TEXTBUTTON_ID_LEVELINFO_LEVEL;
  int id_last  = ED_TEXTBUTTON_ID_LEVELINFO_EDITOR;
  int i;

  for (i = id_first; i <= id_last; i++)
  {
    int gadget_id = textbutton_info[i].gadget_id;
    struct GadgetInfo *gi = level_editor_gadget[gadget_id];
    boolean active = (i != edit_mode_levelinfo);

    /* draw background line below tabulator button */
    ClearRectangleOnBackground(drawto, gi->x, gi->y + gi->height, gi->width, 1);

    /* draw solid line below inactive tabulator buttons */
    if (!active && tab_color != BLACK_PIXEL)	/* black => transparent */
      FillRectangle(drawto, gi->x, gi->y + gi->height, gi->width,
		    ED_GADGET_TINY_DISTANCE, tab_color);

    ModifyGadget(gi, GDI_ACTIVE, active, GDI_END);
    MapTextbuttonGadget(i);
  }

  /* draw little border line below tabulator buttons */
  if (tab_color != BLACK_PIXEL)			/* black => transparent */
    FillRectangle(drawto, gd_gi1->x, gd_gi1->y + gd_gi1->height +
		  ED_GADGET_TINY_DISTANCE,
		  getTabulatorBarWidth(), getTabulatorBarHeight(), tab_color);
}

static void DrawPropertiesTabulatorGadgets()
{
  struct GadgetInfo *gd_gi1 = level_editor_gadget[GADGET_ID_PROPERTIES_INFO];
  struct GadgetDesign *gd = &gd_gi1->alt_design[GD_BUTTON_UNPRESSED];
  int gd_x = gd->x + gd_gi1->border.width / 2;
  int gd_y = gd->y + gd_gi1->height - 1;
  Pixel tab_color = GetPixel(gd->bitmap, gd_x, gd_y);
  int id_first = ED_TEXTBUTTON_ID_PROPERTIES_INFO;
  int id_last  = ED_TEXTBUTTON_ID_PROPERTIES_CONFIG;
  int i;

  /* draw two config tabulators for player elements */
  if (ELEM_IS_PLAYER(properties_element))
    id_last = ED_TEXTBUTTON_ID_PROPERTIES_CONFIG_2;

  /* draw two config and one "change" tabulator for custom elements */
  if (IS_CUSTOM_ELEMENT(properties_element))
    id_last = ED_TEXTBUTTON_ID_PROPERTIES_CHANGE;

  for (i = id_first; i <= id_last; i++)
  {
    int gadget_id = textbutton_info[i].gadget_id;
    struct GadgetInfo *gi = level_editor_gadget[gadget_id];
    boolean active = (i != edit_mode_properties);

    /* use "config 1" and "config 2" instead of "config" for players and CEs */
    if (i == ED_TEXTBUTTON_ID_PROPERTIES_CONFIG &&
	(ELEM_IS_PLAYER(properties_element) ||
	 IS_CUSTOM_ELEMENT(properties_element)))
      continue;

    /* draw background line below tabulator button */
    ClearRectangleOnBackground(drawto, gi->x, gi->y + gi->height, gi->width, 1);

    /* draw solid line below inactive tabulator buttons */
    if (!active && tab_color != BLACK_PIXEL)	/* black => transparent */
      FillRectangle(drawto, gi->x, gi->y + gi->height, gi->width,
		    ED_GADGET_TINY_DISTANCE, tab_color);

    ModifyGadget(gi, GDI_ACTIVE, active, GDI_END);
    MapTextbuttonGadget(i);
  }

  /* draw little border line below tabulator buttons */
  if (tab_color != BLACK_PIXEL)			/* black => transparent */
    FillRectangle(drawto, gd_gi1->x, gd_gi1->y + gd_gi1->height +
		  ED_GADGET_TINY_DISTANCE,
		  getTabulatorBarWidth(), getTabulatorBarHeight(), tab_color);
}

static void DrawLevelInfoLevel()
{
  int i;

  /* draw counter gadgets */
  for (i = ED_COUNTER_ID_LEVEL_FIRST; i <= ED_COUNTER_ID_LEVEL_LAST; i++)
    MapCounterButtons(i);

  /* draw selectbox gadgets */
  for (i = ED_SELECTBOX_ID_LEVEL_FIRST; i <= ED_SELECTBOX_ID_LEVEL_LAST; i++)
    MapSelectboxGadget(i);

  /* draw text input gadgets */
  for (i = ED_TEXTINPUT_ID_LEVEL_FIRST; i <= ED_TEXTINPUT_ID_LEVEL_LAST; i++)
    MapTextInputGadget(i);
}

static void DrawLevelInfoEditor()
{
  int i;

  /* draw counter gadgets */
  for (i = ED_COUNTER_ID_EDITOR_FIRST; i <= ED_COUNTER_ID_EDITOR_LAST; i++)
    MapCounterButtons(i);

  /* draw checkbutton gadgets */
  for (i=ED_CHECKBUTTON_ID_EDITOR_FIRST; i<= ED_CHECKBUTTON_ID_EDITOR_LAST; i++)
    MapCheckbuttonGadget(i);

  /* draw radiobutton gadgets */
  for (i=ED_RADIOBUTTON_ID_EDITOR_FIRST; i<= ED_RADIOBUTTON_ID_EDITOR_LAST; i++)
    MapRadiobuttonGadget(i);

  /* draw drawing area */
  MapDrawingArea(ED_DRAWING_ID_RANDOM_BACKGROUND);
}

static void DrawLevelInfoWindow()
{
  char *text = "Global Settings";
  int font_nr = FONT_TITLE_1;
  struct MenuPosInfo *pos = &editor.settings.headline;
  int sx = SX + ALIGNED_XPOS(pos->x, getTextWidth(text, font_nr), pos->align);
  int sy = SY + pos->y;

  stick_element_properties_window = FALSE;

  UnmapLevelEditorFieldGadgets();

  SetMainBackgroundImage(IMG_BACKGROUND_EDITOR);
  ClearField();

  DrawText(sx, sy, text, font_nr);

  DrawLevelInfoTabulatorGadgets();

  if (edit_mode_levelinfo == ED_MODE_LEVELINFO_LEVEL)
    DrawLevelInfoLevel();
  else	/* (edit_mode_levelinfo == ED_MODE_LEVELINFO_EDITOR) */
    DrawLevelInfoEditor();
}

static void DrawCustomContentArea()
{
  int id = ED_DRAWING_ID_CUSTOM_CONTENT;
  struct GadgetInfo *gi = level_editor_gadget[drawingarea_info[id].gadget_id];
  int x1 = right_gadget_border[GADGET_ID_CUSTOM_DEADLINESS];
  int x2 = right_gadget_border[GADGET_ID_CUSTOM_EXPLOSION_TYPE];
  int x3 = right_gadget_border[GADGET_ID_CUSTOM_EXPLODE_IMPACT];
  int xoffset = ED_GADGET_SPACE_DISTANCE;

  /* add distance for potential left text (without drawing area border) */
  x2 += getTextWidthForGadget(drawingarea_info[id].text_left);

  ModifyGadget(gi, GDI_X, MAX(x1, MAX(x2, x3)) + xoffset, GDI_END);

  MapDrawingArea(ED_DRAWING_ID_CUSTOM_CONTENT);
}

static void DrawCustomChangeContentArea()
{
  int id = ED_DRAWING_ID_CUSTOM_CHANGE_CONTENT;
  struct GadgetInfo *gi = level_editor_gadget[drawingarea_info[id].gadget_id];
  int x1 = right_gadget_border[GADGET_ID_CHANGE_USE_CONTENT];
  int x2 = right_gadget_border[GADGET_ID_CHANGE_REPLACE_WHEN];
  int x3 = right_gadget_border[GADGET_ID_CHANGE_ONLY_COMPLETE];
  int xoffset = ED_GADGET_SPACE_DISTANCE;

  ModifyGadget(gi, GDI_X, MAX(x1, MAX(x2, x3)) + xoffset, GDI_END);

  MapDrawingArea(id);
}

static void RemoveElementContentArea(int id, int font_height)
{
  int border_size = ED_DRAWINGAREA_BORDER_SIZE;

  DrawBackground(SX + ED_AREA_SETTINGS_X(drawingarea_info[id]) - border_size,
		 SY + ED_AREA_SETTINGS_Y(drawingarea_info[id]) - border_size,
		 3 * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size,
		 3 * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size +
		 ED_GADGET_TEXT_DISTANCE + font_height);
}

static void DrawYamYamContentAreas()
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  int tilesize = ED_DRAWINGAREA_TILE_SIZE;
  int yoffset = (tilesize - font_height) / 2;
  int x = SX + ED_AREA_YAMYAM_CONTENT_X(3) + 4 * tilesize;
  int y = SY + ED_AREA_YAMYAM_CONTENT_Y(3) + yoffset;
  int i;

  /* display counter to choose number of element content areas */
  MapCounterButtons(ED_COUNTER_ID_YAMYAM_CONTENT);

  for (i = 0; i < MAX_ELEMENT_CONTENTS; i++)
  {
    int id = ED_DRAWING_ID_YAMYAM_CONTENT_0 + i;

    if (i < level.num_yamyam_contents)
    {
      MapDrawingArea(id);
    }
    else
    {
      UnmapDrawingArea(id);

      /* delete content areas in case of reducing number of them */
      RemoveElementContentArea(id, font_height);
    }
  }

  DrawText(x, y + 0 * tilesize, "content", font_nr);
  DrawText(x, y + 1 * tilesize, "when",    font_nr);
  DrawText(x, y + 2 * tilesize, "smashed", font_nr);
}

static void DrawMagicBallContentAreas()
{
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  int tilesize = ED_DRAWINGAREA_TILE_SIZE;
  int yoffset = (tilesize - font_height) / 2;
  int x = SX + ED_AREA_MAGIC_BALL_CONTENT_X(3) + 4 * tilesize;
  int y = SY + ED_AREA_MAGIC_BALL_CONTENT_Y(3) + yoffset;
  int i;

  /* display counter to choose number of element content areas */
  MapCounterButtons(ED_COUNTER_ID_BALL_CONTENT);

  for (i = 0; i < MAX_ELEMENT_CONTENTS; i++)
  {
    int id = ED_DRAWING_ID_MAGIC_BALL_CONTENT_0 + i;

    if (i < level.num_ball_contents)
    {
      MapDrawingArea(id);
    }
    else
    {
      UnmapDrawingArea(id);

      /* delete content areas in case of reducing number of them */
      RemoveElementContentArea(id, font_height);
    }
  }

  DrawText(x, y + 0 * tilesize, "generated", font_nr);
  DrawText(x, y + 1 * tilesize, "when",      font_nr);
  DrawText(x, y + 2 * tilesize, "active",    font_nr);
}

static void DrawAndroidElementArea(int element)
{
  int id = ED_DRAWING_ID_ANDROID_CONTENT;
  int num_elements = level.num_android_clone_elements;
  int border_size = ED_DRAWINGAREA_BORDER_SIZE;
  int sx = SX + ED_AREA_SETTINGS_X(drawingarea_info[id]) - border_size;
  int sy = SY + ED_AREA_SETTINGS_Y(drawingarea_info[id]) - border_size;
  int xsize = MAX_ANDROID_ELEMENTS;
  int ysize = 1;

  /* display counter to choose number of element areas */
  MapCounterButtons(ED_COUNTER_ID_ANDROID_CONTENT);

  if (drawingarea_info[id].text_left != NULL)
    sx += getTextWidthForDrawingArea(drawingarea_info[id].text_left);

  UnmapDrawingArea(id);

  ModifyEditorDrawingArea(id, num_elements, 1);

  /* delete content areas in case of reducing number of them */
  DrawBackground(sx, sy,
		 xsize * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size,
		 ysize * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size);

  MapDrawingArea(id);
}

static void DrawGroupElementArea(int element)
{
  int id = ED_DRAWING_ID_GROUP_CONTENT;
  int num_elements = group_element_info.num_elements;
  int border_size = ED_DRAWINGAREA_BORDER_SIZE;
  int sx = SX + ED_AREA_SETTINGS_X(drawingarea_info[id]) - border_size;
  int sy = SY + ED_AREA_SETTINGS_Y(drawingarea_info[id]) - border_size;
  int xsize = MAX_ELEMENTS_IN_GROUP;
  int ysize = 1;

  if (drawingarea_info[id].text_left != NULL)
    sx += getTextWidthForDrawingArea(drawingarea_info[id].text_left);

  UnmapDrawingArea(id);

  ModifyEditorDrawingArea(id, num_elements, 1);

  /* delete content areas in case of reducing number of them */
  DrawBackground(sx, sy,
		 xsize * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size,
		 ysize * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size);

  MapDrawingArea(id);
}

static void DrawPlayerInitialInventoryArea(int element)
{
  int id = ED_DRAWING_ID_INVENTORY_CONTENT;
  int player_nr = GET_PLAYER_NR(element);
  int num_elements = level.initial_inventory_size[player_nr];
  int border_size = ED_DRAWINGAREA_BORDER_SIZE;
  int sx = SX + ED_AREA_SETTINGS_X(drawingarea_info[id]) - border_size;
  int sy = SY + ED_AREA_SETTINGS_Y(drawingarea_info[id]) - border_size;
  int xsize = MAX_INITIAL_INVENTORY_SIZE;
  int ysize = 1;

  /* determine horizontal position to the right of specified gadget */
  if (drawingarea_info[id].gadget_id_align != GADGET_ID_NONE)
    sx = (right_gadget_border[drawingarea_info[id].gadget_id_align] +
	  ED_DRAWINGAREA_TEXT_DISTANCE);

  /* determine horizontal offset for leading text */
  if (drawingarea_info[id].text_left != NULL)
    sx += getTextWidthForDrawingArea(drawingarea_info[id].text_left);

  UnmapDrawingArea(id);

  ModifyEditorDrawingArea(id, num_elements, 1);

  /* delete content areas in case of reducing number of them */
  DrawBackground(sx, sy,
		 xsize * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size,
		 ysize * ED_DRAWINGAREA_TILE_SIZE + 2 * border_size);

  MapDrawingArea(id);
}

static void DrawEnvelopeTextArea(int envelope_nr)
{
  int id = ED_TEXTAREA_ID_ENVELOPE_INFO;
  struct GadgetInfo *gi = level_editor_gadget[textarea_info[id].gadget_id];

  UnmapGadget(gi);
  DrawBackground(gi->x, gi->y, gi->width, gi->height);

  if (envelope_nr != -1)
    textarea_info[id].value = level.envelope[envelope_nr].text;

  ModifyGadget(gi, GDI_AREA_SIZE,
	       *counterbutton_info[ED_COUNTER_ID_ENVELOPE_XSIZE].value,
	       *counterbutton_info[ED_COUNTER_ID_ENVELOPE_YSIZE].value,
	       GDI_END);

  MapTextAreaGadget(ED_TEXTAREA_ID_ENVELOPE_INFO);
}

static boolean PrintInfoText(char *text, int font_nr, int start_line)
{
  int font_height = getFontHeight(font_nr);
  int pad_x = ED_ELEMENT_SETTINGS_X(0);
  int pad_y = ED_ELEMENT_SETTINGS_Y(0) + ED_GADGET_SMALL_DISTANCE;
  int sx = SX + pad_x;
  int sy = SY + pad_y;
  int max_lines_per_screen = (SYSIZE - pad_y) / font_height - 1;

  if (start_line >= max_lines_per_screen)
    return FALSE;

  DrawText(sx, sy + start_line * font_height, text, font_nr);

  return TRUE;
}

static int PrintElementDescriptionFromFile(char *filename, int start_line)
{
  int font_nr = FONT_TEXT_2;
  int font_width = getFontWidth(font_nr);
  int font_height = getFontHeight(font_nr);
  int pad_x = ED_ELEMENT_SETTINGS_X(0);
  int pad_y = ED_ELEMENT_SETTINGS_Y(0) + ED_GADGET_SMALL_DISTANCE;
  int sx = SX + pad_x;
  int sy = SY + pad_y + start_line * font_height;
  int max_chars_per_line = (SXSIZE - 2 * pad_x) / font_width;
  int max_lines_per_screen = (SYSIZE - pad_y) / font_height - 1;
  int max_lines_drawable = max_lines_per_screen - start_line;

  if (start_line >= max_lines_per_screen)
    return FALSE;

  return DrawTextFile(sx, sy, filename, font_nr, max_chars_per_line, -1,
		      max_lines_drawable, 0, -1, TRUE, FALSE, FALSE);
}

static void DrawPropertiesInfo()
{
  static struct
  {
    int value;
    char *text;
  }
  properties[] =
  {
    /* configurable properties */

    { EP_WALKABLE_OVER,		"- player can walk over it"		},
    { EP_WALKABLE_INSIDE,	"- player can walk inside it"		},
    { EP_WALKABLE_UNDER,	"- player can walk under it"		},
    { EP_PASSABLE_OVER,		"- player can pass over it"		},
    { EP_PASSABLE_INSIDE,	"- player can pass through it"		},
    { EP_PASSABLE_UNDER,	"- player can pass under it"		},
    { EP_PROTECTED,		"- player is protected by it"		},

    { EP_DIGGABLE,		"- can be digged away"			},
    { EP_COLLECTIBLE,		"- can be collected"			},
    { EP_DROPPABLE,		"- can be dropped after collecting"	},
    { EP_THROWABLE,		"- can be thrown after collecting"	},
    { EP_PUSHABLE,		"- can be pushed"			},

    { EP_CAN_FALL,		"- can fall"				},
    { EP_CAN_MOVE,		"- can move"				},

    { EP_CAN_SMASH_PLAYER,	"- can smash player"			},
#if 0
    { EP_CAN_SMASH_ENEMIES,	"- can smash good and bad guys"		},
#endif
    { EP_CAN_SMASH_EVERYTHING,	"- can smash everything smashable"	},

    { EP_SLIPPERY,		"- slippery for falling elements"	},
    { EP_EM_SLIPPERY_WALL,	"- slippery for some gems (EM style)"	},

    { EP_DONT_RUN_INTO,		"- deadly when running into"		},
    { EP_DONT_COLLIDE_WITH,	"- deadly when colliding with"		},
    { EP_DONT_GET_HIT_BY,	"- deadly when getting hit by"		},
    { EP_DONT_TOUCH,		"- deadly when touching"		},

    { EP_INDESTRUCTIBLE,	"- indestructible"			},

    { EP_CAN_EXPLODE_BY_FIRE,	"- can explode by fire or explosions"	},
    { EP_CAN_EXPLODE_SMASHED,	"- can explode when smashed"		},
    { EP_CAN_EXPLODE_IMPACT,	"- can explode on impact"		},

    { EP_CAN_CHANGE,		"- can change to other element"		},

    /* pre-defined properties */
    { EP_CAN_PASS_MAGIC_WALL,	"- can pass magic walls"		},
    { EP_CAN_PASS_DC_MAGIC_WALL,"- can pass magic walls (DC style)"	},
    { EP_SWITCHABLE,		"- can be switched"			},
#if 0
    { EP_HAS_EDITOR_CONTENT,	"- can contain other elements"		},
#endif

    { -1,			NULL					}
  };
  char *filename = getElementDescriptionFilename(properties_element);
  char *percentage_text = "In this level: ";
  char *properties_text = "Standard properties: ";
  float percentage;
  int num_elements_in_level;
  int num_standard_properties = 0;
  int font1_nr = FONT_TEXT_1;
  int font2_nr = FONT_TEXT_2;
  int font1_width = getFontWidth(font1_nr);
  int font2_height = getFontHeight(font2_nr);
  int pad_x = ED_ELEMENT_SETTINGS_X(0);
  int pad_y = ED_ELEMENT_SETTINGS_Y(0) + ED_GADGET_SMALL_DISTANCE;
  int screen_line = 0;
  int i, x, y;

  if (setup.editor.show_element_token)
  {
    DrawTextF(pad_x, pad_y + screen_line++ * font2_height, FONT_TEXT_3,
	      "[%s]", element_info[properties_element].token_name);
    screen_line++;
  }

  /* ----- print number of elements / percentage of this element in level */

  num_elements_in_level = 0;
  for (y = 0; y < lev_fieldy; y++) 
    for (x = 0; x < lev_fieldx; x++)
      if (Feld[x][y] == properties_element)
	num_elements_in_level++;
  percentage = num_elements_in_level * 100.0 / (lev_fieldx * lev_fieldy);

  DrawTextS(pad_x, pad_y + screen_line * font2_height, font1_nr,
	    percentage_text);
  DrawTextF(pad_x + strlen(percentage_text) * font1_width,
	    pad_y + screen_line++ * font2_height, font2_nr,
	    "%d (%.2f%%)", num_elements_in_level, percentage);

  screen_line++;

  /* ----- print standard properties of this element */

  DrawTextS(pad_x, pad_y + screen_line++ * font2_height, font1_nr,
	    properties_text);

  for (i = 0; properties[i].value != -1; i++)
  {
    if (!HAS_PROPERTY(properties_element, properties[i].value))
      continue;

    DrawTextS(pad_x, pad_y + screen_line++ * font2_height, font2_nr,
	      properties[i].text);
    num_standard_properties++;
  }

  if (num_standard_properties == 0)
    DrawTextS(pad_x + strlen(properties_text) * font1_width,
	      pad_y + (screen_line - 1) * font2_height, font2_nr, "none");

  screen_line++;

  /* ----- print special description of this element */

  PrintInfoText("Description:", FONT_TEXT_1, screen_line);
  if (PrintElementDescriptionFromFile(filename, screen_line + 1) == 0)
    PrintInfoText("No description available.", FONT_TEXT_1, screen_line);
}

#define TEXT_COLLECTING		"Score for collecting"
#define TEXT_SMASHING		"Score for smashing"
#define TEXT_SLURPING		"Score for slurping robot"
#define TEXT_CRACKING		"Score for cracking"
#define TEXT_AMOEBA_SPEED	"Speed of amoeba growth"
#define TEXT_DURATION		"Duration when activated"
#define TEXT_BALL_DELAY		"Element generation delay"
#define TEXT_MOVE_SPEED		"Speed of android moving"
#define TEXT_CLONE_SPEED	"Speed of android cloning"
#define TEXT_GAME_OF_LIFE_1	"Min neighbours to survive"
#define TEXT_GAME_OF_LIFE_2	"Max neighbours to survive"
#define TEXT_GAME_OF_LIFE_3	"Min neighbours to create"
#define TEXT_GAME_OF_LIFE_4	"Max neighbours to create"
#define TEXT_TIME_BONUS		"Extra time to solve level"

static struct
{
  int element;
  int *value;
  char *text;
} elements_with_counter[] =
{
  { EL_EMERALD,		&level.score[SC_EMERALD],	TEXT_COLLECTING	},
  { EL_BD_DIAMOND,	&level.score[SC_EMERALD],	TEXT_COLLECTING	},
  { EL_EMERALD_YELLOW,	&level.score[SC_EMERALD],	TEXT_COLLECTING	},
  { EL_EMERALD_RED,	&level.score[SC_EMERALD],	TEXT_COLLECTING	},
  { EL_EMERALD_PURPLE,	&level.score[SC_EMERALD],	TEXT_COLLECTING	},
  { EL_SP_INFOTRON,	&level.score[SC_EMERALD],	TEXT_COLLECTING	},
  { EL_DIAMOND,		&level.score[SC_DIAMOND],	TEXT_COLLECTING	},
  { EL_CRYSTAL,		&level.score[SC_CRYSTAL],	TEXT_COLLECTING	},
  { EL_PEARL,		&level.score[SC_PEARL],		TEXT_COLLECTING	},
  { EL_BUG,		&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BUG_RIGHT,	&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BUG_UP,		&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BUG_LEFT,	&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BUG_DOWN,	&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BD_BUTTERFLY,	&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BD_BUTTERFLY_RIGHT,&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BD_BUTTERFLY_UP,   &level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BD_BUTTERFLY_LEFT, &level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_BD_BUTTERFLY_DOWN, &level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_SP_ELECTRON,	&level.score[SC_BUG],		TEXT_SMASHING	},
  { EL_SPACESHIP,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_SPACESHIP_RIGHT,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_SPACESHIP_UP,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_SPACESHIP_LEFT,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_SPACESHIP_DOWN,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_BD_FIREFLY,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_BD_FIREFLY_RIGHT,&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_BD_FIREFLY_UP,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_BD_FIREFLY_LEFT, &level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_BD_FIREFLY_DOWN, &level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_SP_SNIKSNAK,	&level.score[SC_SPACESHIP],	TEXT_SMASHING	},
  { EL_YAMYAM,		&level.score[SC_YAMYAM],	TEXT_SMASHING	},
  { EL_YAMYAM_LEFT,	&level.score[SC_YAMYAM],	TEXT_SMASHING	},
  { EL_YAMYAM_RIGHT,	&level.score[SC_YAMYAM],	TEXT_SMASHING	},
  { EL_YAMYAM_UP,	&level.score[SC_YAMYAM],	TEXT_SMASHING	},
  { EL_YAMYAM_DOWN,	&level.score[SC_YAMYAM],	TEXT_SMASHING	},
  { EL_DARK_YAMYAM,	&level.score[SC_YAMYAM],	TEXT_SMASHING	},
  { EL_ROBOT,		&level.score[SC_ROBOT],		TEXT_SMASHING	},
  { EL_PACMAN,		&level.score[SC_PACMAN],	TEXT_SMASHING	},
  { EL_PACMAN_RIGHT,	&level.score[SC_PACMAN],	TEXT_SMASHING	},
  { EL_PACMAN_UP,	&level.score[SC_PACMAN],	TEXT_SMASHING	},
  { EL_PACMAN_LEFT,	&level.score[SC_PACMAN],	TEXT_SMASHING	},
  { EL_PACMAN_DOWN,	&level.score[SC_PACMAN],	TEXT_SMASHING	},
  { EL_NUT,		&level.score[SC_NUT],		TEXT_CRACKING	},
  { EL_DYNAMITE,	&level.score[SC_DYNAMITE],	TEXT_COLLECTING	},
  { EL_EM_DYNAMITE,	&level.score[SC_DYNAMITE],	TEXT_COLLECTING	},
  { EL_DYNABOMB_INCREASE_NUMBER,&level.score[SC_DYNAMITE],TEXT_COLLECTING },
  { EL_DYNABOMB_INCREASE_SIZE,	&level.score[SC_DYNAMITE],TEXT_COLLECTING },
  { EL_DYNABOMB_INCREASE_POWER,	&level.score[SC_DYNAMITE],TEXT_COLLECTING },
  { EL_SHIELD_NORMAL,	&level.score[SC_SHIELD],	TEXT_COLLECTING	},
  { EL_SHIELD_DEADLY,	&level.score[SC_SHIELD],	TEXT_COLLECTING	},
  { EL_EXTRA_TIME,	&level.extra_time_score,	TEXT_COLLECTING	},
  { EL_KEY_1,		&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_KEY_2,		&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_KEY_3,		&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_KEY_4,		&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EM_KEY_1,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EM_KEY_2,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EM_KEY_3,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EM_KEY_4,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EMC_KEY_5,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EMC_KEY_6,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EMC_KEY_7,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_EMC_KEY_8,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_DC_KEY_WHITE,	&level.score[SC_KEY],		TEXT_COLLECTING	},
  { EL_AMOEBA_WET,	&level.amoeba_speed,		TEXT_AMOEBA_SPEED },
  { EL_AMOEBA_DRY,	&level.amoeba_speed,		TEXT_AMOEBA_SPEED },
  { EL_AMOEBA_FULL,	&level.amoeba_speed,		TEXT_AMOEBA_SPEED },
  { EL_BD_AMOEBA,	&level.amoeba_speed,		TEXT_AMOEBA_SPEED },
  { EL_EMC_DRIPPER,	&level.amoeba_speed,		TEXT_AMOEBA_SPEED },
  { EL_MAGIC_WALL,	&level.time_magic_wall,		TEXT_DURATION	},
  { EL_BD_MAGIC_WALL,	&level.time_magic_wall,		TEXT_DURATION	},
  { EL_DC_MAGIC_WALL,	&level.time_magic_wall,		TEXT_DURATION	},
  { EL_ROBOT_WHEEL,	&level.time_wheel,		TEXT_DURATION	},

  { EL_TIMEGATE_SWITCH,	  &level.time_timegate,		TEXT_DURATION	},
  { EL_DC_TIMEGATE_SWITCH,&level.time_timegate,		TEXT_DURATION	},
  { EL_LIGHT_SWITCH,	&level.time_light,		TEXT_DURATION	},
  { EL_LIGHT_SWITCH_ACTIVE, &level.time_light,		TEXT_DURATION	},
  { EL_SHIELD_NORMAL,	&level.shield_normal_time,	TEXT_DURATION	},
  { EL_SHIELD_DEADLY,	&level.shield_deadly_time,	TEXT_DURATION	},
  { EL_EXTRA_TIME,	&level.extra_time,		TEXT_TIME_BONUS	},
  { EL_TIME_ORB_FULL,	&level.time_orb_time,		TEXT_TIME_BONUS	},
  { EL_GAME_OF_LIFE,	&level.game_of_life[0],		TEXT_GAME_OF_LIFE_1 },
  { EL_GAME_OF_LIFE,	&level.game_of_life[1],		TEXT_GAME_OF_LIFE_2 },
  { EL_GAME_OF_LIFE,	&level.game_of_life[2],		TEXT_GAME_OF_LIFE_3 },
  { EL_GAME_OF_LIFE,	&level.game_of_life[3],		TEXT_GAME_OF_LIFE_4 },
  { EL_BIOMAZE,		&level.biomaze[0],		TEXT_GAME_OF_LIFE_1 },
  { EL_BIOMAZE,		&level.biomaze[1],		TEXT_GAME_OF_LIFE_2 },
  { EL_BIOMAZE,		&level.biomaze[2],		TEXT_GAME_OF_LIFE_3 },
  { EL_BIOMAZE,		&level.biomaze[3],		TEXT_GAME_OF_LIFE_4 },

  { EL_EMC_ANDROID,	&level.android_move_time,	TEXT_MOVE_SPEED	},
  { EL_EMC_ANDROID,	&level.android_clone_time,	TEXT_CLONE_SPEED },
  { EL_EMC_MAGIC_BALL,	&level.ball_time,		TEXT_BALL_DELAY	},
  { EL_EMC_LENSES,	&level.lenses_score,		TEXT_COLLECTING	},
  { EL_EMC_MAGNIFIER,	&level.magnify_score,		TEXT_COLLECTING	},
  { EL_SPRING,		&level.slurp_score,		TEXT_SLURPING	},
  { EL_EMC_LENSES,	&level.lenses_time,		TEXT_DURATION	},
  { EL_EMC_MAGNIFIER,	&level.magnify_time,		TEXT_DURATION	},

  { -1,			NULL,				NULL		}
};

static boolean checkPropertiesConfig(int element)
{
  int i;

  if (IS_GEM(element) ||
      IS_CUSTOM_ELEMENT(element) ||
      IS_GROUP_ELEMENT(element) ||
      IS_ENVELOPE(element) ||
      ELEM_IS_PLAYER(element) ||
      HAS_EDITOR_CONTENT(element) ||
      CAN_GROW(element) ||
      COULD_MOVE_INTO_ACID(element) ||
      MAYBE_DONT_COLLIDE_WITH(element) ||
      element == EL_SOKOBAN_OBJECT ||
      element == EL_SOKOBAN_FIELD_EMPTY ||
      element == EL_SOKOBAN_FIELD_FULL)
    return TRUE;
  else
    for (i = 0; elements_with_counter[i].element != -1; i++)
      if (elements_with_counter[i].element == element)
	return TRUE;

  return FALSE;
}

static void DrawPropertiesConfig()
{
  boolean draw_footer_line = FALSE;
  int max_num_element_counters = 4;
  int num_element_counters = 0;
  int i;

  if (!checkPropertiesConfig(properties_element))
  {
    PrintInfoText("No configuration options available.", FONT_TEXT_1, 0);

    return;
  }

  /* check if there are elements where a value can be chosen for */
  for (i = 0; elements_with_counter[i].element != -1; i++)
  {
    if (elements_with_counter[i].element == properties_element)
    {
      int counter_id = ED_COUNTER_ID_ELEMENT_VALUE1 + num_element_counters;

      counterbutton_info[counter_id].y =
	ED_ELEMENT_SETTINGS_YPOS(
		(HAS_EDITOR_CONTENT(properties_element)      ? 1 : 0) +
		(CAN_GROW(properties_element)                ? 1 : 0) +
		(COULD_MOVE_INTO_ACID(properties_element)    ? 1 : 0) +
		(MAYBE_DONT_COLLIDE_WITH(properties_element) ? 1 : 0) +
		(properties_element == EL_EMC_MAGIC_BALL     ? 2 : 0) +
		num_element_counters);

      counterbutton_info[counter_id].value = elements_with_counter[i].value;
      counterbutton_info[counter_id].text_right= elements_with_counter[i].text;

      if (properties_element == EL_GAME_OF_LIFE ||
	  properties_element == EL_BIOMAZE)
      {
	counterbutton_info[counter_id].min_value = 0;	/* min neighbours */
	counterbutton_info[counter_id].max_value = 8;	/* max neighbours */
      }
      else
      {
	/* !!! CHANGE THIS FOR CERTAIN ELEMENTS !!! */
	counterbutton_info[counter_id].min_value = MIN_SCORE;
	counterbutton_info[counter_id].max_value = MAX_SCORE;
      }

      MapCounterButtons(counter_id);

      num_element_counters++;
      if (num_element_counters >= max_num_element_counters)
	break;
    }
  }

  if (HAS_EDITOR_CONTENT(properties_element))
  {
    /* draw stickybutton gadget */
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_STICK_ELEMENT);

    if (IS_AMOEBOID(properties_element))
      MapDrawingArea(ED_DRAWING_ID_AMOEBA_CONTENT);
    else if (properties_element == EL_YAMYAM ||
	     properties_element == EL_YAMYAM_LEFT ||
	     properties_element == EL_YAMYAM_RIGHT ||
	     properties_element == EL_YAMYAM_UP ||
	     properties_element == EL_YAMYAM_DOWN)
      DrawYamYamContentAreas();
    else if (properties_element == EL_EMC_MAGIC_BALL)
    {
      DrawMagicBallContentAreas();

      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_RANDOM_BALL_CONTENT);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_INITIAL_BALL_STATE);
    }
    else if (properties_element == EL_EMC_ANDROID)
      DrawAndroidElementArea(properties_element);
  }

  if (ELEM_IS_PLAYER(properties_element))
  {
    int player_nr = GET_PLAYER_NR(properties_element);

    /* these properties can be set for every player individually */

    if (edit_mode_properties == ED_MODE_PROPERTIES_CONFIG_1)
    {
      drawingarea_info[ED_DRAWING_ID_START_ELEMENT].value =
	&level.start_element[player_nr];
      drawingarea_info[ED_DRAWING_ID_ARTWORK_ELEMENT].value =
	&level.artwork_element[player_nr];
      drawingarea_info[ED_DRAWING_ID_EXPLOSION_ELEMENT].value =
	&level.explosion_element[player_nr];

      checkbutton_info[ED_CHECKBUTTON_ID_USE_START_ELEMENT].value =
	&level.use_start_element[player_nr];
      checkbutton_info[ED_CHECKBUTTON_ID_USE_ARTWORK_ELEMENT].value =
	&level.use_artwork_element[player_nr];
      checkbutton_info[ED_CHECKBUTTON_ID_USE_EXPLOSION_ELEMENT].value =
	&level.use_explosion_element[player_nr];
      checkbutton_info[ED_CHECKBUTTON_ID_INITIAL_GRAVITY].value =
	&level.initial_player_gravity[player_nr];

      selectbox_info[ED_SELECTBOX_ID_PLAYER_SPEED].value =
	&level.initial_player_stepsize[player_nr];

      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_CAN_FALL_INTO_ACID);
      MapCheckbuttonGadget(properties_element == EL_SP_MURPHY ?
			   ED_CHECKBUTTON_ID_SP_BLOCK_LAST_FIELD :
			   ED_CHECKBUTTON_ID_BLOCK_LAST_FIELD);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_BLOCK_SNAP_FIELD);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_CONTINUOUS_SNAPPING);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_INSTANT_RELOCATION);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_SHIFTED_RELOCATION);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_LAZY_RELOCATION);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_USE_START_ELEMENT);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_USE_ARTWORK_ELEMENT);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_USE_EXPLOSION_ELEMENT);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_INITIAL_GRAVITY);
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_CAN_PASS_TO_WALKABLE);

      MapDrawingArea(ED_DRAWING_ID_START_ELEMENT);
      MapDrawingArea(ED_DRAWING_ID_ARTWORK_ELEMENT);
      MapDrawingArea(ED_DRAWING_ID_EXPLOSION_ELEMENT);

      MapSelectboxGadget(ED_SELECTBOX_ID_PLAYER_SPEED);
    }
    else if (edit_mode_properties == ED_MODE_PROPERTIES_CONFIG_2)
    {
      drawingarea_info[ED_DRAWING_ID_INVENTORY_CONTENT].value =
	&level.initial_inventory_content[player_nr][0];

      counterbutton_info[ED_COUNTER_ID_INVENTORY_SIZE].value =
	&level.initial_inventory_size[player_nr];

      checkbutton_info[ED_CHECKBUTTON_ID_USE_INITIAL_INVENTORY].value =
	&level.use_initial_inventory[player_nr];

      /* draw checkbutton gadgets */
      MapCheckbuttonGadget(ED_CHECKBUTTON_ID_USE_INITIAL_INVENTORY);

      /* draw counter gadgets */
      MapCounterButtons(ED_COUNTER_ID_INVENTORY_SIZE);

      /* draw drawing area gadgets */
      DrawPlayerInitialInventoryArea(properties_element);
    }
  }

  if (IS_GEM(properties_element))
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_EM_SLIPPERY_GEMS);

  if (properties_element == EL_EM_DYNAMITE)
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_EM_EXPLODES_BY_FIRE);

  if (COULD_MOVE_INTO_ACID(properties_element) &&
      !ELEM_IS_PLAYER(properties_element) &&
      (!IS_CUSTOM_ELEMENT(properties_element) ||
       edit_mode_properties == ED_MODE_PROPERTIES_CONFIG_2))
  {
    /* set position for checkbutton for "can move into acid" */
    checkbutton_info[ED_CHECKBUTTON_ID_CAN_MOVE_INTO_ACID].x =
      ED_ELEMENT_SETTINGS_XPOS(IS_CUSTOM_ELEMENT(properties_element) ? 1 : 0);
    checkbutton_info[ED_CHECKBUTTON_ID_CAN_MOVE_INTO_ACID].y =
      ED_ELEMENT_SETTINGS_YPOS(IS_CUSTOM_ELEMENT(properties_element) ? 6 :
		       HAS_EDITOR_CONTENT(properties_element) ? 1 : 0);

    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_CAN_MOVE_INTO_ACID);
  }

  if (MAYBE_DONT_COLLIDE_WITH(properties_element))
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_DONT_COLLIDE_WITH);

  if (properties_element == EL_SPRING)
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_USE_SPRING_BUG);

  if (properties_element == EL_TIME_ORB_FULL)
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_USE_TIME_ORB_BUG);

  if (CAN_GROW(properties_element))
  {
    checkbutton_info[ED_CHECKBUTTON_ID_GROW_INTO_DIGGABLE].y =
      ED_ELEMENT_SETTINGS_YPOS(HAS_EDITOR_CONTENT(properties_element) ? 1 : 0);

    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_GROW_INTO_DIGGABLE);
  }

  if (properties_element == EL_SOKOBAN_OBJECT ||
      properties_element == EL_SOKOBAN_FIELD_EMPTY ||
      properties_element == EL_SOKOBAN_FIELD_FULL)
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_AUTO_EXIT_SOKOBAN);

  if (IS_ENVELOPE(properties_element))
  {
    int counter1_id = ED_COUNTER_ID_ENVELOPE_XSIZE;
    int counter2_id = ED_COUNTER_ID_ENVELOPE_YSIZE;
    int button1_id = ED_CHECKBUTTON_ID_ENVELOPE_AUTOWRAP;
    int button2_id = ED_CHECKBUTTON_ID_ENVELOPE_CENTERED;
    int envelope_nr = properties_element - EL_ENVELOPE_1;

    counterbutton_info[counter1_id].value = &level.envelope[envelope_nr].xsize;
    counterbutton_info[counter2_id].value = &level.envelope[envelope_nr].ysize;

    checkbutton_info[button1_id].value = &level.envelope[envelope_nr].autowrap;
    checkbutton_info[button2_id].value = &level.envelope[envelope_nr].centered;

    /* display counter to choose size of envelope text area */
    MapCounterButtons(counter1_id);
    MapCounterButtons(counter2_id);

    /* display checkbuttons to choose auto-wrap and alignment properties */
    MapCheckbuttonGadget(button1_id);
    MapCheckbuttonGadget(button2_id);

    DrawEnvelopeTextArea(envelope_nr);
  }

  if (IS_CUSTOM_ELEMENT(properties_element))
  {
    /* draw stickybutton gadget */
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_STICK_ELEMENT);

    if (edit_mode_properties == ED_MODE_PROPERTIES_CONFIG_1)
    {
      /* draw checkbutton gadgets */
      for (i =  ED_CHECKBUTTON_ID_CUSTOM1_FIRST;
	   i <= ED_CHECKBUTTON_ID_CUSTOM1_LAST; i++)
	MapCheckbuttonGadget(i);

      /* draw counter gadgets */
      for (i =  ED_COUNTER_ID_CUSTOM1_FIRST;
	   i <= ED_COUNTER_ID_CUSTOM1_LAST; i++)
	MapCounterButtons(i);

      /* draw selectbox gadgets */
      for (i =  ED_SELECTBOX_ID_CUSTOM1_FIRST;
	   i <= ED_SELECTBOX_ID_CUSTOM1_LAST; i++)
	MapSelectboxGadget(i);

      /* draw textbutton gadgets */
      MapTextbuttonGadget(ED_TEXTBUTTON_ID_SAVE_AS_TEMPLATE);

      /* draw text input gadgets */
      MapTextInputGadget(ED_TEXTINPUT_ID_ELEMENT_NAME);

      /* draw drawing area gadgets */
      MapDrawingArea(ED_DRAWING_ID_CUSTOM_GRAPHIC);

      draw_footer_line = TRUE;
    }
    else if (edit_mode_properties == ED_MODE_PROPERTIES_CONFIG_2)
    {
      /* draw checkbutton gadgets */
      for (i =  ED_CHECKBUTTON_ID_CUSTOM2_FIRST;
	   i <= ED_CHECKBUTTON_ID_CUSTOM2_LAST; i++)
	MapCheckbuttonGadget(i);

      /* draw counter gadgets */
      for (i =  ED_COUNTER_ID_CUSTOM2_FIRST;
	   i <= ED_COUNTER_ID_CUSTOM2_LAST; i++)
	MapCounterButtons(i);

      /* draw selectbox gadgets */
      for (i =  ED_SELECTBOX_ID_CUSTOM2_FIRST;
	   i <= ED_SELECTBOX_ID_CUSTOM2_LAST; i++)
	MapSelectboxGadget(i);

      /* draw drawing area gadgets */
      MapDrawingArea(ED_DRAWING_ID_CUSTOM_MOVE_ENTER);
      MapDrawingArea(ED_DRAWING_ID_CUSTOM_MOVE_LEAVE);
      DrawCustomContentArea();
    }
  }
  else if (IS_GROUP_ELEMENT(properties_element))
  {
    /* draw stickybutton gadget */
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_STICK_ELEMENT);

    /* draw checkbutton gadgets */
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_CUSTOM_USE_GRAPHIC);
    MapCheckbuttonGadget(ED_CHECKBUTTON_ID_CUSTOM_USE_TEMPLATE);

    /* draw counter gadgets */
    MapCounterButtons(ED_COUNTER_ID_GROUP_CONTENT);

    /* draw selectbox gadgets */
    MapSelectboxGadget(ED_SELECTBOX_ID_GROUP_CHOICE_MODE);

    /* draw textbutton gadgets */
    MapTextbuttonGadget(ED_TEXTBUTTON_ID_SAVE_AS_TEMPLATE);

    /* draw drawing area gadgets */
    DrawGroupElementArea(properties_element);

    /* draw text input gadgets */
    MapTextInputGadget(ED_TEXTINPUT_ID_ELEMENT_NAME);

    /* draw drawing area gadgets */
    MapDrawingArea(ED_DRAWING_ID_CUSTOM_GRAPHIC);

    draw_footer_line = TRUE;
  }

  /* draw little footer border line above CE/GE use/save template gadgets */
  if (draw_footer_line)
  {
    struct GadgetInfo *gd_gi1 = level_editor_gadget[GADGET_ID_PROPERTIES_INFO];
    struct GadgetDesign *gd = &gd_gi1->alt_design[GD_BUTTON_UNPRESSED];
    int gd_x = gd->x + gd_gi1->border.width / 2;
    int gd_y = gd->y + gd_gi1->height - 1;
    Pixel tab_color = GetPixel(gd->bitmap, gd_x, gd_y);

    if (tab_color != BLACK_PIXEL)		/* black => transparent */
      FillRectangle(drawto,
		    SX + ED_ELEMENT_SETTINGS_X(0),
		    SY + ED_ELEMENT_SETTINGS_Y(14) - ED_SETTINGS_TABS_YOFFSET -
		    ED_TAB_BAR_HEIGHT,
		    getTabulatorBarWidth(), getTabulatorBarHeight(), tab_color);
  }
}

static void DrawPropertiesChangeDrawingAreas()
{
  if (IS_CUSTOM_ELEMENT(properties_element))
  {
    MapDrawingArea(ED_DRAWING_ID_CUSTOM_CHANGE_TARGET);
    MapDrawingArea(ED_DRAWING_ID_CUSTOM_CHANGE_TRIGGER);
    MapDrawingArea(ED_DRAWING_ID_CUSTOM_CHANGE_ACTION);

    DrawCustomChangeContentArea();
  }

  redraw_mask |= REDRAW_FIELD;
}

static void DrawPropertiesChange()
{
  int i;

  /* needed to initially set selectbox options for special action options */
  setSelectboxSpecialActionOptions();

  /* draw stickybutton gadget */
  MapCheckbuttonGadget(ED_CHECKBUTTON_ID_STICK_ELEMENT);

  /* draw checkbutton gadgets */
  for (i =  ED_CHECKBUTTON_ID_CHANGE_FIRST;
       i <= ED_CHECKBUTTON_ID_CHANGE_LAST; i++)
    MapCheckbuttonGadget(i);

  /* draw counter gadgets */
  for (i =  ED_COUNTER_ID_CHANGE_FIRST;
       i <= ED_COUNTER_ID_CHANGE_LAST; i++)
    MapCounterButtons(i);

  /* draw selectbox gadgets */
  for (i =  ED_SELECTBOX_ID_CHANGE_FIRST;
       i <= ED_SELECTBOX_ID_CHANGE_LAST; i++)
    MapSelectboxGadget(i);

  /* draw textbutton gadgets */
  for (i =  ED_TEXTBUTTON_ID_CHANGE_FIRST;
       i <= ED_TEXTBUTTON_ID_CHANGE_LAST; i++)
    MapTextbuttonGadget(i);

  /* draw graphicbutton gadgets */
  for (i =  ED_GRAPHICBUTTON_ID_CHANGE_FIRST;
       i <= ED_GRAPHICBUTTON_ID_CHANGE_LAST; i++)
    MapGraphicbuttonGadget(i);

  /* draw drawing area gadgets */
  DrawPropertiesChangeDrawingAreas();
}

static void DrawEditorElementAnimation(int x, int y)
{
  int graphic = el2img(properties_element);
  int frame = (ANIM_MODE(graphic) == ANIM_CE_VALUE ?
	       custom_element.ce_value_fixed_initial :
	       ANIM_MODE(graphic) == ANIM_CE_SCORE ?
	       custom_element.collect_score_initial : FrameCounter);

  DrawFixedGraphicAnimationExt(drawto, x, y, graphic, frame, NO_MASKING);
}

static void DrawEditorElementName(int x, int y, int font_nr)
{
  char *element_name = getElementInfoText(properties_element);
  int font_width = getFontWidth(font_nr);
  int font_height = getFontHeight(font_nr);
  int max_text_width = SXSIZE - x - ED_ELEMENT_SETTINGS_X(0);
  int max_chars_per_line = max_text_width / font_width;
  char buffer[max_chars_per_line + 1];

  if (strlen(element_name) <= max_chars_per_line)
    DrawTextS(x, y, font_nr, element_name);
  else
  {
    int next_pos = max_chars_per_line;

    strncpy(buffer, element_name, max_chars_per_line);
    buffer[max_chars_per_line] = '\0';

    if (element_name[max_chars_per_line] == ' ')
      next_pos++;
    else
    {
      int i;

      for (i = max_chars_per_line - 1; i >= 0; i--)
	if (buffer[i] == ' ')
	  break;

      if (strlen(&element_name[i + 1]) <= max_chars_per_line)
      {
	buffer[i] = '\0';
	next_pos = i + 1;
      }
    }

    DrawTextS(x, y - font_height / 2, font_nr, buffer);

    strncpy(buffer, &element_name[next_pos], max_chars_per_line);
    buffer[max_chars_per_line] = '\0';

    DrawTextS(x, y + font_height / 2, font_nr, buffer);
  }
}

static void DrawPropertiesWindow()
{
  struct GraphicInfo *gd = &graphic_info[IMG_EDITOR_INPUT_TEXT];
  int element_border = graphic_info[IMG_EDITOR_ELEMENT_BORDER].border_size;
  int border_size = gd->border_size;
  int font_nr = FONT_TEXT_1;
  int font_height = getFontHeight(font_nr);
  int xoffset = TILEX + element_border + 3 * border_size;
  int yoffset = (TILEY - font_height) / 2;
  int x1 = editor.settings.element_graphic.x + element_border;
  int y1 = editor.settings.element_graphic.y + element_border;
  int x2 = (editor.settings.element_name.x == -1 ? x1 + xoffset :
	    editor.settings.element_name.x);
  int y2 = (editor.settings.element_name.y == -1 ? y1 + yoffset :
	    editor.settings.element_name.y);
  char *text = "Element Settings";
  int font2_nr = FONT_TITLE_1;
  struct MenuPosInfo *pos = &editor.settings.headline;
  int sx = SX + ALIGNED_XPOS(pos->x, getTextWidth(text, font2_nr), pos->align);
  int sy = SY + pos->y;

  stick_element_properties_window = FALSE;

  /* make sure that previous properties edit mode exists for this element */
  if (edit_mode_properties > ED_MODE_PROPERTIES_CONFIG_2 &&
      !IS_CUSTOM_ELEMENT(properties_element))
    edit_mode_properties = ED_MODE_PROPERTIES_CONFIG_2;

  if (edit_mode_properties > ED_MODE_PROPERTIES_CONFIG &&
      !ELEM_IS_PLAYER(properties_element) &&
      !IS_CUSTOM_ELEMENT(properties_element))
    edit_mode_properties = ED_MODE_PROPERTIES_CONFIG;

  if (edit_mode_properties == ED_MODE_PROPERTIES_CONFIG &&
      (ELEM_IS_PLAYER(properties_element) ||
       IS_CUSTOM_ELEMENT(properties_element)))
    edit_mode_properties = ED_MODE_PROPERTIES_CONFIG_1;

  CopyElementPropertiesToEditor(properties_element);

  UnmapLevelEditorFieldGadgets();
  UnmapLevelEditorToolboxDrawingGadgets();
  UnmapLevelEditorToolboxCustomGadgets();

  if (IS_CUSTOM_ELEMENT(properties_element) ||
      IS_GROUP_ELEMENT(properties_element))
    MapLevelEditorToolboxCustomGadgets();

  SetMainBackgroundImage(IMG_BACKGROUND_EDITOR);
  ClearField();

  DrawText(sx, sy, text, font2_nr);

  FrameCounter = 0;	/* restart animation frame counter */

  DrawElementBorder(SX + x1, SY + y1, TILEX, TILEY, FALSE);
  DrawEditorElementAnimation(SX + x1, SY + y1);
  DrawEditorElementName(x2, y2, font_nr);

  DrawPropertiesTabulatorGadgets();

  if (edit_mode_properties == ED_MODE_PROPERTIES_INFO)
    DrawPropertiesInfo();
  else if (edit_mode_properties == ED_MODE_PROPERTIES_CHANGE)
    DrawPropertiesChange();
  else	/* (edit_mode_properties == ED_MODE_PROPERTIES_CONFIG[_1|_2]) */
    DrawPropertiesConfig();
}

static void UpdateCustomElementGraphicGadgets()
{
  struct ElementInfo *ei = &element_info[properties_element];
  int i;

  ei->gfx_element = (ei->use_gfx_element ? ei->gfx_element_initial :
		     properties_element);

  ModifyEditorElementList();
  RedrawDrawingElements();

  /* force redraw of all mapped drawing area gadgets */
  for (i = 0; i < ED_NUM_DRAWING_AREAS; i++)
  {
    struct GadgetInfo *gi = level_editor_gadget[drawingarea_info[i].gadget_id];

    if (gi->mapped)
      MapDrawingArea(i);
  }
}

static int getOpenDirectionFromTube(int element)
{
  switch (element)
  {
    case EL_TUBE_LEFT_UP:		return (MV_LEFT | MV_UP);
    case EL_TUBE_LEFT_DOWN:		return (MV_LEFT | MV_DOWN);
    case EL_TUBE_RIGHT_UP:		return (MV_RIGHT | MV_UP);
    case EL_TUBE_RIGHT_DOWN:		return (MV_RIGHT | MV_DOWN);
    case EL_TUBE_HORIZONTAL:		return (MV_HORIZONTAL);
    case EL_TUBE_HORIZONTAL_UP:		return (MV_HORIZONTAL | MV_UP);
    case EL_TUBE_HORIZONTAL_DOWN:	return (MV_HORIZONTAL | MV_DOWN);
    case EL_TUBE_VERTICAL:		return (MV_VERTICAL);
    case EL_TUBE_VERTICAL_LEFT:		return (MV_VERTICAL | MV_LEFT);
    case EL_TUBE_VERTICAL_RIGHT:	return (MV_VERTICAL | MV_RIGHT);
    case EL_TUBE_ANY:			return (MV_ANY_DIRECTION);
  }

  return MV_NONE;
}

static int getTubeFromOpenDirection(int direction)
{
  switch (direction)
  {
    case (MV_LEFT | MV_UP):		return EL_TUBE_LEFT_UP;
    case (MV_LEFT | MV_DOWN):		return EL_TUBE_LEFT_DOWN;
    case (MV_RIGHT | MV_UP):		return EL_TUBE_RIGHT_UP;
    case (MV_RIGHT | MV_DOWN):		return EL_TUBE_RIGHT_DOWN;
    case (MV_HORIZONTAL):		return EL_TUBE_HORIZONTAL;
    case (MV_HORIZONTAL | MV_UP):	return EL_TUBE_HORIZONTAL_UP;
    case (MV_HORIZONTAL | MV_DOWN):	return EL_TUBE_HORIZONTAL_DOWN;
    case (MV_VERTICAL):			return EL_TUBE_VERTICAL;
    case (MV_VERTICAL | MV_LEFT):	return EL_TUBE_VERTICAL_LEFT;
    case (MV_VERTICAL | MV_RIGHT):	return EL_TUBE_VERTICAL_RIGHT;
    case (MV_ANY_DIRECTION):		return EL_TUBE_ANY;

    /* if only one direction, fall back to simple tube with that direction */
    case (MV_LEFT):			return EL_TUBE_HORIZONTAL;
    case (MV_RIGHT):			return EL_TUBE_HORIZONTAL;
    case (MV_UP):			return EL_TUBE_VERTICAL;
    case (MV_DOWN):			return EL_TUBE_VERTICAL;
  }

  return EL_EMPTY;
}

static int getTubeFromOpenDirectionNotEmpty(int direction, int element_old)
{
  int element_new = getTubeFromOpenDirection(direction);

  return (element_new != EL_EMPTY ? element_new : element_old);
}

static int getOpenDirectionFromBelt(int element)
{
  int belt_dir = getBeltDirFromBeltElement(element);

  return (belt_dir == MV_LEFT ? MV_RIGHT :
	  belt_dir == MV_RIGHT ? MV_LEFT :
	  belt_dir == MV_NONE ? MV_HORIZONTAL : belt_dir);
}

static int getBeltFromNrAndOpenDirection(int nr, int direction)
{
  int belt_dir = (direction == MV_LEFT ? MV_RIGHT :
		  direction == MV_RIGHT ? MV_LEFT :
		  direction == MV_HORIZONTAL ? MV_NONE : direction);

  if (direction == MV_NONE)
    return EL_EMPTY;

  return getBeltElementFromBeltNrAndBeltDir(nr, belt_dir);
}

static int getBeltFromNrAndOpenDirectionNotEmpty(int nr, int direction,
						 int element_old)
{
  int element_new = getBeltFromNrAndOpenDirection(nr, direction);

  return (element_new != EL_EMPTY ? element_new : element_old);
}

static int getOpenDirectionFromPool(int element)
{
  switch (element)
  {
    case EL_ACID_POOL_TOPLEFT:		return (MV_DOWN | MV_RIGHT);
    case EL_ACID_POOL_TOPRIGHT:		return (MV_DOWN | MV_LEFT);
    case EL_ACID_POOL_BOTTOMLEFT:	return (MV_UP | MV_RIGHT);
    case EL_ACID_POOL_BOTTOMRIGHT:	return (MV_UP | MV_LEFT);
    case EL_ACID_POOL_BOTTOM:		return (MV_HORIZONTAL | MV_UP);
    case EL_ACID:			return (MV_HORIZONTAL | MV_DOWN);
  }

  return MV_NONE;
}

static int getPoolFromOpenDirection(int direction)
{
  switch (direction)
  {
    case (MV_DOWN | MV_RIGHT):		return EL_ACID_POOL_TOPLEFT;
    case (MV_DOWN | MV_LEFT):		return EL_ACID_POOL_TOPRIGHT;
    case (MV_UP | MV_RIGHT):		return EL_ACID_POOL_BOTTOMLEFT;
    case (MV_UP | MV_LEFT):		return EL_ACID_POOL_BOTTOMRIGHT;
    case (MV_HORIZONTAL | MV_UP):	return EL_ACID_POOL_BOTTOM;
    case (MV_HORIZONTAL | MV_DOWN):	return EL_ACID;
  }

  return EL_EMPTY;
}

static int getPoolFromOpenDirectionExt(int direction, int help_element)
{
  int element = getPoolFromOpenDirection(direction);
  int help_direction = getOpenDirectionFromPool(help_element);

  if (element == EL_EMPTY)
  {
    int help_direction_vertical = help_direction & MV_VERTICAL;

    element = getPoolFromOpenDirection(direction | help_direction_vertical);
  }

  if (element == EL_EMPTY)
  {
    int help_direction_horizontal = help_direction & MV_HORIZONTAL;

    element = getPoolFromOpenDirection(direction | help_direction_horizontal);
  }

  return element;
}

static int getPoolFromOpenDirectionNotEmpty(int direction, int element_old)
{
  int element_new = getPoolFromOpenDirectionExt(direction, element_old);

  return (element_new != EL_EMPTY ? element_new : element_old);
}

static int getOpenDirectionFromPillar(int element)
{
  switch (element)
  {
    case EL_EMC_WALL_1:			return (MV_DOWN);
    case EL_EMC_WALL_2:			return (MV_VERTICAL);
    case EL_EMC_WALL_3:			return (MV_UP);
  }

  return MV_NONE;
}

static int getPillarFromOpenDirection(int direction)
{
  switch (direction)
  {
    case (MV_DOWN):			return EL_EMC_WALL_1;
    case (MV_VERTICAL):			return EL_EMC_WALL_2;
    case (MV_UP):			return EL_EMC_WALL_3;
  }

  return EL_EMPTY;
}

static int getPillarFromOpenDirectionNotEmpty(int direction, int element_old)
{
  int element_new = getPillarFromOpenDirection(direction);

  return (element_new != EL_EMPTY ? element_new : element_old);
}

static int getOpenDirectionFromSteel2(int element)
{
  switch (element)
  {
    case EL_DC_STEELWALL_2_LEFT:	return (MV_RIGHT);
    case EL_DC_STEELWALL_2_RIGHT:	return (MV_LEFT);
    case EL_DC_STEELWALL_2_TOP:		return (MV_DOWN);
    case EL_DC_STEELWALL_2_BOTTOM:	return (MV_UP);
    case EL_DC_STEELWALL_2_HORIZONTAL:	return (MV_HORIZONTAL);
    case EL_DC_STEELWALL_2_VERTICAL:	return (MV_VERTICAL);
    case EL_DC_STEELWALL_2_MIDDLE:	return (MV_ANY_DIRECTION);
    case EL_DC_STEELWALL_2_SINGLE:	return (MV_NONE);
  }

  return MV_NONE;
}

static int getSteel2FromOpenDirection(int direction)
{
  switch (direction)
  {
    case (MV_RIGHT):			return EL_DC_STEELWALL_2_LEFT;
    case (MV_LEFT):			return EL_DC_STEELWALL_2_RIGHT;
    case (MV_DOWN):			return EL_DC_STEELWALL_2_TOP;
    case (MV_UP):			return EL_DC_STEELWALL_2_BOTTOM;
    case (MV_HORIZONTAL):		return EL_DC_STEELWALL_2_HORIZONTAL;
    case (MV_VERTICAL):			return EL_DC_STEELWALL_2_VERTICAL;
    case (MV_ANY_DIRECTION):		return EL_DC_STEELWALL_2_MIDDLE;
    case (MV_NONE):			return EL_DC_STEELWALL_2_SINGLE;
  }

  return EL_EMPTY;
}

static int getSteel2FromOpenDirectionNotEmpty(int direction, int element_old)
{
  int element_new = getSteel2FromOpenDirection(direction);

  return (element_new != EL_EMPTY ? element_new : element_old);
}

static int getOpenDirectionFromChip(int element)
{
  switch (element)
  {
    case EL_SP_CHIP_SINGLE:		return (MV_NONE);
    case EL_SP_CHIP_LEFT:		return (MV_RIGHT);
    case EL_SP_CHIP_RIGHT:		return (MV_LEFT);
    case EL_SP_CHIP_TOP:		return (MV_DOWN);
    case EL_SP_CHIP_BOTTOM:		return (MV_UP);
  }

  return MV_NONE;
}

static int getChipFromOpenDirection(int direction)
{
  switch (direction)
  {
    case (MV_NONE):			return EL_SP_CHIP_SINGLE;
    case (MV_LEFT):			return EL_SP_CHIP_RIGHT;
    case (MV_RIGHT):			return EL_SP_CHIP_LEFT;
    case (MV_UP):			return EL_SP_CHIP_BOTTOM;
    case (MV_DOWN):			return EL_SP_CHIP_TOP;
  }

  return EL_EMPTY;
}

static int getChipFromOpenDirectionNotEmpty(int direction, int element_old)
{
  int element_new = getChipFromOpenDirection(direction);

  return (element_new != EL_EMPTY ? element_new : element_old);
}

static int getClosedTube(int x, int y)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  int element_old = IntelliDrawBuffer[x][y];
  int direction_old = getOpenDirectionFromTube(element_old);
  int direction_new = MV_NONE;
  int i;

  for (i = 0; i < NUM_DIRECTIONS; i++)
  {
    int xx = x + xy[i][0];
    int yy = y + xy[i][1];
    int dir = MV_DIR_FROM_BIT(i);
    int dir_opposite = MV_DIR_OPPOSITE(dir);

    if (IN_LEV_FIELD(xx, yy) && IS_TUBE(IntelliDrawBuffer[xx][yy]) &&
	(direction_old & dir) &&
	(getOpenDirectionFromTube(IntelliDrawBuffer[xx][yy]) & dir_opposite))
      direction_new |= dir;
  }

  return getTubeFromOpenDirectionNotEmpty(direction_new, element_old);
}

static int getClosedBelt(int x, int y)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  int element_old = IntelliDrawBuffer[x][y];
  int nr = getBeltNrFromBeltElement(element_old);
  int direction_old = getOpenDirectionFromBelt(element_old);
  int direction_new = MV_NONE;
  int i;

  for (i = MV_BIT_LEFT; i <= MV_BIT_RIGHT; i++)
  {
    int xx = x + xy[i][0];
    int yy = y + xy[i][1];
    int dir = MV_DIR_FROM_BIT(i);
    int dir_opposite = MV_DIR_OPPOSITE(dir);

    if (IN_LEV_FIELD(xx, yy) && IS_BELT(IntelliDrawBuffer[xx][yy]) &&
	(direction_old & dir) &&
	(getOpenDirectionFromBelt(IntelliDrawBuffer[xx][yy]) & dir_opposite))
      direction_new |= dir;
  }

  return getBeltFromNrAndOpenDirection(nr, direction_new);
}

static int getClosedPool(int x, int y)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  int element_old = IntelliDrawBuffer[x][y];
  int direction_old = getOpenDirectionFromPool(element_old);
  int direction_new = MV_NONE;
  int i;

  for (i = 0; i < NUM_DIRECTIONS; i++)
  {
    int xx = x + xy[i][0];
    int yy = y + xy[i][1];
    int dir = MV_DIR_FROM_BIT(i);
    int dir_opposite = MV_DIR_OPPOSITE(dir);

    if (IN_LEV_FIELD(xx, yy) &&
	IS_ACID_POOL_OR_ACID(IntelliDrawBuffer[xx][yy]) &&
	(direction_old & dir) &&
	(getOpenDirectionFromPool(IntelliDrawBuffer[xx][yy]) & dir_opposite))
      direction_new |= dir;
  }

  return getPoolFromOpenDirectionNotEmpty(direction_new, element_old);
}

static int getClosedPillar(int x, int y)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  int element_old = IntelliDrawBuffer[x][y];
  int direction_old = getOpenDirectionFromPillar(element_old);
  int direction_new = MV_NONE;
  int i;

  for (i = MV_BIT_UP; i <= MV_BIT_DOWN; i++)
  {
    int xx = x + xy[i][0];
    int yy = y + xy[i][1];
    int dir = MV_DIR_FROM_BIT(i);
    int dir_opposite = MV_DIR_OPPOSITE(dir);

    if (IN_LEV_FIELD(xx, yy) && IS_EMC_PILLAR(IntelliDrawBuffer[xx][yy]) &&
	(direction_old & dir) &&
	(getOpenDirectionFromPillar(IntelliDrawBuffer[xx][yy]) & dir_opposite))
      direction_new |= dir;
  }

  return getPillarFromOpenDirectionNotEmpty(direction_new, element_old);
}

static int getClosedSteel2(int x, int y)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  int element_old = IntelliDrawBuffer[x][y];
  int direction_old = getOpenDirectionFromSteel2(element_old);
  int direction_new = MV_NONE;
  int i;

  for (i = 0; i < NUM_DIRECTIONS; i++)
  {
    int xx = x + xy[i][0];
    int yy = y + xy[i][1];
    int dir = MV_DIR_FROM_BIT(i);
    int dir_opposite = MV_DIR_OPPOSITE(dir);

    if (IN_LEV_FIELD(xx, yy) && IS_DC_STEELWALL_2(IntelliDrawBuffer[xx][yy]) &&
	(direction_old & dir) &&
	(getOpenDirectionFromSteel2(IntelliDrawBuffer[xx][yy]) & dir_opposite))
      direction_new |= dir;
  }

  return getSteel2FromOpenDirectionNotEmpty(direction_new, element_old);
}

static int getClosedChip(int x, int y)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  int element_old = IntelliDrawBuffer[x][y];
  int direction_old = getOpenDirectionFromChip(element_old);
  int direction_new = MV_NONE;
  int i;

  for (i = 0; i < NUM_DIRECTIONS; i++)
  {
    int xx = x + xy[i][0];
    int yy = y + xy[i][1];
    int dir = MV_DIR_FROM_BIT(i);
    int dir_opposite = MV_DIR_OPPOSITE(dir);

    if (IN_LEV_FIELD(xx, yy) && IS_SP_CHIP(IntelliDrawBuffer[xx][yy]) &&
	(direction_old & dir) &&
	(getOpenDirectionFromChip(IntelliDrawBuffer[xx][yy]) & dir_opposite))
      direction_new |= dir;
  }

  return getChipFromOpenDirectionNotEmpty(direction_new, element_old);
}

static void SetElementSimple(int x, int y, int element, boolean change_level)
{
  int sx = x - level_xpos;
  int sy = y - level_ypos;

  IntelliDrawBuffer[x][y] = element;

  if (change_level)
    Feld[x][y] = element;

  if (IN_ED_FIELD(sx, sy))
    DrawEditorElement(sx, sy, element);
}

static void MergeAndCloseNeighbourElements(int x1, int y1, int *element1,
					   int x2, int y2, int *element2,
					   int (*close_function)(int, int),
					   boolean change_level)
{
  /* set neighbour elements to newly determined connections */
  SetElementSimple(x1, y1, *element1, change_level);
  SetElementSimple(x2, y2, *element2, change_level);

  /* remove all open connections of neighbour elements */
  *element1 = close_function(x1, y1);
  *element2 = close_function(x2, y2);

  /* set neighbour elements to new, minimized connections */
  SetElementSimple(x1, y1, *element1, change_level);
  SetElementSimple(x2, y2, *element2, change_level);
}

static void SetElementIntelliDraw(int x, int y, int new_element,
				  boolean change_level, int button)
{
  static int xy[4][2] =
  {
    { -1, 0 },
    { +1, 0 },
    { 0, -1 },
    { 0, +1 }
  };
  static int last_x = -1;
  static int last_y = -1;
  int old_element = IntelliDrawBuffer[x][y];

  if (new_element == EL_UNDEFINED)
  {
    last_x = -1;
    last_y = -1;

    return;
  }

  if (IS_TUBE(new_element))
  {
    int last_element_new = EL_UNDEFINED;
    int direction = MV_NONE;
    int i;

    /* if old element is of same kind, keep all existing directions */
    if (IS_TUBE(old_element))
      direction |= getOpenDirectionFromTube(old_element);

    for (i = 0; i < NUM_DIRECTIONS; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_TUBE(IntelliDrawBuffer[last_x][last_y]))
      {
	int dir = MV_DIR_FROM_BIT(i);
	int dir_opposite = MV_DIR_OPPOSITE(dir);
	int last_element_old = IntelliDrawBuffer[last_x][last_y];
	int last_direction_old = getOpenDirectionFromTube(last_element_old);
	int last_direction_new = last_direction_old | dir_opposite;

	last_element_new = getTubeFromOpenDirection(last_direction_new);

	direction |= dir;
      }
    }

    new_element = getTubeFromOpenDirectionNotEmpty(direction, new_element);

    if (last_element_new != EL_UNDEFINED)
      MergeAndCloseNeighbourElements(x, y, &new_element,
				     last_x, last_y, &last_element_new,
				     getClosedTube, change_level);
  }
  else if (IS_BELT(new_element))
  {
    int belt_nr = getBeltNrFromBeltElement(new_element);
    int last_element_new = EL_UNDEFINED;
    int direction = MV_NONE;
    int i;

    /* if old element is of same kind, keep all existing directions */
    if (IS_BELT(old_element))
      direction |= getOpenDirectionFromBelt(old_element);

    for (i = MV_BIT_LEFT; i <= MV_BIT_RIGHT; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_BELT(IntelliDrawBuffer[last_x][last_y]))
      {
	int dir = MV_DIR_FROM_BIT(i);
	int dir_opposite = MV_DIR_OPPOSITE(dir);
	int last_element_old = IntelliDrawBuffer[last_x][last_y];
	int last_belt_nr = getBeltNrFromBeltElement(last_element_old);
	int last_direction_old = getOpenDirectionFromBelt(last_element_old);
	int last_direction_new = last_direction_old | dir_opposite;

	last_element_new = getBeltFromNrAndOpenDirection(last_belt_nr,
							 last_direction_new);
	direction |= dir;
      }
    }

    new_element = getBeltFromNrAndOpenDirectionNotEmpty(belt_nr, direction,
							new_element);
    if (last_element_new != EL_UNDEFINED)
      MergeAndCloseNeighbourElements(x, y, &new_element,
				     last_x, last_y, &last_element_new,
				     getClosedBelt, change_level);
  }
  else if (IS_ACID_POOL_OR_ACID(new_element))
  {
    int last_element_new = EL_UNDEFINED;
    int direction = MV_NONE;
    int i;

    /* if old element is of same kind, keep all existing directions */
    if (IS_ACID_POOL_OR_ACID(old_element))
      direction |= getOpenDirectionFromPool(old_element);

    for (i = 0; i < NUM_DIRECTIONS; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_ACID_POOL_OR_ACID(IntelliDrawBuffer[last_x][last_y]))
      {
	int dir = MV_DIR_FROM_BIT(i);
	int dir_opposite = MV_DIR_OPPOSITE(dir);
	int last_element_old = IntelliDrawBuffer[last_x][last_y];
	int last_direction_old = getOpenDirectionFromPool(last_element_old);
	int last_direction_new = last_direction_old | dir_opposite;

	last_element_new = getPoolFromOpenDirection(last_direction_new);

	direction |= dir;
      }
    }

    /* special corrections needed for intuitively correct acid pool drawing */
    if (last_element_new == EL_EMPTY)
      last_element_new = new_element;
    else if (last_element_new != EL_UNDEFINED)
      new_element = last_element_new;

    new_element = getPoolFromOpenDirectionNotEmpty(direction, new_element);

    if (last_element_new != EL_UNDEFINED)
      MergeAndCloseNeighbourElements(x, y, &new_element,
				     last_x, last_y, &last_element_new,
				     getClosedPool, change_level);
  }
  else if (IS_EMC_PILLAR(new_element))
  {
    int last_element_new = EL_UNDEFINED;
    int direction = MV_NONE;
    int i;

    /* if old element is of same kind, keep all existing directions */
    if (IS_EMC_PILLAR(old_element))
      direction |= getOpenDirectionFromPillar(old_element);

    for (i = MV_BIT_UP; i <= MV_BIT_DOWN; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_EMC_PILLAR(IntelliDrawBuffer[last_x][last_y]))
      {
	int dir = MV_DIR_FROM_BIT(i);
	int dir_opposite = MV_DIR_OPPOSITE(dir);
	int last_element_old = IntelliDrawBuffer[last_x][last_y];
	int last_direction_old = getOpenDirectionFromPillar(last_element_old);
	int last_direction_new = last_direction_old | dir_opposite;

	last_element_new = getPillarFromOpenDirection(last_direction_new);

	direction |= dir;
      }
    }

    new_element = getPillarFromOpenDirectionNotEmpty(direction, new_element);

    if (last_element_new != EL_UNDEFINED)
      MergeAndCloseNeighbourElements(x, y, &new_element,
				     last_x, last_y, &last_element_new,
				     getClosedPillar, change_level);
  }
  else if (IS_DC_STEELWALL_2(new_element))
  {
    int last_element_new = EL_UNDEFINED;
    int direction = MV_NONE;
    int i;

    /* if old element is of same kind, keep all existing directions */
    if (IS_DC_STEELWALL_2(old_element))
      direction |= getOpenDirectionFromSteel2(old_element);

    for (i = 0; i < NUM_DIRECTIONS; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_DC_STEELWALL_2(IntelliDrawBuffer[last_x][last_y]))
      {
	int dir = MV_DIR_FROM_BIT(i);
	int dir_opposite = MV_DIR_OPPOSITE(dir);
	int last_element_old = IntelliDrawBuffer[last_x][last_y];
	int last_direction_old = getOpenDirectionFromSteel2(last_element_old);
	int last_direction_new = last_direction_old | dir_opposite;

	last_element_new = getSteel2FromOpenDirection(last_direction_new);

	direction |= dir;
      }
    }

    new_element = getSteel2FromOpenDirectionNotEmpty(direction, new_element);

    if (last_element_new != EL_UNDEFINED)
      MergeAndCloseNeighbourElements(x, y, &new_element,
				     last_x, last_y, &last_element_new,
				     getClosedSteel2, change_level);
  }
  else if (IS_SP_CHIP(new_element))
  {
    int last_element_new = EL_UNDEFINED;
    int direction = MV_NONE;
    int i;

    /* (do not keep existing directions, regardless of kind of old element) */

    for (i = 0; i < NUM_DIRECTIONS; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_SP_CHIP(IntelliDrawBuffer[last_x][last_y]))
      {
	int dir = MV_DIR_FROM_BIT(i);
	int dir_opposite = MV_DIR_OPPOSITE(dir);
	int last_element_old = IntelliDrawBuffer[last_x][last_y];
	int last_direction_old = getOpenDirectionFromChip(last_element_old);
	int last_direction_new = last_direction_old | dir_opposite;

	if (last_direction_old == MV_NONE)
	{
	  last_element_new = getChipFromOpenDirection(last_direction_new);
	  direction |= dir;
	}
	else if (last_direction_old & (dir | dir_opposite))
	{
	  direction |= MV_DIR_OPPOSITE(last_direction_old);
	}
	else
	{
	  direction |= MV_DIR_OPPOSITE(dir);
	}
      }
    }

    new_element = getChipFromOpenDirectionNotEmpty(direction, new_element);

    if (last_element_new != EL_UNDEFINED)
      MergeAndCloseNeighbourElements(x, y, &new_element,
				     last_x, last_y, &last_element_new,
				     getClosedChip, change_level);
  }
  else if (IS_SP_HARDWARE_BASE(new_element))
  {
    int nr = GetSimpleRandom(6);

    new_element = (nr == 0 ? EL_SP_HARDWARE_BASE_1 :
		   nr == 1 ? EL_SP_HARDWARE_BASE_2 :
		   nr == 2 ? EL_SP_HARDWARE_BASE_3 :
		   nr == 3 ? EL_SP_HARDWARE_BASE_4 :
		   nr == 4 ? EL_SP_HARDWARE_BASE_5 : EL_SP_HARDWARE_BASE_6);
  }
  else if (new_element == EL_SP_HARDWARE_GREEN ||
	   new_element == EL_SP_HARDWARE_BLUE ||
	   new_element == EL_SP_HARDWARE_RED)
  {
    int nr = GetSimpleRandom(3);

    new_element = (nr == 0 ? EL_SP_HARDWARE_GREEN :
		   nr == 1 ? EL_SP_HARDWARE_BLUE : EL_SP_HARDWARE_RED);
  }
  else if (IS_GROUP_ELEMENT(new_element))
  {
    boolean connected_drawing = FALSE;
    int i;

    for (i = 0; i < NUM_DIRECTIONS; i++)
    {
      int xx = x + xy[i][0];
      int yy = y + xy[i][1];

      if (last_x == xx && last_y == yy && IN_LEV_FIELD(last_x, last_y) &&
	  IS_IN_GROUP_EL(IntelliDrawBuffer[last_x][last_y], new_element))
	connected_drawing = TRUE;
    }

    if (!connected_drawing)
      ResolveGroupElement(new_element);

    new_element = GetElementFromGroupElement(new_element);
  }
  else if (IS_BELT_SWITCH(old_element))
  {
    int belt_nr = getBeltNrFromBeltSwitchElement(old_element);
    int belt_dir = getBeltDirFromBeltSwitchElement(old_element);

    belt_dir = (belt_dir == MV_LEFT ? MV_NONE :
		belt_dir == MV_NONE ? MV_RIGHT : MV_LEFT);

    new_element = getBeltSwitchElementFromBeltNrAndBeltDir(belt_nr, belt_dir);
  }
  else
  {
    static int swappable_elements[][2] =
    {
      { EL_EXIT_CLOSED,			EL_EXIT_OPEN			},
      { EL_DYNAMITE,			EL_DYNAMITE_ACTIVE		},
      { EL_EM_DYNAMITE,			EL_EM_DYNAMITE_ACTIVE		},
      { EL_QUICKSAND_EMPTY,		EL_QUICKSAND_FULL		},
      { EL_EMERALD,			EL_WALL_EMERALD			},
      { EL_EMERALD_YELLOW,		EL_WALL_EMERALD_YELLOW		},
      { EL_EMERALD_RED,			EL_WALL_EMERALD_RED		},
      { EL_EMERALD_PURPLE,		EL_WALL_EMERALD_PURPLE		},
      { EL_DIAMOND,			EL_WALL_DIAMOND			},
      { EL_BD_DIAMOND,			EL_WALL_BD_DIAMOND		},
      { EL_GATE_1,			EL_GATE_1_GRAY			},
      { EL_GATE_2,			EL_GATE_2_GRAY			},
      { EL_GATE_3,			EL_GATE_3_GRAY			},
      { EL_GATE_4,			EL_GATE_4_GRAY			},
      { EL_EM_GATE_1,			EL_EM_GATE_1_GRAY		},
      { EL_EM_GATE_2,			EL_EM_GATE_2_GRAY		},
      { EL_EM_GATE_3,			EL_EM_GATE_3_GRAY		},
      { EL_EM_GATE_4,			EL_EM_GATE_4_GRAY		},
      { EL_EMC_GATE_5,			EL_EMC_GATE_5_GRAY		},
      { EL_EMC_GATE_6,			EL_EMC_GATE_6_GRAY		},
      { EL_EMC_GATE_7,			EL_EMC_GATE_7_GRAY		},
      { EL_EMC_GATE_8,			EL_EMC_GATE_8_GRAY		},
      { EL_DC_GATE_WHITE,		EL_DC_GATE_WHITE_GRAY		},
      { EL_TIME_ORB_EMPTY,		EL_TIME_ORB_FULL		},
      { EL_LAMP,			EL_LAMP_ACTIVE			},
      { EL_SOKOBAN_FIELD_EMPTY,		EL_SOKOBAN_FIELD_FULL		},
      { EL_SP_BASE,			EL_SP_BUGGY_BASE		},
      { EL_PEARL,			EL_WALL_PEARL			},
      { EL_CRYSTAL,			EL_WALL_CRYSTAL			},
      { EL_TIMEGATE_CLOSED,		EL_TIMEGATE_OPEN		},
      { EL_SWITCHGATE_CLOSED,		EL_SWITCHGATE_OPEN		},
      { EL_SWITCHGATE_SWITCH_UP,	EL_SWITCHGATE_SWITCH_DOWN	},
      { EL_DC_SWITCHGATE_SWITCH_UP,	EL_DC_SWITCHGATE_SWITCH_DOWN	},
      { EL_LIGHT_SWITCH,		EL_LIGHT_SWITCH_ACTIVE		},
      { EL_LANDMINE,			EL_DC_LANDMINE			},
      { EL_SHIELD_NORMAL,		EL_SHIELD_DEADLY		},
      { EL_STEEL_EXIT_CLOSED,		EL_STEEL_EXIT_OPEN		},
      { EL_EM_EXIT_CLOSED,		EL_EM_EXIT_OPEN			},
      { EL_EM_STEEL_EXIT_CLOSED,	EL_EM_STEEL_EXIT_OPEN		},
      { EL_QUICKSAND_FAST_EMPTY,	EL_QUICKSAND_FAST_FULL		},

      { -1,				-1				},
    };
    static int rotatable_elements[][4] =
    {
      {
	EL_BUG_UP,
	EL_BUG_RIGHT,
	EL_BUG_DOWN,
	EL_BUG_LEFT
      },

      {
	EL_SPACESHIP_UP,
	EL_SPACESHIP_RIGHT,
	EL_SPACESHIP_DOWN,
	EL_SPACESHIP_LEFT
      },

      {
	EL_BD_BUTTERFLY_UP,
	EL_BD_BUTTERFLY_RIGHT,
	EL_BD_BUTTERFLY_DOWN,
	EL_BD_BUTTERFLY_LEFT
      },

      {
	EL_BD_FIREFLY_UP,
	EL_BD_FIREFLY_RIGHT,
	EL_BD_FIREFLY_DOWN,
	EL_BD_FIREFLY_LEFT
      },

      {
	EL_PACMAN_UP,
	EL_PACMAN_RIGHT,
	EL_PACMAN_DOWN,
	EL_PACMAN_LEFT
      },

      {
	EL_YAMYAM_UP,
	EL_YAMYAM_RIGHT,
	EL_YAMYAM_DOWN,
	EL_YAMYAM_LEFT
      },

      {
	EL_ARROW_UP,
	EL_ARROW_RIGHT,
	EL_ARROW_DOWN,
	EL_ARROW_LEFT
      },

      {
	EL_SP_PORT_UP,
	EL_SP_PORT_RIGHT,
	EL_SP_PORT_DOWN,
	EL_SP_PORT_LEFT
      },

      {
	EL_SP_GRAVITY_PORT_UP,
	EL_SP_GRAVITY_PORT_RIGHT,
	EL_SP_GRAVITY_PORT_DOWN,
	EL_SP_GRAVITY_PORT_LEFT
      },

      {
	EL_SP_GRAVITY_ON_PORT_UP,
	EL_SP_GRAVITY_ON_PORT_RIGHT,
	EL_SP_GRAVITY_ON_PORT_DOWN,
	EL_SP_GRAVITY_ON_PORT_LEFT
      },

      {
	EL_SP_GRAVITY_OFF_PORT_UP,
	EL_SP_GRAVITY_OFF_PORT_RIGHT,
	EL_SP_GRAVITY_OFF_PORT_DOWN,
	EL_SP_GRAVITY_OFF_PORT_LEFT
      },

      {
	EL_MOLE_UP,
	EL_MOLE_RIGHT,
	EL_MOLE_DOWN,
	EL_MOLE_LEFT
      },

      {
	EL_BALLOON_SWITCH_UP,
	EL_BALLOON_SWITCH_RIGHT,
	EL_BALLOON_SWITCH_DOWN,
	EL_BALLOON_SWITCH_LEFT
      },

      {
	-1,
	-1,
	-1,
	-1,
      },
    };
    int i, j;

    for (i = 0; swappable_elements[i][0] != -1; i++)
    {
      int element1 = swappable_elements[i][0];
      int element2 = swappable_elements[i][1];

      if (old_element == element1 || old_element == element2)
	new_element = (old_element == element1 ? element2 : element1);
    }

    for (i = 0; rotatable_elements[i][0] != -1; i++)
    {
      for (j = 0; j < 4; j++)
      {
	int element = rotatable_elements[i][j];

	if (old_element == element)
	  new_element = (button == 1 ? rotatable_elements[i][(j + 3) % 4] :
			 button == 2 ? rotatable_elements[i][0]           :
			 button == 3 ? rotatable_elements[i][(j + 1) % 4] :
			 old_element);
      }
    }
  }

  SetElementSimple(x, y, new_element, change_level);

  last_x = x;
  last_y = y;
}

static void ResetIntelliDraw()
{
  int x, y;

  for (x = 0; x < lev_fieldx; x++)
    for (y = 0; y < lev_fieldy; y++)
      IntelliDrawBuffer[x][y] = Feld[x][y];

  SetElementIntelliDraw(-1, -1, EL_UNDEFINED, FALSE, -1);
}

static void SetElementExt(int x, int y, int element, boolean change_level,
			  int button)
{
  if (element < 0)
    SetElementSimple(x, y, Feld[x][y], change_level);
  else if (GetKeyModState() & KMOD_Shift)
    SetElementIntelliDraw(x, y, element, change_level, button);
  else
    SetElementSimple(x, y, element, change_level);
}

static void SetElement(int x, int y, int element)
{
  SetElementExt(x, y, element, TRUE, -1);
}

static void SetElementButton(int x, int y, int element, int button)
{
  SetElementExt(x, y, element, TRUE, button);
}

static void DrawLineElement(int sx, int sy, int element, boolean change_level)
{
  int lx = sx + level_xpos;
  int ly = sy + level_ypos;

  SetElementExt(lx, ly, element, change_level, -1);
}

static void DrawLine(int from_x, int from_y, int to_x, int to_y,
		     int element, boolean change_level)
{
  int xsize = ABS(to_x - from_x);
  int ysize = ABS(to_y - from_y);
  int dx = (to_x < from_x ? -1 : +1);
  int dy = (to_y < from_y ? -1 : +1);
  int i;

  if (from_y == to_y)			/* horizontal line */
  {
    for (i = 0; i <= xsize; i++)
      DrawLineElement(from_x + i * dx, from_y, element, change_level);
  }
  else if (from_x == to_x)		/* vertical line */
  {
    for (i = 0; i <= ysize; i++)
      DrawLineElement(from_x, from_y + i * dy, element, change_level);
  }
  else					/* diagonal line */
  {
    if (ysize < xsize)			/* a < 1 */
    {
      float a = (float)ysize / (float)xsize;

      for (i = 0; i <= xsize; i++)
      {
	int x = dx * i;
	int y = dy * (int)(a * i + 0.5);

	DrawLineElement(from_x + x, from_y + y, element, change_level);
      }
    }
    else				/* a >= 1 */
    {
      float a = (float)xsize / (float)ysize;

      for (i = 0; i <= ysize; i++)
      {
	int x = dx * (int)(a * i + 0.5);
	int y = dy * i;

	DrawLineElement(from_x + x, from_y + y, element, change_level);
      }
    }
  }
}

static void DrawBox(int from_x, int from_y, int to_x, int to_y,
		    int element, boolean change_level)
{
  DrawLine(from_x, from_y, from_x, to_y, element, change_level);
  DrawLine(from_x, to_y, to_x, to_y, element, change_level);
  DrawLine(to_x, to_y, to_x, from_y, element, change_level);
  DrawLine(to_x, from_y, from_x, from_y, element, change_level);
}

static void DrawFilledBox(int from_x, int from_y, int to_x, int to_y,
			  int element, boolean change_level)
{
  int y;

  if (from_y > to_y)
    swap_number_pairs(&from_x, &from_y, &to_x, &to_y);

  for (y = from_y; y <= to_y; y++)
    DrawLine(from_x, y, to_x, y, element, change_level);
}

static void DrawArcExt(int from_x, int from_y, int to_x2, int to_y2,
		       int element, boolean change_level)
{
  int to_x = to_x2 - (to_x2 > from_x ? +1 : -1);
  int to_y = to_y2 - (to_y2 > from_y ? +1 : -1);
  int len_x = ABS(to_x - from_x);
  int len_y = ABS(to_y - from_y);
  int radius, x, y;

  radius = (int)(sqrt((float)(len_x * len_x + len_y * len_y)) + 0.5);

  /* not optimal (some points get drawn twice) but simple,
     and fast enough for the few points we are drawing */

  for (x = 0; x <= radius; x++)
  {
    int sx, sy, lx, ly;

    y = (int)(sqrt((float)(radius * radius - x * x)) + 0.5);

    sx = from_x + x * (from_x < to_x2 ? +1 : -1);
    sy = from_y + y * (from_y < to_y2 ? +1 : -1);
    lx = sx + level_xpos;
    ly = sy + level_ypos;

    if (IN_ED_FIELD(sx, sy) && IN_LEV_FIELD(lx, ly))
      DrawLineElement(sx, sy, element, change_level);
  }

  for (y = 0; y <= radius; y++)
  {
    int sx, sy, lx, ly;

    x = (int)(sqrt((float)(radius * radius - y * y)) + 0.5);

    sx = from_x + x * (from_x < to_x2 ? +1 : -1);
    sy = from_y + y * (from_y < to_y2 ? +1 : -1);
    lx = sx + level_xpos;
    ly = sy + level_ypos;

    if (IN_ED_FIELD(sx, sy) && IN_LEV_FIELD(lx, ly))
      DrawLineElement(sx, sy, element, change_level);
  }
}

static void DrawArc(int from_x, int from_y, int to_x, int to_y,
		    int element, boolean change_level)
{
  int to_x2 = to_x + (to_x < from_x ? -1 : +1);
  int to_y2 = to_y + (to_y > from_y ? +1 : -1);

  DrawArcExt(from_x, from_y, to_x2, to_y2, element, change_level);
}

#define DRAW_CIRCLES_BUTTON_AVAILABLE	0

#if DRAW_CIRCLES_BUTTON_AVAILABLE
static void DrawCircle(int from_x, int from_y, int to_x, int to_y,
		       int element, boolean change_level)
{
  int to_x2 = to_x + (to_x < from_x ? -1 : +1);
  int to_y2 = to_y + (to_y > from_y ? +1 : -1);
  int mirror_to_x2 = from_x - (to_x2 - from_x);
  int mirror_to_y2 = from_y - (to_y2 - from_y);

  DrawArcExt(from_x, from_y, to_x2, to_y2, element, change_level);
  DrawArcExt(from_x, from_y, mirror_to_x2, to_y2, element, change_level);
  DrawArcExt(from_x, from_y, to_x2, mirror_to_y2, element, change_level);
  DrawArcExt(from_x, from_y, mirror_to_x2, mirror_to_y2, element,change_level);
}
#endif

static void DrawAreaBorder(int from_x, int from_y, int to_x, int to_y)
{
  int from_sx, from_sy;
  int to_sx, to_sy;

  if (from_x > to_x)
    swap_numbers(&from_x, &to_x);

  if (from_y > to_y)
    swap_numbers(&from_y, &to_y);

  from_sx = SX + from_x * ed_tilesize;
  from_sy = SY + from_y * ed_tilesize;
  to_sx = SX + (to_x + 1) * ed_tilesize - 1;
  to_sy = SY + (to_y + 1) * ed_tilesize - 1;

  DrawSimpleWhiteLine(drawto, from_sx, from_sy, to_sx, from_sy);
  DrawSimpleWhiteLine(drawto, to_sx, from_sy, to_sx, to_sy);
  DrawSimpleWhiteLine(drawto, to_sx, to_sy, from_sx, to_sy);
  DrawSimpleWhiteLine(drawto, from_sx, to_sy, from_sx, from_sy);

  if (from_x == to_x && from_y == to_y)
    MarkTileDirty(from_x/2, from_y/2);
  else
    redraw_mask |= REDRAW_FIELD;
}

static void SelectArea(int from_x, int from_y, int to_x, int to_y,
		       int element, boolean change_level)
{
  if (element == -1 || change_level)
    DrawBox(from_x, from_y, to_x, to_y, -1, FALSE);
  else
    DrawAreaBorder(from_x, from_y, to_x, to_y);
}

/* values for CopyBrushExt() */
#define CB_AREA_TO_BRUSH	0
#define CB_BRUSH_TO_CURSOR	1
#define CB_BRUSH_TO_LEVEL	2
#define CB_DELETE_OLD_CURSOR	3
#define CB_DUMP_BRUSH		4
#define CB_DUMP_BRUSH_SMALL	5

static void CopyBrushExt(int from_x, int from_y, int to_x, int to_y,
			 int button, int mode)
{
  static short brush_buffer[MAX_LEV_FIELDX][MAX_LEV_FIELDY];
  static int brush_width, brush_height;
  static int last_cursor_x = -1, last_cursor_y = -1;
  static boolean delete_old_brush;
  int new_element = BUTTON_ELEMENT(button);
  int x, y;

  if (mode == CB_DUMP_BRUSH ||
      mode == CB_DUMP_BRUSH_SMALL)
  {
    if (!draw_with_brush)
    {
      Error(ERR_WARN, "no brush selected");

      return;
    }

    for (y = 0; y < brush_height; y++)
    {
      for (x = 0; x < brush_width; x++)
      {
	int element = brush_buffer[x][y];
	int element_mapped = element;

	if (IS_CUSTOM_ELEMENT(element))
	  element_mapped = EL_CUSTOM_START;
	else if (IS_GROUP_ELEMENT(element))
	  element_mapped = EL_GROUP_START;
	else if (element >= NUM_FILE_ELEMENTS)
	  element_mapped = EL_UNKNOWN;

	// dump brush as level sketch text for the R'n'D forum:
	// - large tiles: `xxx (0x60 ASCII)
	// - small tiles: ¸xxx (0xb8 ISO-8859-1, 0xc2b8 UTF-8)
	printf("%s%03d", (mode == CB_DUMP_BRUSH ? "`" : "¸"), element_mapped);
      }

      printf("\n");
    }

    return;
  }

  if (mode == CB_DELETE_OLD_CURSOR && !delete_old_brush)
    return;

  if (mode == CB_AREA_TO_BRUSH)
  {
    int from_lx, from_ly;

    if (from_x > to_x)
      swap_numbers(&from_x, &to_x);

    if (from_y > to_y)
      swap_numbers(&from_y, &to_y);

    brush_width = to_x - from_x + 1;
    brush_height = to_y - from_y + 1;

    from_lx = from_x + level_xpos;
    from_ly = from_y + level_ypos;

    for (y = 0; y < brush_height; y++)
    {
      for (x = 0; x < brush_width; x++)
      {
	brush_buffer[x][y] = Feld[from_lx + x][from_ly + y];

	if (button != 1)
	  DrawLineElement(from_x + x, from_y + y, new_element, TRUE);
      }
    }

    if (button != 1)
      CopyLevelToUndoBuffer(UNDO_IMMEDIATE);

    delete_old_brush = FALSE;
  }
  else if (mode == CB_BRUSH_TO_CURSOR || mode == CB_DELETE_OLD_CURSOR ||
	   mode == CB_BRUSH_TO_LEVEL)
  {
    int cursor_x = (mode == CB_DELETE_OLD_CURSOR ? last_cursor_x : from_x);
    int cursor_y = (mode == CB_DELETE_OLD_CURSOR ? last_cursor_y : from_y);
    int cursor_from_x = cursor_x - brush_width / 2;
    int cursor_from_y = cursor_y - brush_height / 2;
    int border_from_x = cursor_x, border_from_y = cursor_y;
    int border_to_x = cursor_x, border_to_y = cursor_y;

    if (mode != CB_DELETE_OLD_CURSOR && delete_old_brush)
      CopyBrushExt(0, 0, 0, 0, 0, CB_DELETE_OLD_CURSOR);

    if (!IN_ED_FIELD(cursor_x, cursor_y) ||
	!IN_LEV_FIELD(cursor_x + level_xpos, cursor_y + level_ypos))
    {
      delete_old_brush = FALSE;
      return;
    }

    for (y = 0; y < brush_height; y++)
    {
      for (x = 0; x < brush_width; x++)
      {
	int sx = cursor_from_x + x;
	int sy = cursor_from_y + y;
	int lx = sx + level_xpos;
	int ly = sy + level_ypos;
	boolean change_level = (mode == CB_BRUSH_TO_LEVEL);
	int element = (mode == CB_DELETE_OLD_CURSOR ? -1 :
		       mode == CB_BRUSH_TO_CURSOR || button == 1 ?
		       brush_buffer[x][y] : new_element);

	if (IN_ED_FIELD(sx, sy) && IN_LEV_FIELD(lx, ly))
	{
	  if (sx < border_from_x)
	    border_from_x = sx;
	  else if (sx > border_to_x)
	    border_to_x = sx;
	  if (sy < border_from_y)
	    border_from_y = sy;
	  else if (sy > border_to_y)
	    border_to_y = sy;

	  DrawLineElement(sx, sy, element, change_level);
	}
      }
    }

    if (mode != CB_DELETE_OLD_CURSOR)
      DrawAreaBorder(border_from_x, border_from_y, border_to_x, border_to_y);

    last_cursor_x = cursor_x;
    last_cursor_y = cursor_y;
    delete_old_brush = TRUE;
  }
}

static void CopyAreaToBrush(int from_x, int from_y, int to_x, int to_y,
			    int button)
{
  CopyBrushExt(from_x, from_y, to_x, to_y, button, CB_AREA_TO_BRUSH);
}

static void CopyBrushToLevel(int x, int y, int button)
{
  CopyBrushExt(x, y, 0, 0, button, CB_BRUSH_TO_LEVEL);
}

static void CopyBrushToCursor(int x, int y)
{
  CopyBrushExt(x, y, 0, 0, 0, CB_BRUSH_TO_CURSOR);
}

static void DeleteBrushFromCursor()
{
  CopyBrushExt(0, 0, 0, 0, 0, CB_DELETE_OLD_CURSOR);
}

void DumpBrush()
{
  CopyBrushExt(0, 0, 0, 0, 0, CB_DUMP_BRUSH);
}

void DumpBrush_Small()
{
  CopyBrushExt(0, 0, 0, 0, 0, CB_DUMP_BRUSH_SMALL);
}

static void FloodFill(int from_x, int from_y, int fill_element)
{
  FloodFillLevel(from_x, from_y, fill_element, Feld, lev_fieldx, lev_fieldy);
}

/* values for DrawLevelText() modes */
#define TEXT_INIT		0
#define TEXT_SETCURSOR		1
#define TEXT_WRITECHAR		2
#define TEXT_BACKSPACE		3
#define TEXT_NEWLINE		4
#define TEXT_END		5
#define TEXT_QUERY_TYPING	6

static int DrawLevelText(int sx, int sy, char letter, int mode)
{
  static short delete_buffer[MAX_LEV_FIELDX];
  static int start_sx;
  static int last_sx, last_sy;
  static boolean typing = FALSE;
  int letter_element = EL_CHAR_ASCII0 + letter;
  int lx = 0, ly = 0;

  /* map lower case letters to upper case and convert special characters */
  if (letter >= 'a' && letter <= 'z')
    letter_element = EL_CHAR_ASCII0 + letter + (int)('A' - 'a');
  else if (letter == CHAR_BYTE_UMLAUT_a || letter == CHAR_BYTE_UMLAUT_A)
    letter_element = EL_CHAR_AUMLAUT;
  else if (letter == CHAR_BYTE_UMLAUT_o || letter == CHAR_BYTE_UMLAUT_O)
    letter_element = EL_CHAR_OUMLAUT;
  else if (letter == CHAR_BYTE_UMLAUT_u || letter == CHAR_BYTE_UMLAUT_U)
    letter_element = EL_CHAR_UUMLAUT;
  else if (letter == '^')
    letter_element = EL_CHAR_COPYRIGHT;
  else
    letter_element = EL_CHAR_ASCII0 + letter;

  if (mode != TEXT_INIT)
  {
    if (!typing)
      return FALSE;

    if (mode != TEXT_SETCURSOR)
    {
      sx = last_sx;
      sy = last_sy;
    }

    lx = last_sx + level_xpos;
    ly = last_sy + level_ypos;
  }

  switch (mode)
  {
    case TEXT_INIT:
      if (typing)
	DrawLevelText(0, 0, 0, TEXT_END);

      typing = TRUE;
      start_sx = sx;
      last_sx = sx;
      last_sy = sy;
      DrawLevelText(sx, sy, 0, TEXT_SETCURSOR);
      break;

    case TEXT_SETCURSOR:
      DrawEditorElement(last_sx, last_sy, Feld[lx][ly]);
      DrawAreaBorder(sx, sy, sx, sy);
      last_sx = sx;
      last_sy = sy;
      break;

    case TEXT_WRITECHAR:
      if (letter_element >= EL_CHAR_START && letter_element <= EL_CHAR_END)
      {
	if (new_element1 >= EL_STEEL_CHAR_START &&
	    new_element1 <= EL_STEEL_CHAR_END)
	  letter_element = letter_element - EL_CHAR_START + EL_STEEL_CHAR_START;

	delete_buffer[sx - start_sx] = Feld[lx][ly];
	Feld[lx][ly] = letter_element;

	if (sx + 1 < ed_fieldx && lx + 1 < lev_fieldx)
	  DrawLevelText(sx + 1, sy, 0, TEXT_SETCURSOR);
	else if (sy + 1 < ed_fieldy && ly + 1 < lev_fieldy)
	  DrawLevelText(start_sx, sy + 1, 0, TEXT_SETCURSOR);
	else
	  DrawLevelText(0, 0, 0, TEXT_END);

	level.changed = TRUE;
      }
      break;

    case TEXT_BACKSPACE:
      if (sx > start_sx)
      {
	Feld[lx - 1][ly] = delete_buffer[sx - start_sx - 1];
	DrawEditorElement(sx - 1, sy, Feld[lx - 1][ly]);
	DrawLevelText(sx - 1, sy, 0, TEXT_SETCURSOR);
      }
      break;

    case TEXT_NEWLINE:
      if (sy + 1 < ed_fieldy - 1 && ly + 1 < lev_fieldy - 1)
	DrawLevelText(start_sx, sy + 1, 0, TEXT_SETCURSOR);
      else
	DrawLevelText(0, 0, 0, TEXT_END);
      break;

    case TEXT_END:
      CopyLevelToUndoBuffer(UNDO_IMMEDIATE);
      DrawEditorElement(sx, sy, Feld[lx][ly]);
      typing = FALSE;
      break;

    case TEXT_QUERY_TYPING:
      break;

    default:
      break;
  }

  return typing;
}

static void SetTextCursor(int unused_sx, int unused_sy, int sx, int sy,
			  int element, boolean change_level)
{
  int lx = sx + level_xpos;
  int ly = sy + level_ypos;

  if (element == -1)
    DrawEditorElement(sx, sy, Feld[lx][ly]);
  else
    DrawAreaBorder(sx, sy, sx, sy);
}

static void CheckLevelBorderElement(boolean redraw_playfield)
{
  int last_border_element = BorderElement;

  SetBorderElement();

  if (redraw_playfield && BorderElement != last_border_element)
    DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
}

static void CopyLevelToUndoBuffer(int mode)
{
  static boolean accumulated_undo = FALSE;
  boolean new_undo_buffer_position = TRUE;
  int x, y;

  if (undo_buffer_steps == 0)
    accumulated_undo = FALSE;

  switch (mode)
  {
    case UNDO_IMMEDIATE:
      accumulated_undo = FALSE;
      break;

    case UNDO_ACCUMULATE:
      if (accumulated_undo)
	new_undo_buffer_position = FALSE;
      accumulated_undo = TRUE;
      break;

    default:
      break;
  }

  if (new_undo_buffer_position)
  {
    /* advance position in undo buffer ring */
    undo_buffer_position = (undo_buffer_position + 1) % NUM_UNDO_STEPS;

    if (undo_buffer_steps < NUM_UNDO_STEPS - 1)
      undo_buffer_steps++;
  }

  /* always reset redo buffer when storing level change into undo buffer */
  redo_buffer_steps = 0;

  for (x = 0; x < lev_fieldx; x++)
    for (y = 0; y < lev_fieldy; y++)
      UndoBuffer[undo_buffer_position][x][y] = Feld[x][y];

  /* check if drawing operation forces change of border style */
  CheckLevelBorderElement(TRUE);

  level.changed = TRUE;
}

static void RandomPlacement(int new_element)
{
  static boolean free_position[MAX_LEV_FIELDX][MAX_LEV_FIELDY];
  int num_free_positions = 0;
  int num_percentage, num_elements;
  int x, y;

  ResetIntelliDraw();

  /* determine number of free positions for randomly placing the new element */
  for (x = 0; x < lev_fieldx; x++) for (y = 0; y < lev_fieldy; y++)
  {
    free_position[x][y] =
      (random_placement_background_restricted ?
       Feld[x][y] == random_placement_background_element :
       Feld[x][y] != new_element);

    if (free_position[x][y])
      num_free_positions++;
  }

  /* determine number of new elements to place there */
  num_percentage = num_free_positions * random_placement_value / 100;
  num_elements = (random_placement_method == RANDOM_USE_PERCENTAGE ?
		  num_percentage : random_placement_value);

  /* if less free positions than elements to place, fill all these positions */
  if (num_free_positions < num_elements)
  {
    for (x = 0; x < lev_fieldx; x++)
      for (y = 0; y < lev_fieldy; y++)
	if (free_position[x][y])
	  SetElement(x, y, new_element);
  }
  else
  {
    while (num_elements > 0)
    {
      x = GetSimpleRandom(lev_fieldx);
      y = GetSimpleRandom(lev_fieldy);

      /* don't place element at the same position twice */
      if (free_position[x][y])
      {
	free_position[x][y] = FALSE;
	SetElement(x, y, new_element);
	num_elements--;
      }
    }
  }

  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
  CopyLevelToUndoBuffer(UNDO_IMMEDIATE);
}

void WrapLevel(int dx, int dy)
{
  int wrap_dx = lev_fieldx - dx;
  int wrap_dy = lev_fieldy - dy;
  int x, y;

  for (x = 0; x < lev_fieldx; x++)
    for (y = 0; y < lev_fieldy; y++)
      FieldBackup[x][y] = Feld[x][y];

  for (x = 0; x < lev_fieldx; x++)
    for (y = 0; y < lev_fieldy; y++)
      Feld[x][y] =
	FieldBackup[(x + wrap_dx) % lev_fieldx][(y + wrap_dy) % lev_fieldy];

  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
  CopyLevelToUndoBuffer(UNDO_ACCUMULATE);
}

static void HandleDrawingAreas(struct GadgetInfo *gi)
{
  static boolean started_inside_drawing_area = FALSE;
  int id = gi->custom_id;
  boolean button_press_event;
  boolean button_release_event;
  boolean inside_drawing_area = !gi->event.off_borders;
  boolean draw_level = (id == GADGET_ID_DRAWING_LEVEL);
  int actual_drawing_function;
  int button = gi->event.button;
  int new_element = BUTTON_ELEMENT(button);
  int sx = gi->event.x, sy = gi->event.y;
  int min_sx = 0, min_sy = 0;
  int max_sx = gi->drawing.area_xsize - 1, max_sy = gi->drawing.area_ysize - 1;
  int item_xsize = gi->drawing.item_xsize, item_ysize = gi->drawing.item_ysize;
  int lx = 0, ly = 0;
  int min_lx = 0, min_ly = 0;
  int max_lx = lev_fieldx - 1, max_ly = lev_fieldy - 1;
  int x, y;

  /* handle info callback for each invocation of action callback */
  gi->callback_info(gi);

  button_press_event = (gi->event.type == GD_EVENT_PRESSED);
  button_release_event = (gi->event.type == GD_EVENT_RELEASED);

  /* make sure to stay inside drawing area boundaries */
  sx = (sx < min_sx ? min_sx : sx > max_sx ? max_sx : sx);
  sy = (sy < min_sy ? min_sy : sy > max_sy ? max_sy : sy);

  if (draw_level)
  {
    /* get positions inside level field */
    lx = sx + level_xpos;
    ly = sy + level_ypos;

    if (!IN_LEV_FIELD(lx, ly))
      inside_drawing_area = FALSE;

    /* make sure to stay inside level field boundaries */
    lx = (lx < min_lx ? min_lx : lx > max_lx ? max_lx : lx);
    ly = (ly < min_ly ? min_ly : ly > max_ly ? max_ly : ly);

    /* correct drawing area positions accordingly */
    sx = lx - level_xpos;
    sy = ly - level_ypos;
  }

  if (button_press_event)
    started_inside_drawing_area = inside_drawing_area;

  if (!started_inside_drawing_area)
    return;

  if (!IS_VALID_BUTTON(button))
    return;

  if (!button && !button_release_event)
    return;

  /* automatically switch to 'single item' drawing mode, if needed */
  actual_drawing_function =
    (draw_level || drawing_function == GADGET_ID_PICK_ELEMENT ?
     drawing_function : GADGET_ID_SINGLE_ITEMS);

  /* clicking into drawing area with pressed Control key picks element */
  if (GetKeyModState() & KMOD_Control)
  {
    last_drawing_function = drawing_function;
    actual_drawing_function = GADGET_ID_PICK_ELEMENT;
  }

  if (GetKeyModState() & KMOD_Shift)
  {
    if (button_press_event || button_release_event)
      ResetIntelliDraw();
  }

  switch (actual_drawing_function)
  {
    case GADGET_ID_SINGLE_ITEMS:
      if (draw_level)
      {
	if (button_release_event)
	{
	  CopyLevelToUndoBuffer(UNDO_IMMEDIATE);

	  if (edit_mode == ED_MODE_DRAWING && draw_with_brush &&
	      !inside_drawing_area)
	    DeleteBrushFromCursor();
	}

	if (!button || button_release_event)
	  break;

	if (draw_with_brush)
	{
	  CopyBrushToLevel(sx, sy, button);
	}
	else
	{
	  if (new_element == EL_PLAYER_1)
	  {
	    /* remove player at old position */
	    for (y = 0; y < lev_fieldy; y++)
	      for (x = 0; x < lev_fieldx; x++)
		if (Feld[x][y] == EL_PLAYER_1)
		  SetElement(x, y, EL_EMPTY);
	  }

	  SetElementButton(lx, ly, new_element, button);
	}
      }
      else
      {
	int type_id = gi->custom_type_id;
	int pos = sx * drawingarea_info[type_id].area_ysize + sy;

	if (item_xsize == MINI_TILEX && item_ysize == MINI_TILEY)
	  DrawMiniGraphicExt(drawto,
			     gi->x + sx * MINI_TILEX,
			     gi->y + sy * MINI_TILEY,
			     el2edimg(new_element));
	else
	  DrawFixedGraphicExt(drawto,
			      gi->x + sx * TILEX,
			      gi->y + sy * TILEY,
			      el2edimg(new_element), 0);

	if (id == GADGET_ID_CUSTOM_GRAPHIC)
	  new_element = GFX_ELEMENT(new_element);

	drawingarea_info[type_id].value[pos] = new_element;

	CopyElementPropertiesToGame(properties_element);

	if (id == GADGET_ID_CUSTOM_GRAPHIC)
	{
	  UpdateCustomElementGraphicGadgets();

	  FrameCounter = 0;	/* restart animation frame counter */
	}
      }
      break;

    case GADGET_ID_CONNECTED_ITEMS:
      {
	static int last_sx = -1;
	static int last_sy = -1;

	if (button_release_event)
	  CopyLevelToUndoBuffer(UNDO_IMMEDIATE);

	if (button)
	{
	  if (!button_press_event)
	    DrawLine(last_sx, last_sy, sx, sy, new_element, TRUE);

	  last_sx = sx;
	  last_sy = sy;
	}
      }
      break;

    case GADGET_ID_LINE:
    case GADGET_ID_ARC:
    case GADGET_ID_RECTANGLE:
    case GADGET_ID_FILLED_BOX:
    case GADGET_ID_GRAB_BRUSH:
    case GADGET_ID_TEXT:
      {
	static int last_sx = -1;
	static int last_sy = -1;
	static int start_sx = -1;
	static int start_sy = -1;
	void (*draw_func)(int, int, int, int, int, boolean);

	if (drawing_function == GADGET_ID_LINE)
	  draw_func = DrawLine;
	else if (drawing_function == GADGET_ID_ARC)
	  draw_func = DrawArc;
	else if (drawing_function == GADGET_ID_RECTANGLE)
	  draw_func = DrawBox;
	else if (drawing_function == GADGET_ID_FILLED_BOX)
	  draw_func = DrawFilledBox;
	else if (drawing_function == GADGET_ID_GRAB_BRUSH)
	  draw_func = SelectArea;
	else /* (drawing_function == GADGET_ID_TEXT) */
	  draw_func = SetTextCursor;

	if (button_press_event)
	{
	  draw_func(sx, sy, sx, sy, new_element, FALSE);
	  start_sx = last_sx = sx;
	  start_sy = last_sy = sy;

	  if (drawing_function == GADGET_ID_TEXT)
	    DrawLevelText(0, 0, 0, TEXT_END);
	}
	else if (button_release_event)
	{
	  draw_func(start_sx, start_sy, sx, sy, new_element, TRUE);
	  if (drawing_function == GADGET_ID_GRAB_BRUSH)
	  {
	    CopyAreaToBrush(start_sx, start_sy, sx, sy, button);
	    CopyBrushToCursor(sx, sy);
	    ClickOnGadget(level_editor_gadget[GADGET_ID_SINGLE_ITEMS],
			  MB_LEFTBUTTON);
	    draw_with_brush = TRUE;
	  }
	  else if (drawing_function == GADGET_ID_TEXT)
	    DrawLevelText(sx, sy, 0, TEXT_INIT);
	  else
	    CopyLevelToUndoBuffer(UNDO_IMMEDIATE);
	}
	else if (last_sx != sx || last_sy != sy)
	{
	  draw_func(start_sx, start_sy, last_sx, last_sy, -1, FALSE);
	  draw_func(start_sx, start_sy, sx, sy, new_element, FALSE);
	  last_sx = sx;
	  last_sy = sy;
	}
      }
      break;

    case GADGET_ID_FLOOD_FILL:
      if (button_press_event && Feld[lx][ly] != new_element)
      {
	FloodFill(lx, ly, new_element);
	DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
	CopyLevelToUndoBuffer(UNDO_IMMEDIATE);
      }
      break;

    case GADGET_ID_PICK_ELEMENT:
      if (button_release_event)
	ClickOnGadget(level_editor_gadget[last_drawing_function],
		      MB_LEFTBUTTON);
      else if (draw_level)
	PickDrawingElement(button, Feld[lx][ly]);
      else
      {
	int type_id = gi->custom_type_id;
	int pos = sx * drawingarea_info[type_id].area_ysize + sy;

	PickDrawingElement(button, drawingarea_info[type_id].value[pos]);
      }

      break;

    default:
      break;
  }
}

static void HandleCounterButtons(struct GadgetInfo *gi)
{
  int gadget_id = gi->custom_id;
  int counter_id = gi->custom_type_id;
  int button = gi->event.button;
  int *counter_value = counterbutton_info[counter_id].value;
  int step = BUTTON_STEPSIZE(button) *
    (gadget_id == counterbutton_info[counter_id].gadget_id_down ? -1 : +1);

  if (counter_id == ED_COUNTER_ID_SELECT_LEVEL)
  {
    boolean pressed = (gi->event.type == GD_EVENT_PRESSED);
    boolean released = (gi->event.type == GD_EVENT_RELEASED);
    boolean level_changed = LevelChanged();

    if ((level_changed && pressed) || (!level_changed && released))
      return;

    if (level_changed && !Request("Level has changed! Discard changes?",
				  REQ_ASK))
    {
      if (gadget_id == counterbutton_info[counter_id].gadget_id_text)
	ModifyEditorCounterValue(counter_id, *counter_value);

      return;
    }
  }

  if (gadget_id == counterbutton_info[counter_id].gadget_id_text)
    *counter_value = gi->textinput.number_value;
  else
    ModifyEditorCounterValue(counter_id, *counter_value + step);

  if (counter_id == ED_COUNTER_ID_SELECT_LEVEL)
  {
      LoadLevel(level_nr);
      LoadScore(level_nr);

      TapeErase();

      ResetUndoBuffer();
      DrawEditModeWindow();

      return;
  }

  switch (counter_id)
  {
    case ED_COUNTER_ID_YAMYAM_CONTENT:
      DrawYamYamContentAreas();
      break;

    case ED_COUNTER_ID_BALL_CONTENT:
      DrawMagicBallContentAreas();
      break;

    case ED_COUNTER_ID_ANDROID_CONTENT:
      DrawAndroidElementArea(properties_element);
      break;

    case ED_COUNTER_ID_GROUP_CONTENT:
      DrawGroupElementArea(properties_element);
      CopyGroupElementPropertiesToGame(properties_element);
      break;

    case ED_COUNTER_ID_INVENTORY_SIZE:
      DrawPlayerInitialInventoryArea(properties_element);
      break;

    case ED_COUNTER_ID_ENVELOPE_XSIZE:
    case ED_COUNTER_ID_ENVELOPE_YSIZE:
      DrawEnvelopeTextArea(-1);
      break;

    case ED_COUNTER_ID_LEVEL_XSIZE:
    case ED_COUNTER_ID_LEVEL_YSIZE:
      lev_fieldx = level.fieldx;
      lev_fieldy = level.fieldy;

      /* check if resizing of level results in change of border border */
      SetBorderElement();

      break;

    default:
      break;
  }

  if ((counter_id >= ED_COUNTER_ID_CUSTOM_FIRST &&
       counter_id <= ED_COUNTER_ID_CUSTOM_LAST) ||
      (counter_id >= ED_COUNTER_ID_CHANGE_FIRST &&
       counter_id <= ED_COUNTER_ID_CHANGE_LAST))
    CopyElementPropertiesToGame(properties_element);

  level.changed = TRUE;
}

static void HandleTextInputGadgets(struct GadgetInfo *gi)
{
  int type_id = gi->custom_type_id;

  strcpy(textinput_info[type_id].value, gi->textinput.value);

  if (type_id == ED_TEXTINPUT_ID_ELEMENT_NAME)
  {
    CopyElementPropertiesToGame(properties_element);

    ModifyEditorElementList();	/* update changed button info text */
  }

  level.changed = TRUE;
}

static void HandleTextAreaGadgets(struct GadgetInfo *gi)
{
  int type_id = gi->custom_type_id;

  strncpy(textarea_info[type_id].value, gi->textarea.value,
	  MAX_ENVELOPE_TEXT_LEN);
  textarea_info[type_id].value[MAX_ENVELOPE_TEXT_LEN] = '\0';

  level.changed = TRUE;
}

static void HandleSelectboxGadgets(struct GadgetInfo *gi)
{
  int type_id = gi->custom_type_id;
  int value_old = *selectbox_info[type_id].value;
  int value_new = selectbox_info[type_id].options[gi->selectbox.index].value;

  *selectbox_info[type_id].value = value_new;

  if (type_id == ED_SELECTBOX_ID_SELECT_CHANGE_PAGE)
  {
    element_info[properties_element].current_change_page = gi->selectbox.index;

    DrawPropertiesWindow();
  }
  else if ((type_id >= ED_SELECTBOX_ID_CUSTOM_FIRST &&
	    type_id <= ED_SELECTBOX_ID_CUSTOM_LAST) ||
	   (type_id >= ED_SELECTBOX_ID_CHANGE_FIRST &&
	    type_id <= ED_SELECTBOX_ID_CHANGE_LAST) ||
	   (type_id == ED_SELECTBOX_ID_GROUP_CHOICE_MODE))
  {
    if (type_id == ED_SELECTBOX_ID_ACTION_TYPE)
    {
      /* when changing action type, also check action mode and action arg */
      if (value_old != value_new)
	setSelectboxSpecialActionVariablesIfNeeded();

      DrawPropertiesChange();
    }

    CopyElementPropertiesToGame(properties_element);

    level.changed = TRUE;
  }
}

static void HandleTextbuttonGadgets(struct GadgetInfo *gi)
{
  int type_id = gi->custom_type_id;
  int i;

  if (type_id >= ED_TEXTBUTTON_ID_LEVELINFO_FIRST &&
      type_id <= ED_TEXTBUTTON_ID_LEVELINFO_LAST)
  {
    edit_mode_levelinfo = gi->custom_type_id;

    DrawLevelInfoWindow();
  }
  else if (type_id >= ED_TEXTBUTTON_ID_PROPERTIES_FIRST &&
	   type_id <= ED_TEXTBUTTON_ID_PROPERTIES_LAST)
  {
    edit_mode_properties = gi->custom_type_id;

    DrawPropertiesWindow();
  }
  else if (type_id == ED_TEXTBUTTON_ID_SAVE_AS_TEMPLATE)
  {
    char *template_filename = getDefaultLevelFilename(-1);
    boolean new_template = !fileExists(template_filename);

    /* backup original "level.field" (needed to track playfield changes) */
    CopyPlayfield(level.field, FieldBackup);

    /* "SaveLevelTemplate()" uses "level.field", so copy editor playfield */
    CopyPlayfield(Feld, level.field);

    if (new_template ||
	Request("Save this template and kill the old?", REQ_ASK))
      SaveLevelTemplate();

    if (new_template)
      Request("Template saved!", REQ_CONFIRM);

    /* restore original "level.field" (needed to track playfield changes) */
    CopyPlayfield(FieldBackup, level.field);
  }
  else if (type_id == ED_TEXTBUTTON_ID_ADD_CHANGE_PAGE &&
	   custom_element.num_change_pages < MAX_CHANGE_PAGES)
  {
    struct ElementInfo *ei = &element_info[properties_element];

    setElementChangePages(ei, ei->num_change_pages + 1);

    /* set new change page to be new current change page */
    ei->current_change_page = ei->num_change_pages - 1;
    ei->change = &ei->change_page[ei->current_change_page];

    setElementChangeInfoToDefaults(ei->change);

    DrawPropertiesWindow();

    level.changed = TRUE;
  }
  else if (type_id == ED_TEXTBUTTON_ID_DEL_CHANGE_PAGE &&
	   custom_element.num_change_pages > MIN_CHANGE_PAGES)
  {
    struct ElementInfo *ei = &element_info[properties_element];

    /* copy all change pages after change page to be deleted */
    for (i = ei->current_change_page; i < ei->num_change_pages - 1; i++)
      ei->change_page[i] = ei->change_page[i + 1];

    setElementChangePages(ei, ei->num_change_pages - 1);

    DrawPropertiesWindow();

    level.changed = TRUE;
  }
}

static void HandleGraphicbuttonGadgets(struct GadgetInfo *gi)
{
  int type_id = gi->custom_type_id;

  if (type_id == ED_GRAPHICBUTTON_ID_PREV_CHANGE_PAGE ||
      type_id == ED_GRAPHICBUTTON_ID_NEXT_CHANGE_PAGE)
  {
    struct ElementInfo *ei = &element_info[properties_element];
    int step = BUTTON_STEPSIZE(gi->event.button);

    step *= (type_id == ED_GRAPHICBUTTON_ID_PREV_CHANGE_PAGE ? -1 : +1);
    ei->current_change_page += step;

    if (ei->current_change_page < 0)
      ei->current_change_page = 0;
    else if (ei->current_change_page >= ei->num_change_pages)
      ei->current_change_page = ei->num_change_pages - 1;

    DrawPropertiesWindow();
  }
  else if (type_id == ED_GRAPHICBUTTON_ID_COPY_CHANGE_PAGE ||
	   type_id == ED_GRAPHICBUTTON_ID_PASTE_CHANGE_PAGE)
  {
    struct ElementInfo *ei = &element_info[properties_element];
    int current_change_page = ei->current_change_page;

    if (type_id == ED_GRAPHICBUTTON_ID_COPY_CHANGE_PAGE)
      element_info[EL_INTERNAL_CLIPBOARD_CHANGE].change_page[0] =
	ei->change_page[current_change_page];
    else if (type_id == ED_GRAPHICBUTTON_ID_PASTE_CHANGE_PAGE)
    {
      ei->change_page[current_change_page] =
	element_info[EL_INTERNAL_CLIPBOARD_CHANGE].change_page[0];

      level.changed = TRUE;
    }

    DrawPropertiesWindow();
  }
}

static void HandleRadiobuttons(struct GadgetInfo *gi)
{
  *radiobutton_info[gi->custom_type_id].value =
    radiobutton_info[gi->custom_type_id].checked_value;

  level.changed = TRUE;
}

static void HandleCheckbuttons(struct GadgetInfo *gi)
{
  int type_id = gi->custom_type_id;

  *checkbutton_info[type_id].value ^= TRUE;

  if (type_id == ED_CHECKBUTTON_ID_CAN_FALL_INTO_ACID ||
      type_id == ED_CHECKBUTTON_ID_CAN_MOVE_INTO_ACID ||
      type_id == ED_CHECKBUTTON_ID_DONT_COLLIDE_WITH ||
      (((type_id >= ED_CHECKBUTTON_ID_CUSTOM_FIRST &&
	 type_id <= ED_CHECKBUTTON_ID_CUSTOM_LAST) ||
	(type_id >= ED_CHECKBUTTON_ID_CHANGE_FIRST &&
	 type_id <= ED_CHECKBUTTON_ID_CHANGE_LAST)) &&
       type_id != ED_CHECKBUTTON_ID_CUSTOM_USE_TEMPLATE))
  {
    CopyElementPropertiesToGame(properties_element);
  }

  if (type_id == ED_CHECKBUTTON_ID_CUSTOM_USE_GRAPHIC)
  {
    UpdateCustomElementGraphicGadgets();
  }
  else if (type_id == ED_CHECKBUTTON_ID_CUSTOM_USE_TEMPLATE)
  {
    char *template_filename = getDefaultLevelFilename(-1);

    if (level.use_custom_template && !fileExists(template_filename))
    {
      Request("No level template found!", REQ_CONFIRM);

      level.use_custom_template = FALSE;
      ModifyGadget(gi, GDI_CHECKED, FALSE, GDI_END);

      return;
    }

    LoadLevelTemplate(level.use_custom_template ? -1 : level_nr);

    DrawEditModeWindow();
  }

  level.changed = TRUE;
}

static void HandleControlButtons(struct GadgetInfo *gi)
{
  static int last_level_drawing_function = GADGET_ID_SINGLE_ITEMS;
  static int last_edit_mode = ED_MODE_DRAWING;
  static int last_custom_copy_mode = -1;
  int id = gi->custom_id;
  int button = gi->event.button;
  int step = BUTTON_STEPSIZE(button);
  int new_element = BUTTON_ELEMENT(button);
  int x, y;

  if (edit_mode == ED_MODE_DRAWING && drawing_function == GADGET_ID_TEXT)
    DrawLevelText(0, 0, 0, TEXT_END);

  if (id < ED_NUM_CTRL1_BUTTONS &&
      id != GADGET_ID_SINGLE_ITEMS &&
      id != GADGET_ID_PICK_ELEMENT &&
      edit_mode != ED_MODE_DRAWING &&
      drawing_function != GADGET_ID_PICK_ELEMENT &&
      !(GetKeyModState() & KMOD_Control))
  {
    DrawDrawingWindow();
    edit_mode = ED_MODE_DRAWING;
  }

  /* element copy mode active, but no element button pressed => deactivate */
  if (last_custom_copy_mode != -1 && id < ED_NUM_CTRL_BUTTONS)
    last_custom_copy_mode = -1;

  switch (id)
  {
    case GADGET_ID_SCROLL_LEFT:
      if (level_xpos >= 0)
      {
	if (lev_fieldx < ed_fieldx - 2)
	  break;

	level_xpos -= step;
	if (level_xpos < -1)
	  level_xpos = -1;
	if (button == 1)
	  ScrollEditorLevel(level_xpos, level_ypos, ED_SCROLL_RIGHT);
	else
	  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_HORIZONTAL],
		     GDI_SCROLLBAR_ITEM_POSITION, level_xpos + 1, GDI_END);
      }
      break;

    case GADGET_ID_SCROLL_RIGHT:
      if (level_xpos <= lev_fieldx - ed_fieldx)
      {
	if (lev_fieldx < ed_fieldx - 2)
	  break;

	level_xpos += step;
	if (level_xpos > lev_fieldx - ed_fieldx + 1)
	  level_xpos = lev_fieldx - ed_fieldx + 1;
	if (button == 1)
	  ScrollEditorLevel(level_xpos, level_ypos, ED_SCROLL_LEFT);
	else
	  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_HORIZONTAL],
		     GDI_SCROLLBAR_ITEM_POSITION, level_xpos + 1, GDI_END);
      }
      break;

    case GADGET_ID_SCROLL_UP:
      if (level_ypos >= 0)
      {
	if (lev_fieldy < ed_fieldy - 2)
	  break;

	level_ypos -= step;
	if (level_ypos < -1)
	  level_ypos = -1;
	if (button == 1)
	  ScrollEditorLevel(level_xpos, level_ypos, ED_SCROLL_DOWN);
	else
	  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_VERTICAL],
		     GDI_SCROLLBAR_ITEM_POSITION, level_ypos + 1, GDI_END);
      }
      break;

    case GADGET_ID_SCROLL_DOWN:
      if (level_ypos <= lev_fieldy - ed_fieldy)
      {
	if (lev_fieldy < ed_fieldy - 2)
	  break;

	level_ypos += step;
	if (level_ypos > lev_fieldy - ed_fieldy + 1)
	  level_ypos = lev_fieldy - ed_fieldy + 1;
	if (button == 1)
	  ScrollEditorLevel(level_xpos, level_ypos, ED_SCROLL_UP);
	else
	  DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_VERTICAL],
		     GDI_SCROLLBAR_ITEM_POSITION, level_ypos + 1, GDI_END);
      }
      break;

    case GADGET_ID_SCROLL_HORIZONTAL:
      level_xpos = gi->event.item_position - 1;

      DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
      BackToFront();

      break;

    case GADGET_ID_SCROLL_VERTICAL:
      level_ypos = gi->event.item_position - 1;

      DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
      BackToFront();

      break;

    case GADGET_ID_SCROLL_LIST_UP:
    case GADGET_ID_SCROLL_LIST_DOWN:
    case GADGET_ID_SCROLL_LIST_VERTICAL:
      if (id == GADGET_ID_SCROLL_LIST_VERTICAL)
	element_shift = gi->event.item_position * ED_ELEMENTLIST_BUTTONS_HORIZ;
      else
      {
	step *= (id == GADGET_ID_SCROLL_LIST_UP ? -1 : +1);
	element_shift += step * ED_ELEMENTLIST_BUTTONS_HORIZ;

	if (element_shift < 0)
	  element_shift = 0;
	if (element_shift > num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS)
	  element_shift = num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS;

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_LIST_VERTICAL],
		     GDI_SCROLLBAR_ITEM_POSITION,
		     element_shift / ED_ELEMENTLIST_BUTTONS_HORIZ, GDI_END);
      }

      ModifyEditorElementList();

      break;

    case GADGET_ID_PROPERTIES:
      if (edit_mode != ED_MODE_PROPERTIES)
      {
	properties_element = new_element;
	DrawPropertiesWindow();
	edit_mode = ED_MODE_PROPERTIES;

	last_level_drawing_function = drawing_function;
	ClickOnGadget(level_editor_gadget[GADGET_ID_SINGLE_ITEMS],
		      MB_LEFTBUTTON);
      }
      else
      {
	DrawDrawingWindow();
	edit_mode = ED_MODE_DRAWING;

	ClickOnGadget(level_editor_gadget[last_level_drawing_function],
		      MB_LEFTBUTTON);
      }
      break;

    case GADGET_ID_WRAP_LEFT:
      WrapLevel(-step, 0);
      break;

    case GADGET_ID_WRAP_RIGHT:
      WrapLevel(step, 0);
      break;

    case GADGET_ID_WRAP_UP:
      WrapLevel(0, -step);
      break;

    case GADGET_ID_WRAP_DOWN:
      WrapLevel(0, step);
      break;

    case GADGET_ID_SINGLE_ITEMS:
    case GADGET_ID_CONNECTED_ITEMS:
    case GADGET_ID_LINE:
    case GADGET_ID_ARC:
    case GADGET_ID_TEXT:
    case GADGET_ID_RECTANGLE:
    case GADGET_ID_FILLED_BOX:
    case GADGET_ID_FLOOD_FILL:
    case GADGET_ID_GRAB_BRUSH:
    case GADGET_ID_PICK_ELEMENT:
      if (drawing_function != GADGET_ID_PICK_ELEMENT)
	last_drawing_function = drawing_function;
      drawing_function = id;
      draw_with_brush = FALSE;
      break;

    case GADGET_ID_RANDOM_PLACEMENT:
      RandomPlacement(new_element);
      break;

    case GADGET_ID_ZOOM:
      // zoom level editor tile size in or out (or reset to default size)
      ed_tilesize = (button == 1 ? ed_tilesize * 2 :
		     button == 2 ? DEFAULT_EDITOR_TILESIZE :
		     button == 3 ? ed_tilesize / 2 : ed_tilesize);

      // limit zoom level by upper and lower bound
      ed_tilesize = MIN(MAX(MICRO_TILESIZE, ed_tilesize), TILESIZE);

      InitZoomLevelSettings();

      if (edit_mode == ED_MODE_DRAWING)
	DrawDrawingWindow();

      break;

    case GADGET_ID_CUSTOM_COPY_FROM:
    case GADGET_ID_CUSTOM_COPY_TO:
    case GADGET_ID_CUSTOM_EXCHANGE:
      last_custom_copy_mode = id;
      last_drawing_function = drawing_function;
      break;

    case GADGET_ID_CUSTOM_COPY:
      CopyCustomElement(properties_element, -1, id);
      break;

    case GADGET_ID_CUSTOM_PASTE:
      CopyCustomElement(-1, properties_element, id);
      break;

    case GADGET_ID_UNDO:
      if (button == 1 && undo_buffer_steps == 0)
      {
	Request("Undo buffer empty!", REQ_CONFIRM);

	break;
      }
      else if (button == 2)
      {
	break;
      }
      else if (button == 3 && redo_buffer_steps == 0)
      {
	Request("Redo buffer empty!", REQ_CONFIRM);

	break;
      }

      if (edit_mode != ED_MODE_DRAWING)
      {
	DrawDrawingWindow();
	edit_mode = ED_MODE_DRAWING;
      }

      if (button == 1)
      {
	/* undo */

	undo_buffer_position =
	  (undo_buffer_position - 1 + NUM_UNDO_STEPS) % NUM_UNDO_STEPS;

	undo_buffer_steps--;
	redo_buffer_steps++;
      }
      else
      {
	/* redo */

	undo_buffer_position = (undo_buffer_position + 1) % NUM_UNDO_STEPS;

	undo_buffer_steps++;
	redo_buffer_steps--;
      }

      for (x = 0; x < lev_fieldx; x++)
	for (y = 0; y < lev_fieldy; y++)
	  Feld[x][y] = UndoBuffer[undo_buffer_position][x][y];

      /* check if undo operation forces change of border style */
      CheckLevelBorderElement(FALSE);

      DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);

      break;

    case GADGET_ID_INFO:
      if (edit_mode != ED_MODE_INFO)
      {
	last_edit_mode = edit_mode;
	edit_mode = ED_MODE_INFO;

	DrawLevelInfoWindow();
      }
      else
      {
	edit_mode = last_edit_mode;

	DrawEditModeWindow();
      }
      break;

    case GADGET_ID_CLEAR:
      if (edit_mode != ED_MODE_DRAWING)
      {
	DrawDrawingWindow();
	edit_mode = ED_MODE_DRAWING;
      }

      for (x = 0; x < MAX_LEV_FIELDX; x++) 
	for (y = 0; y < MAX_LEV_FIELDY; y++) 
	  Feld[x][y] = (button == 1 ? EL_EMPTY : new_element);

      CopyLevelToUndoBuffer(GADGET_ID_CLEAR);

      DrawEditorLevel(ed_fieldx, ed_fieldy, level_xpos, level_ypos);
      break;

    case GADGET_ID_SAVE:
    {
      /* saving read-only levels into personal level set modifies global vars
	 "leveldir_current" and "level_nr"; restore them after saving level */
      LevelDirTree *leveldir_former = leveldir_current;
      int level_nr_former = level_nr;
      char *level_filename;
      boolean new_level;

      if (leveldir_current->readonly &&
	  !PrepareSavingIntoPersonalLevelSet())
	break;

      level_filename = getDefaultLevelFilename(level_nr);
      new_level = !fileExists(level_filename);

      if (new_level ||
	  Request("Save this level and kill the old?", REQ_ASK))
      {
	if (leveldir_former->readonly)
	  ModifyLevelInfoForSavingIntoPersonalLevelSet(leveldir_former->name);

	CopyPlayfield(Feld, level.field);
	SaveLevel(level_nr);

	level.changed = FALSE;

	if (new_level)
	{
	  char level_saved_msg[64];

	  if (leveldir_former->readonly)
	    sprintf(level_saved_msg,
		    "Level saved as level %d into personal level set!",
		    level_nr);
	  else
	    strcpy(level_saved_msg, "Level saved!");

	  Request(level_saved_msg, REQ_CONFIRM);
	}
      }

      /* "cd" back to copied-from levelset (in case of saved read-only level) */
      leveldir_current = leveldir_former;
      level_nr = level_nr_former;

      break;
    }

    case GADGET_ID_TEST:
      if (LevelChanged())
	level.game_version = GAME_VERSION_ACTUAL;

      CopyPlayfield(level.field, FieldBackup);
      CopyPlayfield(Feld, level.field);

      CopyNativeLevel_RND_to_Native(&level);

      UnmapLevelEditorGadgets();
      UndrawSpecialEditorDoor();

      CloseDoor(DOOR_CLOSE_ALL);

      /* needed before playing if editor playfield area has different size */
      ClearRectangle(drawto, REAL_SX, REAL_SY, FULL_SXSIZE, FULL_SYSIZE);

      // redraw_mask = REDRAW_ALL;

      level_editor_test_game = TRUE;

      StartGameActions(FALSE, setup.autorecord, level.random_seed);

      break;

    case GADGET_ID_EXIT:
      RequestExitLevelEditor(TRUE, FALSE);  /* if level has changed, ask user */
      break;

    default:
      if (id >= GADGET_ID_ELEMENTLIST_FIRST &&
	  id <= GADGET_ID_ELEMENTLIST_LAST)
      {
	int element_position = id - GADGET_ID_ELEMENTLIST_FIRST;
	int new_element = editor_elements[element_position + element_shift];

	if (IS_EDITOR_CASCADE(new_element))
	{
	  int i;

	  for (i = 0; editor_elements_info[i].setup_value != NULL; i++)
	  {
	    int *cascade_element= &(*editor_elements_info[i].headline_list)[0];
	    boolean *cascade_value=editor_elements_info[i].setup_cascade_value;

	    if (*cascade_element == new_element)
	    {
	      *cascade_element = EL_CASCADE_TOGGLE(*cascade_element);
	      *cascade_value = IS_EDITOR_CASCADE_ACTIVE(*cascade_element);

	      /* update element selection list */
	      ReinitializeElementList();
	      ModifyEditorElementList();

	      /* update cascading gadget info text */
	      PrintEditorGadgetInfoText(level_editor_gadget[id]);

	      /* save current editor cascading state */
	      SaveSetup_EditorCascade();

	      break;
	    }
	  }

	  break;
	}

	if (last_custom_copy_mode != -1)
	{
	  if (CopyCustomElement(properties_element, new_element,
				last_custom_copy_mode))
	  {
	    ClickOnGadget(level_editor_gadget[last_drawing_function],
			  MB_LEFTBUTTON);

	    last_custom_copy_mode = -1;
	  }

	  break;
	}

	PickDrawingElement(button, new_element);

	if (!stick_element_properties_window &&
	    drawing_function != GADGET_ID_PICK_ELEMENT &&
	    !(GetKeyModState() & KMOD_Control))
	{
	  properties_element = new_element;
	  if (edit_mode == ED_MODE_PROPERTIES)
	    DrawPropertiesWindow();
	}

	if (drawing_function == GADGET_ID_PICK_ELEMENT)
	  ClickOnGadget(level_editor_gadget[last_drawing_function],
			MB_LEFTBUTTON);
      }
#ifdef DEBUG
      else if (gi->event.type == GD_EVENT_PRESSED)
	printf("default: HandleControlButtons: GD_EVENT_PRESSED(%d)\n", id);
      else if (gi->event.type == GD_EVENT_RELEASED)
	printf("default: HandleControlButtons: GD_EVENT_RELEASED(%d)\n", id);
      else if (gi->event.type == GD_EVENT_MOVING)
	printf("default: HandleControlButtons: GD_EVENT_MOVING(%d)\n", id);
      else
	printf("default: HandleControlButtons: ? (id == %d)\n", id);
#endif
      break;
  }
}

void HandleLevelEditorKeyInput(Key key)
{
  char letter = getCharFromKey(key);
  int button = MB_LEFTBUTTON;

  if (drawing_function == GADGET_ID_TEXT &&
      DrawLevelText(0, 0, 0, TEXT_QUERY_TYPING) == TRUE)
  {
    if (letter)
      DrawLevelText(0, 0, letter, TEXT_WRITECHAR);
    else if (key == KSYM_Delete || key == KSYM_BackSpace)
      DrawLevelText(0, 0, 0, TEXT_BACKSPACE);
    else if (key == KSYM_Return)
      DrawLevelText(0, 0, 0, TEXT_NEWLINE);
    else if (key == KSYM_Escape)
      DrawLevelText(0, 0, 0, TEXT_END);
  }
  else if (button_status == MB_RELEASED)
  {
    int id = GADGET_ID_NONE;
    int new_element_shift = element_shift;
    int i;

    switch (key)
    {
      case KSYM_Left:
	id = GADGET_ID_SCROLL_LEFT;
	break;
      case KSYM_Right:
	id = GADGET_ID_SCROLL_RIGHT;
	break;
      case KSYM_Up:
	id = GADGET_ID_SCROLL_UP;
	break;
      case KSYM_Down:
	id = GADGET_ID_SCROLL_DOWN;
	break;
      case KSYM_Page_Up:
	id = GADGET_ID_SCROLL_LIST_UP;
	button = ED_ELEMENTLIST_BUTTONS_VERT - 1;
	break;
      case KSYM_Page_Down:
	id = GADGET_ID_SCROLL_LIST_DOWN;
	button = ED_ELEMENTLIST_BUTTONS_VERT - 1;
	break;

      case KSYM_Home:
      case KSYM_End:
	element_shift = (key == KSYM_Home ? 0 :
			 num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS);

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_LIST_VERTICAL],
		     GDI_SCROLLBAR_ITEM_POSITION,
		     element_shift / ED_ELEMENTLIST_BUTTONS_HORIZ, GDI_END);

	ModifyEditorElementList();

	break;

      case KSYM_Insert:
      case KSYM_Delete:

	/* this is needed to prevent interference with running "True X-Mouse" */
	if (GetKeyModStateFromEvents() & KMOD_Control)
	  break;

	/* check for last or next editor cascade block in element list */
	for (i = 0; i < num_editor_elements; i++)
	{
	  if ((key == KSYM_Insert && i == element_shift) ||
	      (key == KSYM_Delete && new_element_shift > element_shift))
	    break;

	  /* jump to next cascade block (or to start of element list) */
	  if (i == 0 || IS_EDITOR_CASCADE(editor_elements[i]))
	    new_element_shift = i;
	}

	if (i < num_editor_elements)
	  element_shift = new_element_shift;

	if (element_shift > num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS)
	  element_shift = num_editor_elements - ED_NUM_ELEMENTLIST_BUTTONS;

	ModifyGadget(level_editor_gadget[GADGET_ID_SCROLL_LIST_VERTICAL],
		     GDI_SCROLLBAR_ITEM_POSITION,
		     element_shift / ED_ELEMENTLIST_BUTTONS_HORIZ, GDI_END);

	ModifyEditorElementList();

	break;

      case KSYM_Escape:
        if (edit_mode == ED_MODE_DRAWING)
	{
	  RequestExitLevelEditor(setup.ask_on_escape_editor, TRUE);
	}
        else if (edit_mode == ED_MODE_INFO)
	{
	  HandleControlButtons(level_editor_gadget[GADGET_ID_INFO]);
	}
        else if (edit_mode == ED_MODE_PROPERTIES)
	{
	  HandleControlButtons(level_editor_gadget[GADGET_ID_PROPERTIES]);
	}
	else		/* should never happen */
	{
	  DrawDrawingWindow();
	  edit_mode = ED_MODE_DRAWING;
	}

        break;

      default:
	break;
    }

    if (id != GADGET_ID_NONE)
      ClickOnGadget(level_editor_gadget[id], button);
    else if (letter >= '1' && letter <= '3')
      ClickOnGadget(level_editor_gadget[GADGET_ID_PROPERTIES], letter - '0');
    else if (letter == '?')
      ClickOnGadget(level_editor_gadget[GADGET_ID_PROPERTIES], button);
    else if (letter == '.')
      ClickOnGadget(level_editor_gadget[GADGET_ID_SINGLE_ITEMS], button);
    else if (letter == 'U')
      ClickOnGadget(level_editor_gadget[GADGET_ID_UNDO], 3);
    else if (letter == '-' || key == KSYM_KP_Subtract)
      ClickOnGadget(level_editor_gadget[GADGET_ID_ZOOM], 3);
    else if (letter == '0' || key == KSYM_KP_0)
      ClickOnGadget(level_editor_gadget[GADGET_ID_ZOOM], 2);
    else if (letter == '+' || key == KSYM_KP_Add ||
	     letter == '=')	// ("Shift-=" is "+" on US keyboards)
      ClickOnGadget(level_editor_gadget[GADGET_ID_ZOOM], 1);
    else if (key == KSYM_Return ||
	     key == KSYM_space ||
	     key == setup.shortcut.toggle_pause)
      ClickOnGadget(level_editor_gadget[GADGET_ID_TEST], button);
    else
      for (i = 0; i < ED_NUM_CTRL_BUTTONS; i++)
	if (letter && letter == controlbutton_info[i].shortcut)
	  if (!anyTextGadgetActive())
	    ClickOnGadget(level_editor_gadget[i], button);
  }
}

void HandleLevelEditorIdle()
{
  int element_border = graphic_info[IMG_EDITOR_ELEMENT_BORDER].border_size;
  int x = editor.settings.element_graphic.x + element_border;
  int y = editor.settings.element_graphic.y + element_border;
  static unsigned int action_delay = 0;
  unsigned int action_delay_value = GameFrameDelay;
  int i;

  if (edit_mode != ED_MODE_PROPERTIES)
    return;

  if (!DelayReached(&action_delay, action_delay_value))
    return;

  for (i = 0; i < ED_NUM_SELECTBOX; i++)
  {
    struct GadgetInfo *gi = level_editor_gadget[selectbox_info[i].gadget_id];

    if (gi->mapped && gi->active && gi->selectbox.open)
      return;
  }

  DrawEditorElementAnimation(SX + x, SY + y);

  redraw_mask |= REDRAW_FIELD;

  FrameCounter++;	/* increase animation frame counter */
}

void ClearEditorGadgetInfoText()
{
  DrawBackground(INFOTEXT_XPOS, INFOTEXT_YPOS, INFOTEXT_XSIZE, INFOTEXT_YSIZE);
}

void PrintEditorGadgetInfoText(struct GadgetInfo *gi)
{
  char infotext[MAX_OUTPUT_LINESIZE + 1];
  char shortcut[MAX_OUTPUT_LINESIZE + 1];
  int max_infotext_len = getMaxInfoTextLength();

  if (gi == NULL || strlen(gi->info_text) == 0)
    return;

  strncpy(infotext, gi->info_text, max_infotext_len);
  infotext[max_infotext_len] = '\0';

  if (gi->custom_id < ED_NUM_CTRL_BUTTONS)
  {
    int key = controlbutton_info[gi->custom_id].shortcut;

    if (key)
    {
      if (gi->custom_id == GADGET_ID_SINGLE_ITEMS)
	sprintf(shortcut, " ('.' or '%c')", key);
      else if (gi->custom_id == GADGET_ID_PICK_ELEMENT)
	sprintf(shortcut, " ('%c' or 'Ctrl')", key);
      else if (gi->custom_id == GADGET_ID_TEST)
	sprintf(shortcut, " ('Enter' or 'Shift-%c')", key);
      else if (gi->custom_id == GADGET_ID_UNDO)
	sprintf(shortcut, " ('%c/Shift-U')", key);
      else if (gi->custom_id == GADGET_ID_ZOOM)
	sprintf(shortcut, " ('%c', '0', '+')", key);
      else
	sprintf(shortcut, " ('%s%c')",
		(key >= 'A' && key <= 'Z' ? "Shift-" : ""), key);

      if (strlen(infotext) + strlen(shortcut) <= max_infotext_len)
	strcat(infotext, shortcut);
    }
  }

  DrawText(INFOTEXT_XPOS, INFOTEXT_YPOS, infotext, INFOTEXT_FONT);
}

void HandleEditorGadgetInfoText(void *ptr)
{
  struct GadgetInfo *gi = (struct GadgetInfo *)ptr;

  if (game_status != GAME_MODE_EDITOR)
    return;

  ClearEditorGadgetInfoText();

  if (gi == NULL || gi->event.type == GD_EVENT_INFO_LEAVING)
    return;

  /* misuse this function to delete brush cursor, if needed */
  if (edit_mode == ED_MODE_DRAWING && draw_with_brush)
    DeleteBrushFromCursor();

  PrintEditorGadgetInfoText(gi);
}

static void HandleDrawingAreaInfo(struct GadgetInfo *gi)
{
  static int start_lx, start_ly;
  int id = gi->custom_id;
  int type_id = gi->custom_type_id;
  int sx = gi->event.x;
  int sy = gi->event.y;
  int lx = sx + level_xpos;
  int ly = sy + level_ypos;
  int min_sx = 0, min_sy = 0;
  int max_sx = gi->drawing.area_xsize - 1;
  int max_sy = gi->drawing.area_ysize - 1;
  int actual_drawing_function = drawing_function;
  int max_infotext_len = getMaxInfoTextLength();
  char infotext[MAX_OUTPUT_LINESIZE + 1];
  char *text;

  infotext[0] = '\0';		/* start with empty info text */

  /* pressed Control key: simulate picking element */
  if (GetKeyModState() & KMOD_Control)
    actual_drawing_function = GADGET_ID_PICK_ELEMENT;

  ClearEditorGadgetInfoText();

  if (gi->event.type == GD_EVENT_INFO_LEAVING)
    return;

  /* make sure to stay inside drawing area boundaries */
  sx = (sx < min_sx ? min_sx : sx > max_sx ? max_sx : sx);
  sy = (sy < min_sy ? min_sy : sy > max_sy ? max_sy : sy);

  if (id == GADGET_ID_DRAWING_LEVEL)
  {
    if (button_status)
    {
      int min_lx = 0, min_ly = 0;
      int max_lx = lev_fieldx - 1, max_ly = lev_fieldy - 1;

      /* get positions inside level field */
      lx = sx + level_xpos;
      ly = sy + level_ypos;

      /* make sure to stay inside level field boundaries */
      lx = (lx < min_lx ? min_lx : lx > max_lx ? max_lx : lx);
      ly = (ly < min_ly ? min_ly : ly > max_ly ? max_ly : ly);

      /* correct drawing area positions accordingly */
      sx = lx - level_xpos;
      sy = ly - level_ypos;
    }

    if (IN_ED_FIELD(sx,sy) && IN_LEV_FIELD(lx, ly))
    {
      if (button_status)	/* if (gi->state == GD_BUTTON_PRESSED) */
      {
	if (gi->event.type == GD_EVENT_PRESSED)
	{
	  start_lx = lx;
	  start_ly = ly;
	}

	switch (actual_drawing_function)
	{
	  case GADGET_ID_SINGLE_ITEMS:
	    text = "Drawing single items";
	    break;
      	  case GADGET_ID_CONNECTED_ITEMS:
	    text = "Drawing connected items";
	    break;
      	  case GADGET_ID_LINE:
	    text = "Drawing line";
	    break;
      	  case GADGET_ID_ARC:
	    text = "Drawing arc";
	    break;
      	  case GADGET_ID_TEXT:
	    text = "Setting text cursor";
	    break;
      	  case GADGET_ID_RECTANGLE:
	    text = "Drawing rectangle";
	    break;
      	  case GADGET_ID_FILLED_BOX:
	    text = "Drawing filled box";
	    break;
      	  case GADGET_ID_FLOOD_FILL:
	    text = "Flood fill";
	    break;
      	  case GADGET_ID_GRAB_BRUSH:
	    text = "Grabbing brush";
	    break;
      	  case GADGET_ID_PICK_ELEMENT:
	    text = "Picking element";
	    break;

	  default:
	    text = "Drawing position";
	    break;
	}

	if (actual_drawing_function == GADGET_ID_PICK_ELEMENT)
	  sprintf(infotext, "%s: %d, %d", text, lx, ly);
	else
	  sprintf(infotext, "%s: %d, %d", text,
		  ABS(lx - start_lx) + 1, ABS(ly - start_ly) + 1);
      }
      else if (actual_drawing_function == GADGET_ID_PICK_ELEMENT)
	strncpy(infotext, getElementInfoText(Feld[lx][ly]), max_infotext_len);
      else
	sprintf(infotext, "Level position: %d, %d", lx, ly);
    }

    /* misuse this function to draw brush cursor, if needed */
    if (edit_mode == ED_MODE_DRAWING && draw_with_brush && !button_status)
    {
      if (IN_ED_FIELD(sx, sy) && IN_LEV_FIELD(lx, ly))
	CopyBrushToCursor(sx, sy);
      else
	DeleteBrushFromCursor();
    }
  }
  else if (actual_drawing_function == GADGET_ID_PICK_ELEMENT)
  {
    int pos = sx * drawingarea_info[type_id].area_ysize + sy;
    int element = drawingarea_info[type_id].value[pos];

    strncpy(infotext, getElementInfoText(element), max_infotext_len);
  }
  else
  {
    if (id == GADGET_ID_CUSTOM_CONTENT)
      sprintf(infotext, "custom element content position: %d, %d", sx, sy);
    else if (id == GADGET_ID_GROUP_CONTENT)
      sprintf(infotext, "group element position: %d", sx + 1);
    else if (id >= GADGET_ID_YAMYAM_CONTENT_0 &&
	     id <= GADGET_ID_YAMYAM_CONTENT_7)
      sprintf(infotext, "content area %d position: %d, %d",
	      id - GADGET_ID_YAMYAM_CONTENT_0 + 1, sx, sy);
    else if (id >= GADGET_ID_MAGIC_BALL_CONTENT_0 &&
	     id <= GADGET_ID_MAGIC_BALL_CONTENT_7)
      sprintf(infotext, "content area %d position: %d, %d",
	      id - GADGET_ID_MAGIC_BALL_CONTENT_0 + 1, sx, sy);
    else if (id == GADGET_ID_ANDROID_CONTENT)
      sprintf(infotext, "android element position: %d", sx + 1);
    else if (drawingarea_info[type_id].infotext != NULL)
      strcpy(infotext, drawingarea_info[type_id].infotext);
  }

  infotext[max_infotext_len] = '\0';

  if (strlen(infotext) > 0)
    DrawTextS(INFOTEXT_XPOS - SX, INFOTEXT_YPOS - SY, INFOTEXT_FONT, infotext);
}

void RequestExitLevelEditor(boolean ask_if_level_has_changed,
			    boolean quick_quit)
{
  if (!ask_if_level_has_changed ||
      !LevelChanged() ||
      Request("Level has changed! Exit without saving?",
	      REQ_ASK | REQ_STAY_OPEN))
  {
    struct RectWithBorder *vp_door_1 = &viewport.door_1[GAME_MODE_MAIN];
    struct RectWithBorder *vp_door_2 = &viewport.door_2[GAME_MODE_MAIN];

    /* draw normal door */
    UndrawSpecialEditorDoor();

    // close editor doors if viewport definition is the same as in main menu
    if (vp_door_1->x      == DX     &&
	vp_door_1->y      == DY     &&
	vp_door_1->width  == DXSIZE &&
	vp_door_1->height == DYSIZE &&
	vp_door_2->x      == VX     &&
	vp_door_2->y      == VY     &&
	vp_door_2->width  == VXSIZE &&
	vp_door_2->height == VYSIZE)
      CloseDoor(DOOR_CLOSE_ALL | DOOR_NO_DELAY);
    else
      SetDoorState(DOOR_CLOSE_2);

    BackToFront();

    if (quick_quit)
      FadeSkipNextFadeIn();

    SetGameStatus(GAME_MODE_MAIN);

    DrawMainMenu();
  }
  else
  {
    if (!global.use_envelope_request)
    {
      CloseDoor(DOOR_CLOSE_1);
      OpenDoor(DOOR_OPEN_1 | DOOR_COPY_BACK);
    }
  }
}
